; manage actors routine 

xActLo:                           ; lo x position of sprites (actors)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

xActHi:                           ; hi x position of sprites (actors)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

yAct:                             ; y position of sprites (actors)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

actType:                          ; actor type (0=not to show)
  .byte $00, $00, $00, $00, $00, $00, $00, $00
  
actFrame:                         ; actor frame being used 
  .byte $00, $00, $00, $00, $00, $00, $00, $00  
  
actFrameD:                        ; actor frame delay
  .byte $00, $00, $00, $00, $00, $00, $00, $00  
  
actFrameV:                        ; actor frame vary use
  .byte $00, $00, $00, $00, $00, $00, $00, $00   
  
actInitD:                         ; actor initial delay for movement
  .byte $00, $00, $00, $00, $00, $00, $00, $00  
  
actSetUp:                         ; actor set up flag: after actInitD=0, make an action
  .byte $00, $00, $00, $00, $00, $00, $00, $00     
               
actColor:                         ; color of this actor 
  .byte $00, $00, $00, $00, $00, $00, $00, $00  

xActSpeed:                        ; speed of the actor (>0=DX)
  .byte $00, $00, $00, $00, $00, $00, $00, $00

yActSpeed:                        ; speed of the actor in y direction
  .byte $00, $00, $00, $00, $00, $00, $00, $00
  
actExpX:                          ; actor expansion in x        
  .byte $00, $00, $00, $00, $00, $00, $00, $00

actExpY:                          ; actor expansion in y 
  .byte $00, $00, $00, $00, $00, $00, $00, $00
  
actMultic:                        ; actor multicolor    
  .byte $00, $00, $00, $00, $00, $00, $00, $00  
  
actPrior:                         ; background/sprite priority
   .byte $00, $00, $00, $00, $00, $00, $00, $00   

virtualD:                         ; virtual draw register for sprite
  .byte $00
  
virtualX:                         ; virtual high bits register for sprite
  .byte $00
  
virtualEx:                        ; virtual register for expand in x    
  .byte $00
    
virtualEy:                        ; virtual register for expand in y
  .byte $00
  
virtualM:                         ; virtual register for multicolor   
  .byte $00
  
virtualP:                         ; virtual register for background/sprite priority
  .byte $00  

;================================
; This table must be allined with
; ACT_xxx values
;================================
animateTable:
  .byte <animateNone,  >animateNone  ; ACT_NONE
  .byte <animateSara,  >animateSara  ; ACT_SARA
  .byte <animateNone,  >animateNone  ; ACT_WOLF
  .byte <animateApe,   >animateApe   ; ACT_APE
  .byte <animateRagno, >animateRagno ; ACT_RAGNO
  .byte <animateSpa,   >animateSpa   ; ACT_SPA
  .byte <animateMouse, >animateMouse ; ACT_MOU
  .byte <animateLum,   >animateLum   ; ACT_LUM
  .byte <animateCar,   >animateCar   ; ACT_CAR0
  .byte <animateCar,   >animateCar   ; ACT_CAR1
  .byte <animateNone,  >animateNone  ; ACT_CAR2
  .byte <animateNone,  >animateNone  ; ACT_CAR3

;================================
; This table must be allined with
; ACT_xxx values
;================================
moveTable:
  .byte <movingNone,   >movingNone  ; ACT_NONE
  .byte <movingNone,   >movingNone  ; ACT_SARA
  .byte <movingWolf,   >movingWolf  ; ACT_WOLF
  .byte <movingApe,    >movingApe   ; ACT_APE
  .byte <movingRagno,  >movingRagno ; ACT_RAGNO
  .byte <movingSpa,    >movingSpa   ; ACT_SPA
  .byte <movingMouse,  >movingMouse ; ACT_MOU
  .byte <movingLum,    >movingLum   ; ACT_LUM
  .byte 0,             0            ; ACT_CAR0
  .byte 0,             0            ; ACT_CAR1
  .byte 0,             0            ; ACT_CAR2
  .byte 0,             0            ; ACT_CAR3



;================================
; This table must be allined with
; CH_xxx values
;================================
insertTable:
  .byte <insertWolf,   >insertWolf   ; monster: wolf
  .byte <insertApe,    >insertApe    ; monster: ape
  .byte <insertRagno,  >insertRagno  ; monster: ragno 
  .byte 0,             0             ; boss: car 
  .byte <insertLum,    >insertLum    ; monster: lum
  .byte <insertSpa,    >insertSpa    ; monster: spa
  .byte <insertMouse,  >insertMouse  ; monster mouse

  
;=================================
; Remove all actor from the screen
;=================================
removeActor:
      ldx  #7
      lda  #ACT_NONE
loopRA:
      sta  actType,x
      dex
      bpl  loopRA
      rts
      
;=================================
; Change jump dir while jumping
;=================================
changeJumpDir:
      lda  joystick
      and  #JOY_LEFT              ; is going left?
      bne  turnLeft

      lda  joystick
      and  #JOY_RIGHT             ; is going right?
      bne  turnRight
      
      lda  #$00                   ; don't go to x direction anymore
      sta  xActSpeed      
      rts      
      
;=================================
; Turn Sara to left while jumping
;=================================      
turnLeft:
      lda  actFrame               ; put sx facing
      ora  #$02      
      sta  actFrame

      lda  #$FE                   ; -2=sx of 2 pixels
      sta  xActSpeed
      rts

;=================================
; Turn Sara to right while jumping
;=================================      
turnRight:  
      lda  actFrame               ; put dx facing
      and  #$FD      
      sta  actFrame

      lda  #2                     ; go at dx with 2 pixels of movement
      sta  xActSpeed    
      rts
      
;=================================
; part of moveActor0 for jumping up
;=================================
isJumping:                        ; actor is jumping
      jsr  changeJumpDir          ; change jump dir if user does so

      jsr  checkUp                ; chek if she is collided with a block in up direction
      bcc  skipIJ
      jmp  jumpUpFinish

skipIJ:
      lda  xActSpeed              ; if speed x <>0 we must chack even at sx and dx
      beq  skipTestSD

      jsr  checkSx                ; check if she is collided with a block at sx
      bcc  jumpNotFinish
      jmp  jumpUpFinish
jumpNotFinish:

      jsr  checkDx                ; check if she is collided with a block at dx
      bcs  jumpUpFinish

skipTestSD:
      inc  accDel
      lda  accDel
      cmp  #JUMPDEL               ; test for delay of acceleration
      bcc  madeMove

      inc  yActSpeed              ; increase speed (accceleration)
      beq  jumpUpFinish
acc0:
      lda  #0
      sta  accDel                 ; reset acceleration delay
      ;jmp  madeMove

madeMove:                         ; made the x/y actor movement
      ldx  #00
      jsr  moveActor0X
      jmp  moveActorY
      ;rts

;=================================
; Move actor 0 according to user
; joystick action
;=================================
moveActor0:
      ldx  #0
      lda  jump
      cmp  #1
      beq  isJumping
      bcs  isFalling

      lda  joystick
      and  #JOY_UP                ; is going up?
      bne  moveUp

contMov:
      jsr  checkGround            ; check if we are always in conctat with ground
      bcc  activateFallDown       ; no, so we are falling

      jsr  testBridge             ; test for a bridge below the actor

      lda  joystick
      and  #JOY_LEFT              ; is going left?
      bne  movLeft

      lda  joystick
      and  #JOY_RIGHT             ; is going right?
      bne  movRight

      lda  actFrame               ; put base sprite even for sx or dx facing
      and  #$FE      
      sta  actFrame

      lda  #0
      sta  xActSpeed              ; set x speed to 0
      jmp  madeMove

;=================================
; part of moveActor0 for jumping 
; down
;=================================      
isFalling:
      jsr  changeJumpDir          ; change jump dir if user does so
      
      jsr  checkSx                ; check if she is collided with a block at sx
      bcs  setX0

      jsr  checkDx                ; check if she is collided with a block at dx
      bcs  setX0

accFalling:
      jsr  checkGround            ; check for a collision with the ground
      bcc  notAtFlow
      jmp  isAtFlow
notAtFlow:      

      jsr  checkDxGround          ; chek for a collision at dx with ground
      bcc  contAccFalling
      jmp  testSetFlow

contAccFalling:
      inc  accDel
      lda  accDel
      cmp  #JUMPDEL               ; test for delay of acceleration
      bcc  madeMove

      lda  yActSpeed
      cmp  #8                     ; limit y movement to 8 bits for not going into the flow
      beq  skipInc
      inc  yActSpeed
skipInc:
      jmp  madeMove

jumpUpFinish:
activateFallDown:
      lda  #2
      sta  jump                   ; activate fall sequence
      lda  #1
      sta  yActSpeed              ; set y speed to 1
      bne  acc0

moveUp:
      lda  jumpDelay              ; don't jump until the delay is passed
      bne  contMov

      lda  #1
      sta  jump                   ; she is now jumping
      lda  #0
      sta  accDel                 ; reset acceleration delay
      lda  #JUMPSPEED
      sta  yActSpeed              ; give initial y up-speed
      jmp  madeMove

;================================
; Move Sara to the left (if possible)
;================================      
movLeft:
      lda  actFrame               ; put sx facing
      ora  #$02      
      sta  actFrame

      jsr  checkSx                ; chek for a sx collision
      bcs  stopMove

      lda  #$FE                   ; -2=sx of 2 pixels
      sta  xActSpeed
      jmp  madeMove

;================================
; Move Sara to the right (if possible)
;================================           
movRight:
      lda  actFrame               ; put dx facing
      and  #$FD      
      sta  actFrame

      jsr  checkDx                ; chek for a dx collision
      bcs  stopMove

      lda  #2                     ; go at dx with 2 pixels of movement
      sta  xActSpeed
      jmp  madeMove

setX0:                            ; set x velocity to 0 due to a collision
      lda  xActSpeed
      eor  #$FF
      sec
      adc  #00
      sta  xActSpeed
      jsr  moveActor0X            ; we move the actor in the opposite direction to avoid
                                  ; a background collision in middle of a block
      lda  #0                     ; now the actor as collided and he fall down vertically
      sta  xActSpeed
      inc  statFall               ; can't set flow if we have collide in jumping
      jmp  accFalling

isAtFlow:                         ; we are at flow
      lda  #0
      sta  jump                   ; jump is finished
      sta  yActSpeed              ; y speed is finished
      sta  statFall               ; reset falling state for flow

      lda  yAct                   ; fix alignement to up of char
      and  #$f8
      sta  yAct

      lda  #JUMPDELAY             ; set that there is a delay for the next jump
      sta  jumpDelay
      rts ;jmp  madeMove

testSetFlow:
      lda  statFall               ; don't test if statFall is set
      bne  jmpCAccFal

      lda  xActSpeed
      bne  jmpCAccFal             ; if xspeed <>0 we cannot set the flow in falling here

      lda  #1
      sta  statFall               ; statFall is 1: cannot test again here

      lda  joystick
      and  #JOY_RIGHT             ; is going right?
      beq  jmpCAccFal             ; no, so don't set fall here


      lda  xActLo                 ; add 2/3 pixel to x direction for making true flow collision
      adc  #2
      sta  xActLo
      bcc  skipFixHi
      lda  xActHi
      adc  #0
      sta  xActHi

skipFixHi:
      jmp  isAtFlow

jmpCAccFal:
      jmp  contAccFalling

stopMove:                         ; stop the x movement of actor
      lda  #00
      sta  xActSpeed
      jmp  madeMove

;=================================
; Move actor 0 to x direction only
; if it stays into the visible
; screen region
;=================================
moveActor0X:
      ldx  #0
      lda  xActSpeed              ; test at sx or dx according to the direction
      bmi  dirLeft
      lda  xActHi
      beq  madeMove0
      lda  xActLo
      cmp  #(306-256)             ; test right
      bcc  madeMove0

      lda  #2                     ; we pass the screen
      sta  status
      jmp  exitA0X
madeMove0:
      jmp  moveActorRX
      ;rts
dirLeft:
      lda  xActHi
      bne  madeMove0
      lda  xActLo
      cmp  #15                    ; test left
      bcs  madeMove0
exitA0X
      rts

;==================================
; Move an actor to x direction
; according with his speed (>0=DX)
;==================================
moveActorRX:
      clc
      lda  xActSpeed,x           ; read speed in x direction
      bmi  negMoveX

      lda  xActHi,x              ; if the actor is at right, give left speed
      beq  posMoveX

      lda  xActLo,x
      cmp  #(306-256)
      bcc  posMoveX

      lda  actType,x             ; for a mouse, put right side
      cmp  #ACT_MOU
      bne  contInv

      lda  #SA_MOUR
      sta  actFrame,x

contInv:
      ;lda  #$FE                  ; -2=sx of 2 pixels
      lda  xActSpeed,x            ; invert speed
      eor  #$FF
      sec
      adc  #00 
      sta  xActSpeed,x
      bne  negMoveX

posMoveX:
      lda  xActSpeed,x           ; read speed in x direction
      adc  xActLo,x              ; move to dx
      sta  xActLo,x
      lda  xActHi,x
      adc  #$00
      sta  xActHi,x
      rts
negMoveX:                         ; move to sx
      adc  xActLo,x
      sta  xActLo,x
      lda  xActHi,x
      adc  #$ff
      sta  xActHi,x
exitMovX:
      rts          
      

;==================================
; Move an actor to x direction
; according only with his speed (>0=DX)
;==================================
moveActorOX:
      clc
      lda  xActSpeed,x           ; read speed in x direction
      bmi  negMoveSX      

posMoveSX:
      lda  xActSpeed,x           ; read speed in x direction
      adc  xActLo,x              ; move to dx
      sta  xActLo,x
      lda  xActHi,x
      adc  #$00
      sta  xActHi,x
      rts
negMoveSX:                       ; move to sx
      adc  xActLo,x
      sta  xActLo,x
      lda  xActHi,x
      adc  #$ff
      sta  xActHi,x
exitMovSX:
      rts            
      
;==================================
; Move actor 0 to y direction 
; according with his speed
;==================================    
moveActor0Y:
      lda  yActSpeed
      clc
      adc  yAct
      sta  yAct
      rts        

;==================================
; Move an actor to y direction
; according with his speed
;==================================
moveActorY:
      lda  yActSpeed,x
      clc
      adc  yAct,x
      sta  yAct,x
      rts     
      
;=================================
; Draw sprites according with their
; positions
;=================================
drawSprites:
      lda  #$00
      sta  virtualX               ; virtual register for msx position of sprites
      sta  virtualD               ; virtual register for display of sprites
      sta  virtualEx              ; virtual register for expand in x    
      sta  virtualEy              ; virtual register for expand in y
      sta  virtualM               ; virtual register for multicolor         
      sta  virtualP               ; virtual register for priority

      ldx  #7

drawNext:
      lda  actType,x
      bne  toShow                 ; show if it is <>0
      jmp  skipFixH

toShow:
      lda  virtualD
      ora  bitTable,x
      sta  virtualD               ; this sprite is to show     
      
                                  ; test if sprite is to expand in x              
      lda  actExpX,x
      beq  skipExpX
      
      lda  virtualEx              ; expand in x   
      ora  bitTable,x
      sta  virtualEx
      
skipExpX:      
                                  ; test if sprite is to expand in y              
      lda  actExpY,x
      beq  skipExpY
      
      lda  virtualEy              ; expand in y
      ora  bitTable,x
      sta  virtualEy

skipExpY:
                                  ; test if sprite is to make multicolor
      lda  actMultic,x
      beq  skipMultic
      
      lda  virtualM               ; make multicolor   
      ora  bitTable,x
      sta  virtualM      
      
skipMultic:                                                

      lda  xActLo,x               ; fix x position for sprite center
      clc
      adc  #12                    ; 24-12
      sta  temp1
      
      lda  actPrior,x
      beq  skipPrior
      
      lda  virtualP               ; make priority
      ora  bitTable,x
      sta  virtualP        
      
skipPrior:            

      lda  xActHi,x
      adc  #$00
      sta  temp2

      lda  yAct,x                 ; fix y position for sprite center
      clc
      adc  #30                    ; 50-20
      sta  temp3

      
      jsr  makeAnimation          ; make actor animation  
      
      lda  actFrame,x             ; store frame sprite address   
      sta  2040,x         
      sta  $8000+2040,x
      
      lda  actColor,x             ; give color for this sprite
      sta  $D027,x
      
      txa
      asl                         ; *2
      tay

      lda  temp1
      sta  $d000,y                ; store x sprite position
      lda  temp3
      sta  $d001,y                ; store y sprite position

      lda  temp2
      beq  skipFixH

      lda  virtualX
      ora  bitTable,x
      sta  virtualX               ; store msb of position in virtual register

skipFixH:
      dex
      bmi  finalDraw
      jmp  drawNext

finalDraw:
      lda  virtualX               ; fix msx position of sprite
      sta  $d010
      
      lda  virtualEx              ; fix sprite expansion x  
      sta  $d01d
      
      lda  virtualEy              ; fix sprite expansion y
      sta  $d017
      
      lda  virtualM               ; fix sprite multicolor   
      sta  $d01c
      
      lda  virtualP               ; set priority
      sta  $d01b      
      
      lda  virtualD               ; show sprites
      sta  $d015
            
      rts

bitTable:
  .byte  1,2,4,8,16,32,64,128


;================================
; Make animation for the actors
; use a table or routine for save 
; rastertime
;================================
makeAnimation:
      lda  actType,x
      asl
      tay
      lda  animateTable,y 
      sta  animAdd+1
      lda  animateTable+1,y 
      sta  animAdd+2
animAdd:
      jmp  $1234

;================================
; Null animated routine
;================================
animateNone:
      rts

;===============================
; Animate Sara
;===============================
animateSara:
      lda  xActSpeed,x
      beq  exitAS

      lda  actFrame,x           ; inc low bit as we have only 2 frames
      eor  #$01
      sta  actFrame,x
exitAS:
      rts

;================================
; Animate the ape
;================================
animateApe:
      inc  actFrameD,x           ; there is a delay for each frame 
      lda  actFrameD,x
      cmp  #AFD_APE
      bne  exitFrApe

      lda  #$00                  ; reset frame delay counter
      sta  actFrameD,x

      lda  actFrameV,x           ; read direction: 0 inc, 1 dec
      bne  decFrApe

      inc  actFrame,x
      lda  actFrame,x
      cmp  #SA_APE+5
      bne  exitFrApe

      inc  actFrameV,x           ; now movement is inverted 
      bne  exitFrApe

decFrApe:
      dec  actFrame,x
      lda  actFrame,x
      cmp  #SA_APE
      bne  exitFrApe

      dec  actFrameV,x           ; now movement is inverted
exitFrApe
      rts

;===============================
; Animate Ragno
;===============================
animateRagno:
      inc  actFrameD,x           ; there is a delay for each frame 
      lda  actFrameD,x
      cmp  #AFD_RAGNO
      bne  skipAR

      lda  #$00                  ; reset frame delay counter
      sta  actFrameD,x

      lda  actFrame,x            ; inc low bit as we have only 2 frames
      eor  #$01
      sta  actFrame,x 

skipAR:
      rts

;=================================
; Animate car 
;=================================
animateCar:
      inc  actFrameD,x           ; there is a delay for each frame 
      lda  actFrameD,x
      cmp  #AFD_CAR
      bne  skipAC

      lda  #$00                  ; reset frame delay counter 
      sta  actFrameD,x

      lda  actFrame,x            ; inc low bit as we have only 2 frames
      eor  #$01
      sta  actFrame,x
skipAC:
      rts


;================================
; Animate the lum
;================================
animateLum:
      inc  actFrameD,x           ; there is a delay for each frame 
      lda  actFrameD,x
      cmp  #AFD_LUM
      bne  exitFrLum

      lda  #$00                  ; reset frame delay counter
      sta  actFrameD,x 

      lda  actFrameV,x           ; read direction: 0 inc, 1 dec
      bne  decFrLum

      inc  actFrame,x
      lda  actFrame,x
      cmp  #SA_LUM+4
      bne  exitFrLum

      inc  actFrameV,x           ; now movement is inverted 
      bne  exitFrLum

decFrLum:
      dec  actFrame,x
      lda  actFrame,x
      cmp  #SA_LUM
      bne  exitFrLum

      dec  actFrameV,x           ; now movement is inverted
exitFrLum:
      rts

;=================================
; Animate the Spa monster
;=================================
animateSpa:
      inc  actFrameD,x           ; there is a delay for each frame 
      lda  actFrameD,x
      cmp  #AFD_SPA
      bne  exitFrSpa

      lda  #$00                  ; reset frame delay counter 
      sta  actFrameD,x

      lda  actFrame,x           ; inc low bit as we have only 2 frames
      eor  #$01
      sta  actFrame,x
exitFrSpa:
      rts

;=================================
; Animate the Mouse monster
;=================================
animateMouse:
      inc  actFrameD,x           ; there is a delay for each frame 
      lda  actFrameD,x
      cmp  #AFD_MOU
      bne  exitFrMou

      lda  #$00                  ; reset frame delay counter 
      sta  actFrameD,x

      lda  actFrame,x           ; inc low bit as we have only 2 frames
      eor  #$01
      sta  actFrame,x

exitFrMou:
noEnemy:
      rts

;=================================
; Insert enemy if needed
;=================================
insertEnemy:
      lda  enemy                  ; test if there is an enemy to add in this column
      beq  noEnemy

      ldx  #1
loopSearch:
      lda  actType,x
      beq  freeSprite

      inx
      cpx  #8                     ; don't add an enemy if there are all sprite enabled
      beq  noEnemy
      bne  loopSearch

freeSprite:
      lda  #1                     ; insert fix position for x
      sta  xActHi,x
      lda  #72
      sta  xActLo,x

      lda  enemy                  ; insert the correct y position
      clc
      adc  #5                     ; for 4 lines of scores + 1
      asl
      asl
      asl
      sta  yAct,x

      lda  #0
      sta  enemy                  ; enemy is added, so clear status
      sta  yActSpeed,x            ; no y speed

      ; insert the enemy based on map
      lda  enemyType
      sec
      sbc  #CH_FIRST
      asl
      tay
      lda  insertTable,y 
      sta  insertAdd+1
      lda  insertTable+1,y 
      sta  insertAdd+2
insertAdd:
      jmp  $1234



;=================================
; Insert a wolf enemy
;=================================
insertWolf:
      lda  #ACT_WOLF
      sta  actType,x              ; this is a wolf enemy
      lda  #SA_WOLF
      sta  actFrame,x             ; set wolf sprite
      lda  #253
      sta  xActSpeed,x            ; set speed for sx movement     

      lda  #0                     ; no expansion  
      sta  actExpX,x
      sta  actExpY,x
      sta  actPrior,x             ; no prority 
      sta  yActSpeed,x            ; no vertical speed
      lda  #1                     ; multicolor  
      sta  actMultic,x

      lda  #2
      sta  actInitD,x             ; use fix low initial delay     

      jsr  random                 ; set 3 colors by random
      cmp  #33
      bcc  c1
      cmp  #66
      bcc  c2
      lda  #5
      sta  actColor,x
      rts
c1:
      lda  #9
      sta  actColor,x
      rts
c2:
      lda  #10
      sta  actColor,x
      rts

;=================================
; Insert APE enemy
;=================================
insertApe:
      lda  #ACT_APE               ; this is an ape
      sta  actType,x
      lda  #SA_APE
      sta  actFrame,x             ; set initial ape frame
      lda  #10; $0E
      sta  actColor,x             ; set actor color
      lda  #$00
      sta  actFrameD,x            ; this is an animated frame 
      sta  actFrameV,x            ; direction inc 
      sta  xActSpeed,x            ; no initial x speed 
      sta  yActSpeed,x            ; no vertical speed
      sta  actSetUp,x             ; no set up jet

      lda  #0                     ; no expansion
      sta  actExpX,x
      sta  actExpY,x
      sta  actPrior,x             ; no prority
      lda  #1                     ; multicolor
      sta  actMultic,x

      jsr  random
      and  #$0F
      sta  actInitD,x             ; use random initial delay   
      rts

;=================================
; Insert RAGNO enemy
;=================================
insertRagno:
      lda  #ACT_RAGNO             ; this is a ragno
      sta  actType,x
      lda  #SA_RAGNO
      sta  actFrame,x             ; set initial ragno frame
      lda  #11 
      sta  actColor,x             ; set actor color

      lda  #1                     ; xpansion in y
      sta  actExpY,x
      sta  actPrior,x             ; set prority
      lda  #0
      sta  xActSpeed,x            ; no x speed  
      sta  actMultic,x            ; no multicolor  
      sta  actExpX,x
      sta  actFrameD,x            ; this is an animated frame 

      lda  #2
      sta  actInitD,x             ; use fix low initial delay  

      lda  #FC_RAGNO              ; reload conter  
      sta  actFrameV,x

      lda  #VE_RAGNO              ; set initial speed
      sta  yActSpeed,x 
noCar: 
      rts  

;=================================
; Insert LUM enemy
;=================================
insertLum:
      lda  #ACT_LUM               ; this is an lum
      sta  actType,x
      lda  #SA_LUM+1
      sta  actFrame,x             ; set initial ape frame

      jsr  random                 ; direction is random
      and  #$01
      sta  actFrameV,x            ; direction inc 

      lda  #5
      sta  actColor,x             ; set actor color
      lda  #$00
      sta  actFrameD,x            ; this is an animated frame 

      sta  xActSpeed,x            ; no initial x speed 
      sta  actSetUp,x             ; no set up jet
      sta  yActSpeed,x            ; no vertical speed

      ;lda  #0                     ; no expansion
      sta  actExpX,x
      sta  actExpY,x
      sta  actPrior,x             ; no prority
      lda  #1                     ; multicolor
      sta  actMultic,x

      rts

;================================
; Insert Spa monster
;================================
insertSpa:
      lda  #ACT_SPA               ; this is an spa
      sta  actType,x
      lda  #SA_SPA1
      sta  actFrame,x             ; set initial spa frame

      lda  #5
      sta  actColor,x             ; set actor color
      lda  #$00
      sta  actFrameD,x            ; this is an animated frame 

      sta  xActSpeed,x            ; no initial x speed 
      sta  actSetUp,x             ; no set up jet
      sta  yActSpeed,x            ; no vertical speed

      ;lda  #0                     ; no expansion
      sta  actExpX,x
      sta  actExpY,x
      sta  actPrior,x             ; no prority
      lda  #1                     ; multicolor
      sta  actMultic,x

      rts

;================================
; Insert Mouse monster
;================================
insertMouse:
      lda  #ACT_MOU               ; this is an spa
      sta  actType,x
      lda  #SA_MOUR
      sta  actFrame,x             ; set initial spa frame

      lda  #10
      sta  actColor,x             ; set actor color

      lda  #252
      sta  xActSpeed,x            ; set speed for sx movement

      lda  #$00
      sta  actFrameD,x            ; this is an animated frame 

      sta  actSetUp,x             ; no set up jet
      sta  yActSpeed,x            ; no vertical speed

      ;lda  #0                     ; no expansion
      sta  actExpX,x
      sta  actExpY,x
      sta  actPrior,x             ; no prority
      lda  #1                     ; multicolor
      sta  actMultic,x
      rts

;=================================
; Get next free index for sprite
; starting from passed x-1 index
; carry=1 if no more sprites are
; available
;=================================
getNextFree:
      inx
      cpx  #8                     ; don't add an enemy if there are all sprite enabled
      beq  noEnemy1

loopS1:
      lda  actType,x
      bne  getNextFree

      clc
      rts         
      
noEnemy1:
      sec
      rts      
      
      
;=================================
; Remove one enemy if it goes
; out of left screen
;=================================
removeEnemy:
      ldx  #1
loopRemove:
      lda  xActHi,x
      bne  skipLo

      lda  xActLo,x
      cmp  #15
      bcs  skipLo

      lda  #0
      sta  actType,x              ; remove this actor

skipLo:
      inx
      cpx  #8
      bne  loopRemove
      rts

;=================================
; Move the monsters
;=================================
moveMonster:
      inc  flipflopwait
      lda  flipflopwait
      and  #$01
      beq  forceret

      ldx  #1

      lda  actType,x
      beq  moveNext
      
loopMovMon:
      lda  actInitD,x            ; use a initial delay in movement  
      beq  makeMov
      dec  actInitD,x
      jmp  moveNext
      
makeMov:      
      lda  actType,x
      asl
      tay
      lda  moveTable,y 
      sta  moveAdd+1
      lda  moveTable+1,y 
      sta  moveAdd+2
moveAdd:
      jsr  $1234

moveNext:
      inx
      cpx  #8
      bne  loopMovMon
forceret:
      rts

;=================================
; Do not move
;=================================
movingNone:
      rts

;=================================
; Moving the wolf
;=================================
movingWolf:
      jsr  movZigZag             ; use a zig-zag movement 
      jsr  moveActorRX
      jsr  moveActorY
      rts

;=================================
; Moving the Ape
;=================================
movingApe:
      jsr  movSX                 ; always at sx
      jsr  moveActorOX
      jsr  moveActorY
      rts

;=================================
; Moving the Ragno
;=================================
movingRagno:
      jsr  moveRagno
      ;jsr  moveActorX           ; we don't move in x
      jsr  moveActorY
      rts

;=================================
; Moving the Spa
;=================================
movingSpa:
      rts

;=================================
; Moving the Mouse
;=================================
movingMouse:
      jsr  movZigZagMouse         ; use a zig-zag movement 
      jsr  moveActorRX
      jsr  moveActorY
      rts

;=================================
; Moving the Lum
;=================================
movingLum:
      rts

;=================================
; Make a zig-zag movement
;=================================
movZigZag:
      lda  xActSpeed,x
      bmi  negTest

      jsr  checkDx                ; test for a dx collision
      bcs  changeDir              ; if so change direction
      bcc  grCheck

negTest:
      jsr  checkSx                ; test for a sx collision
      bcs  changeDir              ; if so change direction

grCheck:                          ; check for ground under the monster
      jsr  checkGround
      bcs  exitMov                ; change direction if there is no ground

changeDir:
      jsr  changeXDir
exitMov: 
      rts 

;=================================
; Make a zig-zag movement of mouse
;=================================
movZigZagMouse:
      lda  xActSpeed,x
      bmi  negTestM

      jsr  checkDx                ; test for a dx collision
      bcs  changeDirM             ; if so change direction
      bcc  grCheckM

negTestM:
      jsr  checkSx                ; test for a sx collision
      bcs  changeDirM             ; if so change direction

grCheckM:                         ; check for ground under the monster
      jsr  checkGround
      bcs  exitMovM               ; change direction if there is no ground

changeDirM:
      lda  xActSpeed,x
      bmi  toDx
      lda  #SA_MOUR
      jmp  setAFMZ
toDx:
      lda  #SA_MOUL
setAFMZ:
      sta  actFrame,x
      jsr  changeXDir
exitMovM: 
      rts 


;==================================
; Make a sx only movement
;==================================
movSX:
      lda  actSetUp,x             ; if 0, we must init the speed
      bne  contMSX 

      lda  #$FE                   ; go at sx  
      sta  xActSpeed,x
      inc  actSetUp,x

contMSX:

      jsr  checkSx                ; test for a sx collision  
      bcc  exitMSX

      lda  #0                     ; turn off x speed 
      sta  xActSpeed,x
exitMSX:
      rts

;==================================
; Move the ragno up and down
;==================================
moveRagno:
      dec  actFrameV,x 
      bne  exitMR

      lda  #FC_RAGNO             ; reload conter
      sta  actFrameV,x

      lda  yActSpeed,x           ; invert movement
      eor  #$FF
      sec
      adc  #00 
      sta  yActSpeed,x

exitMR:
      rts
      
;================================
; Change x direction with same vel
;================================      
changeXDir:                      ; change the direction of monster
      lda  xActSpeed,x
      eor  #$FF
      sec
      adc  #00                    ; complement 1
      sta  xActSpeed,x      
      rts
      
;==================================
; Check dx collision
; we test the dx byte in middle
; position of sprite
;==================================
checkDx:
      lda  yAct,x
      sbc  #4;11                  ; this avoid bug in middle block
      jsr  commonCheck
      lda  (temp1),y              ; read the char under the actor
      cmp  #CHARKILL
      bcs  setKill                ; kill if the case

      cmp  #CHARLIMIT
      rts

;==================================
; Check sx collision
; we test the sx byte in middle
; position of sprite
;==================================
checkSx:
      lda  yAct,x
      sbc  #4;11                  ; this avoid bug in middle block
      jsr  commonCheck
      dey
      dey
      lda  (temp1),y              ; read the char under the actor
      cmp  #CHARKILL
      bcs  setKill                ; kill if the case

      cmp  #CHARLIMIT
      rts

;==================================
; check for Up collision
; we check the middle char over the
; sprite
; C=1 if there is the up collision
;==================================
checkUp:
      lda  yAct,x
      sbc  #21
      jmp  check

;==================================
; Check the ground below the actor
; C=1 if there is the ground (collision)
;==================================
checkGround:
      lda yAct,x
check:
      jsr  commonCheck
      dey                         ; use the center character

      lda  (temp1),y              ; read the char under the actor
      cmp  #CHARKILL
      bcs  setKill                ; kill if the case

      cmp  #CHARLIMIT
      rts

;==================================
; Check the ground below the actor
; but at dx of it
; C=1 if there is the ground (collision)
;==================================
checkDxGround:
      lda  yAct,x
      jsr  commonCheck

      lda  (temp1),y              ; read the char under the actor
      cmp  #CHARKILL
      bcs  setKill                ; kill if the case

continueCheck:
      cmp  #CHARLIMIT
      rts

;================================
; set that Sara is killed and 
; return as if no collision 
; with chard
;================================
setKill:
      cpx  #0                    ; only actor 0 must died with status
      bne  continueCheck

      pha
      lda  #1                    ; kill Sara ()
      sta  status
      pla
      clc
      rts

;=================================
; Common part of the check routine
; A= in: y actor position to check
; Y= out: char position in row to
;         check
; X= actor number
;=================================
commonCheck:
      lsr
      lsr
      lsr                        ; =/8 (row position)

      tay
      
      lda  memMap
      bne  table2
                                 ; use memory map 0
      lda  rowTblLo,y
      sta  temp1
      lda  rowTblHi,y
      sta  temp2
      jmp  contCheck
      
table2:                          ; use memory map 2
      lda  rowTblLo2,y
      sta  temp1
      lda  rowTblHi2,y
      sta  temp2
      
contCheck:
      ;lda  xActHi,x              ; divide x position by 8
      ;sta  temp3
      ;lda  xActLo,x

      lda  xActHi,x              ; divide x position by 8
      sta  temp3
      lda  xActLo,x
      sta  low

      lda  #8
      clc
      sbc  xScroll
      adc  low
      sta  low
      bcc  skHi
      inc  temp3
skHi:
      lda  low  
      lsr  temp3
      ror
      lsr  temp3
      ror
      lsr  temp3
      ror

      tay
exitDiamond:
      rts

low:  .byte 0


;=================================
; check if there is a diamond
; in one char near the actor
; and remove it from the memory map
;=================================
ckeckDiamond:
      ldx  #00
      jsr  checkGround
      cmp  #CH_DIAM1              ; check diamond under actor
      beq  isDiamond

      jsr  checkUp
      cmp  #CH_DIAM1              ; check diamond over actor
      beq  isDiamond

      jsr  checkSx                ; check diamond at sx of actor
      cmp  #CH_DIAM1
      beq  isDiamond

      jsr  checkDx                ; check diamond at dx of actor
      cmp  #CH_DIAM1
      bne  exitDiamond            ; moved up in commoncheck

isDiamond:
      lda  #CH_SPACE              ; filled the diamond with a space in current memory map
      sta  (temp1),y
      
      sta  valP+1
      lda  #CH_DIAM1              ; put values used in test porpagate
      sta  testP+1
      jsr  testPropagate
      
      sed                         ; decimal mode
      sec
      lda  bonus                  ; a bonus is taken
      adc  #0
      sta  bonus
      cld

      cmp  #BLIFE                 ; test if we have enought bonus for having a new life
      bne  noExtraL

      lda  #0
      sta  bonus                  ; clear bonus

      jsr  incLife                ; add a new life

noExtraL:
      lda  #DIAMPOINT
      jmp  addScore               ; add point

                                  ; the flower is taken

;=================================
; Check enemy collision
;=================================
checkEnemy:
      lda  $D01E                  ; read sprite/sprite collision
      beq  noCollision
                                  
      sta  temp1
      
      and  #$01                  ; if Sara has not collided, we exit
      beq  noCollision
      
      ldx  #7

loopCheck:
      lda  temp1
      and  bitTable,x
      beq  noColl

      lda  jump
      cmp  #2                     ; is Sara falling
      beq  monstKill              ; so the monster died

actKill:                          ; actor is died
      lda  #1
      sta  status
      rts

monstKill:
      lda  yActSpeed
      cmp  #4                     ; test if we have enought speed for killing the enemy
      bcc  actKill
      
      lda  actType,x              ; sara cannot kill a enemy with jump if it is above the limit
      cmp  #ACT_LIMIT
      bcs  actKill

      lda  #MONSPOINT
      jsr  addScore               ; add this points for having killed a monster

      ;lda  #0
      ;sta  actType,x             ; the monster is disabled (this not work correctly)

      txa
      asl
      tay
      lda  #0
      sta  actType,x
      ;sta  $d000,y; position the current X sprite at 0,0 (invisible anyway?)
      sta  $d001,y
      rts

noColl:
      dex
      bne  loopCheck

noCollision:
      rts
      
;================================
; performs a died animation
;================================      
diedAnimation:      
      lda  #0
      sta  xActSpeed             ; stop x motion of Sara
      
      lda  #$FD 
      sta  yActSpeed             ; move Sara up for a while
      
      ldx  #10
loopUp:      
      txa
      pha
      jsr  moveActor0Y           ; move Sara      
      jsr  waitIRQ               ; attend syncronization for madding the scroll
      jsr  drawSprites           ; draw all the actors      
      pla
      tax
      dex
      bne  loopUp
      
      lda  #$05
      sta  yActSpeed             ; move Sara down until out of screen
            
loopDn:      
      jsr  moveActor0Y           ; move Sara      
      jsr  waitIRQ               ; attend syncronization for madding the scroll
      jsr  drawSprites           ; draw all the actors 
      
      lda  yAct
      cmp  #200
      bcc  loopDn      
      rts

;================================
; Test for a bridge below the 
; actor. Test is made at some time
; interval, as bridge will change
; his structure...
;================================
testBridge:
      pha
      lda  timeBr                ; we test for a bridge only after some time
      bne  exitPTB

      pla
      cmp  #CH_BRIDGE1
      beq  goBR2
      cmp  #CH_BRIDGE2
      beq  goBR3
      cmp  #CH_BRIDGE3
      beq  goBR4
      rts

goBR2:
      lda  #CH_BRIDGE2           ; filled the bridge with next value in current memory map
      sta  (temp1),y

      sta  valP+1
      lda  #CH_BRIDGE1           ; put values used in test porpagate
      sta  testP+1
      jsr  testPropagate
      rts

goBR3:
      lda  #CH_BRIDGE3           ; filled the bridge with next value in current memory map
      sta  (temp1),y

      sta  valP+1
      lda  #CH_BRIDGE2           ; put values used in test porpagate
      sta  testP+1
      jsr  testPropagate
      rts 

goBR4:
      lda  #CH_BRIDGE4           ; filled the bridge with next value in current memory map
      sta  (temp1),y

      sta  valP+1
      lda  #CH_BRIDGE3           ; put values used in test porpagate
      sta  testP+1
      jsr  testPropagate
      rts



exitPTB:
      pla
      rts