; manage I/O routines


score:                           ; actual score
  .byte $00, $00, $00

hiScore:                         ; high score
  .byte $00, $00, $00

;=================================
; Clear the screen by removing
; actors and rewrite all
;=================================
clearScreen:
      jsr  removeActor            ; remove all actor
      jsr  drawSprites            ; be sure they are not now visible
      
      jsr  erase2Screen           ; clearing the screen with color
      jsr  writeGameTitle
      jsr  writeScoreTitle
      ;lda #$1b
      ;sta $d011
      rts


;==================================
; Get Joystick movement
;==================================
getJoystick:
      lda  #$FF
      sta  $DC00
      lda  $DC00
      eor  #$FF
      sta  joystick
      rts       
      
;=================================
; Write win string
;=================================
writeWin:
      lda  #<(SCREEN1+11*40+4)
      sta  CTO
      lda  #>(SCREEN1+11*40+4)
      sta  CTO+1
      
      lda  #<(SCREEN2+11*40+4)
      sta  CTO1
      lda  #>(SCREEN2+11*40+4)
      sta  CTO1+1      
      
      lda  #<Swin
      sta  CFROM
      lda  #>Swin
      sta  CFROM+1
      
      jsr  putString

      lda  #<(SCREEN1+12*40+4)
      sta  CTO
      lda  #>(SCREEN1+12*40+4)
      sta  CTO+1
      
      lda  #<(SCREEN2+12*40+4)
      sta  CTO1
      lda  #>(SCREEN2+12*40+4)
      sta  CTO1+1      
      
      lda  #<Swin2
      sta  CFROM
      lda  #>Swin2
      sta  CFROM+1
      
      jsr  putString 

      lda  #<(SCREEN1+13*40+4)
      sta  CTO
      lda  #>(SCREEN1+13*40+4)
      sta  CTO+1
      
      lda  #<(SCREEN2+13*40+4)
      sta  CTO1
      lda  #>(SCREEN2+13*40+4)
      sta  CTO1+1      
      
      lda  #<Swin3
      sta  CFROM
      lda  #>Swin3
      sta  CFROM+1
      
      jsr  putString 
      rts
Swin:
  .byte "WELL DONE SARA: YOU ARE THE BEST",0
Swin2:
  .byte "AND NOW IT'S TIME TO ATTEND LSS2",0
Swin3:  
  .byte "................................",0

;=================================
; Write title of game
;=================================
writeGameTitle:
      lda  #<(SCREEN1+24*40+1)
      sta  CTO
      lda  #>(SCREEN1+24*40+1)
      sta  CTO+1
      
      lda  #<(SCREEN2+24*40+1)
      sta  CTO1
      lda  #>(SCREEN2+24*40+1)
      sta  CTO1+1      
      
      lda  #<Sname
      sta  CFROM
      lda  #>Sname
      sta  CFROM+1
      
      jsr  putString             ; put the name of the game 
      rts
Sname:
  .byte "LITTLE SARA SISTER 1",78+64," BY ICE TEAM 2006",0

;=================================
; give bonus: time*25 points
;=================================
giveBonus:
      pha                      
      lda  #<(SCREEN1+13*40+10)
      sta  CTO
      lda  #>(SCREEN1+13*40+10)
      sta  CTO+1
      
      lda  #<(SCREEN2+13*40+10)
      sta  CTO1
      lda  #>(SCREEN2+13*40+10)
      sta  CTO1+1      
      
      lda  #<Sbonus
      sta  CFROM
      lda  #>Sbonus
      sta  CFROM+1
      
      jsr  putString      
      pla

      tax
loopBonus:
      stx  temp3
      lda  #$20
      jsr  addScore               ; add the score
      jsr  testScore              ; test if this is the high score
      jsr  writeScore
      jsr  waitIRQ
      ldx  temp3
      dex
      bne  loopBonus

      rts

Sbonus:
  .byte "BONUS:  TIME*20",0


;=================================
; Write fire string
;=================================
writeFire:
      lda  #<(SCREEN1+13*40+15)
      sta  CTO
      lda  #>(SCREEN1+13*40+15)
      sta  CTO+1
      
      lda  #<(SCREEN2+13*40+15)
      sta  CTO1
      lda  #>(SCREEN2+13*40+15)
      sta  CTO1+1      
      
      lda  #<Sfire
      sta  CFROM
      lda  #>Sfire
      sta  CFROM+1
      
      jsr  putString      
      rts

Sfire:
  .byte "PRESS FIRE",0
  

;=================================
; Write get ready string
;=================================
writeGetReady:
      lda  #<(SCREEN1+13*40+9)
      sta  CTO
      lda  #>(SCREEN1+13*40+9)
      sta  CTO+1
      
      lda  #<(SCREEN2+13*40+9)
      sta  CTO1
      lda  #>(SCREEN2+13*40+9)
      sta  CTO1+1      
      
      lda  #<Sgetr
      sta  CFROM
      lda  #>Sgetr
      sta  CFROM+1
      
      jsr  putString      
      rts

Sgetr:
  .byte "      GET READY...",0    

;=================================
; Write game over string
;=================================
writeGameOver:
      lda  #<(SCREEN1+11*40+15)
      sta  CTO
      lda  #>(SCREEN1+11*40+15)
      sta  CTO+1
      
      lda  #<(SCREEN2+11*40+15)
      sta  CTO1
      lda  #>(SCREEN2+11*40+15)
      sta  CTO1+1      
      
      lda  #<Sover
      sta  CFROM
      lda  #>Sover
      sta  CFROM+1
      
      jsr  putString       
      rts

Sover:
  .byte "GAME OVER",0

;=================================
; Write the title of score
;=================================
writeScoreTitle:
      lda  #<(SCREEN1+0*40+3)
      sta  CTO
      lda  #>(SCREEN1+0*40+3)
      sta  CTO+1
      
      lda  #<(SCREEN2+0*40+3)
      sta  CTO1
      lda  #>(SCREEN2+0*40+3)
      sta  CTO1+1      
      
      lda  #<Sscore
      sta  CFROM
      lda  #>Sscore
      sta  CFROM+1
      
      jsr  putString             ; put the name of the game      
      rts
Sscore:
  .byte "SCORE   BONUS    LIVES  LEVEL  TIME             ",CH_DIAM1+64,0

;=================================
; Write the score
;=================================
writeScore:
      lda  bonus                  ; write the number of bonus
      jsr  atoax
      stx  $400+40+14
      sta  $400+40+15
      stx  $8400+40+14
      sta  $8400+40+15

      lda  lifes
      ora  #$30
      sta  $400+40+22
      sta  $8400+40+22

      lda  level
      clc
      adc  #49                    ; add '1'
      sta  $400+40+29
      sta  $8400+40+29

      lda  time                   ; write the time
      jsr  atoax
      stx  $400+40+35
      sta  $400+40+36
      stx  $8400+40+35
      sta  $8400+40+36

      ldx  #0
      jsr  writePoints
      ldx  #3
      jsr  writePoints

      rts

;=================================
; write score
; x=0/3 0 for score, 3 for highscore
;=================================
writePoints:
      ldy  #0

      lda  #$2A                   ; this is the low address for score ($42A)
      cpx  #3
      bne  skipws

      lda  #$52                   ; this is the high address for hiscore ($452)
skipws:
      sta  wra1+1                 ; change low address as needed
      sta  wra11+1
      sta  wra2+1
      sta  wra21+1
      
loopws:
      lda  score,x
      pha
      lsr
      lsr
      lsr
      lsr
      ora  #$30
wra1:
      sta  $400+40+2,y
wra11:      
      sta  $8400+40+2,y
      iny
      pla
      and  #$0F
      ora  #$30
wra2:
      sta  $400+40+3,y
wra21:
      sta  $8400+40+3,y      
      inx
      iny
      cpy  #6
      bne  loopws
      rts

;=================================
; add points to score
; A=point to add
;=================================
addScore:
      stx  temp3
      ldx  #2
      ;ldy  #0                     ; clear carry indicator
      sed                         ; decimal mode
      clc
      adc  score,x
      sta  score,x
      bcc  exitscore

      ;iny                         ; carry indicator
      dex
      lda  #0
      adc  score,x
      sta  score,x
      bcc  exitscore

      dex
      lda  #0
      adc  score,x
      sta  score,x
exitscore:
      cld                         ; normal mode

      ;cpy  #0                     ; test carry indicator
      ;beq  skipAS

      ;lda  score+1                ; read middle of score
      ;and  #$3F
      ;cmp  #$40
      ;bne  skipAS                 ; if $40, we have reach another 4000 points

      ;jsr  incLife                ; give another life
skipAS:
      ldx  temp3
      rts

;=================================
; Test if this score must be the
; hiscore
;=================================
testScore:
                                  ; test if we have a new highscore
      lda  score
      cmp  hiScore
      bcc  notHS
      bne  setHS

      lda  score+1
      cmp  hiScore+1
      bcc  notHS
      bne  setHS

      lda  score+2
      cmp  hiScore+2
      bcc  notHS
      bne  setHS

notHS:
      rts

setHS:                             ; copy the score to hiscore
      ldx  #3
setHS_:
      lda  score-1,x
      sta  score+2,x
      dex
      bne  setHS_
      beq  notHS

;=================================
; input a=$12 output x= $31 "1" a= $32 "2"
;=================================
atoax:
      pha                      ; save A for lo-nibble fetch
      lsr
      lsr
      lsr
      lsr
      ora  #$30
      tax
      pla                      ;lo-nibble fetch
      and  #$0F
      ora  #$30
      rts
         
;================================
; Put a string in both memory map
; CTO, CTO+1, CFROM are to be setted
;================================      
putString:  
      ldx  #0 
loopWGT:      
      lda  (CFROM),x             ; read the char 
      beq  exitWGT
      
      cmp  #64
      bmi  skipAj
      
      sec
      sbc  #64                   ; CHR$ to Screen
skipAj:      
      
      sta  (CTO),x               ; copy in first place
      sta  (CTO1),x              ; copy in second place
      inc  CFROM
      bne  skF
      inc  CFROM+1  
skF:            
      inc  CTO
      inc  CTO1
      bne  skT
      inc  CTO+1  
      inc  CTO1+1
skT:      

      jmp  loopWGT
exitWGT:
      rts     
      
      
;================================
; Put a string in both memory map
; CTO, CFROM are to be setted
;================================      
put1String:  
      ldx  #0 
loopWGT1:      
      lda  (CFROM),x             ; read the char 
      beq  exitWGT1
      
      cmp  #64
      bmi  skipAj1
      
      sec
      sbc  #64                   ; CHR$ to Screen
skipAj1:      
      
      sta  (CTO),x               ; copy in first place
      
      inc  CFROM
      bne  skF1
      inc  CFROM+1  
skF1:            
      inc  CTO
      bne  skT1
      inc  CTO+1  
skT1:      

      jmp  loopWGT1
exitWGT1:
      rts
            
;================================
; Clear the screen in 1° memory
; map
;================================      
erase1Screen:      
      lda  #1
      jsr  SCREEN                ; clearing the screen with color in page 0
           
      lda  #1
      sta  memMap
      lda  #6
      sta  xScroll
 
      jsr  flipBank
      rts
      
;================================
; Clear the screen in both memory
; map
;================================      
erase2Screen:      
      ;jsr  erase1Screen
      
      ldx  #1                    ; clear in map 2 
      lda  #32
loopCS:
N     SET 0
      REPEAT 25       
      sta  SCREEN2+N*40,x
N     SET  N+1
      REPEND   
      inx
      cpx  #40
      bne  loopCS    

      jsr  erase1Screen
      rts      
      
;================================
; Clear the screen in bank 3 map
;================================      
erase3Screen:                  
      ldx  #0
      lda  #32
loopCS3:
N     SET 0
      REPEAT 25        
      sta  SCREEN3+N*40,x
N     SET  N+1
      REPEND   
      inx
      cpx  #40
      bne  loopCS3      
      rts      

            
;================================
; Wait for a fire action
; this avoit too fast pressing
;================================
waitFire:
releasefire
      jsr  getJoystick          ; check for already pressed fire
      and  #JOY_FIRE
      bne  releasefire
waitFire2                       ; wait a joystick fire action
      jsr  getJoystick
      and  #JOY_FIRE
      beq  waitFire2
      rts      
      
;================================
; Flip from bank 0 to 3
;================================      
vicBank3:                                 
      lda  $DD00      
      and  #$FC
      sta  $DD00
      rts

;================================                   
; Flip form bank 3 to 0
;================================
vicBank0:
      lda  $DD00
      ora  #$03
      sta  $DD00       
      rts
      

  
;=================================
; Write Credits
;=================================
writeCredits:
      lda  #<(SCREEN3+4*40+15)
      sta  CTO
      lda  #>(SCREEN3+4*40+15)
      sta  CTO+1            
      
      lda  #<STT
      sta  CFROM
      lda  #>STT
      sta  CFROM+1
      
      jsr  put1String             ; put the name of the game

      lda  #7
      ldy  #8
loopT1:
      sta  $D800+4*40+14,y
      dey
      bne  loopT1
     

      lda  #<(SCREEN3+10*40+12)
      sta  CTO
      lda  #>(SCREEN3+10*40+12)
      sta  CTO+1            
      
      lda  #<ST0
      sta  CFROM
      lda  #>ST0
      sta  CFROM+1
      
      jsr  put1String             ; put the name of the game

      lda  #<(SCREEN3+12*40+6)
      sta  CTO
      lda  #>(SCREEN3+12*40+6)
      sta  CTO+1            
      
      lda  #<ST1
      sta  CFROM
      lda  #>ST1
      sta  CFROM+1
      
      jsr  put1String             ; put the name of the game    
      
      lda  #<(SCREEN3+13*40+6)
      sta  CTO
      lda  #>(SCREEN3+13*40+6)
      sta  CTO+1            
      
      lda  #<ST2
      sta  CFROM
      lda  #>ST2
      sta  CFROM+1
      
      jsr  put1String             ; put the name of the game      
      
      lda  #<(SCREEN3+15*40+9)
      sta  CTO
      lda  #>(SCREEN3+15*40+9)
      sta  CTO+1            
      
      lda  #<ST3
      sta  CFROM
      lda  #>ST3
      sta  CFROM+1
      
      jsr  put1String             ; put the name of the game          

      lda  #<(SCREEN3+21*40+11)
      sta  CTO
      lda  #>(SCREEN3+21*40+11)
      sta  CTO+1            
      
      lda  #<ST4
      sta  CFROM
      lda  #>ST4
      sta  CFROM+1
      
      jsr  put1String            

      lda  #<(SCREEN3+22*40+14)
      sta  CTO
      lda  #>(SCREEN3+22*40+14)
      sta  CTO+1            
      
      lda  #<ST5
      sta  CFROM
      lda  #>ST5
      sta  CFROM+1
      
      jsr  put1String 


      lda  #4
      ldy  #16
loopT2:
      sta  $D800+21*40+10,y
      sta  $D800+22*40+13,y
      dey
      bne  loopT2
      rts

STT:  .byte "LSS 1.5",0
ST0:  .byte "MAIN CREDITS:",0
ST1:  .byte "ICE00            CODE, GFX",0
ST2:  .byte "RICHARD BAYLISS  MUSIC",0
ST3:  .byte "BY ICE TEAM (C) 2006",0
ST4:  .byte "USE JOYSTICK #2",0
ST5:  .byte "FIRE TO GO",0



;================================
; Make an animated color effect
;================================
colorEffect:
      ldx  #39
loopCEF:
      lda  colorA,x
      sta  $D800+11*40,x
      sta  $D800+12*40,x
      sta  $D800+13*40,x
      sta  $D800+14*40,x
      sta  $D800+15*40,x
      dex
      bpl  loopCEF

                                  ; rotate colors to left
      lda  colorA
      sta  dummy
                                           
      ldx  #1
      ldy  #0
loopSX:      
      lda  colorA,x
      sta  colorA,y
      inx
      iny
      cpx  #39
      bne  loopSX
      lda  dummy
      sta  colorA,y
      rts

; credits test color effect tables
colorA:
  .byte  1,  1,  1,  1,  1,  3, 3,  3,  3, 5
  .byte  5,  5,  5,  3,  3,  5,  5, 5, 5,  3
  .byte  3,  3,  3,  1,  1,  1,  1,  7,  7,  7
  .byte  2,  2,  2,  2,  7,  7,  7,  1,  1,  1
  
colorB:
  .byte $00
  
effect:
  .byte $01

