; manage IRQ/time routines


;==================================
; play music, set IRQ1, set graphics
; for scroll
;==================================
irqR0:
      lda  xScroll
      and  #$07
      ora  #$10
      sta  $D016                 ; set scroll for x as needed    

      ldx  #1
      stx  $d019                 ; acknowledge the raster interrupt
      lda  #<irqR1
      sta  $0314
      lda  #>irqR1
      sta  $0315
      lda  #RASTER1
      sta  $D012                 ; Reading/Writing IRQ balance value

      lda  jumpDelay
      beq  pMusic

      dec  jumpDelay             ; decrease the delay for next jump
pMusic:
      jsr  playMusic    
      
      jsr  diamondAnim           ; animation for diamond
      jsr  forkAnim              ; animation for fork

                                 ; increment time for bridge
      inc  timeBr
      lda  timeBr
      cmp  #T_BRIDGE
      bne  skipTB

      lda  #0
      sta  timeBr
skipTB:

      jmp  $ea81

;=================================
; set IRQ0, set graphics for title
; screen, let performs scrolling
;=================================
irqR1:
      ldx  #1
      stx  $d019                  ; acknowledge the raster interrupt     

      lda  #<irqR0
      sta  $0314

      lda  #$00
      sta  $D016                  ; set not scroll for x (here it did not get flickers)

      lda  #>irqR0
      sta  $0315
      lda  #RASTER0
      sta  $D012                  ; Reading/Writing IRQ balance value

      lda  #1
      sta  GO

      lda  effect
      bne  exitIRQ

      jsr  colorEffect
exitIRQ:

      jmp  $ea81 
      
      
      
;=================================
; Dec time of 1 sec. after 50
; frames
;=================================
decTime:
      lda  time
      beq  noDecTime
      inc  timeDl
      lda  timeDl
      cmp  #50                    ; 50 frames (pal)=1 second
      bcc  noDecTime
      lda  #$00
      sta  timeDl                 ; reset time frame (delay) conter
      sed
      lda  time
      sec
      sbc  #$01                   ; sub 1 second (in decimal mode)
      sta  time
      cld
      bne  noDecTime

      ; time out
      lda  #1                     ; we must died as out of time
      sta  status
noDecTime:
      rts


;==================================
; Wait for IRQ before going on
;==================================
waitIRQ:
      lda  GO
      beq  waitIRQ
      dec  GO
      rts
      
      
;================================
; waste time (X=amount)
;================================      
wasteTime      
      jsr  waitIRQ
      dex
      bne  wasteTime      
      rts
      
;==================================      
; install interrupt routine
;==================================
installIRQ:
      sei
      lda  #0
      sta  GO
      
      lda  #<irqR0
      sta  $0314
      lda  #>irqR0
      sta  $0315
                                 ; disable cia interrupt
      ldx  #$00
      stx  $DC0E                 ; Control register A of CIA #1
      inx
      stx  $D01A                 ; IRQ mask register
      cli
                                 ; use VIC interrupt
      stx  $D019                 ; Interrupt indicator register
      lda  #RASTER0
      sta  $D012                  ; Reading/Writing IRQ balance value
      lda  #$1B
      sta  $D011                  ; VIC control register      
      rts      
      

      
;timer = $0700      


dummy: .byte 00