; manage scroll routines

;=================================
; Check for scroll:
; A= amount to scroll
;=================================
checkScroll:
      ldx  #$00
      lda  xActHi
      cmp  #1
      bcs  needScroll
      lda  xActLo
SCR:
      cmp  #200
      bcc  noneedScroll
needScroll:
      ldx  #$02
noneedScroll:
      txa
      rts

;=================================
; Made the hw/sw Scroll
; A = pixel to shift (0..4)
;=================================
madeScroll:
      ldx  xMap                  ; test if we reach the end of the map
      cpx  mapSize
      bcc  canMadeScroll
      rts

canMadeScroll:                   ; store tha amount of shift for sprite and graphics
      sta  shiftVel+1
      sta  shiftVel2+1
      sta  shiftSVel+1

      ldx  #7                    ; shift all the sprite according to the graphics
doScrollSpr:
      lda  xActLo,x
      sec
shiftSVel:
      sbc  #$00
      sta  xActLo,x
      lda  xActHi,x
      sbc  #$00
      sta  xActHi,x
      dex
      bpl  doScrollSpr

      lda  xScroll               ; shift the graphics
      sec
shiftVel:
      sbc  #$00
      bmi  swShift
      sta  xScroll
      
      sec                        ; test if at the current speed, the next scroll we must flip page
shiftVel2:      
      sbc  #$00    
      bpl  exitSV
      jsr  copyScreen            ; copy the screen in hidden map, as in the next scroll we must flip page (if goes at current speed)
      lda  #1
      sta  propagate             ; we must propagate change in the new pages if necessary
exitSV:        
      rts
swShift:
      and  #$07
      sta  xScroll

      jsr  flipBank              ; flip memory bank                    
      jsr  shiftColor            ; shift the color map
      jsr  drawLastCol           ; draw the last column after the shift

      lda  #0
      sta  propagate             ; don't need to propagate anymore
      rts

;=================================
; Shift the memory graphics to sx
;=================================
shiftColor:
      ldx  #1                     ; shift the color map to sx of one char every 1 columns
loop2SG:
N     SET 4
      REPEAT SCROLLROWS/2
      lda  $D800+N*40,x
      sta  $D800+N*40-1,x
N     SET  N+1
      REPEND   
      inx
      cpx  #40
      bne  loop2SG                 

      ldx  #1                     ; shift the color map to sx of one char every 1 columns
loop3SG:
N     SET (SCROLLROWS/2+4)
      REPEAT (SCROLLROWS/2)
      lda  $D800+N*40,x
      sta  $D800+N*40-1,x
N     SET  N+1
      REPEND   
      inx
      cpx  #40
      bne  loop3SG       

      rts

;=================================
; Draw next char in block of last
; column
;=================================
drawLastCol:
      lda  mapAddr               ; set the actual map pointer
      clc
      adc  xMap
      sta  actMapAddr
      lda  mapAddr+1
      adc  #$00
      sta  actMapAddr+1

      lda  memMap                ; use screen according with actual map 
      bne  theOther
      
      lda  #<(SCREEN1+4*40+39)   ; set destination (last char of first line)
      sta  dest
      lda  #>(SCREEN1+4*40+39)
      sta  dest+1
      jmp  contDraw
      
theOther: 
      lda  #<(SCREEN2+4*40+39)   ; set destination (last char of first line)
      sta  dest
      lda  #>(SCREEN2+4*40+39)
      sta  dest+1
      jmp  contDraw    

contDraw:
      lda  #<($D800+4*40+39)     ; set destination (last char of first line)
      sta  cDest
      lda  #>($D800+4*40+39)
      sta  cDest+1

      lda  #20                   ; we have 20 rows to update
      sta  rowLeft

      ldy  #$00
      sty  temp1                 ; row position index

loopWrite:
      ldx  xBlock

      lda (actMapAddr),y         ; read next block in the map for this row
      tay
      
      lda  colorTblLo,y          ; read source pos from table
      sta  sourcePosC+1
      lda  colorTblHi,y
      sta  sourcePosC+2            
     
      lda  blockTblLo,y          ; read source pos from table
      sta  sourcePos+1
      lda  blockTblHi,y
      sta  sourcePos+2      

      lda  actMapAddr            ; next row of the map is MAPSIZE after
      clc
      adc  mapSize
      sta  actMapAddr            ; adjust map pointer low
      lda  actMapAddr+1
      adc  #$00
      sta  actMapAddr+1          ; adjust map pointer hi
      ldy  #$00   
      
sourcePos:
      lda  BLOCKS,x              ; read the right caracter
      sta  (dest),y              ; write to the destination

      jsr  checkChar             ; check char for enemy/effect
      
      inc  temp1                 ; set for next row

sourcePosC:      
      lda  BKCOLOR,x             ; read the color for this block at the given position
      ;sta  actBkColor            ; remember actual color for this block        
      ;lda  actBkColor
      sta  (cDest),y             ; write color to destination

      lda  dest                  ; move destination to the next row
      clc
      adc  #40
      sta  dest
      lda  dest+1
      adc  #0
      sta  dest+1

      lda  cDest                 ; move color destination to the next row
      clc
      adc  #40
      sta  cDest
      lda  cDest+1
      adc  #0
      sta  cDest+1

      txa
      adc  #4
      tax

      dec rowLeft                ; one row is out
      beq nextInBlock

      cpx #$10
      bcc sourcePos
      jmp loopWrite

nextInBlock:                     ; set pointer for next block & increase map if necessary
      inc  xBlock
      lda  xBlock
      cmp  #$04
      bcc  exitIB
      lda  #$00
      sta  xBlock
      inc  xMap
exitIB:
      rts

;================================
; Check char for enemy/effect
; enemy must be in order
; (FIRST to LAST)
;================================
checkChar:      
      cmp  #CH_FIRST
      bcc  otherC

      cmp  #CH_LAST
      bcc  isMonst

otherC:
      cmp  #CH_RESTART           ; check for restart point
      bne  exitCC

      lda  xMap
      clc
      sbc  #0
      sta  restart               ; store restart point if Sara is killed
exitCC:
      rts
      
isMonst:      
      sta  enemyType             ; store the type of enemy 
      lda  temp1
      sta  enemy                 ; set enemy row position
      rts


;rowTblLo:
;N      SET 0
       ;REPEAT 24
       ;dc.b #<($400+N*40)
;N      SET N+1
       ;REPEND
rowTblHi:
N      SET 0
       REPEAT 24
       dc.b #>($400+N*40)
N      SET N+1
       REPEND
       
rowTblLo2:
N      SET 0
       REPEAT 24
       dc.b #<($8400+N*40)
N      SET N+1
       REPEND
       
rowTblHi2:
N      SET 0
       REPEAT 24
       dc.b #>($8400+N*40)
N      SET N+1
       REPEND       
       
       
;================================
; Copy actual screen to hidden page
;================================              
copyScreen:
       lda  memMap
       beq  c1to2
       jmp  c2to1
        
;================================
; Copy from screen 1 ($400)
; to screen 2($8400) with scrolling
;================================       
c1to2:
       ldx  #1
sh1to2:
N      SET 4
       REPEAT SCROLLROWS
       lda  SCREEN1+N*40,x
       sta  SCREEN2+N*40-1,x
N      SET  N+1
       REPEND   
       inx
       cpx  #40
       bne  sh1to2
       rts

;================================
; Copy from screen 2 ($8400)
; to screen 1 ($400) with scrolling
;================================       
c2to1:
      ldx  #1
sh2to1:
N     SET 4
      REPEAT SCROLLROWS
      lda  SCREEN2+N*40,x
      sta  SCREEN1+N*40-1,x
N     SET  N+1
      REPEND   
      inx
      cpx  #40
      bne  sh2to1
      rts      

       
;================================
; Flip bank
;================================       
flipBank: 
      lda  memMap
      beq  f1to2
                                 ; flip from bank 2 to 0
      
      lda  $DD00
      ora  #$03
      sta  $DD00                                  
      dec  memMap
 ;inc 53280
      rts
f1to2:                           ; flip from bank 0 to 2

      lda  $DD00
      ora  #$01
      and  #$FD
      sta  $DD00
 ;dec 53280
      inc  memMap         
      rts     
      
;================================
; test if it is necessary to
; propagate changes into the 2 
; pages and make this
; temp1= address in current map
;================================      
testPropagate:      
      lda  propagate             ; test if we need propagation 
      beq  exitProp             
       
      lda  temp1                 ; copy actual address
      sta  CTO
      lda  temp1+1
      sta  CTO+1
      
      lda  CTO+1
      
      ldx  memMap                ; calculate address in the other map
      bne  mm2      
      
      clc                        ; map: 400->8400
      adc  #$80      
      jmp  contProp
mm2:            
      sec                        ; ap: 8400->400
      sbc  #$80      
contProp:
      sta  CTO+1
      
      dey                        ; we have to test the char before as map is left shifted            
      lda  (CTO),y               ; read the char in the other map
testP:
      cmp  #CH_DIAM1             ; be sure it is a diamond
      bne  exitProp
valP:
      lda  #CH_SPACE            
      sta  (CTO),y               ; replace with space 
exitProp:      
      rts
       
memMap:                          ; memory map: 0=bank 0, 1=bank 2
  .byte $00       
  
propagate:                       ; 1= propagate changes into the 2 pages if necessary
  .byte $00  
  
enemyType:                       ; type of enemy from the map
  .byte $00  
  
restart:                         ; x map position of restart point
  .byte $00  
  