
;=================================
; Select map according to the level
;=================================
selectMap:
      ldy  level      
      lda  mapTableLow,y
      sta  mapAddr      
      lda  mapTableHigh,y
      sta  mapAddr+1
      
      ldy  #0
      lda  (mapAddr),y            ; read screen color
      sta  $D020                      
      sta  $D021
      
      clc                         ; inc pointer
      lda  #01
      adc  mapAddr
      sta  mapAddr
      bcc  skipI1
      inc  mapAddr+1
skipI1:

      lda  (mapAddr),y            ; read music to play
      sta  musicToPlay

      clc                         ; inc pointer
      lda  #01
      adc  mapAddr
      sta  mapAddr
      bcc  skipI2
      inc  mapAddr+1
skipI2:      

      lda  (mapAddr),y            ; read x map size
      sta  mapSize

      clc                         ; inc pointer
      lda  #01
      adc  mapAddr
      sta  mapAddr
      bcc  skipI3
      inc  mapAddr+1
skipI3:


exitSelect
      lda  #0
      sta  xBlock
      ;sta  xMap
      ;sta  restart               ; set restart point in case of kill  
      rts

;=================================
; Inc life but not too much
;=================================
incLife:
      lda  lifes
      cmp  #9
      beq  skipLF                 ; we cannot have more then 9 lifes

      inc  lifes                  ; get an extra life
skipLF
      rts

;=================================
; Get a random number 
; routine in publication magazine
;=================================
random:
     inc  Z
     ldy  Z
     lda  $DC04
     eor  $FEDC,y
     eor  $D012
     rts
Z: .byte $00     
    