/*
 * Snake.c

 */

#include "Snake.h"

void PrintMessage (short score);

long __Startup__()
{
  SysAppInfoType	*appInfo;
  void				*prevGlobals;
  void				*globalsPtr;
  long				result = -1;

  // MUST be called for Palm to initialize application
  if (SysAppStartup(&appInfo, &prevGlobals, &globalsPtr) == 0) 
  {
    // If this is a normal launch run, otherwise bail out
    if (appInfo->cmd == sysAppLaunchCmdNormalLaunch)
    {
		EventType		event;
		short			SnakeDirection;
		short			SnakeSize = PAUSED;
		RectangleType	rec;
		Boolean			redo;
			
		MemHandle		h;
		MemPtr			p;
		Segment			*s;
		
		// create a block of memory capable of holding 150 snake segments
		h = MemHandleNew (sizeof(Segment) * 150);
		// lock the memory
		p = MemHandleLock (h);
		// point the snake segments at the memory
		s = p;

		// set the rectangle size to the snake size
		rec.extent.x = rec.extent.y = SNAKE_SIZE;	

// start of game
START:
		// tell the user the game is paused, display the score
		PrintMessage (SnakeSize);
		
		// set draw apple flag to true
		redo = true;	
		// set the original snake direction
		SnakeDirection = UP;
		// set the original position of the snake
		s[0].x = s[0].y = 80;
		// pause the game
		SnakeSize = PAUSED;
		
		do
		{
			if(SnakeSize != PAUSED)	
				// if the game isn't paused, delay until it's time for the next animation
				// NOTE: the delay decreases as more apples are eaten to make it harder
				SysTaskDelay(100/SnakeSize + 10);

			// get an event from the queue
			EvtGetEvent(&event, 1); 	
																											
			// if a keydown event occurs
			if (event.eType == keyDownEvent)
			{
				// if it is a hard key
				if (event.data.keyDown.chr >= vchrHard1	&& 
					event.data.keyDown.chr <= vchrHard4 ||
					event.data.keyDown.chr == pageDownChr ||
					event.data.keyDown.chr == pageUpChr)
				{
					// if the game is paused
					if (SnakeSize == PAUSED)
					{
							// unpause game
							SnakeSize = 2;
							// erase the window because there is a message there
							WinEraseWindow();
					}else
					{

						// check to see if the snake is reversing direction, if not allow the
						// direction to change
						if(SnakeDirection - event.data.keyDown.chr != 1 &&
							event.data.keyDown.chr - SnakeDirection != 1)
							// the new direction is equal to the key pressed
							SnakeDirection = event.data.keyDown.chr; 
					}

					// change the event so the system doesn't exit when a hard key is pressed
					event.eType = nilEvent;
				} // is a hardkey
			} //keydown event
				
			// allow the system to handle the event
			SysHandleEvent (&event);		

			// if the game isn't paused, update the snake
			if (SnakeSize != PAUSED)
			{
				// shift the array representing the body up one position
				DmWrite (s, sizeof(Segment), s, sizeof(Segment) * 149);
							
				// update head of snake
				if (SnakeDirection == DOWN)
					s[0].y += SNAKE_SIZE;
				if (SnakeDirection == UP)
					s[0].y -=  SNAKE_SIZE;
				if (SnakeDirection == RIGHT1 || SnakeDirection == RIGHT2)
					s[0].x += SNAKE_SIZE;																																			
				if (SnakeDirection == LEFT1 || SnakeDirection == LEFT2)
					s[0].x -=  SNAKE_SIZE;																						

				// check if the head crashed on the body
				if (WinGetPixel (s[0].x, s[0].y))
					goto START; 
				
				// check if there is an apple, or the new apple flag is true
				if (WinGetPixel (s[0].x + 2, s[0].y) || redo)
				{
					// calc a random position for the apple
					rec.topLeft.x = SysRandom (0) % (BOARD_SIZE / 10) * 10;
					rec.topLeft.y = SysRandom (0) % (BOARD_SIZE / 10) * 10;
				
					// if the random position is on the snake head set the redo flag to true
					// else if the random position is on the snake set the redo flag
					if (s[0].x - rec.topLeft.x + s[0].y - rec.topLeft.y)
						redo = WinGetPixel(rec.topLeft.x, rec.topLeft.y);
					else 
						redo = true;
					
					// if redo is false, increment SnakeSize because an apple was eaten
					SnakeSize += redo | 1; 
					// draw the apple
					WinDrawRectangle (&rec, 3);	
				} // apple eaten OR redo flag is true						
				
				// erase the tail
				rec.topLeft.x = s[SnakeSize].x;
				rec.topLeft.y = s[SnakeSize].y;
				WinEraseRectangle (&rec, 0);		

				// draw the head
				rec.topLeft.x = s[0].x;
				rec.topLeft.y = s[0].y;
				WinDrawRectangle (&rec, 0);	
		
				// check if the head is out of bounds
				if (!WinGetPixel(s[0].x, s[0].y))
					goto START;
			} // if the game isn't paused
		}while(event.eType != appStopEvent); // loop until the user exits
			
		// unlock the snake memory
		MemHandleUnlock(h);
		// free the memory
		MemHandleFree(h); 
	} // normal launch

    // MUST be called before exiting application
    SysAppExit(appInfo, prevGlobals, globalsPtr);
  } // SysAppStartup(...) failed
  
  return result;
} // long __Startup__()

void PrintMessage (short score)
{
	char cScore[10];

	// draw the message to the screen
	WinDrawChars("-Press Any Key to Begin-", 24, 29, 70);

	// convert the score into a string
	StrIToA (&cScore, score);
	
	// create the score message
	StrPrintF (&cScore, "Score: %i", score);

	// draw the score to the screen
	WinDrawChars (cScore, StrLen (cScore), 65, 80);			
} // void PrintMessage(short score)