#include "draw2d.h"
#include "gfx.h"

extern void userAction();
extern u8 reset;
extern GPDRAWSURFACE	gpDraw[2];
extern int				backbuf;

extern Board curboard;

const int display[7] =
{
	5, /* W pawn */
	5, /* B pawn */
	0, /* rook */
	2, /* bishop */
	3, /* queen */
	1, /* knight */
	4  /* king */
};

#define DX 56
#define DY 16
#define P_W 26
#define P_H 26

extern void gm_printf(char*,int,int);
extern void gm_flip();
extern void clearScreen();
extern u8 flipBoard;
extern s16 getClock(u8);
extern u32 getMachineTime();
extern void drawClock(int);
extern void waitNoKey();

u8 dpal = 255;

void drawBoard2D(Board b)
{
	int i,j,k=56,l;

	clearScreen();
	for (i=0;i<8;i++)
	{
		l=1-(i&0x1);
		for (j=0;j<8;j++)
		{
			unsigned char p = b->board[flipBoard?63-k-j:k+j];
			GpBitBlt(NULL, &gpDraw[backbuf], DX+j*P_W, DY+i*P_H, P_W, P_H, (unsigned char*)GFX_IMG, 6*P_W, l*P_H, GFX_W, GFX_H);
			l = 1-l;
			if (p!=DEAD)
			{
				int x = display[b->types[p]];
				int y = (COLOR(p)==WHITE)?1:0;
				GpTransBlt(NULL, &gpDraw[backbuf], DX+j*P_W, DY+i*P_H, P_W, P_H, (unsigned char*)GFX_IMG, x*P_W, y*P_H, GFX_W,GFX_H,dpal);
			}
		}
		k-=8;
	}
	drawClock(backbuf);
}

u8 svx,svy;

void initGfx2D(u16 *pmain,int smain)
{
	GP_HPALETTE h_pal;
	u16 palette[256],i;
	gm_memset(palette,0,256);
	gm_memcpy(palette,pmain,smain);
	gm_memcpy(((u8*)palette)+smain,GFX_PAL,sizeof(GFX_PAL));
	if (dpal==255)
	{
		dpal = (u8)(smain>>1);
		for (i=0;i<sizeof(GFX_IMG);i++)
			GFX_IMG[i] += dpal;
	}
	palette[255]=0x0000; /* black */
	palette[254]=0xfffe; /* white */
	palette[253]=0xf800; /* red */
	palette[252]=0xffc0; /* yellow */
	palette[251]=0xfe00; /* orange */
	h_pal = GpPaletteCreate( 256, palette );
	GpPaletteSelect( h_pal );
	GpPaletteRealize();
	svx = svy = 4;
}

extern u8 view2d;
extern u8 lastsrc,lastdst;

void drawRect(u8 x,u8 y,u8 col,u8 flip)
{
	if (flip)
	{
		x = 7-x;
		y = 7-y;
	}
	GpRectDraw(&gpDraw[backbuf],DX+x*P_W,DY+y*P_H,DX+(x+1)*P_W-1,DY+(y+1)*P_H-1,col);
	GpRectDraw(&gpDraw[backbuf],DX+x*P_W-1,DY+y*P_H-1,DX+(x+1)*P_W,DY+(y+1)*P_H,col);
}

u8 selPos2D(u8 src)
{
	int key = 0;
	u8 x=svx,y=svy,nx=x,ny=y,sx=0,sy=0,lsx=0,lsy=0,ldx=0,ldy=0;
	u8 ret;

	if (src!=DEAD)
	{
		sx = COL(src);
		sy = 7-ROW(src);
		nx = x = flipBoard?7-sx:sx;
		ny = y = flipBoard?7-sy:sy;
	}
	drawBoard2D(curboard);
	drawRect(x,y,253,0);
	if (src!=DEAD)
		drawRect(sx,sy,251,flipBoard);
	if (lastsrc!=DEAD)
	{
		lsx = COL(lastsrc);
		lsy = 7-ROW(lastsrc);
		ldx = COL(lastdst);
		ldy = 7-ROW(lastdst);
		drawRect(lsx,lsy,252,flipBoard);
		drawRect(ldx,ldy,252,flipBoard);
	}
	gm_flip();
	GpThreadSleep(10);
	while (!(key & (GPC_VK_FA|GPC_VK_FB)))
	{
		key = GpKeyGet();
		if ((key & GPC_VK_LEFT) && x>0)  nx--;
		if ((key & GPC_VK_RIGHT) && x<7) nx++;
		if ((key & GPC_VK_UP) && y>0)    ny--;
		if ((key & GPC_VK_DOWN) && y<7)  ny++;
		userAction();
		if (reset||!view2d)
			return DEAD;
		if (x!=nx||y!=ny)
		{
			drawBoard2D(curboard);
			if (src!=DEAD)
				drawRect(sx,sy,251,flipBoard);
			if (lastsrc!=DEAD)
			{
				drawRect(lsx,lsy,252,flipBoard);
				drawRect(ldx,ldy,252,flipBoard);
			}
			drawRect(nx,ny,253,0);
			gm_flip();
			GpThreadSleep(80);
			svx = x = nx;
			svy = y = ny;
		}
	}
	ret = (key&GPC_VK_FB)?DEAD:(flipBoard?POS(y,7-x):POS(7-y,x));
	waitNoKey();
	return ret;
}

const u8 promos2D[] = {T_QUEEN,T_ROOK,T_BISHOP,T_KNIGHT};

u8 getPromotion2D(Board b,u8 pos)
{
	int key = 0;
	u8 p = 0,i = b->board[pos],r = 7-ROW(pos),c = COL(pos),np = p;
	drawBoard2D(b);
	drawRect(c,r,251,flipBoard);
	gm_flip();
	while (!(key & GPC_VK_FA))
	{
		key = GpKeyGet();
		if ((key & GPC_VK_LEFT)||(key & GPC_VK_UP))
			np = p>0?p-1:3;
		if ((key & GPC_VK_RIGHT) || (key & GPC_VK_DOWN))
			np = p<3?p+1:0;
		userAction();
		if (np!=p)
		{
			p = np;
			b->types[i] = promos2D[p];
			drawBoard2D(b);
			drawRect(c,r,251,flipBoard);
			gm_flip();
			GpThreadSleep(80);
		}
	}
	waitNoKey();
	return promos2D[p];
}

void animateMove2D(u8 src,u8 dst)
{
	drawBoard2D(curboard);
	gm_flip();
}
