#include "GamePartner.h"
#include "gpmain.h"

int	backbuf = 0;

#include "draw2d.h"
#include "draw3d.h"

#include "background.h"

#define VIEW_3D 0
#define VIEW_2D 1

u8 view2d;
u8 flipBoard;
u8 pieceSet = 0;
u8 curspeed;

int options[7] = {0,0,1,0,2,0,0}; /* default game options */

extern	Board	curboard;
extern	u8		verify(Board,u8,u8);
extern	u8		play(u8,u8,Board,u8,u8);
extern	u8		playMove(u8,u8,u8,u8);
extern	void	playMoveSnd();
extern	void	playLoop2(int);
extern	void	playNoise();
extern	void	stopMoveSnd();
extern	void	stopLoop2();
extern	void	stopNoise();

void gm_flip()
{
	GpSurfaceFlip(&gpDraw[backbuf++]);
	backbuf &= 0x01;
}

void gm_printf(char *s,int x,int y)
{
	if (view2d)
		GpTextOut(NULL, &gpDraw[backbuf], x, y, s, 254);
}

void gm_printf_shadow(char *s,int x,int y,int color)
{
	GpTextOut(NULL, &gpDraw[backbuf], x+1, y+1, s, 255);
	GpTextOut(NULL, &gpDraw[backbuf], x-1, y-1, s, 255);
	GpTextOut(NULL, &gpDraw[backbuf], x-1, y+1, s, 255);
	GpTextOut(NULL, &gpDraw[backbuf], x+1, y-1, s, 255);
	GpTextOut(NULL, &gpDraw[backbuf], x, y, s, color);
}

void showBoard()
{
	if (view2d)
	{
		drawBoard2D(curboard);
		gm_flip();
	}
	else
		drawBoard3D(curboard,DEAD,DEAD);
}

void initGfx()
{
	if (view2d)
		initGfx2D((u16*)BKGRND_PAL,sizeof(BKGRND_PAL));
	else
		initGfx3D((u8*)BKGRND_IMG,(u16*)BKGRND_PAL,sizeof(BKGRND_IMG));
}

u8 selPos(u8 src)
{
	if (view2d)
		return selPos2D(src);
	else
		return selPos3D(src);
}

void waitNoKey()
{
	while (GpKeyGet());
}

/**
 * Time
 */

s16 clock[2];
s16 masterClk;
u8 clkidx;
const s16 fbonus[] = {0,2,5,10,30}; /* Increment clock time bonus */

u32 getMachineTime()
{
	return GpTickCountGet()/1000;
}

s16 getChessClock()
{
	return clock[clkidx];
}

s16 getTimeBonus()
{
	return fbonus[options[selectedIncrement]];
}

s16 getClock(u8 side)
{
	s16 ret;
	if (options[selectedTime]==0)
		return -1;
	side = side==WHITE?0:1;
	if (side==clkidx)
		ret = clock[side]-(getMachineTime()-masterClk);
	else
		ret = clock[side];
	return ret<0?0:ret;
}

void initClocks()
{
	const s16 clks[] = {-1,300,600,900,1800};
	clock[0] = clock[1] = clks[options[selectedTime]];
	clkidx = 0;
	masterClk = getMachineTime();
}

void switchClock()
{
	clock[clkidx] = clock[clkidx]-(getMachineTime()-masterClk)+fbonus[options[selectedIncrement]];
	clkidx=1-clkidx;
	masterClk = getMachineTime();
}

void suspendTime()
{
	clock[clkidx]-=getMachineTime()-masterClk;
}

void resumeTime()
{
	masterClk = getMachineTime();
}

void setSpeed(u8 speed)
{
	if (speed!=curspeed)
	{
		GpClockSpeedChange(speeds[speed].master_speed*1000000, speeds[speed].div_factor, speeds[speed].clk_mode);
		curspeed = speed;
		masterClk = getMachineTime();
	}
}

void doNoise()
{
	playNoise();
	GpThreadSleep(80);
	stopNoise();
}

/**
 *
 */

void animateMove(u8 src,u8 dst)
{
	if (view2d)
		animateMove2D(src,dst);
	else
		animateMove3D(src,dst);
}

/**
 *
 */

u8 getPromotion(Board b,u8 pos)
{
	if (view2d)
		return getPromotion2D(b,pos);
	else
		return getPromotion3D(b,pos);
}

/**
 *
 */

extern u8 reset;

void playerMove(u8 col)
{
	u8 src,dst;
	u8 p = 0;
	struct _board tmpboard;
	while (1)
	{
		src = DEAD;
		do
		{
			src = selPos(DEAD);
			doNoise();
			if (src!=DEAD)
				p = curboard->board[src];
			else if (reset)
				return;
		} while (src==DEAD || p==DEAD || COLOR(p)!=col);
		do
		{
			dst = selPos(src);
			if (dst==DEAD)
				break;
			else if (reset)
				return;
			p = curboard->board[dst];
		} while (p!=DEAD && COLOR(p)==col);
		if (dst==DEAD)
		{
			doNoise();
			continue;
		}
		if (verify(curboard,src,dst))
			continue;
		copy(&tmpboard,curboard);
		play(src,dst,&tmpboard,T_QUEEN,0);
		if (!isCheck(&tmpboard,col))
			break;
	}
	if (   (curboard->types[curboard->board[src]]==T_WPAWN && ROW(dst)==7)
 		|| (curboard->types[curboard->board[src]]==T_BPAWN && ROW(dst)==0))
		p = getPromotion(&tmpboard,dst);
	playMove(src,dst,p,1);
	animateMove(src,dst);
	playMoveSnd();
	GpThreadSleep(200);
	stopMoveSnd();
	switchClock();
	setSpeed(options[selectedSpeed]);
}

void computerMove(u8 src,u8 dst,u8 promo)
{
	animateMove(src,dst);
	playMoveSnd();
	GpThreadSleep(40);
	stopMoveSnd();
	switchClock();
	if (view2d)
		setSpeed(SPEED_40);
	else
		setSpeed(SPEED_133);
}

void clearScreen()
{
	if (view2d)
		gm_memcpy(gpDraw[backbuf].ptbuffer,BKGRND_IMG,sizeof(BKGRND_IMG));
}

void Init(u8 mode)
{
	view2d = mode;
	if (view2d)
	{
		GpGraphicModeSet(GPC_DFLAG_8BPP, NULL);
		setSpeed(SPEED_40);
	}
	else
	{
		GpGraphicModeSet(GPC_DFLAG_16BPP, NULL);
		setSpeed(SPEED_133);
	}
	GpLcdSurfaceGet(&gpDraw[0], 0);
	GpLcdSurfaceGet(&gpDraw[1], 1);
	backbuf = 0;
	clearScreen();
	backbuf = 1;
	GpSurfaceSet(&gpDraw[0]);
	initGfx();
}

void drawMenu(const char**menu,int x,int y,int n,int idx,int xm,int ym,char *msg)
{
	int i;
	clearScreen();
	for (i=0;i<n;i++)
	{
		if (i==idx)
			gm_printf(">",x-10,y);
		gm_printf_shadow((char*)menu[i],x,y,254);
		y+=14;
	}
	gm_printf_shadow(msg,xm,ym,254);
	gm_flip();
}

u8 gameMenu()
{
	int key,idx = 0,n;
	const char* menu[]={"START A NEW GAME","GAME CREDITS","SHOW INTRO","EXIT TO GP32"};
	drawMenu(menu,100,90,4,idx,80,180,"PDROMS.DE COMPO 2003");
	while (1)
	{
		key = GpKeyGet();
		if (key & GPC_VK_FB)
			return CANCEL;
		if ((key & GPC_VK_FA)||(key & GPC_VK_START)||(key & GPC_VK_SELECT))
			return idx;
		n = idx;
		if (((key&GPC_VK_UP)||(key&GPC_VK_LEFT)) && n>0)
			n--;
		if (((key&GPC_VK_DOWN)||(key&GPC_VK_RIGHT)) && n<3)
			n++;
		if (n!=idx)
		{
			doNoise();
			idx = n;
			drawMenu(menu,100,90,4,idx,80,180,"PDROMS.DE COMPO 2003");
		}
	}
}

/**
 *
 */

void drawSubMenu(const char**menu,const char**choices,const int*count,int*sel,int x,int y,int w,int n,int idx,char*msg,int xm,int ym)
{
	int i,j=0;
	clearScreen();
	for (i=0;i<n;i++)
	{
		if (idx==i)
			gm_printf(">",x-10,y);
		gm_printf_shadow((char*)menu[i],x,y,254);
		gm_printf_shadow((char*)choices[j+sel[i]],x+w,y,254);
		j+=count[i];
		y+=12;
	}
	gm_printf_shadow(msg,xm,ym,254);
	gm_flip();
}

u8 gameSubMenu()
{
	int key,idx = 0,n,mod;
	const char* menu[]={"COLOR","LEVEL","USE BOOK","VIEW","TIME","INCREMENT","SPEED"};
	const char* items[] ={	"WHITE","BLACK",
						 	"BEGINNER","ELO 1050","ELO 1100","ELO 1150","ELO 1200",
							"NO","YES",
							"2D","3D",
							"NO LIMIT","5 mn","10 mn","15 mn","30 mn",
							"NONE","2 s","5 s","10 s","30 s",
							"40","66","80","100","120","133"};
	const int icount[] = {2,5,2,2,5,5,6};
	drawSubMenu(menu,items,icount,options,90,80,80,7,idx,"PRESS START TO PLAY",80,180);
	while (1)
	{
		key = GpKeyGet();
		if (key & GPC_VK_START)
			return PLAY;
		mod = 0;
		if (key & GPC_VK_FB)
		{
			options[idx] = options[idx]==0?icount[idx]-1:options[idx]-1;
			mod = 1;
		}
		if ((key & GPC_VK_FA)||(key & GPC_VK_SELECT))
		{
			options[idx] = options[idx]+1<icount[idx]?options[idx]+1:0;
			mod = 1;
		}
		n = idx;
		if (((key&GPC_VK_UP)||(key&GPC_VK_LEFT)) && n>0)
			n--;
		if (((key&GPC_VK_DOWN)||(key&GPC_VK_RIGHT)) && n<6)
			n++;
		if (n!=idx || mod)
		{
			doNoise();
			idx = n;
			drawSubMenu(menu,items,icount,options,90,80,80,7,idx,"PRESS START TO PLAY",80,180);
		}
	}
}

/**
 *
 */

u8 inGameMenu()
{
	int key,idx = 1,n,ret=0;
	const char* menu[]={"ABORT GAME","RETURN TO GAME","CHANGE VIEW","EXIT TO GP32"};

	suspendTime();
	if (!view2d)
		Init(VIEW_2D);
	drawMenu(menu,100,90,4,idx,80,180,"WWW.PDROMS.DE RULES");
	while (1)
	{
		key = GpKeyGet();
		if (key & GPC_VK_FB)
		{
			ret = CANCEL;
			break;
		}
		if (key & (GPC_VK_FA|GPC_VK_START|GPC_VK_SELECT))
		{
			ret = idx;
			break;
		}
		n = idx;
		if ((key&(GPC_VK_UP|GPC_VK_LEFT)) && n>0)
			n--;
		if ((key&(GPC_VK_DOWN|GPC_VK_RIGHT)) && n<3)
			n++;
		if (n!=idx)
		{
			doNoise();
			idx = n;
			drawMenu(menu,100,90,4,idx,80,180,"WWW.PDROMS.DE RULES");
		}
	}
	waitNoKey();
	resumeTime();
	return ret;
}

void drawClock(int bb)
{
	s16 clk;
	char buf[16];

	clk = getClock(WHITE);
	if (clk<0)
		return;
	GpRectFill(NULL,&gpDraw[bb],9,10,44,14,255);
	GpRectFill(NULL,&gpDraw[bb],269,215,44,14,255);
	if (clk==0)
		gm_sprintf(buf,"FLAG");
	else
		gm_sprintf(buf,"%02d:%02d",clk/60,clk%60);
	GpTextOut(NULL, &gpDraw[bb], flipBoard?10:270, flipBoard?10:215, buf, 254);
	clk = getClock(BLACK);
	if (clk==0)
		gm_sprintf(buf,"FLAG");
	else
		gm_sprintf(buf,"%02d:%02d",clk/60,clk%60);
	GpTextOut(NULL, &gpDraw[bb], flipBoard?270:10, flipBoard?215:10, buf, 254);
}

u32 curtime = 0;

void userAction()
{
	int key = GpKeyGet();
	if (key&GPC_VK_START||key&GPC_VK_SELECT)
	{
		u8 savspeed = curspeed;
		u8 savview = view2d;
		doNoise();
		waitNoKey();
		switch(inGameMenu())
		{
			case ABORT_GAME:
				abortGame();
				break;
			case EXIT_GAME:
				GpAppExit();
			case CHANGE_VIEW:
				savview = 1-savview;
				break;
		}
		playMoveSnd();
		GpThreadSleep(50);
		stopMoveSnd();
		if (!savview)
			Init(VIEW_3D);
		showBoard();
		setSpeed(savspeed);
	}
	if (key&GPC_VK_FR)
	{
		if (view2d)
			flipBoard = 1-flipBoard;
		else
			pieceSet = 1 - pieceSet;
		showBoard();
		waitNoKey();
	}
	if (view2d && curtime!=getMachineTime())
	{
		curtime=getMachineTime();
		drawClock(1-backbuf);
	}
}

/**
 *
 */

void waitButton()
{
	int key = 0;
	while(!(key & (GPC_VK_FA|GPC_VK_FB|GPC_VK_START|GPC_VK_SELECT)))
		key = GpKeyGet();
	waitNoKey();
}

void gameCredits()
{
	int x = 65;
	clearScreen();
	gm_printf_shadow("CODE  : THOR",x,80,254);
	gm_printf_shadow("GFX   : MADXX, The 8tre",x,95,254);
	gm_printf_shadow("MUSIC : MADXX",x,110,254);
	gm_printf_shadow("THANKS TO :",x,130,254);
 	gm_printf_shadow("Kojote,MrSpiv,RCX21000",x+5,145,254);
	gm_printf_shadow("COPYLEFT  2003",x+40,170,254);
	gm_printf_shadow("Shadow Of Dawn",x+40,182,254);
	gm_flip();
	waitButton();
	playMoveSnd();
	GpThreadSleep(50);
	stopMoveSnd();
}

void showResult(u8 result)
{
	const char*resmsg[] = {
		"  STALEMAT, DRAW GAME.   ",
		"      MAT, YOU WIN !     ",
		"       MAT, I WIN !      ",
		"DRAW, 3 FOLD REPETITIONS.",
		"  DRAW, 50 MOVES RULE.   ",
		"   I RESIGN, YOU WIN !   ",
		"       GAME ABORTED      ",
		"   TIME OUT, YOU WIN !   ",
		"    TIME OUT, I WIN !    "
	};
	waitNoKey();
	if (!view2d)
		Init(VIEW_2D);
	drawBoard2D(curboard);
	gm_printf_shadow((char*)resmsg[result],56,112,252);
	gm_flip();
	waitButton();
	playMoveSnd();
	GpThreadSleep(100);
	stopMoveSnd();
}

void GpMain(void *arg)
{
	u8 option,result;
	curspeed = 255;
	GpPcmInit(PCM_M11,PCM_8BIT);
	while(1)
	{
		Init(VIEW_3D);
		playLoop2(srates[curspeed]);
		intro3D();
		stopLoop2();
		playMoveSnd();
		GpThreadSleep(100);
		stopMoveSnd();
		Init(VIEW_2D);
		playLoop2(srates[curspeed]);
		do
		{
			option = gameMenu();
			waitNoKey();
			playMoveSnd();
			GpThreadSleep(50);
			stopMoveSnd();
			switch(option)
			{
				case NEW_GAME:
					option=gameSubMenu();
					break;
				case CREDITS:
					gameCredits();
					break;
				case EXIT:
					GpAppExit();
			}
		} while (option!=PLAY && option!=INTRO);
		waitNoKey();
		stopLoop2();
		if (option==INTRO)
			continue;
		playMoveSnd();
		GpThreadSleep(50);
		stopMoveSnd();
		if (options[selectedView])
			Init(VIEW_3D);
		flipBoard = options[selectedColor];
		initClocks();
		if (options[selectedColor])
			setSpeed(options[selectedSpeed]);
		result = playChess(options[selectedColor]?WHITE:BLACK,options[selectedLevel],options[selectedBook]);
		showResult(result);
	}
}

u8 random()
{
	return GpRandN(255);
}
