
#define BITSPERLONG sizeof(int)*8

#define TOP2BITS(x) (x>>(BITSPERLONG-2))

#define NN 0  /* range: 0...BITSPERLONG/2 */

unsigned int isqrt(unsigned int x)
{
    unsigned int i;
	unsigned int r;
    unsigned int a = 0;               /* accumulator */
    unsigned int e = 0;               /* trial product */

    r=0;                                /* remainder */
    for (i=0; i<BITSPERLONG/2+NN; i++)  /* NOTE 1 */
    {
        r <<= 2;                        /* NOTE 2 */
        r +=  TOP2BITS(x);
        x <<= 2;

        a <<= 1;
        e  =  (a<<1)+1;

        if ( r>=e )
        {
            r-=e;
            a++;
        }
    }

    return a;
}
