DECLARE FUNCTION Floormap! (secs%)
DECLARE SUB palgrad (col1%, R1%, g1%, b1%, col2%, r2%, g2%, b2%)

DECLARE FUNCTION plasma! (secs%)
DECLARE FUNCTION fadeoff% (grades%, r%, g%, b%)
DECLARE SUB shadowpal ()
DECLARE FUNCTION LoadPcx% (PCX$, sg&, ofs%)
DECLARE SUB drawsphere (x%, y%, r%, lightdir!, lightazi!, dire!)
DECLARE FUNCTION xTIMER& ()
DECLARE SUB EraseScreenBuffer ()
DECLARE FUNCTION TexturedBall! (file$, move%, secs%)

CONST sec2mili! = 1193181.666# / 64
CONST mili2sec! = 1 / sec2mili!
CONST pi = 3.141592
CONST pi2 = 2 * pi
CONST scrrel! = 1.6666666# * 200 / 300
CONST scrrelinv! = 1 / scrrel!

CONST debug = 1
REDIM SHARED tex(127, 127) AS INTEGER
DIM SHARED wseg&, buffseg&
REDIM SHARED b(-8 TO 128 * 128) AS INTEGER
wseg& = VARSEG(b(0)) + 1
b(-2) = 256 * 8
b(-1) = 128

REDIM SHARED buffer(-8 TO 31999) AS INTEGER
buffseg& = VARSEG(buffer(0)) + 1


temp% = buffseg&
DIM SHARED ylut%(199)
FOR i% = 0 TO 199: ylut%(i%) = temp%: temp% = temp% + 20: NEXT
DIM SHARED divt%(0 TO 16736)
DIM SHARED mapz%(-1024 TO 1024)
DIM SHARED mapx%(-1024 TO 1024)
DIM SHARED mapy%(-1024 TO 1024)
REDIM SHARED frames!(1 TO 10)

SCREEN 13: CLS
RANDOMIZE TIMER
palgrad 0, 0, 0, 0, 255, 0, 0, 0
frames!(1) = TexturedBall("fdemo.pcx", 1, 30)
EraseScreenBuffer
palgrad 0, 0, 0, 0, 255, 0, 0, 0
CLS
frames!(2) = plasma!(30)
palgrad 0, 0, 0, 0, 255, 0, 0, 0
CLS
frames!(3) = Floormap!(30)
palgrad 0, 0, 0, 0, 255, 0, 0, 0
CLS

frames!(10) = TexturedBall("world32.pcx", 2, 50)
palgrad 0, 0, 0, 0, 255, 0, 0, 0



SCREEN 0: WIDTH 80, 25: CLS
PRINT "Intro frame rate:"; frames!(1)
PRINT "Plasma frame rate:"; frames!(2)
PRINT "Floormap frame rate:"; frames!(3)
PRINT "World frame rate:"; frames!(10)
PRINT
PRINT "My First Demo  by Antoni Gual (agual@eic.ictnet.es)"
PRINT "Programmed for the October 2001 Toshi's QB Demo Competition"
PRINT
PRINT "Greets to Toshi and to all QB coders there!"


a$ = INPUT$(1)

END
fmap:
'READ tim%,xj&,  angle, height, dee, vangle
DATA  5,   600,      0,      0,   0,      0
DATA  1,     0,      0,      0,   0,      0 
DATA  5,     0,    300,      0,   0,      0
DATA  1,     0,      0,      0,   0,      0 
DATA  5,     0,      0,    200,   0,      0
DATA  1,     0,      0,      0,   0,      0 
DATA  5,   300,   -100,   -200,   0,      0
DATA  1,     0,      0,      0,   0,      0
DATA  5,   600,      0,      0,   0,      0
     
DATA -1

SUB drawsphere (x%, y%, r%, lightdir, lightazi, dire)
'3d shadowed sphere drawing using dithering and a range of color palette
'by Antoni Gual  agual@eic.ictnet.es 5/2001
'INPUTS:
'x%, y%  position on screen
'r%      radius
'clr%    base color (the darkest one in range, it must be the lower palette nr)
'scrang  in radians direction of the light source
'vertang in radians angle of the light source to a line perpendicular to screen
'SHARED VARIABLES THAT MUST BE INITIALIZED BEFORE CALLING ROUTINE:
'clrng%   must be set to the width of a color range
'scrrel!  IS the screen shape factor(1.6666*200/320 for SCR 13)
'buffseg& SEGMENT of screen buffer. If drawing directly to screen set to &HA000
'buffoff% OFFSET from start of buffer, set to 0 for screen and 4 for PUT array
'----------------------------------------------------------------------------
SHARED clrng%
    r2& = CLNG(r%) * r%
    'calc light direction components
    CONST clrngt% = 8 * 256
    temp! = SIN(lightazi)
    xl! = COS(lightdir) * temp! * clrngt%
    yl! = SIN(lightdir) * temp! * clrngt%
    zl! = COS(lightazi) * clrngt%
    R1! = 1! / r%
    r2! = R1! * scrrelinv!
    
    'draw line by line
    clr% = 0
    FOR j% = -r% TO r%
        yj% = y% + j%
        IF yj% > 199 THEN EXIT FOR
        IF yj% >= 0 THEN
            sg1& = ylut%(yj%)
            rand2% = RND * 256
            j1! = j% * R1!
            tp1! = j1! * yl!
            tp3! = 1 - j1! * j1!
            texy& = mapy%(j%) * 256&
            'pixels of a screen line
            a! = SQR(r2& - j% * j%) * scrrel!
            aa% = INT(a!)
            aaa! = r% / (a! + .000000001#)
            FOR i% = -aa% TO aa%
                xI% = x% + i%
                IF xI% > 319 THEN EXIT FOR
                IF xI% >= 0 THEN
                    'calc the z component as a function of the dist to center
                    i1! = i% * r2!
                    k1! = SQR(tp3! - i1! * i1!)
                    'calc brightness as dot product normal * light direction
                    c% = xl! * i1! + tp1! + k1! * zl!
                    DEF SEG = wseg&
                    t1% = (mapx%(i% * aaa!) + dire) AND 255
                    ccc% = PEEK(texy& + t1%)
                    c1% = ccc% + (256 - 32 * (CINT(c% \ 256) - ((c% AND 255) > mapz%((c% + rand2%) AND 255))))
                    IF c1% > 255 THEN c1% = 255
                    DEF SEG = sg1&
                    POKE xI%, c1%
                END IF
                
           NEXT
        END IF
    NEXT
END SUB

SUB EraseScreenBuffer
 REDIM buffer(-8 TO 31999) AS INTEGER
 buffer(-2) = 2560
 buffer(-1) = 200
END SUB

DEFINT A-Z
FUNCTION fadeoff (grades%, r%, g%, b%)
cols = col2 - col1 + 1
dr = ABS(r2 - R1)
dg = ABS(g2 - g1)
db = ABS(b2 - b1)
r = R1
g = g1
b = b1
OUT &H3C8, col1
FOR i = 1 TO grades
    OUT &H3C9, r
    OUT &H3C9, g
    OUT &H3C9, b
    er = er - dr: eg = eg - dg: eb = eb - db
    WHILE er < 0: er = er + cols: r = r + 1: WEND
    WHILE eg < 0: eg = eg + cols: g = g + 1: WEND
    WHILE eb < 0: eb = eb + cols: b = b + 1: WEND
NEXT

END FUNCTION

FUNCTION Floormap! (secs%)
'textures
CLS
CONST texsize = 128
CONST texsize1 = texsize - 1

FOR i = 0 TO texsize1
    FOR j = 0 TO texsize1
        tex(i, j) = i XOR j
    NEXT
NEXT
'fixed point
CONST fixbase = 128
CONST longtext32 = -1& + texsize * fixbase
CONST line8 = 320 * 8
CONST invline = 1 / 320


SCREEN 13
palgrad 0, 0, 0, 0, 128, 32, 0, 32
palgrad 255, 63, 63, 63, -1, 0, 0, 0
COLOR 255
'angle tables
CONST pi256 = pi2 / 256

DIM cosinus(0 TO 256), sinus(0 TO 256)
DIM lrr!(0 TO 199), cdcg!(0 TO 256), sgsd!(0 TO 256)
FOR i = 0 TO 256
 cosinus(i) = fixbase * COS(pi256 * i)
 sinus(i) = fixbase * SIN(pi256 * i)
NEXT



FOR i = 0 TO longtext32
    divt(i) = (i \ fixbase) AND texsize1
NEXT


 xj& = 0
 yj& = 0
 height = 64: lheig = height - 1
 dee = 111: ldee = dee - 1
 angle = 0:  langle = angle - 1
 vangle = 30 * 256 / 360: lvangle = vangle - 1
 'frame count
 t! = TIMER: tend! = t! + secs%
 f = 0
 ttt& = xTIMER
 'main loop
 DO
  'move
  IF TIMER > tt! THEN
    READ tim%
    IF tim% < 0 THEN EXIT DO
    READ dyx%, dangle%, dheight%, ddee%, dvangle%
    tt! = TIMER + tim
    tim2& = tim * sec2mili!
  END IF
  t& = xTIMER - ttt&: ttt& = xTIMER
  tdiv! = t& / tim2&
  IF dangle% THEN langle = angle: angle = CINT(angle + dangle% * tdiv!) AND 255
  IF dyx% THEN
    yj& = (yj& - tdiv! * dyx% * sinus(angle)) AND longtext32
    xj& = (xj& + tdiv! * dyx% * cosinus(angle)) AND longtext32
  END IF
  IF dheight% THEN lheig = height: height = height + dheight% * tdiv!

  'recalc tables if parameters varied

  IF dee <> ldee THEN
   IF dee < ldee THEN EraseScreenBuffer
   dee200 = dee - 200
   R1 = 210 - dee: IF R1 < 0 THEN R1 = 0
   GOSUB tablelr: ldee = dee
  END IF

  IF lheig <> height THEN GOSUB tablelr: lheig = height

  IF vangle <> lvangle THEN
    FOR i = 0 TO 256
      cdcg!(i) = fixbase * (COS(pi256 * (i + vangle)) - COS(pi256 * (i - vangle))) * invline
      sgsd!(i) = fixbase * (SIN(pi256 * (i - vangle)) - SIN(pi256 * (i + vangle))) * invline
    NEXT
    GOSUB tablelr
    angleg = (angle - vangle) AND 255
    cg& = cosinus(angleg)
    sg& = sinus(angleg)
    lvangle = vangle
  END IF

  IF langle <> angle THEN
    GOSUB tableang
    angleg = (angle - vangle) AND 255
    cg& = cosinus(angleg)
    sg& = sinus(angleg)
    langle = angle
  END IF
  

  'draw floor
  FOR j = R1 TO 199
     t1 = mapx%(j)
     X1 = (xj& + t1 * cg&) AND longtext32
     Y1 = (yj& - t1 * sg&) AND longtext32
     dx1 = mapy%(j)
     dy1 = mapz%(j)
     DEF SEG = ylut%(j)
     FOR i = 0 TO 319
       POKE i, tex(divt(X1), divt(Y1))
       X1 = X1 + dx1 AND longtext32
       Y1 = Y1 + dy1 AND longtext32
  NEXT i, j

  'put buffer to screen
  PUT (0, 0), buffer(-2), PSET
  'LOCATE 1, 1: PRINT dee; height; angle; xj&; yj&; vangle
  f = f + 1
 LOOP UNTIL LEN(INKEY$) OR (TIMER > tend!)
Floormap! = f / (TIMER - t!)
ERASE cosinus, sinus, lrr!, cdcg!, sgsd!
EXIT FUNCTION

tablelr:
    deeh! = CSNG(dee) * height * vangle / 21
    FOR i = R1 TO 199
        lrr!(i) = deeh! / (dee200 + i)
    NEXT
tableang:
   
    FOR i = R1 TO 199
        tmp! = lrr!(i)
        mapx%(i) = tmp!
        mapy%(i) = tmp! * cdcg!(angle)
        mapz%(i) = tmp! * sgsd!(angle)
    NEXT

RETURN

END FUNCTION

FUNCTION LoadPcx (PCX$, sg&, ofs%)
'LOADS A PCX into a buffer. Modified from Kurt Kuzba
'
f = FREEFILE
OPEN PCX$ FOR BINARY AS #f
IF LOF(f) = 0 THEN CLOSE #f: KILL PCX$: LoadPcx = 1: EXIT FUNCTION

fin& = LOF(1) - 767: SEEK #f, fin&: p$ = INPUT$(768, 1)
p% = 1: fin& = fin& - 1
OUT &H3C8, 0: DEF SEG = VARSEG(p$)
FOR t& = SADD(p$) TO SADD(p$) + 767: OUT &H3C9, PEEK(t&) \ 4: NEXT

SEEK #f, 129: t& = ofs%: rle% = 0
DO
   p$ = INPUT$(256, f): fpos& = SEEK(f): l% = LEN(p$)
   IF fpos& > fin& THEN l% = l% - (fpos& - fin&): done = 1
   FOR p& = SADD(p$) TO -1& + SADD(p$) + l%
      DEF SEG = VARSEG(p$): dat% = PEEK(p&): DEF SEG = sg&
      IF rle% THEN
         FOR rle% = rle% TO 1 STEP -1
            POKE t&, dat%: t& = t& + 1
         NEXT
      ELSE
         IF (dat% AND 192) = 192 THEN
            rle% = dat% AND 63
         ELSE
            POKE t&, dat%: t& = t& + 1
         END IF
      END IF
   NEXT
LOOP UNTIL done
CLOSE f
END FUNCTION

SUB palgrad (col1, R1, g1, b1, col2, r2, g2, b2)
'creates a color gradient between two palette indexes
'fixed point scaled by 256
cols = col2 - col1 + 1
dr = ABS(r2 - R1)
dg = ABS(g2 - g1)
db = ABS(b2 - b1)
r = R1
g = g1
b = b1
OUT &H3C8, col1
FOR col = col1 TO col2
    OUT &H3C9, r
    OUT &H3C9, g
    OUT &H3C9, b
    er = er - dr: eg = eg - dg: eb = eb - db
    WHILE er < 0: er = er + cols: r = r + 1: WEND
    WHILE eg < 0: eg = eg + cols: g = g + 1: WEND
    WHILE eb < 0: eb = eb + cols: b = b + 1: WEND
NEXT

END SUB

FUNCTION plasma! (secs%)


SHARED mk%
STATIC lastp%, p%, k1%
FOR i% = 0 TO 63
    OUT &H3C9, i%
    OUT &H3C9, 0
    OUT &H3C9, i%
NEXT i%
FOR i% = 64 TO 127
    OUT &H3C9, 63
    OUT &H3C9, i% - 64
    OUT &H3C9, 127 - i%
NEXT i%
FOR i% = 128 TO 191
    OUT &H3C9, 63
    OUT &H3C9, 191 - i%
    OUT &H3C9, 0
NEXT i%
FOR i% = 192 TO 255
    OUT &H3C9, 255 - i%
    OUT &H3C9, 0
    OUT &H3C9, 0
NEXT i%


FOR i% = -1024 TO 1024
mapx%(i%) = SIN(i% / 45) * 97
mapy%(i%) = SIN(i% / 35) * 128 + SIN(i% / 17) * 72
mapz%(i%) = SIN(i% / 17) * 72
NEXT i%



t! = TIMER: tend! = t! + secs%
xf1% = 0: yf1% = 0: xf2% = 319: yf2% = 199
DO
    GOSUB plasmatic
    
LOOP UNTIL LEN(INKEY$) OR (TIMER > tend!)
plasma = mk% / (TIMER - t!)
EXIT FUNCTION
plasmatic:
mk% = mk% + 1
ypp% = &HA000 + yf1% * 20


    IF lastp% <> ps% THEN k1% = 0: lastp% = ps%
    k1% = (k1% + 1) MOD 723
    FOR y% = yf1% TO yf2%
        DEF SEG = ypp%
        ypp% = ypp% + 20
        t1% = mapx%(y% - yp% + k1%) + y%
        t2% = -y% - yp% + k1%
        t3% = y% - yp%
        FOR x% = xf1% TO xf2%
            xxp% = x% - xp%
            c% = mapx%(xxp% - k1%) + t1%
            c% = mapz%(c% + mapy%(xxp% + k1%) + t2%) + x%
            POKE x%, mapy%(xxp% + t2%) + mapx%(y% - yp% - mapy%(t3% + c%))
    NEXT x%, y%
RETURN
END FUNCTION

SUB shadowpal
CONST palinc = 10
FOR i = 0 TO 31
    OUT &H3C7, i
    ri = INP(&H3C9)
    gi = INP(&H3C9)
    bi = INP(&H3C9)
    r = ri
    g = gi
    b = bi
    'COLOR i: LOCATE 1, i + 1: PRINT "A"
    FOR j = 0 TO 6
        er = er - ri: eg = eg - gi: eb = eb - bi
        WHILE er < 0: er = er + palinc: r = r - 1: WEND
        WHILE eg < 0: eg = eg + palinc: g = g - 1: WEND
        WHILE eb < 0: eb = eb + palinc: b = b - 1: WEND
        OUT &H3C8, i + j * 32
        OUT &H3C9, r
        OUT &H3C9, g
        OUT &H3C9, b
        'COLOR i + j * 32: LOCATE j + 1, i + 1: PRINT "A"
NEXT j, i
'a$ = INPUT$(1)
END SUB

DEFSNG A-Z
FUNCTION TexturedBall! (file$, move%, secs%)
REDIM b(-8 TO 128 * 128) AS INTEGER
wseg& = VARSEG(b(0)) + 1
IF LoadPcx(file$, wseg&, 0) THEN PRINT "File "; file$; " not Found!": END
shadowpal
FOR i% = 0 TO 255: mapz%(i%) = (RND * 255): NEXT
FOR i% = -100 TO 100
    tmp = i% / 100.000003#
    tmp1 = ATN(tmp / SQR(1 - tmp * tmp))
    mapy%(i%) = INT((i% + 100!) * 128 / 200)
    mapx%(i%) = 128 * tmp1 / pi
NEXT
EraseScreenBuffer
SELECT CASE move%
CASE 1: a = 0: b = 0: e = 234: x% = 160: y% = 100: r% = 100
CASE 2:
    b = pi - .4: e = 0: x% = 160: y% = 100: r% = 100: rr% = r% * r%
    FOR i% = 1 TO 1000
        xx% = 318 * RND - 159: yy% = 198 * RND - 99
        IF CLNG(xx%) * xx% + CLNG(yy%) * yy% > rr% THEN
            DEF SEG = ylut%(yy% + 100): POKE xx% + 160, 31
        END IF
    NEXT
CASE ELSE
END SELECT

t! = TIMER: frm% = 0: tend! = t! + secs%
t1& = xTIMER: t& = 0
DO
    'reset buffer
    'draw new sphere
    SELECT CASE move%
    CASE 1:
        e = e + t& * .001: IF e > 255 THEN e = e - 256
        a = 0
        'b = b - t& * .000005: IF b < 0 THEN b = b + pi2
    CASE 2:
        e = e - t& * .0005: IF e < 0 THEN e = e + 256
        a = 0
        b = b - t& * .000005: IF b < 0 THEN b = b + pi2
    CASE ELSE
    END SELECT
    drawsphere x%, y%, r%, a, b, e
    'read timer
    t2& = xTIMER: t& = ABS(t2& - t1&): SWAP t1&, t2&
    'display sphere
    PUT (0, 0), buffer(-2), PSET
    'display time elapsed in 1/18.8 ths of a microsecond
    'IF debug THEN LOCATE 1, 1: PRINT t&;
    frm% = frm% + 1
LOOP UNTIL LEN(INKEY$) OR (TIMER > tend!)
'print frames/second (only accurate if you don't freeze buffer)
TexturedBall! = frm% / (TIMER - t!)
END FUNCTION

FUNCTION xTIMER& STATIC
CONST forty = &H40
CONST byte = 256&
    DEF SEG = forty
    DO
        t2% = PEEK(&H6C): t3% = PEEK(&H6D): t4% = PEEK(&H6E)
        OUT &H43, &H0: t0% = INP(forty): t1% = INP(forty)
    LOOP UNTIL PEEK(&H6C) = t2%
    xTIMER& = (((t4% * byte + t3%) * byte + t2% + 1) * byte - t1%) * 4 - t0% \ 64
END FUNCTION

