;==============================================================
; Palette value definitions, for easy reference, plus some
; nice names for some (incomplete)
;==============================================================
.ENUM $00
clBlack:	   .db
	clRGB000:	db
clDarkestRed:  .db
	clRGB100:	db
clDarkRed:	   .db
	clRGB200:	db
clRed:		   .db
	clRGB300:	db
clDarkestGreen: .db
	clRGB010:	db
	clRGB110:	db
	clRGB210:	db
	clRGB310:	db
clDarkGreen:   .db
	clRGB020:	db
	clRGB120:	db
clDarkYellow:  .db
	clRGB220:	db
	clRGB320:	db
clGreen:	   .db
	clRGB030:	db
	clRGB130:	db
	clRGB230:	db
clYellow:	   .db
	clRGB330:	db
clDarkestBlue: .db
	clRGB001:	db
clDarkestPurple: .db
	clRGB101:	db
	clRGB201:	db
	clRGB301:	db
	clRGB011:	db
clDkGrey:	   .db
	clRGB111:	db
	clRGB211:	db
clPaleRed:	   .db
	clRGB311:	db
	clRGB021:	db
	clRGB121:	db
	clRGB221:	db
	clRGB321:	db
	clRGB031:	db
	clRGB131:	db
	clRGB231:	db
	clRGB331:	db
clDarkBlue:	   .db
	clRGB002:	db
	clRGB102:	db
	clRGB202:	db
	clRGB302:	db
	clRGB012:	db
	clRGB112:	db
	clRGB212:	db
	clRGB312:	db
	clRGB022:	db
	clRGB122:	db
clLtGrey:	   .db
	clRGB222:	db
clPink:		   .db
	clRGB322:	db
	clRGB032:	db
	clRGB132:	db
	clRGB232:	db
	clRGB332:	db
clBlue:		   .db
	clRGB003:	db
	clRGB103:	db
	clRGB203:	db
clMagenta:	   .db
	clRGB303:	db
	clRGB013:	db
	clRGB113:	db
	clRGB213:	db
	clRGB313:	db
	clRGB023:	db
	clRGB123:	db
	clRGB223:	db
	clRGB323:	db
clCyan:		   .db
	clRGB033:	db
	clRGB133:	db
	clRGB233:	db
clWhite:	   .db
	clRGB333:	db
.ENDE


;==============================================================
; Palette loader
; parameter 1 = which palette index to start at
; parameter 2 = location of palette data
; parameter 3 = number of values to write
;==============================================================
.MACRO LOAD_PALETTE
	.IF NARGS != 3
		.PRINTT "Not enough arguments for LOAD_PALETTE!\n"
		.FAIL
	.ENDIF
	push af
	push bc
	push hl
	ld a,\1
	out ($bf),a
	ld a,$c0
	out ($bf),a
	ld hl,\2
	ld b,\3
	ld c,$be
	otir
	pop hl
	pop bc
	pop af
.ENDM

;==============================================================
; Tile loader
; parameter 1 = tile number to start at
; parameter 2 = location of tile data
; parameter 3 = No. of tiles to load
; parameter 4 = bits per pixel
;==============================================================
.MACRO LOAD_TILES
	push af
	push bc
	push hl
	ld a,(\1*32)&$ff
	out ($BF),a
	ld a,$40|((\1*32)>>8)
 	out ($BF),a
	ld hl,\2	; Tile data location
 	ld bc,\3*8	; Number of tiles * 8
	TileWritingLoop\@:	; \@ = a different number each time the macro is run
 		ld a,(hl)
		out ($BE),a
		.IF \4==1
			ld a,0
		.ELSE
			inc hl
			ld a,(hl)
		.ENDIF
		out ($BE),a
		.IF \4<=2
			ld a,0
		.ELSE
			inc hl
			ld a,(hl)
		.ENDIF
		out ($BE),a
		.IF \4<=3
			ld a,0
		.ELSE
			inc hl
			ld a,(hl)
		.ENDIF
		out ($BE),a
		inc hl

		dec c
	 	jr nz,TileWritingLoop\@
		.IF \3>=32
 			dec b
			jr nz,TileWritingLoop\@
		.ENDIF
	pop hl
	pop bc
	pop af
.ENDM