; My first SMS thing
; by Maxim

;Useful defines and macros:
.include "graphics.inc"

; VRAM mapping stuff
.define TileDefinitionBase	$2000	; must be $0000 or $2000
.define NameTableAddress	$3800	; must be a multiple of $800; usually $3800; fills $700 bytes
.define SpriteTableAddress	$3f00	; must be a multiple of $100; usually $3f00; fills $100 bytes

; WLA-DX stuff - set up the memory map and stuff like that.
.MEMORYMAP
SLOTSIZE $4000
DEFAULTSLOT 0
SLOT 0 $0000
SLOT 1 $4000
.ENDME


.rombanksize $4000
.rombanks 2

; SDSC tag
.sdsctag 0.1, "My first SMS program", "It's crap!", "Maxim"

; 
.bank 0 slot 0
.org $0000

; Standard stuff (for the SMS anyway)
	di		; disable interrupts (re-enable later if you want them)
	im 1	; Interrupt mode 1

	ld sp, $dff0	; load stack pointer to not-quite-the-end of user RAM

	jp main	; jump to main program

.org $0066	; Pause button handler
	retn		; do nothing

main:	; main program

	; Load VDP with default values, thanks to Mike G :P
	; hl = address of data
	; b = size of data
	; c = port
	; otir = while (b>0) do {out c,(hl); b--}
	ld hl,VdpData
	ld b,VdpDataEnd-VdpData
	ld c,$bf
	otir

	; Clear VRAM, again thanks to Mike
	ld a,$00		; \
	out ($BF),a		;  | Set VRAM address
	ld a,$40		;  | to $0000
 	out ($BF),a		; /
	ld bc, $4000	; Counter for 16KB of VRAM
	ld a,$00		; Value to write
	ClearVRAMLoop:
		out ($BE),a	; Output to VRAM address, which is auto-incremented after each write
		dec c
		jr nz,ClearVRAMLoop
		dec b
		jr nz,ClearVRAMLoop


	; Load palette
	LOAD_PALETTE 0 PaletteData (PaletteDataEnd-PaletteData)

	; Load font
	LOAD_TILES 0 TileData 96 2
	LOAD_TILES 96 LogoTileData 175 4

	; Write data to VRAM
	; Set address to start of name table
	ld a,NameTableAddress&$ff
	out ($BF),a
	ld a,$40|(NameTableAddress>>8)
 	out ($BF),a
	ld hl,TextData				; Point to text
	ld bc,EndTextData-TextData	; How many chars to write
	WriteTilesLoop:
		ld a,(hl)	; Value to write
		cp 95		; compare a with 95, set z flag if they match
		jr z,WriteTilesLoopEnd	; if so, it's the string end so stop writing it
		sub $20
		out ($BE),a	; Output to VRAM address, which is auto-incremented after each write
		ld a,%00000000
		out ($BE),a
		inc hl

		jr WriteTilesLoop
	WriteTilesLoopEnd:

	; Turn screen on
	ld a,%11010000
;         ||||| |`- Zoomed sprites -> 16x16 pixels
;         ||||| `-- Doubled sprites -> 2 tiles per sprite, 8x16
;         ||||`---- 30 row/240 line mode
;         |||`----- 28 row/224 line mode
;         ||`------ VBlank interrupts
;         |`------- Enable display
;         `-------- Must be set (VRAM size bit)
	out ($bf),a
	ld a,$81
	out ($bf),a

	InfiniteLoop:	; to stop the program
		jp InfiniteLoop

; Data


;==============================================================
; VDP initialisation data
;==============================================================
VdpData:
.db %00000110,$80
;    |||||||`- Disable synch
;    ||||||`-- Enable extra height modes
;    |||||`--- SMS mode instead of SG
;    ||||`---- Shift sprites left 8 pixels
;    |||`----- Enable line interrupts
;    ||`------ Blank leftmost column for scrolling
;    |`------- Fix top 2 rows during scrolling
;    `-------- Fix right 8 columns during scrolling
.db %10010000,$81
;    ||||| |`- Zoomed sprites -> 16x16 pixels
;    ||||| `-- Doubled sprites -> 2 tiles per sprite, 8x16
;    ||||`---- 30 row/240 line mode
;    |||`----- 28 row/224 line mode
;    ||`------ VBlank interrupts
;    |`------- Enable display
;    `-------- Must be set (VRAM size bit)
.db NameTableAddress>>10,$82
.db SpriteTableAddress>>7,$85
.db TileDefinitionBase>>10,$86
.db $3,$87
;    `-------- Border palette colour (sprite palette)
.db $00,$88
;    ``------- Horizontal scroll
.db $20,$89
;    ``------- Vertical scroll
.db $ff,$8a
;    ``------- Line interrupt spacing
VdpDataEnd:

;==============================================================
; My chosen palette
;==============================================================
PaletteData:
.db clBlack, clDkGrey, clLtGrey, clWhite
.db clRGB112,clRGB122,clRGB011,clRGB223,clRGB233,clRGB001,clRGB012
PaletteDataEnd:

TileData:
.include "MyFont2bit.inc"
TileDataEnd:

LogoTileData:
.include "smspowerlogo.inc"
LogoTileDataEnd:

TextData:
;    12345678901234567890123456789012
.db " Hello world! This is my first  "
.db " SMS program, and it is crappy! "
.db "                                "
.db " It's been a busy week for me in"
.db "  world of Sega 8-bittery. I've "
.db "   solved the noise generator   "
.db " problem, figured out PSG anti- "
.db " aliasing, and learnt enough SMS"
.db "programming to make this, my own"
.db " personal \"Only Words\" rip-off. "
.db "                                "
.db " So what's different? Well... I "
.db "  made a smoothed font for it,  "
.db "which involved writing a program"
.db "to do that, and I made some nice"
.db "  WLA DX macros for loading the "
.db "  palette and tiles. It's also  "
.db " using overscan :P It's not much"
.db " but if you've ever started out "
.db " with SMS programming you might "
.db "   appreciate the difficulty.   "
.db "                                "
.db "    Anyway... Happy Birthday    "
.db "   "   ,132,137,142,147,152,157,162,167,172,177,182,187,192,197,202,207,212,217,222,227,232,237,242,247,252,1, 6,11," "
.db "  ",128,133,138,143,148,153,158,163,168,173,178,183,188,193,198,203,208,213,218,223,228,233,238,243,248,253,2, 7,12," "
.db "  ",129,134,139,144,149,154,159,164,169,174,179,184,189,194,199,204,209,214,219,224,229,234,239,244,249,254,3, 8,13," "
.db "  ",130,135,140,145,150,155,160,165,170,175,180,185,190,195,200,205,210,215,220,225,230,235,240,245,250,255,4, 9,14," "
.db "  ",131,136,141,146,151,156,161,166,171,176,181,186,191,196,201,206,211,216,221,226,231,236,241,246,251,  0,5,10,"  "
.db 95
EndTextData:

nop	; in case I left any trailing labels which need something to point at I think
