#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sms.h>
#include "menu.h"

void reset_sprites() {
    int i;
    for (i = 0; i != 64; i++) {
        set_sprite(i, -16, -16, 0);
    }
}

void clear_area(int x, int y, int w, int h) {
    unsigned int buf[32], *p;
    int i;

	memset(buf, 0, sizeof(buf));
	for (i = 0; i != h; i++) {
        set_bkg_map(buf, x, y+i, w, 1);
    }
}

void menu_init(menu_state *menu, int x, int y, char *items[], int width, int visible_count, int count) {
	menu->x = x;
	menu->y = y;
	menu->items = items;
	menu->width = width;
	menu->visible_count = visible_count;
	menu->count = count;
	menu->top_option = 0;
	menu->option = 0;

	menu->need_refresh = 1;
}

int menu_handler(menu_state *menu, int joy) {
	if (joy & JOY_UP) {
	   menu->option--;
	   if (menu->option < 0) {
		  menu->option = menu->count - 1;
	   }
	}
	if (joy & JOY_DOWN) {
	   menu->option++;
	   if (menu->option >= menu->count) {
		  menu->option = 0;
	   }
	}

    if (menu->option < menu->top_option) {
		menu->top_option = menu->option;
		menu->need_refresh = 1;
	} else if (menu->option >= menu->top_option + menu->visible_count) {
		menu->top_option = menu->option - menu->visible_count + 1;
		menu->need_refresh = 1;
	}

	return menu->option;
}

void menu_update_cursor(menu_state *menu) {
   	int cx, cy;

   	cx = (menu->x-1) << 3;
   	cy = menu->y << 3;
   	set_sprite(MENU_CURSOR_SPRITE_NUMBER, cx, cy+((menu->option - menu->top_option) << 3), MENU_CURSOR_SPRITE_TILE);
}

void menu_draw(menu_state *menu) {
    int i;
    char **p;
    int cx, cy;
    int maxcount;

    maxcount = menu->visible_count;
    if (menu->count < maxcount) {
    	maxcount = menu->count;
	}

    for (i = 0, p = menu->items + menu->top_option; i != maxcount; i++, p++) {
    	clear_area(menu->x, menu->y+i, menu->width, 1);
        gotoxy(menu->x, menu->y+i);
        puts(*p);
    }

	menu_update_cursor(menu);
    menu->need_refresh = 0;
}

void menu_update(menu_state *menu) {
	if (menu->need_refresh) {
		menu_draw(menu);
	} else {
		menu_update_cursor(menu);
	}
}

void icon_menu_init(icon_menu_state *menu, int x, int y, int xofs, int yofs, int icon_w, int icon_h, int width, int count) {
	menu->x = x;
	menu->y = y;
	menu->xofs = xofs;
	menu->yofs = yofs;
	menu->icon_w = icon_w;
	menu->icon_h = icon_h;
	menu->width = width;
	menu->count = count;
	menu->option = 0;

	menu->need_refresh = 1;
}

int icon_menu_handler(icon_menu_state *menu, int joy) {
	if (joy & JOY_UP) {
	   menu->option -= menu->width;
	   if (menu->option < 0) {
		  menu->option = (menu->count / menu->width) * menu->width + (menu->option % menu->width);
		  if (menu->option >= menu->count) {
	   	     menu->option -= menu->width;
		  }
	   }
	}
	if (joy & JOY_DOWN) {
	   menu->option += menu->width;
	   if (menu->option >= menu->count) {
		  menu->option = menu->option % menu->width;
	   }
	}
	if (joy & JOY_LEFT) {
		if (menu->option % menu->width) {
			menu->option--;
		} else {
			menu->option += menu->width - 1;
			if (menu->option >= menu->count) {
				menu->option = menu->count - 1;
			}
		}
	}
	if (joy & JOY_RIGHT) {
		if (menu->option % menu->width != menu->width - 1) {
			menu->option++;
		} else {
			menu->option = (menu->option / menu->width) * menu->width;
		}
	}

	return menu->option;
}

void icon_menu_update(icon_menu_state *menu) {
   	int cx, cy;

   	cx = menu->x << 3;
   	cx += ((menu->option % menu->width) * menu->xofs) << 3;
   	cy = menu->y << 3;
   	cy += ((menu->option / menu->width) * menu->yofs) << 3;

   	set_sprite(ICON_MENU_CURSOR_SPRITE_NUMBER, cx-8, cy-8, ICON_MENU_CURSOR_SPRITE_TILE_TL);
   	set_sprite(ICON_MENU_CURSOR_SPRITE_NUMBER+1, cx+menu->icon_w, cy-8, ICON_MENU_CURSOR_SPRITE_TILE_TR);
   	set_sprite(ICON_MENU_CURSOR_SPRITE_NUMBER+2, cx-8, cy+menu->icon_h, ICON_MENU_CURSOR_SPRITE_TILE_BL);
   	set_sprite(ICON_MENU_CURSOR_SPRITE_NUMBER+3, cx+menu->icon_w, cy+menu->icon_h, ICON_MENU_CURSOR_SPRITE_TILE_BR);
}
