#ifndef _MENU_
#define _MENU_

#define MENU_CURSOR_SPRITE_NUMBER 0
#define MENU_CURSOR_SPRITE_TILE 0x10

#define ICON_MENU_CURSOR_SPRITE_NUMBER 0
#define ICON_MENU_CURSOR_SPRITE_TILE_TL 0xCC
#define ICON_MENU_CURSOR_SPRITE_TILE_TR 0xCE
#define ICON_MENU_CURSOR_SPRITE_TILE_BL 0xCD
#define ICON_MENU_CURSOR_SPRITE_TILE_BR 0xCF

typedef struct _menu_state {
	int x, y;
	char **items;
	int width;
	int visible_count;
	int count;
	int top_option;
	int option;
	char need_refresh;
} menu_state;

typedef struct _icon_menu_state {
	int x, y;
	int xofs, yofs;
	int icon_w, icon_h;
	int width;
	int count;
	int option;
	char need_refresh;
} icon_menu_state;

extern void reset_sprites();
extern void clear_area(int x, int y, int w, int h);

extern void menu_init(menu_state *menu, int x, int y, char *items[], int width, int visible_count, int count);
extern int menu_handler(menu_state *menu, int joy);
extern void menu_update_cursor(menu_state *menu);
extern void menu_draw(menu_state *menu);
extern void menu_update(menu_state *menu);

extern void icon_menu_init(icon_menu_state *menu, int x, int y, int xofs, int yofs, int icon_w, int icon_h, int width, int count);
extern int icon_menu_handler(icon_menu_state *menu, int joy);
extern void icon_menu_update(icon_menu_state *menu);

#endif /*_MENU_*/
