#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sms.h>
#include "sk_core.h"

UBYTE *sk_select_line(sk_levelmap *level, UBYTE y) {
	return level->data + (y << MAP_LINE_SHIFT);
}

UBYTE *sk_select_cell(sk_levelmap *level, UBYTE x, UBYTE y) {
	return level->data + (y << MAP_LINE_SHIFT) + x;
}

void sk_load_map(sk_levelmap *level, UBYTE *map) {
	UBYTE x, y, *o, *d;
	char *p;

	level->w = 0;
	level->h = 0;
	level->lastdir = 0;
	memset(level->data, 0, sizeof(level->data));
	memset(level->title, 0, sizeof(level->title));

	x = 0;
	y = 0;
	d = level->data;
	for (o = map; *o; o++) {
		if (*o == 10) { // Handles line feeds
			x = 0;
			y++;
			d = sk_select_line(level, y);
		} else if (*o == ';') { // Handles titles
			o++;

			while ((*o == ' ') || (*o == '\t')) {
				o++;
			}

			p = level->title;
			while (*o != 10) {
				if ((*o != 13) && (p - level->title < 32)) {
					*p = *o;
					p++;
				}

				o++;
			}

			*p = 0;
		} else if (*o != 13) { // Handles the map
			if ((*o == '@') || (*o == '&')) {
				level->ply_x = x;
				level->ply_y = y;
			}

			*d = (*o) | REFRESH_MASK;
			d++;

			x++;
			if (x > level->w) {
				level->w = x;
			}
		}
	}
	level->h = y + 1;
}

void sk_shove_it(sk_levelmap *level, BYTE x, BYTE y, BYTE xofs, BYTE yofs, char offender) {
	UBYTE *p, *p2;

	p = sk_select_cell(level, x, y);
	if ((*p == '$') || (*p == '*')) {
		p2 = sk_select_cell(level, x + xofs, y + yofs);

		if ((*p2 == ' ') || (*p2 == '.')) {
			if (*p2 == '.') {
				*p2 = '*';
			} else {
				*p2 = '$';
			}
			if (*p == '*') {
				*p = '.';
			} else {
				*p = ' ';
			}
			*p2 |= REFRESH_MASK;
			*p  |= REFRESH_MASK;
		}
	}
}

void sk_move_player(sk_levelmap *level, BYTE xofs, BYTE yofs) {
	UBYTE i, j, *p, *p2;
	char ch2;

/*	for (i = 0; i != level->h; i++) {
		p = sk_select_line(level, i);
		for (j = 0; j != level->w; j++) {
			if ((*p == '@') || (*p == '&')) {
				sk_shove_it(level, j + xofs, i + yofs, xofs, yofs, *p);
				p2 = sk_select_cell(level, j + xofs, i + yofs);
				ch2 = *p2 & REFRESH_UNMASK;
				if ((ch2 == ' ') || (ch2 == '.')) {
					if (ch2 == '.') {
						*p2 = '&';
					} else {
						*p2 = '@';
					}
					if (*p == '&') {
						*p = '.';
					} else {
						*p = ' ';
					}
					*p2 |= REFRESH_MASK;
					*p  |= REFRESH_MASK;
				}
			}
			p++;
		}
	} */
	j = level->ply_x;
	i = level->ply_y;

	sk_shove_it(level, j + xofs, i + yofs, xofs, yofs, *p);
	p = sk_select_cell(level, j, i);
	p2 = sk_select_cell(level, j + xofs, i + yofs);
	ch2 = *p2 & REFRESH_UNMASK;
	if ((ch2 == ' ') || (ch2 == '.')) {
		if (ch2 == '.') {
			*p2 = '&';
		} else {
			*p2 = '@';
		}
		if (*p == '&') {
			*p = '.';
		} else {
			*p = ' ';
		}
		*p2 |= REFRESH_MASK;
		*p  |= REFRESH_MASK;

		level->ply_x = j + xofs;
		level->ply_y = i + yofs;
	}
}

UBYTE sk_check_level_end(sk_levelmap *level) {
	UBYTE i, j, *p, ch;

	for (i = 0; i != level->h; i++) {
		p = sk_select_line(level, i);
		for (j = 0; j != level->w; j++) {
			ch = (*p & REFRESH_UNMASK);
			if ((ch == '.') || (ch == '&')) {
				return FALSE;
			}
			p++;
		}
	}

	return TRUE;
}
