#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <sms.h>
#include "apa.h"
#include "sk_core.h"
#include "sk_display.h"

UWORD sk_skin_tile(sk_levelmap *level, UBYTE x, UBYTE y, UBYTE tile) {
	UBYTE cond, mask;

	switch (tile) {
		case 0:
		case ' ':
			return 0x100;
		break;

		case '.':
			return 0x101;
		break;

		case '$':
			return 0x102;
		break;

		case '*':
			return 0x103;
		break;

		case '@':
			return 0x108 + level->lastdir;
		break;

		case '&':
			return 0x104 + level->lastdir;
		break;

		case '#':
			mask = 0;

			cond = *(sk_select_cell(level, x, y-1)) & REFRESH_UNMASK;
			cond = cond == '#';
			if (y && cond) {
				mask |= 0x01;
			}
			cond = *(sk_select_cell(level, x+1, y)) & REFRESH_UNMASK;
			cond = cond == '#';
			if ((x < level->w - 1) && cond) {
				mask |= 0x02;
			}
			cond = *(sk_select_cell(level, x, y+1)) & REFRESH_UNMASK;
			cond = cond == '#';
			if ((y < level->h - 1) && cond) {
				mask |= 0x04;
			}
			cond = *(sk_select_cell(level, x-1, y)) & REFRESH_UNMASK;
			cond = cond == '#';
			if (x && cond) {
				mask |= 0x08;
			}
			return 0x110 + mask;
		break;

		default:
			return tile;
	}
}

void sk_render_map(sk_levelmap *level) {
	UBYTE i, j, *p;
	UBYTE xofs, yofs;
	UWORD tile;

	xofs = (MAX_MAP_W - level->w) >> 1;
	yofs = (MAX_MAP_H - level->h) >> 1;

	for (i = 0; i != level->h; i++) {
		p = sk_select_line(level, i);
		for (j = 0; j != level->w; j++) {
			tile = *p;
			if (tile & REFRESH_MASK) {
				tile &= ~REFRESH_MASK;
				*p = tile;
//				tile |= BKG_ATTR_2NDTILESET;
				tile = sk_skin_tile(level, j, i, tile);
				set_bkg_map(&tile, j + xofs, i + yofs, 1, 1);
			}
			p++;
		}
	}
}

void put_thumbnail_pixel(apa_canvas *canvas, int x, int y, char ch, UBYTE enabled) {
	int color = 0;

	x <<= 1;
	y <<= 1;

	if (enabled) {
		switch (ch) {
			case '#': color = 15; break;
			case '@': color = 14; break;
			case '&': color = 6; break;
			case '$': color = 9; break;
			case '*': color = 1; break;
			case '.': color = 4; break;
		}
	} else {
		switch (ch) {
			case '#': color = 7; break;
			case '@': color = 8; break;
			case '&': color = 8; break;
			case '$': color = 8; break;
			case '*': color = 8; break;
			case '.': color = 8; break;
		}
	}

/*    apa_put_pixel(canvas, x, y, color);
    apa_put_pixel(canvas, x+1, y, color);
    apa_put_pixel(canvas, x, y+1, color);
    apa_put_pixel(canvas, x+1, y+1, color);*/

/*    apa_vert_line(canvas, x, y, 2, color);
    apa_vert_line(canvas, x+1, y, 2, color);*/

    apa_hor_line(canvas, x, y, 2, color);
    apa_hor_line(canvas, x, y+1, 2, color);
}

void sk_render_thumbnail(sk_levelmap *level, UBYTE x, UBYTE y, UBYTE num, UBYTE enabled) {
    unsigned char charset[16*10*32];
    unsigned char *coltable[16];
    unsigned int map[16*10];
    apa_canvas canvas;

	UBYTE i, j, *p;
	BYTE xofs, yofs;
	UBYTE min_x, max_x, min_y, max_y;
	UWORD basetile;
	char ch;

	basetile = num*(6*4) + 256;
	xofs = ((6*4) - level->w + 1) >> 1;
	yofs = ((4*4) - level->h + 1) >> 1;

	min_x = 0;
	max_x = level->w;
	if (xofs < 0) {
		min_x = -xofs;
	}
	if (max_x > (6*4)) {
		max_x = (6*4);
	}

	min_y = 0;
	max_y = level->h;
	if (yofs < 0) {
		min_y = -yofs;
	}
	if (max_y > (4*4)) {
		max_y = (4*4);
	}

	apa_init_canvas(&canvas, 6, 4, basetile, charset, coltable, map);

	for (i = min_y; i != max_y; i++) {
		p = sk_select_line(level, i);
		for (j = min_x; j != max_x; j++) {
			ch = *p & REFRESH_UNMASK;
			if (ch && (ch != ' ')) {
	    		put_thumbnail_pixel(&canvas, j + xofs, i + yofs, ch, enabled);
			}
			p++;
		}
	}

	apa_show_canvas(&canvas, x, y);
}
