program SokoJoin;
	{$M $4000,0,0 }
	uses Dos, Windos;

	const
		SIG: array[0..3] of char = 'SOKO';
		TERM: array[0..3] of char = #0#0#0#0;

	var DirInfo: TSearchRec;
		OutFile: File;

	procedure CompressLevel(FName: String);
		var Dir: DirStr;
			Name: NameStr;
			Ext: ExtStr;
			Params: String;
		begin
			FSplit(FName, Dir, Name, Ext);
			Params := Dir + Name + Ext + ' ' + Dir + Name + '.APK';
			Writeln(Params);

			SwapVectors;
			Exec('APACK.EXE', Params);
			SwapVectors;

			if DosError <> 0 then
				begin
					Writeln('Dos error #', DosError, ' while processing ', FName);
					Halt(1);
                end;
		end;

	procedure JoinLevel(FName: String);
		var InFile: File;
			W     : Word;
			Buf	  : array [0..2047] of byte;
		begin
			Assign(InFile, FName);
			Reset(InFile, 1);

			W := FileSize(InFile);
			BlockWrite(OutFile, W, SizeOf(W));

            while not Eof(InFile) do
				begin
					BlockRead(InFile, Buf, SizeOf(Buf), W);
					BlockWrite(OutFile, Buf, W);
				end;

			Close(InFile);
		end;
Begin
	if ParamCount < 1 then
		begin
			Writeln('Sokoban Level Joiner v1.0 by Haroldo O. Pinheiro');
			Writeln('Will search current dir for .LEV files, compress them with APACK.EXE');
			Writeln('and join the compressed files on a single binary.');
			Writeln('Usage: SOKOJOIN <dest>');
			Halt(1);
		end;

  	FindFirst('*.LEV', faArchive, DirInfo);
  	while DosError = 0 do
  		begin
			CompressLevel(DirInfo.Name);
   			FindNext(DirInfo);
  		end;

	Assign(OutFile, ParamStr(1));
	Rewrite(OutFile, 1);
	BlockWrite(OutFile, SIG, SizeOf(SIG));

  	FindFirst('*.APK', faArchive, DirInfo);
  	while DosError = 0 do
  		begin
			JoinLevel(DirInfo.Name);
   			FindNext(DirInfo);
  		end;

	BlockWrite(OutFile, TERM, SizeOf(SIG));
End.