/*
 * Copyright (c) 2011, Harley Laue
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *    * Redistributions of source code must retain the above copyright
 *      notice, this list of conditions and the following disclaimer.
 *    * Redistributions in binary form must reproduce the above copyright
 *      notice, this list of conditions and the following disclaimer in the
 *      documentation and/or other materials provided with the distribution.
 *    * Neither the name of the <organization> nor the
 *      names of its contributors may be used to endorse or promote products
 *      derived from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * This file includes the low level system calls.
 */
#ifndef __IO_H__
#define __IO_H__

#include <stdint.h>

/* I/O Register addresses */
#define MEM_CTRL     0x3E
#define IO_CTRL      0x3F
#define PSG          0x7F /* This is the same as HCNT, which is convensionally to used */
#define VCNT         0x7E
#define HCNT         0x7F
#define VDP_DATA     0xBE
#define VDP_CTRL     0xBF
#define AB_REG       0xDC
#define BMISC_REG    0xDD

#define EI __asm ei __endasm;
#define DI __asm di __endasm;

/**
 * Read the byte at the supplied memory address
 */
uint8_t in(uint8_t addr);

/**
 * Write a byte to the supplied memory address.
 */
void out(uint8_t addr, uint8_t value);


#ifdef SDCC
#define io_var(name, addr) __sfr __at addr name;
#define in_sdcc(name) uint8_t name();
#define out_sdcc(name) void name(uint8_t value);

/*
 * These are SDCC specific that allow reading and writing to the variable and
 * it generates the Z80 assembly for the in/out. These variables can be used
 * directly to avoid a function call, or can be used via the functions below.
 */
io_var(io_mem_ctrl, MEM_CTRL)
io_var(io_ctrl, IO_CTRL)
io_var(io_psg, PSG)
io_var(io_vcnt, VCNT)
io_var(io_hcnt, HCNT)
io_var(io_vdp_data, VDP_DATA)
io_var(io_vdp_ctrl, VDP_CTRL)
io_var(io_ab_reg, AB_REG)
io_var(io_bmisc_reg, BMISC_REG)

in_sdcc(in_mem_ctrl)
in_sdcc(in_io_ctrl)
in_sdcc(in_psg)
in_sdcc(in_vcnt)
in_sdcc(in_hcnt)
in_sdcc(in_vdp_data)
in_sdcc(in_vdp_ctrl)
in_sdcc(in_ab_reg)
in_sdcc(in_bmisc_reg)

out_sdcc(out_mem_ctrl)
out_sdcc(out_io_ctrl)
out_sdcc(out_psg)
out_sdcc(out_vcnt)
out_sdcc(out_hcnt)
out_sdcc(out_vdp_data)
out_sdcc(out_vdp_ctrl)
out_sdcc(out_ab_reg)
out_sdcc(out_bmisc_reg)

#undef io_var
#undef in_sdcc
#undef out_sdcc
#endif

#endif

