;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; Main source of Sega Master System FMV demo
; Written by Alex Marshall <trap15@raidenii.net>
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

	.org	$00
start:
	di
	im	1
	ld	sp, $DFF0
	jp	main

	.org	$10
rst10:
	ld	a, l
	out	(vdp_ctrl), a
	ld	a, h
	out	(vdp_ctrl), a
	ret

	.org	$18
rst18:
	in	a, (vdp_ctrl)
	ret

	.org	$20
rst20:
	out	(vdp_data), a
	ret

	.org	$28
rst28:
	in	a, (vdp_data)
	ret

	.org	$38
irq:
	ex	af, af'		; 4
	exx			; 4

	in	a, (vdp_ctrl)	; 11
	rlca			; 4
	jr	c, frame_irq	; 7

	outi			; 16
	outi			; 16

	exx			; 4
	ex	af, af'		; 4
	ei			; 4
	ret			; 10
; 4+4+11+4+7+16+16+4+4+4+10
; 84

	.org	$66
nmi:
	ex	af, af'

	ld	a, (paused)
	xor	1
	ld	(paused), a

	ex	af, af'
	retn

frame_irq:
	ld	hl, raster_tbl

	ld	a, (frame)
	inc	a
	ld	(frame), a

	exx
	ex	af, af'
	ei
	ret

drv_info:
	.db	"SMS FMV Demonstration  Ver1.0.0 by trap15", 0

	.org	$100
.rept 256
	outi
.endr
outiblk_end:
	ret

; \1 = Count
.macro	outiblk
	call	outiblk_end - (\1*2)
.endm

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
main:
	call	mapper_init
	call	vdp_init

	call	fmv_init

; Set up raster table
	exx
	ld	hl, raster_tbl
	ld	c, vdp_ctrl
	exx

	ei
	xor	a
	ld	(frame), a
	ld	(hackscr), a

mainloop:
	ld	hl, frame
	xor	a

-	cp	(hl)
	jr	z, -
	dec	(hl)

	ld	a, (paused)
	or	a
	jr	nz, mainloop

	di
fmv_update:
	ld	ix, wait
	dec	(ix+0)
	jp	m, fmv_update_main
	ei

	jp	mainloop

