; ==========================================================================================================
;                                                   2048
;
; A game based on http://gabrielecirulli.github.io/2048/
; Design inspired by the C64 release http://csdb.dk/release/?id=129788
;
; Created by Julien Verneuil aka Grz- for the SMS Power! 17th Anniversary Competitions in 2014. 
;
; The game was made in four days (24/03/2014 to 27/03/2014),
; it was initially a demo but i only had three effects of which only one was totally completed and nothing else, 
; so i decided to make a game instead when i saw the C64 release of 2048.
;
; It would have been nice to have themes, tiles of SMS game to replace numbers,
; unfortunately i am not a graphics artist and was too short of time.
;
; As for the code,
; most of the routines in this file were written from scratch in theses three days, 
; except the base skeleton code (interrupt section and handler, utils, etc) which were built earlier on,
; the code is massively rushed... but at least it somehow manage to work! :D
; Anyway, do anything you want with it and have fun!
;
; website: http://garzul.tonsite.biz
; email: grz.zrg at gmail dot com
;
; ==========================================================================================================

; ==== banking ====
.memorymap
defaultslot 0
slotsize $8000
slot 0 $0000
.endme

.rombankmap
bankstotal 1
banksize $8000
banks 1
.endro

.computesmschecksum

.sdsctag 1.0,"2048","Puzzle game for the SMS Power! 17th Anniversary","Grz-"
.smstag

.define addr_board               $C000
.define addr_ghost               $C100 ; "ghost" board used to stop merged tiles :)))
.define addr_move                $C020
.define addr_still_move          $C030
.define addr_move_still_possible $C040
.define addr_score               $C050
.define addr_highscore           $C060
.define addr_state_of_game       $C070
.define addr_button_released     $C080
.define addr_screen              $C090 ; quick fix for to know if intro or not :P
.define addr_move_delay          $D010 ; delay between tiles moves in vbl
.define addr_vbl_counter         $D000
.define addr_checker_speed       $D001
.define addr_checker_col1        $D002
.define addr_checker_col2        $D003
.define addr_curr_pal_index      $D004
.define addr_active_hline        $D100
.define addr_rng_seed            $D005
.define addr_highscore_position  $3D5A
.define addr_score_position      $389E
.define addr_font_position       $2C00
.define addr_win_position        $3886
.define addr_lose_position       $3886

.define const_checker_speed           $03
.define const_checker_col1            $14
.define const_checker_col2            $32
.define const_board_tile_nt_adress    $391C ; starting nametable adress of the board
.define const_background_tiles_adress $1C00 ; starting adress of the background tiles
.define const_move_delay              $07 ; this should be a power of two minus one because vbl_counter%this
.define const_font_start              $160 ; index of the first tile
.define const_max_tile_index          13 ; 8092
.define const_2048_tile_index         11

.define P1_UP_BIT    0
.define P1_DOWN_BIT  1
.define P1_LEFT_BIT  2
.define P1_RIGHT_BIT 3
.define P1_SW1_BIT   4
.define P1_SW2_BIT   5

.define MOVE_UP    1
.define MOVE_DOWN  2
.define MOVE_LEFT  3
.define MOVE_RIGHT 4

.define EMPTY_TILE 0
.define FIRST_TILE 1

.bank 0 slot 0
.org $0000
.section "Boot&Setup" force
    di
    im 1
    ld sp, $dff8
	
    ld hl,VDP_DATA
	call SetupVDP
	
    ld hl,$4000 
    call VRAMToHL 
	call ClrVRAM
	call ClrPSG

	ld hl,$3E00
	call DisableSprites

    jp main
.ends

.org $0038
.section "VBL/HBL interrupt" force
	push af
	push bc
	push de
	push hl
	
	in a,($BF)
	bit 7,a
	jp nz,vblHandler
	
	jp hblHandler
	
	EOI: ; end of interrupt
	
	pop hl
	pop de
	pop bc
	pop af
	ei
	ret
.ends

; ==== pause ====
.org $0066
.section "Pause handler" force
	call ClrPSG
	retn
.ends

; ==== main ====
.section "Main" free
	main:
		call intro
		
		ld a,1
		ld (addr_screen),a
		
		call gameSetup
		
		ld a,const_move_delay
		ld (addr_move_delay),a
		
		; === game part
		ei

		gameLoop:
			ld a,(addr_move)
			or a
			jr nz,gameLoop
			
			call checkInputs
			jp gameLoop
			
	intro:
		call loadFont
		call loadBackground2
		
		ld a,const_checker_speed
		ld (addr_checker_speed),a
		
		ld a,const_checker_col1
		ld (addr_checker_col1),a	
		
		ld a,const_checker_col2
		ld (addr_checker_col2),a
		
		ld de,PRESS_START
		ld hl,$3C0C
		call drawText
		
		ld de,BASED
		ld hl,$3d18
		call drawText
		
		ld de,CREDIT
		ld hl,$3d8e
		call drawText
		
		ld de,AUTHOR
		ld hl,$3b2a
		call drawText
		
		xor a
		ld (addr_screen),a
		
		ei
		halt
		
		call displayOn
		
		-:
			in a,($dc)
			bit P1_SW1_BIT,a
			jr nz,-
	
		di
		ret
		
	gameSetup:
		call displayOff
		ld hl,$4000 
		call VRAMToHL 
		call ClrVRAM
		call ClrPSG
		ld hl,$3E00
		call DisableSprites
		call loadBackground
		call loadTiles
		call loadFont
		call newGame
		call setupHighScore
		call displayOn
		xor a
		ld (addr_vbl_counter),a
		ret
		
	newGame:
		xor a
		ld (addr_state_of_game),a
		ld (addr_move),a
		
		call clearBoard
		ld de,HIGHSCORE_DATA2
		ld hl,addr_highscore_position
		call drawText
		ld a,1
		call updateHighScore
		call setupScore
	
		ld de,(addr_rng_seed)
		call Rand16
		
		ld a,l
		and $f
		ld b,a
		ld c,FIRST_TILE
		call setBoardTile
		
		/*
		ld b,0
		ld a,10
		ld c,a
		call setBoardTile
		
		ld b,1
		ld a,10
		ld c,a
		call setBoardTile
		*/
		
		call placeRandomTile
		xor a
		ld (addr_button_released),a
		
		xor a
		ld (addr_vbl_counter),a
		ret
		
	setupHighScore:
		xor a
		ld (addr_highscore),a
		ld (addr_highscore+1),a
		ld (addr_highscore+2),a
		ld (addr_highscore+3),a
		ld de,HIGHSCORE_DATA
		ld hl,addr_highscore_position
		call drawText
		ret
	
	setupScore:
		ld de,SCORE_DATA
		ld hl,addr_score_position
		call drawText
		xor a
		ld (addr_score),a
		ld (addr_score+1),a
		ld (addr_score+2),a
		ld (addr_score+3),a
		ret
		
	clearBoard:
		call loadBackgroundTileMap
	
		ld hl,addr_board
		xor a
		ld b,$10
		-:
			ld (hl),a
			inc hl
			
			push hl
			push bc
			dec b

			ld c,EMPTY_TILE
			call setBoardTile
			pop bc
			pop hl
		djnz -
		ret
		
	checkInputs:
		ld a,(addr_state_of_game)
		or a
		jr nz, +
			checkDPAD:
			
			ld a,(addr_button_released)
			or a
			jr nz,++
			
			in a,($dc)
			bit P1_UP_BIT,a
			jr z,P1_UP

			bit P1_DOWN_BIT,a
			jr z,P1_DOWN
			
			bit P1_LEFT_BIT,a
			jr z,P1_LEFT

			bit P1_RIGHT_BIT,a
			jr z,P1_RIGHT
			
			bit P1_SW1_BIT,a
			jr z,NEW_GAME
			
			xor a
			ld (addr_button_released),a
			ret
			
			++:
				cp MOVE_UP
				jr nz,+++
				
				in a,($dc)
				bit P1_UP_BIT,a
				jr nz,releaseDPAD
				ret
				
				+++:
				cp MOVE_DOWN
				jr nz,++++
				
				in a,($dc)
				bit P1_DOWN_BIT,a
				jr nz,releaseDPAD
				ret
				
				++++:
				cp MOVE_LEFT
				jr nz,+++++
				
				in a,($dc)
				bit P1_LEFT_BIT,a
				jr nz,releaseDPAD
				ret
				
				+++++:
				cp MOVE_RIGHT
				jr nz,++++++
				
				in a,($dc)
				bit P1_RIGHT_BIT,a
				jr nz,releaseDPAD
				ret
				
				releaseDPAD:
					xor a
					ld (addr_button_released),a
					
				++++++:
			ret
			
		+:
			cp 4
			jr z,++++++++++
			
			cp 1
			jr nz,++ 
			
			; lose
			in a,($dc)
			bit P1_SW1_BIT,a
			jr z,P1_SW1_LOSE
			ret
			
			++: ; win
			
			in a,($dc)
			bit P1_SW1_BIT,a
			jr z,P1_SW1_WIN
			
			bit P1_SW2_BIT,a
			jr z,P1_SW2_WIN ; but still continue
			ret
			
			++++++++++:
			
			in a,($dc)
			bit P1_SW1_BIT,a
			jr z,P1_SW1_WIN
			
			jp checkDPAD
		ret
		
	P1_UP:
		ld a,MOVE_UP
		ld (addr_move),a
		jp end_of_dpad_check
		
	P1_DOWN:
		ld a,MOVE_DOWN
		ld (addr_move),a
		jp end_of_dpad_check
		
	P1_LEFT:
		ld a,MOVE_LEFT
		ld (addr_move),a
		jp end_of_dpad_check
		
	P1_RIGHT:
		ld a,MOVE_RIGHT
		ld (addr_move),a
		jp end_of_dpad_check
		
	end_of_dpad_check:
		ld (addr_button_released),a
		ret ; return from checkInputs
		
	NEW_GAME:
		di
		call displayOff
		call newGame
		call displayOn
		ei
		jp gameLoop
		
	P1_SW1_LOSE:
		di
		call displayOff
		call newGame
		call displayOn
		ei
		jp gameLoop
		
	P1_SW1_WIN:
		di
		call displayOff
		call newGame
		call displayOn
		ei
		jp gameLoop
		
	P1_SW2_WIN:
		ld a,4
		ld (addr_state_of_game),a
		jp gameLoop
		
	P1_SW1_CHEAT:
		di
		call displayOff
		call newGame
		call displayOn
		ei
		jp gameLoop
		
	; ===========================================================================
	; main game logic is done here (called in the VBL handler on N VBLANK)
	; ===========================================================================
	processMove:
		xor a
		ld (addr_still_move),a
		ld a,(addr_move)
		cp MOVE_UP
		jp nz,cDown
			ld de,addr_board
			ld hl,addr_board+4
			ld b,12
			-:		
				push bc
				ld bc,addr_ghost
				ld c,l
				ld a,(bc)
				or a
				pop bc
				jr nz,nup
				
				ld c,(hl)
				ld a,c
				or a
				jr z,nup ; check if the source tile is empty
				ld a,(de)
				cp c
				jr z,+ ; check if both tiles are equals
				or a
				jr z,++ ; check if the destination tile is empty
				jp nup
				+: ; both tiles equals
					; check if the destination tile is the max
					cp const_max_tile_index
					jr z,nup
					
					push bc
					push de
					push hl
					push hl
					ld hl,addr_ghost
					ld l,e
					inc (hl)
					pop hl
					
					ld a,(de)
					inc a
					
					; check if the tile is 2048
					cp const_2048_tile_index
					jr nz,+++
						push af
						push bc
						push de
						push hl
						ld a,2
						ld (addr_state_of_game),a
						
						ld de,WIN
						ld hl,addr_win_position
						call drawText
						pop hl
						pop de
						pop bc
						pop af
						;ret
					+++:
					
					ld b,a
					call game_addToScore
					
					ld c,a
					
				jp +++
				++: ; destination tile empty
					push bc
					push de
					push hl
					ld a,(hl)
					ld c,a
				+++:
					ld b,e
					call setBoardTile
					pop hl
					push hl
					ld b,l
					ld c,EMPTY_TILE
					call setBoardTile
					pop hl
					pop de
					pop bc
					
					inc a
					ld (addr_still_move),a
				nup:
					inc de
					inc hl
				djnz -
				
				; "quick" check next and generate tile if no more moves
				call checkIfMoveUpPossible
				ld a,(addr_move_still_possible)
				or a
				jr nz,++++++
					xor a
					ld (addr_move),a
					
					ld a,(addr_still_move)
					or a
					jr z,++++++
						call placeRandomTile
						call clearGhostBoard
						call updateScore
						xor a
						call updateHighScore
					jp Return
				++++++:
			ret
		cDown:
		
		cp MOVE_DOWN
		jp nz,cLeft
			ld de,addr_board+15
			ld hl,addr_board+11
			ld b,12
			-:
				push bc
				ld bc,addr_ghost
				ld c,l
				ld a,(bc)
				or a
				pop bc
				jr nz,ndown
			
				ld c,(hl)
				ld a,c
				or a
				jr z,ndown ; check if the source tile is empty
				ld a,(de)
				cp c
				jr z,+ ; check if both tiles are equals
				or a
				jr z,++ ; check if the destination tile is empty
				jp ndown
				+: ; both tiles equals
					; check if the destination tile is the max
					cp const_max_tile_index
					jr z,ndown
					
					push bc
					push de
					push hl
					push hl
					ld hl,addr_ghost
					ld l,e
					inc (hl)
					pop hl
					
					ld a,(de)
					inc a
					
					; check if the tile is 2048
					cp const_2048_tile_index
					jr nz,+++
						push af
						push bc
						push de
						push hl
						ld a,2
						ld (addr_state_of_game),a
						
						ld de,WIN
						ld hl,addr_win_position
						call drawText
						pop hl
						pop de
						pop bc
						pop af
						;ret
					+++:
					
					ld b,a
					call game_addToScore
					
					ld c,a
				jp +++
				++: ; destination tile empty
					push bc
					push de
					push hl
					ld a,(hl)
					ld c,a
				+++:
					ld b,e
					call setBoardTile
					pop hl
					push hl
					ld b,l
					ld c,EMPTY_TILE
					call setBoardTile
					pop hl
					pop de
					pop bc
					
					inc a
					ld (addr_still_move),a
				ndown:
					dec de
					dec hl
				djnz -
				
				; "quick" check next and generate tile if no more moves
				call checkIfMoveDownPossible
				ld a,(addr_move_still_possible)
				or a
				jr nz,++++++
					xor a
					ld (addr_move),a
					
					ld a,(addr_still_move)
					or a
					jr z,++++++
						call placeRandomTile
						call clearGhostBoard
						call updateScore
						xor a
						call updateHighScore
					jp Return
				++++++:
			ret
		cLeft:
		
		cp MOVE_LEFT
		jp nz,cRight
			ld de,addr_board
			ld hl,addr_board+1
			ld b,16
			-:
				push bc
				ld bc,addr_ghost
				ld c,l
				ld a,(bc)
				or a
				pop bc
				jr nz,nleft
				
				ld a,16
				sub b
				inc a
				and 3
				jr z,nleft
				
				ld c,(hl)
				ld a,c
				or a
				jr z,nleft ; check if the source tile is empty
				ld a,(de)
				cp c
				jr z,+ ; check if both tiles are equals
				or a
				jr z,++ ; check if the destination tile is empty
				jp nleft
				+: ; both tiles equals
					; check if the destination tile is the max
					cp const_max_tile_index
					jr z,nleft
					
					push bc
					push de
					push hl
					push hl
					ld hl,addr_ghost
					ld l,e
					inc (hl)
					pop hl
					
					ld a,(de)
					inc a
					
					; check if the tile is 2048
					cp const_2048_tile_index
					jr nz,+++
						push af
						push bc
						push de
						push hl
						ld a,2
						ld (addr_state_of_game),a
						
						ld de,WIN
						ld hl,addr_win_position
						call drawText
						pop hl
						pop de
						pop bc
						pop af
						;ret
					+++:
					
					ld b,a
					call game_addToScore
					
					ld c,a
				jp +++
				++: ; destination tile empty
					push bc
					push de
					push hl
					ld a,(hl)
					ld c,a
				+++:
					ld b,e
					call setBoardTile
					pop hl
					push hl
					ld b,l
					ld c,EMPTY_TILE
					call setBoardTile
					pop hl
					pop de
					pop bc
					
					inc a
					ld (addr_still_move),a
				nleft:
					inc de
					inc hl
				djnz -
				
				; "quick" check next and generate tile if no more moves
				call checkIfMoveLeftPossible
				ld a,(addr_move_still_possible)
				or a
				jr nz,++++++
					xor a
					ld (addr_move),a
					
					ld a,(addr_still_move)
					or a
					jr z,++++++
						call placeRandomTile
						call clearGhostBoard
						call updateScore
						xor a
						call updateHighScore
					jp Return
				++++++:
			ret
		cRight:
		
		cp MOVE_RIGHT
		jp nz,Return
			ld de,addr_board+15
			ld hl,addr_board+14
			ld b,16
			-:
				push bc
				ld bc,addr_ghost
				ld c,l
				ld a,(bc)
				or a
				pop bc
				jr nz,nright
			
				ld a,16
				sub b
				inc a
				and 3
				jr z,nright
				
				ld c,(hl)
				ld a,c
				or a
				jr z,nright ; check if the source tile is empty
				ld a,(de)
				cp c
				jr z,+ ; check if both tiles are equals
				or a
				jr z,++ ; check if the destination tile is empty
				jp nright
				+: ; both tiles equals
					; check if the destination tile is the max
					cp const_max_tile_index
					jr z,nright
					
					push bc
					push de
					push hl
					push hl
					ld hl,addr_ghost
					ld l,e
					inc (hl)
					pop hl
					
					ld a,(de)
					inc a
					
					; check if the tile is 2048
					cp const_2048_tile_index
					jr nz,+++
						push af
						push bc
						push de
						push hl
						ld a,2
						ld (addr_state_of_game),a
						
						ld de,WIN
						ld hl,addr_win_position
						call drawText
						pop hl
						pop de
						pop bc
						pop af
						;ret
					+++:
					
					ld b,a
					call game_addToScore
					
					ld c,a
				jp +++
				++: ; destination tile empty
					push bc
					push de
					push hl
					ld a,(hl)
					ld c,a
				+++:
					ld b,e
					call setBoardTile
					pop hl
					push hl
					ld b,l
					ld c,EMPTY_TILE
					call setBoardTile
					pop hl
					pop de
					pop bc
					
					inc a
					ld (addr_still_move),a
				nright:
					dec de
					dec hl
				djnz -
				
				; "quick" check next and generate tile/free inputs if no more moves
				call checkIfMoveRightPossible
				ld a,(addr_move_still_possible)
				or a
				jr nz,++++++
					xor a
					ld (addr_move),a
					
					ld a,(addr_still_move)
					or a
					jr z,++++++
						call placeRandomTile
						call clearGhostBoard
						call updateScore
						xor a
						call updateHighScore
					jp Return
				++++++:
			;ret
		Return:
		ret
		
	; ===============================================================
	; check if at least one move is possible, subroutine for all dirs
	; ===============================================================
	checkIfMoveUpPossible:
		ld de,addr_board
		ld hl,addr_board+4
		ld b,12
		-:		
			push bc
			ld bc,addr_ghost
			ld c,l
			ld a,(bc)
			or a
			pop bc
			jr nz,++
			
			ld c,(hl)
			ld a,c
			or a
			jr z,++ ; check if the source tile is empty
			ld a,(de)
			cp c
			jr z,+ ; check if both tiles are equals
			or a
			jr z,+ ; check if the destination tile is empty
			jp ++
			+: ; both tiles equals
				; check if the destination tile is the max
				cp const_max_tile_index
				jr z,++
					
				ld a,1
				ld (addr_move_still_possible),a
				ret
			++:
				inc de
				inc hl
			djnz -
			
			xor a
			ld (addr_move_still_possible),a
		ret
		
	checkIfMoveDownPossible:
		ld de,addr_board+15
		ld hl,addr_board+11
		ld b,12
		-:
			push bc
			ld bc,addr_ghost
			ld c,l
			ld a,(bc)
			or a
			pop bc
			jr nz,++
		
			ld c,(hl)
			ld a,c
			or a
			jr z,++ ; check if the source tile is empty
			ld a,(de)
			cp c
			jr z,+ ; check if both tiles are equals
			or a
			jr z,+ ; check if the destination tile is empty
			jp ++
			+: ; both tiles equals
				; check if the destination tile is the max
				cp const_max_tile_index
				jr z,++
				
				ld a,1
				ld (addr_move_still_possible),a
				ret
			++:
				dec de
				dec hl
			djnz -
			
			xor a
			ld (addr_move_still_possible),a
		ret
		
	checkIfMoveLeftPossible:
		ld de,addr_board
		ld hl,addr_board+1
		ld b,16
		-:
			push bc
			ld bc,addr_ghost
			ld c,l
			ld a,(bc)
			or a
			pop bc
			jr nz,++
		
			ld a,16
			sub b
			inc a
			and 3
			jr z,++
			
			ld c,(hl)
			ld a,c
			or a
			jr z,++ ; check if the source tile is empty
			ld a,(de)
			cp c
			jr z,+ ; check if both tiles are equals
			or a
			jr z,+ ; check if the destination tile is empty
			jp ++
			+: ; both tiles equals
				; check if the destination tile is the max
				cp const_max_tile_index
				jr z,++
				
				ld a,1
				ld (addr_move_still_possible),a
				ret
			++:
				inc de
				inc hl
			djnz -
			
			xor a
			ld (addr_move_still_possible),a
		ret
		
	checkIfMoveRightPossible:
		ld de,addr_board+15
		ld hl,addr_board+14
		ld b,16
		-:
			push bc
			ld bc,addr_ghost
			ld c,l
			ld a,(bc)
			or a
			pop bc
			jr nz,++
		
			ld a,16
			sub b
			inc a
			and 3
			jr z,++

			ld c,(hl)
			ld a,c
			or a
			jr z,++ ; check if the source tile is empty
			ld a,(de)
			cp c
			jr z,+ ; check if both tiles are equals
			or a
			jr z,+ ; check if the destination tile is empty
			jp ++
			+: ; both tiles equals
				ld a,1
				ld (addr_move_still_possible),a
				ret
			++:
				dec de
				dec hl
			djnz -
			
			xor a
			ld (addr_move_still_possible),a
		ret
		
	clearGhostBoard:
		ld hl,addr_ghost
		ld b,16
		-:
			xor a
			ld (hl),a
			inc hl
		djnz -
		ret
		
	; this chunk of code will calculate the value to add by using the tile index and shift its bits
	; then convert it to bcd and call addToScore
	game_addToScore:
		ld hl,2
		dec b

		--:
			add hl,hl
			djnz --
	/*
		push af
		ld a,l
		call bin2bcd
		ld c,a
		ld a,h
		call bin2bcd
		ld b,a
		pop af
	*/

		ld b,h
		ld c,l
					
		ex af,af'
		call addToScore
		ex af,af'
		ret
		
	; this bcd chunk was ripped from cpcwiki.eu :p
	addToScore:
		ld hl,(addr_score)
		ld a,l
		add a,c
		daa
		ld l,a
		ld a,h
		adc a,b
		daa
		ld h,a
		ld (addr_score),hl
		ret nc
		ld hl,(addr_score + 2)
		ld a,l
		add a,1
		daa
		ld l,a
		ld a,h
		adc a,0
		daa
		ld h,a
		ld (addr_score + 2),hl
		ret
		
	updateScore:
		ld hl,(addr_score + 2)
		ld de,$38AA ; vram adress of the score chunk to update!
		call bcdHl
		ld hl,(addr_score)
		ld de,$38B2 ; vram adress of the score chunk to update!
		call bcdHl
		ret
		
	updateHighScore:
		; force update
		or a
		jr nz,forceUpdateHighScore
		
		; check if we should update
		ld de,addr_score+3 ; copy score to highscore
		ld hl,addr_highscore+3
		ld b,4
		-:
			ld a,(de)
			ld c,(hl)
			cp c
			jr z,++
			jr nc,+++
				ld a,c
				or a
				jr z,++
				ret ; highscore > score
			++:
			
			dec de
			dec hl
		djnz -
		
		+++:
			
		ld de,addr_score ; copy score to highscore
		ld hl,addr_highscore
		ld b,4
		-:
			ld a,(de)
			ld (hl),a
			inc de
			inc hl
		djnz -
	
		forceUpdateHighScore:
		
		ld hl,(addr_highscore + 2)
		ld de,$3D6E ; vram adress of the score chunk to update!
		call bcdHl
		ld hl,(addr_highscore)
		ld de,$3D76 ; vram adress of the score chunk to update!
		call bcdHl
		ret
		
	bcdHl:
		ld a,h
		call bcdA
		ld a,l
		call bcdA
		ret
	
	bcdA:
		ld h,a
		rra
		rra
		rra
		rra
		and $f
		cp $a ; fix a bug related to the score (it sucks but it work!)
		jr nz,+
			dec a
		+:
		add a,$30
		call putChar
		;inc de
		ld a,h
		and $f
		cp $a ; fix a bug related to the score (it sucks but it work!)
		jr nz,+
			dec a
		+:
		add a,$30
		
		;ld de,$38AA
		;ld a,$31
		call putChar
		;inc de
		ret
		
	putChar:
		push af
		push hl
		ld hl,const_font_start
		ld bc,$00FF
		scf
		ccf
		sbc hl,bc
		
		ld c,l
		
		ld b,33 ; font is starting at space character
		sub b
		add a,c
		
		ex de,hl
		call VRAMToHL
		;add a,c
		out ($be),a
		ld a,9
		out ($be),a
		ex de,hl
		pop hl
		pop af
		inc de
		inc de
		ret
.ends

.section "Utils" free
	displayOn:
		ld a,(VDP_DATA+1)
		or $40
		out ($bf),a
		ld a,$81
		out ($bf),a	
		ret
		
	displayOff:
		ld a,(VDP_DATA+1)
		out ($bf),a
		;--- 12 t state to be secure with the 28 state during active display
		inc hl
		dec hl
		;---
		ld a,$81
		out ($bf),a	
		ret
		
	;======================================================================
	; setBoardTile
	;
	; Input: b = tile index of the board (0 to $F)
	;        c = tile index which will be placed on the board (0 to $B)
	;======================================================================
	setBoardTile:
		; place in memory
		ld hl,addr_board
		ld l,b
		ld (hl),c

		ld hl,const_board_tile_nt_adress
		ld de,$0
		
		; calculate X
		ld a,b
		and $3 ; %4
		sla a
		sla a
		sla a
		ld e,a
		add hl,de
		
		; calculate Y
		ld a,b
		sra a
		sra a
		ld de,$100
		ld b,a
		-:
			add hl,de
		djnz -
		
		; calculate tile number based on the index
		ld b,c
		xor a
		-:
			add a,$10
		djnz -
		ld c,a
		
		; place the tile on the board using the nametable
		ld e,$4
		tileCopy:
			; select adress
			ld a,l
			out ($bf),a
			ld a,h
			or $40
			out ($bf),a

			ld b,$4
			-:
				ld a,c
				inc c
				out ($be),a
				xor a
				out ($be),a
			djnz -
			
			push de
			ld de,$0040
			add hl,de
			pop de
			dec e
			cp e
		jr nz,tileCopy
		ret
	
	placeRandomTile:
		ld de,(addr_rng_seed)
		call Rand16
			
		ld a,h
		and $f
		ld b,a
		ld c,FIRST_TILE
			
		; check if already exist
		ld de,addr_board
		ld e,b
		ld a,(DE)
		or a
		jr nz,+
			call setBoardTile
			ret
		+:
			ld b,15
			-:
				ld de,addr_board
				ld e,b
				ld a,(DE)
				or a
				jr nz,NonEmptyTile2
					call setBoardTile
					ret
				NonEmptyTile2:
			djnz -
		ret
.ends

.section "Vbl&Hbl handler" free
	vblHandler:
		;ld hl,$C000
		;xor a
		;ld (hl),a

		ld a,(addr_vbl_counter)
		ld c,a
		;ld hl,addr_checker_speed
		ld hl,addr_move_delay
		ld b,(hl)
		and b
		cp b
		jr nz,noGameUpdate
		
		;ld hl,addr_vbl_counter
		;ld (HL),$00
		
		; === display off
		ld a,(VDP_DATA+1)
		out ($bf),a
		inc hl
		dec hl
		ld a,$81
		out ($bf),a	
		
		ld a,(addr_screen)
		or a
		jr z,notInGame
		
		;call updatePal
		call processMove
		
		; check if there is at least one move possible
		call checkIfMoveUpPossible
		ld a,(addr_move_still_possible)
		or a
		jr nz,+
			call checkIfMoveDownPossible
			ld a,(addr_move_still_possible)
			or a
			jr nz,++
				call checkIfMoveLeftPossible
				ld a,(addr_move_still_possible)
				or a
				jr nz,+++
					call checkIfMoveRightPossible
					ld a,(addr_move_still_possible)
					or a
					jr nz,++++
						ld a,1
						ld (addr_state_of_game),a
						
						ld de,LOSE
						ld hl,addr_lose_position
						call drawText
					++++:
				+++:
			++:
		+:
		
		notInGame:
		
		; === display on
		ld a,(VDP_DATA+1)
		or $40
		out ($bf),a
		ld a,$81
		out ($bf),a	
		
		noGameUpdate:
		
		ld hl,addr_vbl_counter
		inc (hl)
		
		jp EOI

	hblHandler:
		ld hl,(addr_rng_seed)
		inc hl
		ld (addr_rng_seed),hl
		jp EOI
		
	updatePal:
		;ld hl,addr_curr_pal_index
		ld bc,$C000
		ld hl,(addr_curr_pal_index)
		ld a,c
		add a,l
		
		ld h,b
		ld l,a
		call CRAMToHL
		ld a,(addr_checker_col1)
		out ($be),a
		
		ld a,(addr_curr_pal_index)
		cp $04
		jr c,+
		and $03
		jp changeSecondValue
		+:
		add a,$04
		
		changeSecondValue:
		
		ld h,a
		ld bc,$C000
		ld a,c
		add a,h
		ld h,b
		ld l,a
		call CRAMToHL
		ld a,(addr_checker_col2)
		out ($be),a
		
		ld hl,addr_curr_pal_index
		inc (hl)
		
		ld a,(addr_curr_pal_index)
		
		cp $08
		jr nz,+
		ld a,$00
		ld (addr_curr_pal_index),a
		
		+:

		;ld hl,addr_curr_color
		;inc (hl)
		ret
.ends

.section "Data" free
	loadPalettes:
		; palette
		ld hl,$C000
		call CRAMToHL

		ld hl,BackgroundPal
		ld b,BackgroundPalEnd-BackgroundPal
		ld c,$be
		otir
		
		ld hl,$C010
		call CRAMToHL

		ld hl,SpritesPal
		ld b,SpritesPalEnd-SpritesPal
		ld c,$be
		otir
		ret
		
	loadBackground:
		call loadPalettes
		
		; tiles
		ld hl,const_background_tiles_adress
		call VRAMToHL
		
		ld hl,BackgroundTiles
		ld bc,BackgroundTilesEnd-BackgroundTiles
		call WriteVRAM

		call loadBackgroundTileMap
		ret
		
	loadBackground2:
		; palette
		ld hl,$C000
		call CRAMToHL

		ld hl,Background2Pal
		ld b,Background2PalEnd-Background2Pal
		ld c,$be
		otir
		
		ld hl,$C010
		call CRAMToHL

		ld hl,Sprites2Pal
		ld b,Sprites2PalEnd-Sprites2Pal
		ld c,$be
		otir
		
		; tiles
		ld hl,$0000
		call VRAMToHL
		
		ld hl,BackgroundTiles2
		ld bc,BackgroundTiles2End-BackgroundTiles2
		call WriteVRAM

		ld hl,$3800
		call VRAMToHL

		ld hl,BackgroundMap2
		ld bc,BackgroundMap2End-BackgroundMap2
		call WriteVRAM
		ret
		
	loadBackgroundTileMap:
		ld hl,$3800
		call VRAMToHL

		ld hl,BackgroundMap
		ld bc,BackgroundMapEnd-BackgroundMap
		call WriteVRAM
		ret
		
	loadTiles:
		ld hl,$0
		call VRAMToHL
		
		ld hl,Tile1To14
		ld bc,Tile1To14End-Tile1To14
		call WriteVRAM
		ret
		
	loadFont:
		; store font data at the end
		ld hl,addr_font_position
		call VRAMToHL
		ld hl,FontData
		ld bc,FontDataEnd-FontData 
		WriteTilesLoop:
			ld a,(hl)
			out ($be),a
			xor a
			out ($be),a
			out ($be),a
			out ($be),a
			inc hl
			dec c
			jp nz,WriteTilesLoop
			dec b
			jp nz,WriteTilesLoop
		ret
		
	;======================================================================
	; drawText
	;
	; Input: de = null terminated text data
	;        hl = position adress in the tilemap
	;======================================================================
	drawText:
		call VRAMToHL
		dec de
		jp +
		-:
			ld b,33 ; font is starting at space character
			sub b
			
			add a,c
			out ($be),a
			ld a,9 ; 1 for normal palette - 9 for sprite
			out ($be),a
			
			+:
			scf
			ccf
			ld hl,const_font_start
			ld bc,$00FF
			sbc hl,bc
			
			ld c,l

			inc de
			ld a,(de)
			or a
		jr nz,-
		ret

	.include "utils.inc"
		
	; ==== data section ====
	; VDP data
	VDP_DATA:
	.db $16,$a0,$ff,$ff,$ff,$fc,$fb,$f0,$00,$00,$00
	
	HIGHSCORE_DATA:
	.db "HIGHSCORE 00000000" $00
	
	HIGHSCORE_DATA2:
	.db "HIGHSCORE" $00
	
	SCORE_DATA:
	.db "SCORE 00000000" $00
	
	PRESS_START:
	.db "Press START to play." $00
	
	BASED:
	.db "based on" $00
	CREDIT:
	.db "http://git.io/2048" $00
	AUTHOR:
	.db "by Grz-" $00
	
	WIN:
	.db "You win!" $00
	
	LOSE:
	.db "You lose!" $00
	
	.include "font.inc"
	;.include "gfx/map.inc"
	;.include "gfx/sprite.inc"
	.include "gfx/background.inc"
	.include "gfx/tiles.inc"
.ends
