; collision detection for two rectangle
; use hl,de,bc and de'
; x1/w1 -> h/l
; x2/w2 -> d/e
; y1/h1 -> b/c
; y2/h2 -> d'/e'
rectCollision:
	;ex af,af'
		ld a,h
		add a,l
		cp d ; if (x1 + w1) < x2
		jr nc,+
		ld a,d
		add a,e
		cp h ; if (x2 + w2) < x1
		jr nc,+
		ld a,b
		add a,c
		exx
		cp d ; if (y1 + h1) < y2
		jr nc,+
		ld a,d
		add a,e
		exx
		cp b ; if (y2 + h2) < y1
	+:
	;ex af,af'
	ret
	
ClrPSG:
	ld a,$9f
	out ($7f),a
	ld a,$bf
	out ($7f),a
	ld a,$df
	out ($7f),a
	ld a,$ff
	out ($7f),a
	ret

; put sprite list terminator at location pointed by hl
PutSpriteTerminator:
	ex af,af'
		ld a,l
		out ($bf),a
		ld a,h
		or $40
		out ($bf),a
		ld a,$D0
		out ($be),a
	ex af,af'
	ret
	
; disable all sprites starting at the location pointed by hl (output $D0 to y pos)
DisableSprites:
	call VRAMToHL
	ld b,$40
	-:
		ld a,l
		out ($bf),a
		ld a,h
		or $40
		out ($bf),a
		ld a,$D0
		out ($be),a
		inc hl
	djnz -
	ret

; setup all 11 VDP registers in one go from data at (hl)
SetupVDP
	ex af,af'
	push bc
	ld b,0
	ld c,11
		-:
			ld a,(hl)
			out ($bf),a
			ld a,b
			or $80
			out ($bf),a
			inc hl
			inc b
			ld a,b
			cp c
			jp nz,-
	pop bc
	ex af,af'
	ret
	
VRAMToHL:
	ex af,af'
		ld a,l
		out ($bf),a
		ld a,h
		or $40
		out ($bf),a
	ex af,af'
	ret
	
CRAMToHL:
	ex af,af'
		ld a,l
		out ($bf),a
		ld a,$C0
		out ($bf),a
	ex af,af'
	ret

; put a value (located in b) in vram
PutVRAM:
	ld a,b
	out ($be),a
	ret
	
WriteVRAM:
	ex af,af'
	-:	
		ld a,(hl)
		out ($be),a
		inc hl
		dec bc
		ld a,c
		or b
		jp nz,-
	ex af,af'
	ret

WriteToHL:
	ex af,af'
	push bc 
	push hl
	push de
		-:
			ld a,(hl)
			ld (de),a
			inc hl
			inc de
			dec b
			jp nz,-
	pop de
	pop hl 
	pop bc 
	ex af,af'
	ret	

ClrVRAM:
	ex af,af'
	push bc
		ld bc,$4000
		ld a,$00
		bclrvram:
			out ($be),a
		    dec c
		    jp nz,bclrvram
		    dec b 
		    jp nz,bclrvram 
	pop bc
	ex af,af'
	ret
	
WaitVBL:
	ex af,af'
	-:
		in a,($BF)
		and $80
		jp z,-
	ex af,af'
	ret
	
; taken from : http://www.msx.org/forum/development/msx-development/bcdhex-conversion-asm
bin2bcd:
	push	bc
	ld	b,10
	ld	c,-1
div10:	inc	c
	sub	b
	jr	nc,div10
	add	a,b
	ld	b,a
	ld	a,c
	add	a,a
	add	a,a
	add	a,a
	add	a,a
	or	b
	pop	bc
	ret
	
;============================================
;
; Rand16
;
; 16-bit Random Number Generator
; Input: DE = seed
; Output: HL = pseudo-random number, period 65536
;
;=============================================
Rand16:
    ld a,d
    ld h,e
    ld l,253
    or a
    sbc hl,de
    sbc a,0
    sbc hl,de
    ld d,0
    sbc a,d
    ld e,a
    sbc hl,de
    jr nc,Rand
    inc hl
Rand:
;    ld (Seed),hl
	ret