;SMS FM Tool by Chris Covell, January-March 2015

Check_VB_Write:
	ld a,(VBL_Write_ADDR+1) ;Get high byte for writing
	or a
	jr z,no_VB_writing
;--------- if A nonzero, write to VRAM!
	ld e,a
        ld a,(VBL_Write_ADDR)
        out ($bf),a
	ld a,e
;;;;;;;;;;	or $40		;VRAM write is always ORed with $40
	out ($bf),a	;Set VRAM address
	ld a,(VBL_Write_TYPE)
	cp 0
	jr nz,not_as_is
	;as-is
	ld a,(VBL_Write_DATA)
        out ($be),a
	jr VB_write_done
;1111111111111111
not_as_is:
	cp 1
	jr nz,not_checkmark
	;checkmark
	ld a,(VBL_Write_DATA)
	or a	;Is it blank, or otherwise?
	jr z,blank_check
	ld a,$61	;checkmark sign.
blank_check:
        out ($be),a
	jr VB_write_done
;222222222222222
not_checkmark:
	cp 2
	jr nz,not_prthex
	;print as hex
        ld a,(VBL_Write_DATA)
        call Print_Byte
	jr VB_write_done
;3333333333333
not_prthex:
	cp 3
	jr nz,not_prtnybb
	;print 1 nybble
        ld a,(VBL_Write_DATA)
        call Print_Nybble
	jr VB_write_done
;1x1x1x1x1x1x1x1x1x
not_prtnybb:
	ld e,a
	and $F0
	cp $10
	jr nz,not_3nyb
	;3 nybbles
	ld a,e
	call Print_Nybble
        ld a,(VBL_Write_DATA)
        call Print_Byte
	jr VB_write_done
;2x2x2x2x2x2x2x2x
not_3nyb:
	cp $20
	jr nz,not_prtstring
	;print string
	ld a,(VBL_Write_DATA)	;Pointer to which INSTRUMENT
	ld e,a			;Move into E
	xor a
	ld d,a			;Clear D
	ld HL,Instrument_Txt
	add HL,DE
	call Print_Text
	jr VB_write_done
not_prtstring:	;It's SOMETHING else?

VB_write_done:
	xor a
	ld (VBL_Write_ADDR),a
	ld (VBL_Write_ADDR+1),a		;Clear our "flag"!
no_VB_writing:
	ret


VDP_setup:
    ;==============================================================
    ; Set up VDP registers
    ;==============================================================
    ld hl,VdpData
    ld b,VdpDataEnd-VdpData
    ld c,$bf
    otir

    ;==============================================================
    ; Clear VRAM
    ;==============================================================
    ; 1. Set VRAM write address to 0 by outputting $4000 ORed with $0000
    ld a,$00
    out ($bf),a
    ld a,$40
    out ($bf),a
    ; 2. Output 16KB of zeroes
    ld bc, $4000    ; Counter for 16KB of VRAM
    ld a,$00        ; Value to write
ClearVRAMLoop:
        out ($be),a ; Output to VRAM address, which is auto-incremented after each write
        dec c
        jp nz,ClearVRAMLoop
        dec b
        jp nz,ClearVRAMLoop

	ret


Screen_On:
	push AF
    ; Turn screen on
    ld a,%11100100
;          |||| |`- Zoomed sprites -> 16x16 pixels
;          |||| `-- Doubled sprites -> 2 tiles per sprite, 8x16
;          |||`---- 30 row/240 line mode
;          ||`----- 28 row/224 line mode
;          |`------ VBlank interrupts
;          `------- Enable display
    out ($bf),a
    ld a,$81
    out ($bf),a
	pop AF
	ret


Enable_H_Int:
	ld a,%00010100
;		 || |`- 
;		 || `-- ?
;		 |`---- 
;		 `----- Hsync Interrupts!
	out ($bf),a
	ld a,$80
	out ($bf),a
	ret

Disable_H_Int:
	ld a,%00000100
;		 || |`- 
;		 || `-- ?
;		 |`---- 
;		 `----- Hsync Interrupts! (Disabled)
	out ($bf),a
	ld a,$80
	out ($bf),a
	ret

;==============================================================
; VRAM to HL
;==============================================================
; Sets VRAM write address to hl
;==============================================================
VRAMToHL:
  push af
    ld a,l
    out ($bf),a
    ld a,h
    out ($bf),a
  pop af
  ret


Load_Tiles:

	call WriteSprTiles
    ;==============================================================
    ; Load tiles (CHR)
    ;==============================================================

    ld hl,TxtTiles              ; Location of tile data ($8000+$600 nam.)
    ld bc,TxtTilesEnd-TxtTiles  ; Counter for number of bytes to write
    ; 1. Set VRAM write address to tile index 20
    ; by outputting $4000 ORed with $0000
    ld a,$00
    out ($bf),a
    ld a,$42
    out ($bf),a
    ; 2. Output tile data

WriteTilesLoop:

        ld a,(hl)        ; Get data byte
        out ($be),a
        inc hl           ; Add one to hl so it points to the next data byte
        dec c
        jp nz,WriteTilesLoop
        dec b
        jp p,WriteTilesLoop
	ret

WriteSprTiles:
    ; Write Sprite Tiles by outputting $4000 ORed with $2000
    ld a,$00
    out ($bf),a
    ld a,$60
    out ($bf),a
    ; 2. Output tile data
    ld hl,SprTiles              ; Location of tile data ($8000+$600 nam.)

    ld bc,SprTilesEnd-SprTiles  ; Counter for number of bytes to write
    jr WriteTilesLoop


Load_Map:
    ;==============================================================
    ; Write Map to name table
    ;==============================================================
    ld hl,TxtMap               ; Location of map data
    ld bc,TxtMapEnd-TxtMap  ; Counter for number of bytes to write
Load_Map_noptr:
    ; 1. Set VRAM write address to name table index 0
    ; by outputting $4000 ORed with $3800+0
    ld a,$00
    out ($bf),a
    ld a,$38|$40
    out ($bf),a

WriteMapLoop:
        ld a,(hl)    ; Get data byte
        out ($be),a
        inc hl           ; Add one to hl so it points to the next data byte
        dec c
        jp nz,WriteMapLoop
        dec b
        jp p,WriteMapLoop

EndWriteMapLoop:
	ret
;----------------------------------










;----------------------------------
Go_Line:	;Jumps to a line number.
	ld a,(lineno) 	;Line no needs to be multiplied by $40
	and %00000011
	rrca	;10000001
	rrca	;11000000
        out ($bf),a
	ld a,(lineno)
	and %11111100
	rrca	;01111110
	rrca	;00111111
	or $38|$40
        out ($bf),a
	ret


Print_Text:
	push BC
	ld c,$10	;SPRITES BEHIND MAP
Print_Textlp:
        ld a,(hl)    ; Get data byte
        or a
        jr z,EndPrtTxt	;Quit if byte is Zero!
	cp $ff		;If $FF, swap palettes
	jr nz,prt_txt_char
	ld a,c
	xor $08		;Set 2nd palette
	ld c,a
	jr prt_txt_bgpal
prt_txt_char:
        out ($be),a
	ld a,c
	out ($be),a
prt_txt_bgpal:
        inc hl           ; Add one to hl so it points to the next data byte
        jp Print_Textlp
EndPrtTxt:
	pop BC
	ret
	
Print_Byte:	;Prints byte as HEX
	push AF
    rlca                   ; Get high 4 bits into 4 low bits
    rlca
    rlca
    rlca
        and $0F
        or  $10	;Point to HEX
	out ($be),a
	ld a,$10	;SPRITES BEHIND MAP
	out ($be),a

	pop AF
Print_Nybble:
	push AF
        and $0F
        or  $10	;Point to HEX
	out ($be),a
	ld a,$10	;SPRITES BEHIND MAP
	out ($be),a
	pop AF
	ret

;******************************************************************************
Load_Palette:
    ;==============================================================
    ; Load palette
    ;==============================================================
	ld hl,ColPalData	;Point to in-program palette
Load_Palette_noptr:
    ; 1. Set VRAM write address to CRAM (palette) address 0 (for palette index 0)
    ; by outputting $c000 ORed with $0000
	ld a,$00
	out ($bf),a
	ld a,$c0
	out ($bf),a
    ; 2. Output colour data

	ld b,$20		;32 bytes
	ld c,$be
	otir
	ret

;******************************************************************************

Splash_Screen_Wait:

	ld HL,Splash_Pal
	call	Load_Palette_noptr
    	ld hl,SplashMap               ; Location of map data
    	ld bc,SplashMapEnd-SplashMap  ; Counter for number of bytes to write
	call Load_Map_noptr

    ld hl,SplashTiles              	; Location of tile data ($8000+$600 nam.)
    ld bc,SplashTilesEnd-SplashTiles  ; Counter for number of bytes to write
    ld a,$00
    out ($bf),a
    ld a,$40
    out ($bf),a
    call	WriteTilesLoop

	ld HL,splash_fanfare    ;Fanfare data pointer
	call FM_RegDump		;Block Write to FM Registers

	call Screen_On
	call Disable_H_Int
	ei	;enable interrupts

	ld HL,Splash_Delay
	ld (delay1),HL	;Store delay!
	xor a
	ld (paused),a	;Make sure we're not paused.
splsh_lp:
	ld a,(delay1+1)
	ld b,a
	ld a,(delay1)
	or b
	jr nz,splsh_lp

    di
    ;TURN SCREEN, INTERRUPTS OFF!
    ld a,%10000100
    out ($bf),a
    ld a,$81
    out ($bf),a

	ret

;========================

Debug_Wait:
    ld a,$00
    out ($bf),a
    ld a,$38|$40		;Write to MAP!
    out ($bf),a
    ld bc, $600 	    ; 2. Output xxKB of zeroes
    ld a,$00        ; Value to write
	call ClearVRAMLoop
	call NoSprites
	call DetectJapanesePaddle
	call Print_FM_Paddle

    	ld hl,Controls_Txt
    	ld a,6		;23=last line of SMS display.
	ld (lineno),a
    	call Go_Line
    	call Print_Text

	call Screen_On
	call Disable_H_Int
	ei	;enable interrupts

	ld HL,Debug_Delay
	ld (delay1),HL	;Store delay!
	xor a
	ld (paused),a	;Make sure we're not paused.
;--- FREEZE IF NO FM PRESENT!?
	ld a,(FM_Present)
	or a
	jr z,debug_infloop
	ld HL,fanfare_end    	;data pointer
	call FM_RegDump		;Block Write to FM Registers
debug_lp:
	call DetectCon2Paddle	;Check if Controller 2 around?
	call DetectJapanesePaddle
	call ReadPaddle
	call	ReadCon2Paddle
	ld a,(delay1+1)
	ld b,a
	ld a,(delay1)
	or b
	jr nz,debug_lp

    di
    ;TURN SCREEN, INTERRUPTS OFF!
    ld a,%10000100
    out ($bf),a
    ld a,$81
    out ($bf),a

	ret

debug_infloop:
	call DetectJapanesePaddle
	call ReadPaddle
	jr debug_infloop






; VDP initialisation data
VdpData:
.db $04,$80,$84,$81,$ff,$82,$ff,$83,$07,$84,$ff,$85,$ff,$86,$f0,$87,$00,$88,$00,$89,$01,$8a
VdpDataEnd:

ColPalData:
.include "gfx\text-pal.inc"
.include "gfx\text-pal2.inc"
ColPalDataEnd:
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
BlankPaletteData:
.db $00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00,$00
BlankPaletteDataEnd:

CursBlinkPal:
.db $30,$20,$03,$02,$0C,$08
