;SMS FM Tool by Chris Covell, January-March 2015

;==============================================================
; Sprite disabler
;==============================================================
; Sets sprite 1 to y=208
; Clobbers HL, A
;==============================================================
NoSprites:
  ld hl,SpriteTableAddress | $4000
  call VRAMToHL
  ld a,208
  ld b,$40
clr_spr_y:
  out ($be),a
  djnz clr_spr_y

  xor a
  ld b,$C0
clr_spr_xetc:
  out ($be),a
  djnz clr_spr_xetc
  ret

Move_Sprites:
  ld hl,SpriteTableAddress | $4000
  call VRAMToHL

  	ld HL,RowSprPosTbl	;Point to table of sprite Y-pos
	ld a,(RowNum)
	ld e,a			;Copy RowNum to E for addition
	xor a
	ld d,a
	add HL,DE		;Add Y-pos for Row Value
	ld a,(HL)
	dec a		;Adjust it slightly...
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos
	out ($be),a	;Save in sprite Y-pos	;Fastest?

  ld hl,SpriteTableAddress+$80 | $4000	;Point to X-pos
  call VRAMToHL

	call Row_Col_in_DE      ;Combines Row, Col offset in DE

 	ld HL,ColSprLenTbl	;Point to table of sprite RUN LENGTHS
	add HL,DE		;Add pointer for Row/Col Value
        ld a,(HL)               ;Get X-position
	ld c,a			;Store sprite runs (1..8) in C
	dec c                   ;now 0..7

 	ld HL,ColSprPosTbl	;Point to table of sprite X-pos
	add HL,DE		;Add pointer for Row/Col Value

;	ld a,(nmicount)
;	and 1
	ld e,$0		;Store tile # in E!

	ld a,(HL)               ;Get X-position
	ld b,$8		;Do 8 sprites
spr_width_lp:
	ld d,a		;Save A temporarily
	out ($be),a	;Save in sprite X-pos
	ld a,e		;Get back Tile #
	out ($be),a	;Make our cursor flicker!

	ld a,c		;Get sprite runs
	or a		;Or with itself
	jr z,spr_width_keep
	dec c		;Decrement width info
	ld a,d		;Restore X-pos
	add a,8		;Add 8 to X-pos
	ld d,a
spr_width_keep:		;Don't add to X-pos!
	ld a,d		;Restore X-pos

	djnz spr_width_lp

;Flicker palette a bit!
	ld a,$1F	;Last palette of sprites!
	out ($bf),a
	ld a,$c0
	out ($bf),a
    ; 2. Output colour data
	ld a,(nmicount)
	and 1
	ld e,a
	ld a,(CursDepth)	;Get cursor depth (0,1,2)
	add a,a			;...0,2,4
	or e
	ld e,a
	xor a
	ld d,a
	ld hl,CursBlinkPal
	add HL,DE
	ld a,(HL)
	out ($be),a


  	ret