; main file to my project,
; "Move the character!"


; banking
.memorymap
defaultslot 0
slotsize $2000
slot 0 $0000
slot 1 $c000
.endme
.rombankmap
bankstotal 1
banksize $2000
banks 1
.endro


.include "tiles.asm"
.include "aplib-z80.asm"
.ramsection "aPlibstuff" bank 0 slot 1
aPLibMemory instanceof aPLibMemoryStruct
.ends

; the usual definitions
.define VDPControl $bf
.define VDPData $be
.define VRAMWrite $4000
.define CRAMWrite $c000

; all this stuff......
.smstag

.org $68
.section "commentary" force
commentary:
.db "Alright, I get it, this is a game that I haven't "
.db "been in for quite a while, but as soon as I saw "
.db "that a competition was coming up, who could resist? "
.db "The only problem...only about 5 days left to make "
.db "something. So here's what I came up with, just a "
.db "little \"platformer\". With one level. Enjoy." 0
.ends


.struct t
    x db
    y db
.endst


.ramsection "ram" bank 0 slot 1
controller db
tile instanceof t
.ends


.bank 0 slot 0
.org $00
.section "begin" force
    di
    im 1
    ld sp,$dff0
    jp main
.ends


.org $38
.section "interrupt" force
    di
    push af
    in a,$bf
    pop af
    call ButtonHandle
    call TileUpdate
    call GetCtrl
    ei
    ret
.ends

.org $66
.section "pause" force
    retn
.ends


.section "main" free
main:
    call VDPStuff

    ld bc, $4000
    call SetVDP
    -: ld a,$00
    out [VDPData],a
    dec bc
    ld a,b
    or c
    jr nz,-

    ld hl,$0000 | CRAMWrite
    call SetVDP
    ld hl,PaletteData
    ld bc,PaletteDataEnd-PaletteData
    call CopyVDP

    ld hl,$0010 | CRAMWrite
    call SetVDP
    ld hl,PaletteData
    ld bc,PaletteDataEnd-PaletteData
    call CopyVDP

    ; load tiles
    ld hl,tiledat
    ld de,$0000
    di
    call vram_depack

    ld hl,Message
    call PrintMsg

    ; Turn screen on
    ;call ScreenOn

    ld a,$80
    ld [tile.x],a
    ld a,$60
    ld [tile.y],a

ei
-:
halt
jr -
.ends


.section "tile" free
TileUpdate:
    push hl
    push af

    call ScreenOff

    ld hl,$7f80
    call SetVDP

    ld a, [tile.x]
    out (VDPData), a
    ld a, $5F
    out (VDPData), a

    ld hl,$7f00
    call SetVDP

    ld a, [tile.y]
    out (VDPData), a
    ld a, $d0
    out (VDPData), a

    call ScreenOn
    pop af
    pop hl
    ret
.ends


.section "data" free
SetVDP:
    push bc
    ld c,VDPControl
    out (c),l
    out (c),h
    pop bc
    ret

CopyVDP:
-:  ld a,(hl)    ; Get data byte
    out (VDPData),a
    inc hl       ; Point to next letter
    dec bc
    ld a,b
    or c
    jr nz,-
    ret


.asciitable
map " " to "~" = 0
.enda

Message:
.asc "      Move the character!        "
.asc "a stupid demo by nicklausw       "
.asc "   (homsar47, of course) "
.db $ff

PaletteData:
.db $00,$3f ; Black, white
PaletteDataEnd:
.ends

.section "controller" free
GetCtrl:
    push af
    in a,$dc
    ld [controller],a
    pop af
    ret

ButtonHandle:
    push af
    ld a,[controller]

    bit 0,a
    call z, _MoveUp

    bit 1,a
    call z, _MoveDo

    bit 2,a
    call z, _MoveLe

    bit 3,a
    call z, _MoveRi

    pop af
    ret

_MoveUp:
    push af
    ld a,[tile.y]
    cp $16
    jr z,+
    dec a
    dec a
    ld [tile.y],a
    +: pop af
    ret

_MoveDo:
    push af
    ld a,[tile.y]
    cp $B8
    jr z,+
    inc a
    inc a
    ld [tile.y],a
    +: pop af
    ret

_MoveLe:
    push af
    ld a,[tile.x]
    cp 0
    jr z,+
    dec a
    dec a
    ld [tile.x],a
    +: pop af
    ret

_MoveRi:
    push af
    ld a,[tile.x]
    cp $F8
    jr z,+
    inc a
    inc a
    ld [tile.x],a
    +: pop af
    ret
.ends

.section "VDP" free
PrintMsg:
    push hl
    ld hl,$3800 | VRAMWrite
    call SetVDP
    pop hl
-:  ld a,(hl)
    cp $ff
    jr z,+
    out (VDPData),a
    xor a
    out (VDPData),a
    inc hl
    jr -
+: ret

ScreenOn:
    ld a,%11100100
    out (VDPControl),a
    ld a,$81
    out (VDPControl),a
    ret

ScreenOff:
    ld a,%10100100
    out (VDPControl),a
    ld a,$81
    out (VDPControl),a
    ret

; VDP initialisation data
VDPStuff:
    ld hl,VDPI
    ld b,$80
    ld c,VDPE-VDPI
    -: ld a,[hl]
    out [VDPControl],a
    ld a,b
    out [VDPControl],a
    inc hl
    dec c
    inc b
    ld a,c
    cp 0
    jr nz,-
    ret

VDPI:
    .db $6 $a0 $ff $ff $ff $ff $00 $00 $00 $00 $ff
VDPE:
.ends