.include "objectAttributes.inc"
.include "menu.asm"
.bank 2 slot 1

;Clear sprite table on memory
.section "clearSprites" free
clearObjectTable:
	xor a
	ld hl, objectTable.1.objType
	ld (hl), a
	ld de, objectTable.1.objType + 1
	fastLdir (18 * _sizeof_object) - 1
;;fallThrow
clearSpriteTable:;Lbl_8473:
	ld a, $f1
	ld b, 64
	ld hl, spriteTable
	
-:		ld (hl), a
		inc l
	djnz -	
	ret
.ends

.section "clearScroll" free
;zera o scroll
clearScroll: ; Lbl_847e
	ld hl, $0000
	ld (horizontalScroll), hl
	ld (verticalScroll), hl
	ret 
.ends

.macro depackTiles
	call turnOffVdp
	ld a, alphabetTilesBank
	ld (mapperSlot2), a

	decompress alphabetTiles, $3700 - alphabetTilesSize, alphabetTilesCount
	decompress openingTiles, $3700 - alphabetTilesSize - openingTilesSize, openingTilesCount
	decompress megamanSteadTempTiles, 0, megamanSteadTempTilesCount 
	decompress openingSpritesTiles, MegamanMaxFrameSize, openingSpritesTilesCount
.endm

.macro clearVdp
	ld de, $3700 | VramWrite
	ld bc, VdpControlPort ; ld b, 0 ; ld c, VdpControlPort
	out (c), e
	out (c), d
	
	dec c ; ld c, VdpDataPort
	ld de, $0198 ; black tile
	ld h, 4
-:			out (c), e
			out (c), d
		djnz - 
		dec h
	jp nz, - 
	
	ld bc, $2000
	ld hl, palette
-:		ld (hl), c
		inc l
	djnz -
.endm

;load texts during blank period in the following format:
;numLines [numChar+2 vramAddress [char]]
;hl: pointer to the first position
.section "loadPassiveText" free
loadPassiveText:
	ld d, (hl)
	inc l
	ld a, %00000001
	ld c, VdpControlPort
--:		ld b, (hl)
		inc hl 
		outi
		outi
		dec c
-:			outi
			out (VdpDataPort), a
		jr nz, -
		inc c
		dec d
	jp nz, --
	ret
.ends

.macro animateIntroText
	call clearSpriteTable

	ld hl, introText
	call loadPassiveText
	
	call turnOnVdp	
	ld a, (resolutionDependencies.introTextScroll)
	ld (verticalScroll + 1), a
	call fadeText
.endm

.macro loadNameTable
	ld a, (resolutionDependencies.openingScroll)
	ld (verticalScroll + 1), a
	ld hl, (resolutionDependencies.openingFirstDepackedLine)
	ld de, (resolutionDependencies.openingFirstVramLine)
	call depackOpeningScreen

.endm

.macro loadObjectTable
	call clearObjectTable

	ld a, $80
	ld (objectTable.1.yFraction), a
	ld (objectTable.1.ySpeed), a
	
	ld a, $28
	ld (objectTable.2.y), a
	
	ld a, $47
	ld (objectTable.4.y), a
	
	ld a, objects.opening.windows
	ld (objectTable.6.objType), a
	ld (objectTable.7.objType), a
	
	inc a ; ld a, objects.opening.parapeito
	ld (objectTable.3.objType), a
	ld (objectTable.4.objType), a
	
	ld a, objects.opening.megamanHead
	ld (objectTable.16.objType), a
	
	ld a, objects.opening.megamanBody
	ld (objectTable.17.objType), a
	
	ld hl, $fc3d
	ld (objectTable.16.y), hl
	ld (objectTable.17.y), hl
	
	ld a, $27
	ld (objectTable.6.y), a
	ld a, $6f
	ld (objectTable.7.y), a
	
.endm

.macro fadeInBackground
	call turnOnVdp
	ld c, 3 + 3*29
	ld hl, openingPalettesFade
--:		ld b, 8
		push hl
-:			push bc
			call prepareForVblank
			pop bc
			ld a, (hl)
			and StartKey | BKey
			jp nz, skipOpening
		djnz -
		ld hl, hasNewPalette
		inc (hl)
		inc l
		ex de, hl
		pop hl
		fastLdir 29
		dec c
	jp nz, --
.endm

.macro animateOpeningText
	ld hl, VramWrite | $3c46
	ld (vramRaw.destiny), hl
	ld hl, endSeqOuti - ((27*4) + 74)*2
	ld (vramRaw.fastOtirCall), hl	
	ld hl, historyText

	ld iyl, 5
--:		ld a, 1
		ld (vramRaw.haveData), a
		ld de, vramRaw.buffer

		call copyHistoryTextLine
		
		ex de, hl
		ld b, 37 ; number of entries between two lines
-:			ld (hl), c
			inc l
			ld (hl), a
			inc l
		djnz -
		ex de, hl
		
		call copyHistoryTextLine
		
		ex de, hl
		call fadeText
		ex de, hl
		dec iyl
	jr nz, --
.endm

.define speed tempVars
.macro scrollBackgroud
	ld hl, endSeqOuti - 128
	ld (vramRaw.fastOtirCall), hl
	ld hl, (resolutionDependencies.openingFirstVramLine)
	ld (vramRaw.destiny), hl
	ld hl, -$0080
	ld (speed), hl
	
	ld c, 35 + 24
	ld ix, (resolutionDependencies.openingFirstDepackedLine)
	
--:				push bc
				dec ix
				dec ix
				ld c, (ix + 0)
				ld b, (ix + 1)
				ld de, vramRaw.buffer
				call depackOpeningLine
				ld hl, vramRaw.haveData
				inc (hl)
				ld hl, (vramRaw.destiny)
				ld de, -64
				add hl, de
				ld a, (resolutionDependencies.nameTableBegining + 1)
				dec a
				cp h
				jr nz, +
					ld h, $3e | VramWrite.hi
+:				ld (vramRaw.destiny), hl
				pop bc
				
				ld b, 16
				ld a, c 
				cp 23
				jp m, +
				jr nz, ++
					ld hl, -$0200
					ld (speed), hl
					xor a
					ld hl, palette + 5
					ld (hl), a
					inc a
					ld hl, hasNewPalette
					ld (hl), a
+:				ld b, 4
++:			
-:			ld hl, (verticalScroll)
			ld de, (speed)
			add hl, de
			xor a
			cp h
			jr nz, +
				ld a, (resolutionDependencies.verticalScrollEnd)
				ld h, a
+:			ld (verticalScroll), hl
			push bc
			call scrollObjects
			call decreaseMegamanFrameTimer
			call objectsToSprites
			call prepareForVblank
			pop bc
			ld a, (hl)
			and StartKey | BKey
			jp nz, skipOpening
			
		djnz -
		dec c
	jr nz, --
.endm

.macro wait
	ld b, $70
-:		push bc
		call decreaseMegamanFrameTimer
		call objectsToSprites
		call prepareForVblank	
		pop bc
	djnz -
.endm


.section "megamanFrameTimers" free
megamanFrameTimers:
	.db 4 4 4 4 12 4 4 4 4 2 2 2
.ends
.macro titleScreen
	ld hl, hasNewPalette
	inc (hl)
	inc l
	ld de, titleScreenPalette
	ex de, hl
	fastLdir 6
	
	ld a, 3
	ld (objectTable.18.objType), a
	ld e, $98
	
	
	ld bc, $000b
-:		ld a, (frameCounter)
		and $08
		ld a, $f0
		jr z, +
			ld a, e
+:		ld (objectTable.18.y), a
		
		push bc
		push de
		call decreaseMegamanFrameTimer
		call objectsToSprites
		call prepareForVblank
		pop de
		pop bc
		ld a, (hl)
		and StartKey | BKey | UKey | DKey
		jr z, +
		and StartKey | BKey
		jr nz, ++
			ld a, $40
			sub e
			ld e, a
			ld hl, difficult
			ld a, 1
			sub (hl)
			ld (hl), a
+:	djnz -
	dec c
	jr nz, -
++:	
.endm


.macro animateMegamanExit	
	xor a
	ld (objectTable.18.objType), a
	
	ld c, 12
	ld e, 6
		
		ld hl, megamanFrameTimers
		push hl
		
--: 	ld a, 4
		cp c
		jr nz, +	
			ld e, 10
+:		ld a, 3
		cp c
		jr nz, ++
			xor a
			ld (objectTable.17.objType), a
			ld e, 15

++:		pop hl
		ld b, (hl)
		inc hl
		push hl
		
		ld hl, objectTable.16.objType
		ld (hl), e
		inc e
		push de
-:			push bc
			call objectsToSprites
			call prepareForVblank
			pop bc
		djnz -
		pop de
		dec c
	jr nz, --
	pop hl
	
	ld b, $4f
-:		ld a, 15
		ld (objectTable.16.objType), a
		ld hl, (objectTable.16.y)
		ld de, -8
		add hl, de
		ld (objectTable.16.y), hl
		
		push bc
		call objectsToSprites
		call prepareForVblank
		pop bc

	djnz -	
.endm

.section "introduction" free
introduction: ; Lbl_9ee7
	depackTiles
	clearVdp
	animateIntroText
;Prg13_Lbl_9f9d:
	loadNameTable
jp loadObjectTable	
loadObjectTable:	
	loadObjectTable
	call objectsToSprites
	fadeInBackground
	animateOpeningText
	scrollBackgroud
	wait
titleScreen:	
	titleScreen
	push bc
	animateMegamanExit
	pop bc
	ld a, b
	or c
	jp z, introduction
	
	menu.startPassword
	ret
.ends	

;fade out the pallete in one level
;hl: start position on the palette buffer
;b: number of entries to be faded
.section "fadeOutPalette"
fadeOutPalette:
-:		ld a, (hl)
		call fadeColor
		ld (hl), a
		inc l
	djnz -
	ret
.ends

;fade in the pallete in a especified level
;hl: start position on the stored palette witch will be faded
;de: start position on the destination buffer
;b: number of entries to be faded
;c: level of the fadding (the higher, the darker)
.section "fadeInPalette"
fadeInPalette:
--:		ld a, (hl)
		push bc
-:			dec c
			jr z, +
			call fadeColor
		jr -
+:		pop bc
		ld (de), a
		inc hl
		inc e
	djnz --
	ret
.ends

;fade a color in a, returns also in a
.section "fadeColor" free
fadeColor:
	push hl
	ld h, a
	ld l, %00010000
-:		cp l
		push hl
		jr nc, +
			ld l, 0
			ex (sp), hl
+:		dec l
		and l
		inc l
		sra l
		sra l
	jr nz, -
	
	pop hl
	ld a, h
	sub l
	pop hl
	sub l
	pop hl
	sub l
	pop hl
	ret
.ends


.section "skipOpening" free
skipOpening: ;Prg13_Lbl_a7b0
	ld sp, $dfec
	call turnOffVdp
	ld de, $3780 | VramWrite
	ld hl, openingMapLines
	call depackOpeningScreen
	ld a, (resolutionDependencies.introTextScroll)
	ld (verticalScroll + 1), a
	
	ld hl, openingPalette + 9
	ld de, palette + 9
	fastLdir 20
	
	call clearObjectTable
	
	ld a, objects.opening.windows
	ld (objectTable.4.objType), a
	inc a ; ld a, objects.opening.parapeito
	ld (objectTable.3.objType), a
	ld a, objects.opening.megamanHead
	ld (objectTable.16.objType), a
	ld (objectTable.16.frameTimer), a
	ld a, objects.opening.megamanBody
	ld (objectTable.17.objType), a
	
	ld hl, $00a0
	ld (objectTable.3.y), hl
	ld hl, $00c8
	ld (objectTable.4.y), hl

	ld hl, $0077
	ld (objectTable.16.y), hl
	ld (objectTable.17.y), hl
		
	call turnOnVdp
	jp titleScreen
.ends


;add a new object to one of the 12 first positions on the object table
;c: type of the object
.macro addNewObject
	ld b, 12
	ld de, _sizeof_object
	ld hl, objectTable.3.objType
addNewObjectLoop:		
		ld a, (hl)
		or a
		jr nz, addNewObjectNextIteration
		
			ld (hl), c
			inc hl
			inc hl
			inc hl
			ld (hl), a
			inc hl
			ld (hl), $e0
			inc hl
			ld (hl), $ff
			jr endAddNewObject
addNewObjectNextIteration:
		add hl, de
		djnz addNewObjectLoop	
endAddNewObject: 		
.endm

;scroll the windows, parapeitos and megaman up to the title screen
;destroys : all but ix
.section "scrollObjects" free
scrollObjects: ; Prg13_Lbl_a61b
	ld iy, objectTable.3
	ld b, 13
	ld a, $e9
	ld de, (objectTable.1.ySpeed)
-:		ld l, (iy + object.objType)
		dec l
		jp m, ++
		
		ld l, (iy + object.yFraction)
		ld h, (iy + object.y)
		add hl, de
		
		ld (iy + object.yFraction), l 
		ld (iy + object.y), h 
		
		jr c, +
			dec (iy + object.y +1)
+:		inc (iy + object.y +1)
		jr nz, ++
		cp h
		jr nc, ++
			ld (iy + object.objType), 0
			
++:		ld hl, _sizeof_object
		ex de, hl
		add iy, de
		ex de, hl
	djnz -
		ld a, c
		cp 23
		jr c, ++
			ld hl, objectTable.2.yFraction
			push hl
			push hl
			ld bc, (2 << 8) | objects.opening.windows
			ld hl, objectTable.1.yFraction
-:				ld a, (hl)
				sub e
				ld (hl), a
				inc hl
				ld a, (hl)
				sbc a, d
				ld (hl), a
				jr nc, +
					ld (hl), $48
					dec hl
					ld (hl), $00
					push bc
					push de
					addNewObject
					pop de
					pop bc
+:				pop hl
				inc c
			djnz -
++:	
	ld a, 2
	cp d
	jr z, +
		inc de
		inc de
+:	ld (objectTable.1.ySpeed), de
	
	ld hl, (objectTable.16.y)
	ld c, d
	add hl, bc
	ld (objectTable.16.y), hl
	
	ld hl, (objectTable.17.y)
	ld c, d
	add hl, bc
	ld (objectTable.17.y), hl
	
	ret
.ends

.section "decreaseMegamanFrameTimer" free
decreaseMegamanFrameTimer:	
	ld hl, objectTable.16.frameTimer
	dec (hl)
	ret nz
		ld a, 5
		ld (hl), a
		dec hl
		inc (hl)
		inc a; ld a, objects.opening.megamanHead + 2
		cp (hl)
		ret nz
			dec (hl)
			dec (hl)
	ret
.ends

;iy:object Address
;h : most significant part of the attribute Table of the object
;de : postion on the sprite Table
.section "objectToSprites" free
objectToSprites:
	ld l, (iy + object.objType)
	dec l
	ret m
	
	sla l
	ld c, (hl)
	inc l
	ld h, (hl)
	ld l, c
	ld b, (hl)
	inc hl
	ld a, (iy + object.y)
		
-:		push af
		add a, (hl)
		inc hl
		ld c, a
		sbc a, a
		cp (iy + object.y + 1)
		jr nz, +
			ld a, 231
			cp c
			jr c, +
				ld a, (resolutionDependencies.objectToSpriteYOffset)
				add a, c
				ld (de), a
				inc d
				sla e
				ld a, (hl)
				add a, (iy + object.x)
				ld (de), a
				inc hl
				inc e
				ld c, d; make sure b will not be decremented
				ldi
				dec d
				sra e
			jr ++
+:				inc hl
				inc hl
++:			pop af
	djnz -
	ret
.ends

.section "objectsToSprites" free
objectsToSprites:	
	call clearSpriteTable
	ld de, spriteTable
	ld iy, objectTable.1.objType
	ld b, $12	
-:		push bc
		ld h, >objects.openingTable
		call objectToSprites

		ld bc, _sizeof_object
		add iy, bc
		pop bc	
	djnz -
	ret		
.ends

.section "turnOnVdp" free	
turnOnVdp: ; Lbl_a51d ; the Vdp will be enabled on the next vBlank
	ld a, (vdpMisc2Value)
	or M2FrameInterrupts
	out (VdpControlPort), a
	ld (vdpMisc2Value), a
	ld a, VdpMisc2
	out (VdpControlPort), a
	ret 
.ends

.section "turnOffVdp" free
turnOffVdp: ; Lbl_a52d
	ld a, (vdpMisc2Value)
	and $ff~(M2FrameInterrupts | M2DisplayEnabled)
	out (VdpControlPort), a
	ld (vdpMisc2Value), a
	ld a, VdpMisc2
	out (VdpControlPort), a
	ret 
.ends

.define openingPalette.size 29
.section "openingPalettesFade" free
openingPalettesFade: ; Lbl_aa4f
		.db $00 $00 $00 $00 $00 $00 $00 $00 $00 $00 $02 $15 $00 $00 $00 $22  $00 $15 $00 $1F $34 $3C $00 $00 $00 $00 $1F $14 $00
		.db $00 $00 $00 $00 $00 $22 $15 $20 $15 $15 $05 $2a $15 $21 $15 $23  $00 $2a $00 $1F $34 $3C $00 $00 $15 $15 $1F $28 $20
openingPalette:                                                                 
		.db $00 $00 $00 $00 $00 $23 $14 $34 $21 $15 $1B $3f $22 $35 $2A $37  $00 $3F $00 $1F $34 $3C $00 $00 $15 $2A $1F $3C $34
titleScreenPalette:
		.db $00 $3f $04 $13 $39 $02
.ends

.section "copyHistoryTextLine" free
historyText: ; Prg13_Lbl_ad46
  .asc "   IN THE YEAR OF 200X,    "
  .asc "A SUPER ROBOT NAMED MEGAMAN"
  .asc "       WAS CREATED.        "
  .asc " DR.LIGHT CREATED MEGAMAN  "
  .asc " TO STOP THE EVIL DESIRES  "
  .asc "        OF DR.WILY.        "
  .asc " HOWEVER,AFTER HIS DEFEAT, "
  .asc "   DR.WILY CREATED EIGHT   "
  .asc "    OF HIS OWN ROBOTS      "
  .asc "   TO COUNTER MEGAMAN.     "

; hl: source
; de : destiny
; a : 1
;output: 1 on c	
copyHistoryTextLine:
	ld bc, (27 << 8) | ($98 + 27)
-:		ldi
		ld (de), a
		inc e
	djnz -
	ret
	
.ends

.section "textFadePalette and fadeText routine" free
textFadePalette:
	.byte $00,$15,$2a,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f
	.byte $3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$3f,$2a,$15,$00
textFadePaletteEnd:
		
fadeText:		
	ld c, textFadePaletteEnd - textFadePalette ;$fes
	ld hl, textFadePalette
--:		ld b, $0a ;Prg13_Lbl_9f60
		ld a, (hl)
		ld (palette+1), a
		ld a, 1
		ld (hasNewPalette), a
		push hl
-:			push bc
			call prepareForVblank
			pop bc
			ld a, (hl)
			and StartKey | BKey
			jp nz, skipOpening
		djnz -
		pop hl
		inc hl
		dec c
	jp nz, --
	ret
.ends

.section "introText" free
introText:
	/*
	.byte 4
	.byte $15 
	.word $39ce | VramWrite
	.asc  "c1988 CAPCOM CO.LTD"
	.byte $21
	.word $3a42 | VramWrite
	.asc  "TM AND c1989 CAPCOM U.S.A.,INC."
	.byte $0d
	.word $3ad6 | VramWrite
	.asc  "LICENSED BY"
	.byte $1d
	.word $3b48 | VramWrite
	.asc  "NINTENDO OF AMERICA. INC."
	*/
	.byte 2
	.byte $1e
	.word $3a44 | VramWrite
	.asc  "SMSPOWER! CODING COMPETITION"
	.byte $0c
	.word $3ad4 | VramWrite
	.asc  "2015 GVX32"
.ends	