#include "library/_sms_setz80stackpoint.bas"
#include "library/smsvdp.bas"
#include "library/smsfilvrm.bas"
#include "library/smsfilvrmtx.bas"
#include "library/smsfilvrmtxof.bas"
#include "library/smsfilvrmtxoford.bas"
#include "library/smsldirvm.bas"
#include "library/smsldirvmtxof.bas"
#include "library/smsscroll.bas"
#include "library/smsvpoke.bas"
#include "library/smsrnd.bas"
#include "library/smsjoypad.bas"
#include "library/smspalette.bas"
#include "library/smsdelay.bas"
#include "library/smswaitvbl.bas"
#include "library/zombiterror_charmap.bas"
#include "library/smsvpoketxof.bas"
#include "library/zombiterror_charmap_2bitdepth.bas"
#include "library/zombiterror_missandskulltiles01_4bitdepth.bas"

'- ZOMBI TERROR (c) 2014,2015 KABUTO FACTORY - Code, graphics & audio soundtrack by Manuel Gomez (Baron Ashler)
'- Thanks to Bieno64, Ivanzx, Laser, Mode2, Nai, Oscar Ruiz, Rulas Int., Sacri Estevez and Urindil for their help and support
'- SMS version by Paulo Silva (Nitrofurano)

dim ee0 as uinteger at $C010
dim x as uinteger at $C012
dim y as uinteger at $C014
dim e as uinteger at $C016
dim m as uinteger at $C018
dim seed as uinteger at $C01A
dim d as uinteger at $C01C
dim z as uinteger at $C01E
dim m2 as uinteger at $C020
dim p as uinteger at $C022

dim succeed as ubyte at $C02D
dim jprs as ubyte at $C02E
dim leaveattack as ubyte at $C02F
dim arma as ubyte at $C030
dim vidaj as ubyte at $C031
dim llave as ubyte at $C032
dim botiquin as ubyte at $C033
dim n as ubyte at $C034
dim vidaz as ubyte at $C035
dim vidap as ubyte at $C036
dim enemz as ubyte at $C037
dim suma as ubyte at $C038
dim sumaz as ubyte at $C039
dim gameover as ubyte at $C03A
dim piloto as ubyte at $C03B
dim jacum as ubyte at $C03C
dim stage as ubyte at $C03D
dim mvd as ubyte at $C03E
dim debug as ubyte at $C03F
dim debug2 as ubyte at $C040
dim curchar as ubyte at $C041
dim curxpos as uinteger at $C042
dim curcnt as uinteger at $C044
dim curwrong as uinteger at $C046
dim curlp as uinteger at $C048

d=$C060:z=$C070:p=$C080
debug=0:debug2=0
leaveattack=0
succeed=0

'-------------------------------------------------------------------------------

sub smsputchar(tx1 as uinteger,ty1 as uinteger,tch1 as ubyte,tat1 as ubyte,tof1 as ubyte)
  smsvpoketxof($3800+((tx1+(ty1*32))*2),tch1,tat1,tof1)
  end sub

sub smswritetext(tx1 as uinteger,ty1 as uinteger,ttx1 as uinteger,tle1 as uinteger,tat1 as ubyte,tof1 as ubyte)
  smsldirvmtxof($3800+((tx1+(ty1*32))*2),ttx1,tat1,tle1,tof1)
  end sub

sub smswritestring(tx1 as uinteger,ty1 as uinteger,tch1 as ubyte,tle1 as uinteger,tat1 as ubyte,tof1 as ubyte)
  smsfilvrmtxof($3800+((tx1+(ty1*32))*2),tch1,tat1,tle1,tof1)
  end sub

sub smswritedec(tx1 as uinteger,ty1 as uinteger,tvl as uinteger,tle1 as uinteger,tat1 as ubyte,tof1 as ubyte)
  dim txlp as uinteger at $C002:dim tylp as uinteger at $C004
  tylp=1
  for txlp=tle1 to 1 step -1
    smsdelay(20)
    smsvpoketxof($3800+((tx1+txlp-1+(ty1*32))*2),48+(int(tvl/tylp) mod 10),tat1,tof1)
    smsdelay(20)
    tylp=tylp*10
    next
  end sub

sub placepicture (tpic as uinteger)
  dim tpage1 as uinteger at $C002
  dim tadr1 as uinteger at $C004
  dim tsiz1 as uinteger at $C006
  dim tsiz2 as uinteger at $C008
  dim te0 as uinteger at $C00A
  for te0=0 to 15
    smspalettergb(te0,$000)
    next
  tpage1=int((tpic*385)/512)
  tadr1=(int((tpic*385) mod 512))*32
  tsiz1=12288:tsiz2=0
  if (tsiz1+tadr1)>16384 then
    tsiz1=16384-tadr1:tsiz2=12288-tsiz1
    poke $FFFF,tpage1+2
    smsdelay(20)
    smsldirvm($0000+tsiz1,$8000,tsiz2)
    end if
  poke $FFFF,tpage1+1
  smsdelay(20)
  smsldirvm($0000,$8000+tadr1,tsiz1)
  tpage1=int((384+(tpic*385))/512)
  tadr1=(int((384+(tpic*385)) mod 512))*32
  poke $FFFF,tpage1+1
  smsdelay(20)
  for te0=0 to 15
    smspalettergb(te0,(peek($8000+tadr1+(te0*2))*256)+peek($8000+tadr1+(te0*2)+1))
    next
  end sub

sub zombiefightdebug(tlabel as ubyte,tdelay as uinteger)
  smsputchar(0,12,tlabel,%00001001,96)
  smswritedec(0,17,leaveattack,2,%00001001,96)  
  smswritedec(0,18,arma,2,%00001001,96)  
  smswritedec(0,19,suma,2,%00001001,96)
  smswritedec(0,20,seed,5,%00001001,96)
  smswritedec(0,21,e,2,%00001001,96)
  smswritedec(0,22,vidaz,2,%00001001,96)
  smswritedec(0,23,vidap,2,%00001001,96)
  smswaitvbl(tdelay)
  end sub

'-------------------------------------------------------------------------------

smsvdp(0,%00000100):smsvdp(1,%11100000) '- smsvdp(1,$84)
smsvdp(2,$ff):smsvdp(5,$ff):smsvdp(6,$ff):smsvdp(7,$F0):smsvdp(10,$FF)
smsfilvrm($0000,0,$4000) '- replaces "clear vram"

for ee0=0 to 31
  smspalettergb(ee0,$000)
  next

smspalettergb(16,$000)
smspalettergb(17,$FFF)
smspalettergb(18,$555)
smspalettergb(19,$AAA)
smspalettergb(20,$500)
smspalettergb(21,$550)
smspalettergb(22,$A00)
smspalettergb(23,$A55)
smspalettergb(24,$AA5)
smspalettergb(25,$FF0)
smspalettergb(26,$000)
smspalettergb(27,$FFF)
smspalettergb(28,$000)
smspalettergb(29,$FFF)
smspalettergb(30,$000)
smspalettergb(31,$FFF)

'- fill text area sequence
smsfilvrmtxoford($3800,0,0,256)
smsfilvrmtxoford($3A00,0,1,128)
smsfilvrmtxof($3B00,code(" "),%00001001,384,96)

'- fill character tiles area - 64 characters, 2 bitdepth
for ee0=0 to 511
  smsvpoke ($3000+(ee0*4),peek(@typeface2bitdepth01+(ee0*2)))
  smsdelay(50)
  smsvpoke ($3001+(ee0*4),peek(@typeface2bitdepth01+1+(ee0*2)))
  smsdelay(50)
  next

'- fill character tiles area - 8 udg characters, 4 bitdepth
smsldirvm($3E00,@missandskulltiles01,64*4)

'- throwing sprites away
smsfilvrm($3F00,224,255)




'removethis
'-------------------------------------------------------------------------------
'- debug activated if buttons 1,2 and down are simultaneously pressed before title, after boot
'if ((smsjoypad1() bor smsjoypad2()) band 63) =50 then:debug=1:end if
'
'- debug activated if buttons 1,2 and up are simultaneously pressed before title, after boot
'if ((smsjoypad1() bor smsjoypad2()) band 63) =49 then:debug2=1:end if



'-------------------------------------------------------------------------------
gameloop:
gosub Titulo
gosub gamestart
gosub gameplay
goto gameloop

'-------------------------------------------------------------------------------

Titulo:

debug=0:debug2=0

smsfilvrmtxof($3B00,code(" "),%00001001,384,96)
placepicture(0)
smswritetext(4,14,@text03b,@text03bend-@text03b,%00001001,96) '- "2014,2015 KABUTO FACTORY"
smswritetext(1,18,@text03c,@text03cend-@text03c,%00001001,96) '- "ORIGINAL VERSION - MANUEL GOMEZ"
smswritetext(4,19,@text03d,@text03dend-@text03d,%00001001,96) '- "SMS VERSION - PAULO SILVA"
smswritetext(4,23,@text03e,@text03eend-@text03e,%00001001,96) '- "PRESS ANY BUTTON TO START"

jpadloop1:  '- missing pause/start for starting
if ((smsjoypad1() bor smsjoypad2()) band $30) =0 then:goto jpadloop1:end if

smsfilvrmtxof($3800,code(" "),%00001001,768,96)

smswaitvbl(20) '- missing jprs
smswritetext(1,0,@TextIntro,@TextIntroEnd-@TextIntro,%00001001,96)

jpadloop2:
if ((smsjoypad1() bor smsjoypad2()) band $30)  =0 then:goto jpadloop2:end if


'- debug cheat mode
'- debug activated if down from joysticks 1 and 2 are pressed
if (smsjoypad1() band 15)=2 and ( smsjoypad2() band 15)=2 then:debug=1:end if
'- debug activated if up from joysticks 1 and 2 are pressed
if (smsjoypad1() band 15)=1 and ( smsjoypad2() band 15)=1 then:debug2=1:debug=1:end if


smsfilvrmtxoford($3800,0,0,256)
smsfilvrmtxoford($3A00,0,1,128)

smsfilvrmtxof($3B00,code(" "),%00001001,384,96)

for ee0=0 to 15
  smspalettergb(ee0,$000)
  next

return

'-------------------------------------------------------------------------------
gamestart:
return
'-------------------------------------------------------------------------------
gameplay:

DefinirVariables:
x=5:y=10:arma=1:vidaj=10:llave=0:botiquin=0:vidaz=2:vidap=10
jprs=0:gameover=0:piloto=0:stage=1:mvd=0
leaveattack=0

if debug2=1 then '- this throws to precint, for testing romero entry
  x=8:y=14:stage=2
  end if

if gameover=0 then
  gosub RutinaPosicion
  end if

gameplayloop:
if debug<>0 then:vidaj=99:end if
if gameover=0 then:
  gosub ElegirAccion
  goto gameplayloop
  end if
if gameover=1 and piloto<>1 then:
  gosub FinalMalo
  end if

return

'-------------------------------------------------------------------------------

ElegirAccion:
checkjoystick:
jacum=(smsjoypad1() bor smsjoypad2())band 63

'debug - joystick value
if debug=1 then
  smsdelay(20)
  smswritedec(27,13,jacum,3,%00001001,96)
  smsdelay(20)
  end if

seed=seed bxor jacum

if (jacum band 15)=0 then:jprs=0:end if
if ((jacum band 8)<>0 and x<10) and jprs=0 then:x=x+1:jprs=1:mvd=1:gosub RutinaPosicion:end if '- x+ '- goto RutinaAtaques
if ((jacum band 2)<>0 and y<(10+(10*(stage-1))) ) and jprs=0 then:y=y+1:jprs=1:mvd=1:gosub RutinaPosicion:end if '- y+ '- goto RutinaAtaques
if ((jacum band 4)<>0 and x>1) and jprs=0 then:x=x-1:jprs=1:mvd=1:gosub RutinaPosicion:end if '- x- '- goto RutinaAtaques
if ((jacum band 1)<>0 and y>(1+(10*(stage-1))) ) and jprs=0 then:y=y-1:jprs=1:mvd=1:gosub RutinaPosicion:end if '- y- '- goto RutinaAtaques
if ((jacum band 16)<>0) then
  m=peek(@MapaLugaresData+(y*10)+x-11)
  if stage=1 then
    if m=5 and llave=1 then:
      gosub FinalParte1
      stage=2:y=20:x=5:gosub RutinaPosicion  '- remove this line later, stage conclusion needs some improvement - final1?
      end if '- goto final1?
    if m=6 and arma<>2 then:arma=2:gosub RutinaPosicion:end if '- goto RutinaPosiciion?
    if m=4 and arma<>3 then:arma=3:gosub RutinaPosicion:end if '- goto RutinaPosiciion?
    if m=2 and botiquin=0 then:botiquin=1:vidaj=10:gosub RutinaPosicion:end if '- goto RutinaPosiciion?
    if m=3 and llave=0 then:llave=1:gosub RutinaPosicion:end if '- goto RutinaPosiciion?
    end if
  if stage=2 then
    if m=6 and piloto=1 then:
      gameover=1:gosub RutinaPosicion  '- remove this line later, stage conclusion needs some improvement - finalbueno3?
      gosub FinalBueno
      end if '- goto finalbueno3?
    if m=5 and arma <>3 then:arma=3:gosub RutinaPosicion:end if
    if m=4 and botiquin=0 then:botiquin=1:vidaj=10:gosub RutinaPosicion:end if '- goto rutinaposicion2?
    if m=3 and piloto=0 then:
      gosub TerminalDePolicia
      'piloto=1
      gosub RutinaPosicion '- remove this line later, stage conclusion needs some improvement - terminaldepolicia3?
      end if '- goto terminaldepolicia3
    end if
  end if

return

'-------------------------------------------------------------------------------

RutinaPosicion:
displaypictureandinfo:

if mvd<>0 then:gosub RutinaAtaques:end if

m=peek(@MapaLugaresData+x+(y*10)-11)
e=peek(@MapaEnemigosData+x+(y*10)-11)
m2=m+3
if y>10 then: m2=m2+8:end if '<!-----

smsfilvrmtxof($3B00,code(" "),%00001001,384,96) '- cls lower part

'-debug
if debug=1 then
  smsputchar(3,23,code("X"),%00001001,96)
  smswritedec(5,23,x,2,%00001001,96)
  smsputchar(9,23,code("Y"),%00001001,96)
  smswritedec(11,23,y,2,%00001001,96)
  smswritedec(22,23,m,2,%00001001,96) '(@MapaLugaresData)
  smswritedec(25,23,m2,2,%00001001,96) 'pictures
  smswritedec(28,23,e,2,%00001001,96) '(@MapaEnemigosData)
  end if

if gameover=0 then

smswritetext(3,20,@TextActions,@TextActionsend-@TextActions,%00001001,96) '- actions
m=peek(@MapaLugaresData+(y*10)+x-11)
if stage=1 then:
  if m=5 and llave=1 then:
    smswritetext(5,21,@TextActionEscape,@TextActionEscapeEnd-@TextActionEscape,%00001001,96) '- A-ESCAPE!!!
    end if
  if m=6 and arma<>2 then:
    smswritetext(5,21,@TextActionTakeGun,@TextActionTakeGunEnd-@TextActionTakeGun,%00001001,96) '- A-TAKE GUN
    end if
  if m=4 and arma<>3 then:
    smswritetext(5,21,@TextActionTakeChainsaw,@TextActionTakeChainsawEnd-@TextActionTakeChainsaw,%00001001,96) '- A-TAKE CHAINSAW
    end if
  if m=2 and botiquin=0 then:
    smswritetext(5,21,@TextActionTakeMedkit,@TextActionTakeMedkitEnd-@TextActionTakeMedkit,%00001001,96) '- A-TAKE MED.KIT
    end if
  if m=3 and llave=0 then:
    smswritetext(5,21,@TextActionTakeKey,@TextActionTakeKeyEnd-@TextActionTakeKey,%00001001,96) '- A-TAKE KEY
    end if
  end if
if stage=2 then:
  if m=6 then:
    smswritetext(5,21,@TextActionEscape,@TextActionEscapeEnd-@TextActionEscape,%00001001,96) '- A-ESCAPE!!!
    end if
  if m=5 and arma<>3 then:
    smswritetext(5,21,@TextActionTakeShotgun,@TextActionTakeShotgunEnd-@TextActionTakeShotgun,%00001001,96) '- A-TAKE SHOTGUN
    end if
  if m=4 and botiquin=0 then:
    smswritetext(5,21,@TextActionTakeMedkit,@TextActionTakeMedkitEnd-@TextActionTakeMedkit,%00001001,96) '- A-TAKE MED.KIT
    end if
  if m=3 and piloto=0 then:
    smswritetext(5,21,@TextActionAskForHelp,@TextActionAskForHelpEnd-@TextActionAskForHelp,%00001001,96) '- A-ASK FOR HELP
    end if
  end if

smswritetext(25,15,@TextLife,@TextLifeend-@TextLife,%00001001,96) '- life
smswritedec(26,16,vidaj,2,%00001001,96)

smswritetext(24,19,@TextWeapon,@TextWeaponend-@TextWeapon,%00001001,96) '- weapon
if arma=1 then:
  smswritetext(25,20,@TextWeapons,8,%00001001,96)    '- Bat
  end if
if arma=2 then:
  smswritetext(25,20,@TextWeapons+8,8,%00001001,96)  '- Gun
  end if
if arma=3 and stage=1 then:
  smswritetext(23,20,@TextWeapons+16,8,%00001001,96) '- Chainsaw
  end if
if arma=3 and stage=2 then:
  smswritetext(23,20,@TextWeapons+24,8,%00001001,96) '- Shotgun
  end if

smswritetext(3,15,@TextExit,@TextExitend-@TextExit,%00001001,96) '- exit
if not ((y=1) or (y=11)) then
  smswritetext(12,15+0,@TextDirections+(10*0),10,%00001001,96) '- up-north
  end if
if not((y=10) or (y=20)) then
  smswritetext(12,15+1,@TextDirections+(10*1),10,%00001001,96) '- down-south
  end if
if x<10 then
  smswritetext(12,15+2,@TextDirections+(10*2),10,%00001001,96) '- right-east
  end if
if x>1 then
  smswritetext(12,15+3,@TextDirections+(10*3),10,%00001001,96) '- left-west
  end if

smswritetext(3,12,@TextLocation,@TextLocationend-@TextLocation,%00001001,96) '- location
smswritetext(13,12,@text02+(16*m2),16,%00001001,96)
placepicture(m2)

end if

if (vidaj<=0 or vidaj>240) and leaveattack=0 then:
  for ee0=0 to 3
    smswritetext(4,19,@TextYouredead,@TextYouredeadEnd-@TextYouredead,%00001001,96)    '- YOU'RE DEAD!
    smswaitvbl(25)
    smswritetext(4,19,@TextYouredeadEnd,@TextYouredeadEnd-@TextYouredead,%00001001,96) '- YOU'RE DEAD!
    smswaitvbl(25)
    next
  gameover=1
  end if
m=peek(@MapaLugaresData+x+(y*10)-11)

return

'-------------------------------------------------------------------------------

RutinaAtaques:

smsfilvrmtxof($3B00,code(" "),%00001001,384,96) 'cls lower part
e=peek(@MapaEnemigosData+(y*10)+x-11)

if e=3 then:
  seed=smsrnd(seed)
  e=seed mod 2 			'with mod 2 the results are 0 (no enemies) and 1 (common zombie)?
  end if

if e=1 then:
  placepicture(1)
  smswritetext(3,12,@RutinaAtaquesText01+(21*0),21,%00001001,96) '- ZOMBI ATTACKS!!!!
  vidaz=2
  end if
if e=2 and stage=1 then:
  placepicture(2)
  smswritetext(3,12,@RutinaAtaquesText01+(21*1),21,%00001001,96) '- FATHER LUCIO ATTACKS!!!!
  vidap=10
  end if
if e=2 and stage=2 then:
  placepicture(3)
  smswritetext(3,12,@RutinaAtaquesText01+(21*2),21,%00001001,96) '- UNCLE GEORGE ATTACKS!!!!
  vidap=10
  end if

leaveattack=0
mvd=0

'-debug
if debug=1 then
  zombiefightdebug(code("A"),25)
  end if

EleccionAtaque:

'-debug
if debug=1 then
  zombiefightdebug(code("B"),25)
  end if

if e=1 or e=2 then
  smswritetext(25,15,@TextLife,@TextLifeend-@TextLife,%00001001,96) '- life
  smswritedec(26,16,vidaj,2,%00001001,96)
  smswritetext(24,19,@TextWeapon,@TextWeaponend-@TextWeapon,%00001001,96) '- weapon
  if arma=1 then:
    smswritetext(25,20,@TextWeapons,8,%00001001,96)    '- Bat
    end if
  if arma=2 then:
    smswritetext(25,20,@TextWeapons+8,8,%00001001,96)  '- Gun
    end if
  if arma=3 and stage=1 then:
    smswritetext(23,20,@TextWeapons+16,8,%00001001,96) '- Chainsaw
    end if
  if arma=3 and stage=2 then:
    smswritetext(23,20,@TextWeapons+24,8,%00001001,96) '- Shotgun
    end if
  smswritetext(1,15,@TextEleccionAtaque01a,@TextEleccionAtaque01b-@TextEleccionAtaque01a,%00001001,96) '- ACTION:
  smswritetext(9,15,@TextEleccionAtaque01b,@TextEleccionAtaque01c-@TextEleccionAtaque01b,%00001001,96) '- 1-Attack
  smswritetext(9,16,@TextEleccionAtaque01c,@TextEleccionAtaque01d-@TextEleccionAtaque01c,%00001001,96) '- 2-Escape
  'smswaitvbl(100)  '????????

'-debug
if debug=1 then
  zombiefightdebug(code("C"),25)
  end if

  EleccionAtaque2:
  jacum=(smsjoypad1() bor smsjoypad2())band 63
  if (jacum band 16)<>0 then:            '- if INKEY$="1" then
    gosub TiradaJugador
    goto EleccionAtaque3 '-??????? check if this works
    end if
  if (jacum band 32)<>0 and e=1 then:    '- if INKEY$="2" AND e=1 then: 
    smswritetext(1,18,@TextLoseLifeWhenEscape,@TextLoseLifeWhenEscapeEnd-@TextLoseLifeWhenEscape,%00001001,96) '- Lose life when escape
    vidaj=vidaj-1
    'smswaitvbl(200)
    goto EleccionAtaque3
    end if
  if (jacum band 32)<>0 and e=2 then:    '- if INKEY$="2" AND e=2 then
    smswritetext(1,18,@TextLoseTwoLivesAnd,@TextLoseTwoLivesAndEnd-@TextLoseTwoLivesAnd,%00001001,96) '- Lose two lives &
    smswritetext(1,19,@TextYourWeapon,@TextYourWeaponEnd-@TextYourWeapon,%00001001,96)                 '- your weapon...
    arma=1

    vidaj=vidaj-2
    'smswaitvbl(200)
    goto EleccionAtaque3
    end if
  goto EleccionAtaque2
  EleccionAtaque3:
  end if

'-debug
if debug=1 then
  zombiefightdebug(code("D"),25)
  end if

return

'-------------------------------------------------------------------------------

TiradaJugador:
suma=0

'try other characters for testing?
smswritestring(1,15,code(" "),16,%00001001,96)
smswritestring(9,16,code(" "),9,%00001001,96)

for n=1 to arma
  seed=smsrnd(seed)
  poke d+n,(seed band 1)
  suma=suma+peek(d+n)
  next
smswritetext(1,15,@TextYouAttack,@TextYouAttackEnd-@TextYouAttack,%00001001,96) '- You attack:
if peek(d+1)=0 then
  smsputchar(12,15,$f4,%00001001,0)
  smsputchar(13,15,$f5,%00001001,0)
  smsputchar(12,16,$f6,%00001001,0)
  smsputchar(13,16,$f7,%00001001,0)
  end if
if peek(d+1)=1 then
  smsputchar(12,15,$f0,%00001001,0)
  smsputchar(13,15,$f1,%00001001,0)
  smsputchar(12,16,$f2,%00001001,0)
  smsputchar(13,16,$f3,%00001001,0)
  end if

if arma=2 then: gosub RestoTiradaJugador1:end if
if arma=3 then: gosub RestoTiradaJugador1:end if
smswritetext(4,19,@TextYouMakeDamage,@TextYouMakeDamageEnd-@TextYouMakeDamage,%00001001,96) '- You make ? damage
smsputchar(4+9,19,48+suma,%00001001,96)

'-debug
if debug=1 then
  zombiefightdebug(code("E"),50)
  end if

smswaitvbl(200)
e=peek(@MapaEnemigosData+x+(y*10)-11)
if e=1 then:vidaz=vidaz-suma:end if
if e=2 then:vidap=vidap-suma:end if
if e=1 and (vidaz<=0 or vidaz>240) then:
  smswritetext(4,19,@TextZombiEliminated,@TextZombiEliminatedEnd-@TextZombiEliminated,%00001001,96)       '- ZOMBI ELIMINATED!
  vidaz=2:leaveattack=1
  smswaitvbl(100)
  'goto RutinaPosicion
  end if
if (e=2 and stage=1) and (vidap<=0 or vidap>240) then:
  smswritetext(4,19,@TextFLucioEliminated,@TextFLucioEliminatedEnd-@TextFLucioEliminated,%00001001,96)    '- F. LUCIO ELIMINATED
  vidap=10:leaveattack=1
  smswaitvbl(100)
  'goto RutinaPosicion
  end if
if (e=2 and stage=2) and (vidap<=0 or vidap>240) then:
  smswritetext(4,19,@TextUGeorgeEliminated,@TextUGeorgeEliminatedEnd-@TextUGeorgeEliminated,%00001001,96) '- UNCLE GEORGE ELIMINATED
  vidap=10:leaveattack=1
  smswaitvbl(100)
  'goto RutinaPosicion
  end if

'-debug
if debug=1 then
  zombiefightdebug(code("F"),50)
  end if

TiradaEnemigo:
if leaveattack=0 then:
  for ee0=13 to 20
    smswritestring(0,ee0,code(" "),22,%00001001,96) '- (space...)
    next
  enemz=e		'lets try this instead of peek(@MapaEnemigosData+x+(y*10)-11)
  sumaz=0
  for n=1 to enemz
    seed=smsrnd(seed)
    poke z+n,(seed band 1)
    sumaz=sumaz+peek(z+n)
    next
  smswritetext(1,15,@TextZAttack,@TextZAttackEnd-@TextZAttack,%00001001,96) '- Z. attack:
  if peek(z+1)=0 then
    smsputchar(12,15,$f4,%00001001,0) 
    smsputchar(13,15,$f5,%00001001,0)
    smsputchar(12,16,$f6,%00001001,0)
    smsputchar(13,16,$f7,%00001001,0)
    end if
  if peek(z+1)=01 then
    smsputchar(12,15,$f0,%00001001,0)
    smsputchar(13,15,$f1,%00001001,0)
    smsputchar(12,16,$f2,%00001001,0)
    smsputchar(13,16,$f3,%00001001,0)
    end if
  if peek(@MapaEnemigosData+x+(y*10)-11)=2 then: gosub RestoTiradaZombi:end if
  smswritetext(4,19,@TextYouGotDamage,@TextYouGotDamageEnd-@TextYouGotDamage,%00001001,96) '- You got ? damage
  smsputchar(4+8,19,48+sumaz,%00001001,96)
  vidaj=vidaj-sumaz

'-debug
if debug=1 then
  zombiefightdebug(code("G"),50)
  end if

  smswaitvbl(100)
  if ( vidaj<=0 or vidaj>240) then:
    for ee0=0 to 3
      smswritetext(4,19,@TextYouredead,@TextYouredeadEnd-@TextYouredead,%00001001,96)    '- YOU'RE DEAD!
      smswaitvbl(25)
      smswritetext(4,19,@TextYouredeadEnd,@TextYouredeadEnd-@TextYouredead,%00001001,96) '- YOU'RE DEAD!
      smswaitvbl(25)
      leaveattack=1
      next
    gameover=1: '- goto Titulo '-?
    end if
  end if

'-debug
if debug=1 then
  zombiefightdebug(code("H"),50)
  end if

if leaveattack=0 then:
  goto EleccionAtaque
  end if

return

'-------------------------------------------------------------------------------

RestoTiradaJugador1:
if peek(d+2)=0 then
  smsputchar(15,15,$f4,%00001001,0)
  smsputchar(16,15,$f5,%00001001,0)
  smsputchar(15,16,$f6,%00001001,0)
  smsputchar(16,16,$f7,%00001001,0)
  end if
if peek(d+2)=1 then
  smsputchar(15,15,$f0,%00001001,0)
  smsputchar(16,15,$f1,%00001001,0)
  smsputchar(15,16,$f2,%00001001,0)
  smsputchar(16,16,$f3,%00001001,0)
  end if
if arma<>3 then: goto RestoTiradaJugador3:end if

RestoTiradaJugador2:
if peek(d+3)=0 then
  smsputchar(18,15,$f4,%00001001,0)
  smsputchar(19,15,$f5,%00001001,0)
  smsputchar(18,16,$f6,%00001001,0)
  smsputchar(19,16,$f7,%00001001,0)
  end if
if peek(d+3)=1 then
  smsputchar(18,15,$f0,%00001001,0)
  smsputchar(19,15,$f1,%00001001,0)
  smsputchar(18,16,$f2,%00001001,0)
  smsputchar(19,16,$f3,%00001001,0)
  end if

RestoTiradaJugador3:

return

'-------------------------------------------------------------------------------

RestoTiradaZombi:
if peek(d+2)=0 then
  smsputchar(15,15,$f4,%00001001,0)
  smsputchar(16,15,$f5,%00001001,0)
  smsputchar(15,16,$f6,%00001001,0)
  smsputchar(16,16,$f7,%00001001,0)
  end if
if peek(d+1)=0 then
  smsputchar(15,15,$f0,%00001001,0)
  smsputchar(16,15,$f1,%00001001,0)
  smsputchar(15,16,$f2,%00001001,0)
  smsputchar(16,16,$f3,%00001001,0)
  end if
return

'-------------------------------------------------------------------------------

DefinirVariables1:
x=5:y=10:arma=1:vidaj=10
llave=0:botiquin=0:vidaz=2:vidap=10
stage=1

if debug<>0 then:vidaj=99:end if

return

'-------------------------------------------------------------------------------

DefinirVariables2:
x=5:y=10:arma=2:vidaj=5
piloto=0:botiquin=0:vidaz=2:vidap=10
stage=2

if debug<>0 then:vidaj=99:end if

return

'-------------------------------------------------------------------------------

DispTextFinalPart01:
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextFinalPart01,@TextFinalPart01End-@TextFinalPart01,%00001001,96)
smswaitvbl(300)
return

DispTextStartPart02:
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextStartPart02,@TextStartPart02End-@TextStartPart02,%00001001,96)
smswaitvbl(300)
return

DispTextGameOver:
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextGameOver,@TextGameOverEnd-@TextGameOver,%00001001,96)
smswaitvbl(300)
return

DispTextEndingGame:
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextEndingGame,@TextEndingGameEnd-@TextEndingGame,%00001001,96)
smswaitvbl(300)
return

'-------------------------------------------------------------------------------

FinalParte1:

smswaitvbl(20) '- missing jprs
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextFinalPart01,@TextFinalPart01End-@TextFinalPart01,%00001001,96)
jpadloopfp1a:
if (smsjoypad1() bor smsjoypad2())=0 then:goto jpadloopfp1a:end if

smswaitvbl(20) '- missing jprs
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextStartPart02,@TextStartPart02End-@TextStartPart02,%00001001,96)
jpadloopfp1b:
if (smsjoypad1() bor smsjoypad2())=0 then:goto jpadloopfp1b:end if

smsfilvrmtxoford($3800,0,0,256)
smsfilvrmtxoford($3A00,0,1,128)
smsfilvrmtxof($3B00,code(" "),%00001001,384,96)

for ee0=0 to 15
  smspalettergb(ee0,$000)
  next

return

'-------------------------------------------------------------------------------

FinalBueno:

smswaitvbl(20) '- missing jprs
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextEndingGame,@TextEndingGameEnd-@TextEndingGame,%00001001,96)
jpadloopfb:
if (smsjoypad1() bor smsjoypad2())=0 then:goto jpadloopfb:end if

smsfilvrmtxoford($3800,0,0,256)
smsfilvrmtxoford($3A00,0,1,128)
smsfilvrmtxof($3B00,code(" "),%00001001,384,96)

return

'-------------------------------------------------------------------------------

FinalMalo:

smswaitvbl(20) '- missing jprs
smsfilvrmtxof($3800,code(" "),%00001001,768,96)
smswritetext(1,0,@TextGameOver,@TextGameOverEnd-@TextGameOver,%00001001,96)
jpadloopfm:
if (smsjoypad1() bor smsjoypad2())=0 then:goto jpadloopfm:end if

smsfilvrmtxoford($3800,0,0,256)
smsfilvrmtxoford($3A00,0,1,128)
smsfilvrmtxof($3B00,code(" "),%00001001,384,96)

return

'-------------------------------------------------------------------------------

TerminalDePolicia:

smsfilvrmtxof($3B00,code(" "),%00001001,384,96)
placepicture(18)

smswritetext(3,12,@TextEmergencyNetworkSystem1,@TextEmergencyNetworkSystem1End-@TextEmergencyNetworkSystem1,%00001001,96)
smswritetext(1,15,@TextEmergencyNetworkSystem2,@TextEmergencyNetworkSystem2End-@TextEmergencyNetworkSystem2,%00001001,96)

curchar=code("A")
for curxpos=p to p+11:poke curxpos,code(" "):next
curxpos=0
curcnt=0
jprs=1

checkjoystick2:
jacum=(smsjoypad1() bor smsjoypad2())band 63

'debug - joystick value
if debug=1 then
  smsdelay(20)
  smswritedec(27,13,jacum,3,%00001001,96)
  smsdelay(20)
  end if

if (jacum band 15)=0 then:jprs=0:end if
if ((jacum band 8)<>0 ) and jprs=0 then:curxpos=curxpos+1:jprs=1:end if '- x+
if ((jacum band 4)<>0 ) and jprs=0 then:curxpos=curxpos-1:jprs=1:end if '- x-
if ((jacum band 1)<>0 ) and jprs=0 then:curchar=curchar-1:jprs=1:end if '- y-
if ((jacum band 2)<>0 ) and jprs=0 then:curchar=curchar+1:jprs=1:end if '- y+
if ((jacum band 48)<>0 ) then:goto checkjoystick2af:end if

if curxpos<0 or curxpos>128 then:curxpos=11:end if
if curxpos>11 then:curxpos=0:end if
if curchar<32 then:curchar=95:end if
if curchar>95 then:curchar=32:end if

poke p+curxpos,curchar
smswritetext(10,20,p,12,%00001001,96)
if (curcnt band 16)<>0 then
  smsputchar(10+curxpos,20,code("."),%00001001,96)
  end if

smswaitvbl(1)
curcnt=curcnt+1
goto checkjoystick2
checkjoystick2af:

curwrong=0
for curlp=0 to 5
  if peek(p+curlp)<>peek(@TextPilotName+curlp) then:curwrong=1:end if
  next
if curwrong=0 then:
  piloto=1
  smswritetext(1,22,@TextEmergencyNetworkSystem3,@TextEmergencyNetworkSystem3End-@TextEmergencyNetworkSystem3,%00001001,96)
  smswaitvbl(200)
  'smsfilvrmtxof($3D80,code(" "),%00001001,64,96)
  goto TerminalDePoliciaEnd
else
  smswritetext(1,22,@TextEmergencyNetworkSystem4,@TextEmergencyNetworkSystem4End-@TextEmergencyNetworkSystem4,%00001001,96)
  smswaitvbl(200)
  'smsfilvrmtxof($3D80,code(" "),%00001001,64,96)
  goto TerminalDePoliciaEnd
  end if

'jpadlooptermp:
'if ((smsjoypad1() bor smsjoypad2()) band $30)  =0 then:goto jpadlooptermp:end if

TerminalDePoliciaEnd:

return

'-------------------------------------------------------------------------------

TextLocation:
asm
  defb "LOCATION:"
  end asm
TextLocationend:
TextExit:
asm
  defb "EXIT:"
  end asm
TextExitend:
TextActions:
asm
  defb "ACTIONS:"
  end asm
TextActionsend:
TextLife:
asm
  defb "LIFE"
  end asm
TextLifeend:

TextWeapon:
asm
  defb "WEAPON"
  end asm
TextWeaponend:

TextWeapons:
asm
  defb "BAT     "
  defb "GUN     "
  defb "CHAINSAW"
  defb "SHOTGUN "
  end asm
TextWeaponsend:

TextActionEscape:
asm
  defb "A-ESCAPE!!!"
  end asm
TextActionEscapeEnd:
TextActionTakeGun:
asm
  defb "A-TAKE GUN"
  end asm
TextActionTakeGunEnd:
TextActionTakeChainsaw:
asm
  defb "A-TAKE CHAINSAW"
  end asm
TextActionTakeChainsawEnd:
TextActionTakeShotgun:
asm
  defb "A-TAKE CHAINSAW"
  end asm
TextActionTakeShotgunEnd:
TextActionTakeMedkit:
asm
  defb "A-TAKE MED.KIT"
  end asm
TextActionTakeMedkitEnd:
TextActionTakeKey:
asm
  defb "A-TAKE KEY"
  end asm
TextActionTakeKeyEnd:
TextActionAskForHelp:
asm
  defb "A-ASK FOR HELP"
  end asm
TextActionAskForHelpEnd:

TextDirections:
asm
  defb "UP-NORTH  "
  defb "DOWN-SOUTH"
  defb "RIGHT-EAST"
  defb "LEFT-WEST "
  end asm
TextDirectionsend:

TextYouredead:
asm
  defb "YOU'RE DEAD!    "
  end asm
TextYouredeadEnd:
TextYouredeadOff:
asm
  defb "                "
  end asm
TextYouredeadOffEnd:

TextEleccionAtaque01:
TextEleccionAtaque01a:
asm
  defb "ACTION: "
  end asm
TextEleccionAtaque01b:
asm
  defb"1-ATTACK"
  end asm
TextEleccionAtaque01c:
asm
  defb "2-ESCAPE"
  end asm
TextEleccionAtaque01d:

text02:
asm
  defb "TITLE           "
  defb "ZOMBI           "
  defb "FATHER LUCIO    "
  defb "UNCLE GEORGE    "
  defb "FOREST          "
  defb "LABORATORY      "
  defb "CHURCH          "
  defb "CEMETERY        "
  defb "PIER            "
  defb "TOWN            "
  defb "BEACH           "
  defb "PATH            "
  defb "INFECTED ZONE   "
  defb "MILITARY CONTROL"
  defb "PRECINT         "
  defb "HOSPITAL        "
  defb "SHOPPING MALL   "
  defb "HELIPORT        "
  end asm

text03a:
asm
  defb "ZOMBI TERROR"
  end asm
text03aend:
text03b:
asm
  defb $5F
  defb "2014,2015 KABUTO FACTORY"
  end asm
text03bend:
text03c:
asm
  defb "ORIGINAL VERSION - MANUEL GOMEZ"
  end asm
text03cend:
text03d:
asm
  defb "SMS VERSION - PAULO SILVA"
  end asm
text03dend:
text03e:
asm
  defb "PRESS ANY BUTTON TO START"
  end asm
text03eend:

RutinaAtaquesText01:
RutinaAtaquesText01a:
asm
  defb "ZOMBI ATTACKS!!!!    "
  end asm
RutinaAtaquesText01b:
asm
  defb "FATHER LUCIO ATTACKS!"
  end asm
RutinaAtaquesText01c:
asm
  defb "UNCLE GEORGE ATTACKS!"
  end asm
RutinaAtaquesText01d:

TextZombiEliminated:
asm
  defb "ZOMBI ELIMINATED! "
  end asm
TextZombiEliminatedEnd:
TextFLucioEliminated:
asm
  defb "F. LUCIO ELIMINATED!"
  end asm
TextFLucioEliminatedEnd:
TextUGeorgeEliminated:
asm
  defb "UNCLE GEORGE ELIMINATED!"
  end asm
TextUGeorgeEliminatedEnd:



TextLoseLifeWhenEscape:
asm
  defb "LOSE LIFE WHEN ESCAPE"
  end asm
TextLoseLifeWhenEscapeEnd:

TextLoseTwoLivesAnd:
asm
  defb "Lose two lives &"
  end asm
TextLoseTwoLivesAndEnd:
TextYourWeapon:
asm
  defb "your weapon..."
  end asm
TextYourWeaponEnd:

TextYouAttack:
asm
  defb "YOU ATTACK:"
  end asm
TextYouAttackEnd:
TextYouMakeDamage:
asm
  defb "YOU MAKE ? DAMAGE"
  end asm
TextYouMakeDamageEnd:
TextZAttack:
asm
  defb "Z. ATTACK:"
  end asm
TextZAttackEnd:
TextYouGotDamage:
asm
  defb "YOU GOT ? DAMAGE"
  end asm
TextYouGotDamageEnd:

'-------------------------------------------------------------------------------

TextIntro:
asm
  defb "THE SOUND OF THE SEA AND THE    SEAGULLS WAKES YOU FROM YOUR    LETHARGY. YOU HAVE A TERRIBLE   HEADACHE AND YOU CAN'T REMEMBER WHAT HAPPENED LAST NIGHT."
  defb "                                       "
  defb "THE GULETNESS OF THE PLACE      WHERE YOU ARE IS STRANGE...     THERE'S SOMETHING WRONG         IN THE AIR."
  defb "                                                     "
  defb "YOU NEED TO ESCAPE, BUT THE     BOAT NEAR TO YOU DOESN'T START. YOU HAVE TO ENTER THE ISLAND    TO FIND THE KEY TO START THE    ENGINE..."
  defb "                                                       "
  defb "PRESS ANY BUTTON TO START..."
  end asm
TextIntroEnd:

TextFinalPart01:
asm
  defb "YOU START THE BOAT ENGINES AND  GO AWAY FROM THE ISLAND. YOU    TRY TO COMMUNICATE BY RADIO BUT THERE'S NO RESPONSE."
  defb "                                            "
  defb "REVIEWING THE MAPS AND THE      NAVIGATION BOOKS, YOU TAKE      NOTICE ON A SMALL PIECE OF      PAPER WITH ONLY ONE WORD        WRITTEN ON IT........................ROMERO."
  defb "                                                    "
  defb "END OF THE FIRST PART..."
  end asm
TextFinalPart01End:

TextStartPart02:
asm
  defb "AFTER YOUR ESCAPE FROM THE      ISLAND, YOUR BOAT IS EMPTY OF   FUEL. WITHOUT COURSE AND        SUPPLIES, YOU WANDER ALONE IN   THE SEA FOR MANY DAYS..."
  defb "                                        "
  defb "HUNGRY AND WEAK, YOU SURVIVE    TO THE VOYAGE AND REACH THE     CITY OF SAN DARIO, ONLY TO      CHECK YOUR NIGHTMARE IS NOT     OVER YET..."
  end asm
TextStartPart02End:

TextGameOver:
asm
  defb "YOU HARDLY REACH TO THE         HELICOPTER, ONLY TO TAKE CARE   THAT YOU DON'T KNOW HOW TO      PILOT IT..."
  defb "                                                     "
  defb "THE ZOMBIES GET YOU AND START   TO EAT YOU, WHILE YOU PAINFULLY FELL YOU HAVE RACHED HERE FOR   NOTHING..."
  defb "                                                      "
  defb "...PLEASE, TRY AGAIN..."
  end asm
TextGameOverEnd:

TextEndingGame:
asm
  defb "ROMERO AND YOU HARDLY REACH TO  THE HELICOPTER AND PUT THE      ENGINES ON..."
  defb "                                                   "
  defb "HOWEVER, THE PILOT SEEMS        WORRIED ABOUT THE LEVEL OF THE  FUEL: IT'S VERY LOW...          YOU ESCAPE FROM THE CITY,       BUT... WHAT WILL BE YOUR FATE?"
  defb "                                  "
  defb "THANKS TO BIENO64, IVANZX,      LASER, MODE2, NAI, OSCAR RUIZ,  RULAS INTERNATIONAL, SACRI      ESTEVEZ AND URINDIL FOR THEIR   HELP AND SUPPORT..."
  defb "                                             "
  defb "...AND YOU FOR PLAYING          ZOMBI TERROR..."
  end asm
TextEndingGameEnd:

TextPilotName:
asm
  defb "ROMERO"
  end asm
TextPilotNameEnd:

'-------------------------------------------------------------------------------

TextEmergencyNetworkSystem1:
asm
  defb "SAN DIEGO POLICE DEPARTMENT     EMERGENCY NETWORK SYSTEM"
  end asm
TextEmergencyNetworkSystem1End:

TextEmergencyNetworkSystem2:
asm
  defb "TO ASK FOR AN HELICOPTER PILOT, PLEASE INSERT HIS LAST NAME     WITH UP/DOWN AND A BUTTON, AND  PRESS START WHEN READY..."
  end asm
TextEmergencyNetworkSystem2End:

TextEmergencyNetworkSystem3:
asm
  defb "PILOT NOTIFIED. PLEASE GO TO    THE HELIPORT FOR YOUR RESCUE."
  end asm
TextEmergencyNetworkSystem3End:

TextEmergencyNetworkSystem4:
asm
  defb "PILOT DOESN'T EXIST.            PLEASE TRY AGAIN."
  end asm
TextEmergencyNetworkSystem4End:

'-------------------------------------------------------------------------------

MapaLugaresData:
MapaLugaresDataPart1:
'1-FOREST; '2-LAB; '3-CHURCH; '4-CEMETERY; '5-PIER; '6-TOWN; '7-BEACH; '8-PATH; 
asm
  defb 7,7,7,7,7,7,7,7,7,7
  defb 7,1,1,1,1,1,1,3,1,7
  defb 7,1,2,1,1,1,1,8,1,7
  defb 7,1,8,1,1,1,8,8,1,7
  defb 7,4,8,8,8,8,8,1,1,7
  defb 7,1,1,1,6,1,1,1,1,7
  defb 7,1,1,1,8,1,1,1,1,7
  defb 7,1,1,1,8,1,1,1,1,7
  defb 7,1,1,1,8,1,1,1,1,7
  defb 7,7,7,7,5,7,7,7,7,7
  end asm
MapaLugaresDataPart2:
'1-INFECTED ZONE; '2-MILITARY CONTROL; '3-PRECINT; '4-HOSPITAL; '5-SHOPPING MALL; '6-HELIPORT; 
asm
  defb 1,1,1,1,1,1,1,1,1,1
  defb 1,6,1,1,1,1,1,1,1,1
  defb 1,1,1,2,1,2,1,1,1,1
  defb 1,2,1,2,1,2,1,3,1,1
  defb 1,2,1,2,1,2,1,2,2,2
  defb 1,2,2,2,2,2,2,2,1,1
  defb 1,2,4,2,1,1,1,2,1,1
  defb 1,2,2,2,2,1,2,2,2,5
  defb 1,1,1,2,2,2,2,2,1,1
  defb 1,1,1,1,2,2,2,2,1,1
  end asm

MapaEnemigosData:
MapaEnemigosDataPart1:
asm
  defb 0,3,3,0,3,3,0,3,3,0
  defb 3,1,1,1,1,1,1,2,1,3
  defb 3,1,0,1,1,1,1,0,1,3
  defb 0,1,3,1,1,1,0,3,1,0
  defb 3,0,0,3,0,3,0,1,1,3
  defb 3,1,1,1,0,1,1,1,1,3
  defb 0,1,1,1,3,1,1,1,1,0
  defb 3,1,1,1,0,1,1,1,1,3
  defb 3,1,1,1,3,1,1,1,1,3
  defb 0,0,0,0,0,0,0,0,0,0
  end asm
MapaEnemigosDataPart2:
asm
  defb 1,1,1,1,1,1,1,1,1,1
  defb 1,2,1,1,1,1,1,1,1,1
  defb 1,1,1,3,1,3,1,1,1,1
  defb 1,3,1,3,1,3,1,2,1,1
  defb 1,0,1,3,1,3,1,3,3,3
  defb 1,3,0,0,0,0,0,0,1,1
  defb 1,3,0,3,1,1,1,3,1,1
  defb 1,3,0,3,0,1,3,0,3,0
  defb 1,1,1,0,0,0,3,3,1,1
  defb 1,1,1,1,0,3,3,3,1,1
  end asm


'-------------------------------------------------------------------------------

'useless labels to be removed?

Final:
TiradaJugador1:
TiradaJugador2:
return

'-------------------------------------------------------------------------------
'-------------------------------------------------------------------------------

