#include <stdbool.h>
#include <stdlib.h>
#include "..\SMSlib\SMSlib.h"
#include "..\PSGlib\PSGlib.h"
#include "gfx.h"
#include "music.h"

unsigned char bgy=0;
signed char bgdir=+1;

unsigned char speed=0;

#define NUM_OBJECTS 24

unsigned char objx[NUM_OBJECTS];
unsigned char objy[NUM_OBJECTS];
signed char objdirx[NUM_OBJECTS];
signed char objdiry[NUM_OBJECTS];

inline void initObjects (void) {
  unsigned char i;
  for (i=0;i<NUM_OBJECTS;i++) {
    objx[i]=rand()%256-8;

    objy[i]=rand()%32;
    if (i%2==0)
      objy[i]=192-8-objy[i];

    objdirx[i]=rand()%4;
    if (objdirx[i]>1)
      objdirx[i]--;
    else
      objdirx[i]-=2;

    objdiry[i]=rand()%4;
    if (objdiry[i]>1)
      objdiry[i]--;
    else
      objdiry[i]-=2;
  }
}

void updateObjectsX (void) {
  unsigned char i;
  for (i=0;i<NUM_OBJECTS;i++) {
    if (((objdirx[i]>0) && (objx[i]<255-8)) || ((objdirx[i]<0) && (objx[i]>1))) {
      objx[i]+=objdirx[i];
    } else {
      objdirx[i]=0-objdirx[i];
    }
  }
}

void updateObjectsY (void) {
  unsigned char i;
  for (i=0;i<NUM_OBJECTS;i++) {
    if (objy[i]<192/2) {
      if (((objdiry[i]>0) && (objy[i]<bgy+32-8)) || ((objdiry[i]<0) && (objy[i]>1)))
        objy[i]+=objdiry[i];
      else
        objdiry[i]=0-objdiry[i];
    } else {
      if (((objdiry[i]>0) && (objy[i]<192-8)) || ((objdiry[i]<0) && (objy[i]>(bgy+32+12*8))))
        objy[i]+=objdiry[i];
      else
        objdiry[i]=0-objdiry[i];
    }
  }
}

inline void updateBG (void) {
  if (++speed>2) {
    speed=0;
    if (((bgdir>0) && (bgy<32)) || ((bgdir<0) && (bgy>0)))
      bgy+=bgdir;
    else
      bgdir=0-bgdir;
  }
}

void main (void) {
  unsigned char i;
  
  initObjects();

  // load assets
  SMS_loadPSGaidencompressedTiles(maxim_tiles__psgcompr, 0);
  SMS_loadSTMcompressedTileMap(0,0,maxim_tilemap__stmcompr);
  SMS_loadBGPalette(maxim_palette__bin);
  SMS_loadSpritePalette(maxim_palette__bin);
  SMS_useFirstHalfTilesforSprites (true);
  SMS_displayOn();
  
  PSGPlay(maxim_psg);

  while(true) {
    SMS_waitForVBlank ();
    SMS_setBGScrollY (-bgy-32);
    SMS_copySpritestoSAT ();
    PSGFrame();

    // move background
    updateBG();
    
    // move objects
    updateObjectsX();
    updateObjectsY();

    // place sprites
    SMS_initSprites ();
    for (i=0;i<NUM_OBJECTS;i++)
      SMS_addSprite (objx[i], objy[i], 20);    // the snail
    SMS_finalizeSprites ();
  }
}

SMS_EMBED_SEGA_ROM_HEADER(9999,0); // code 9999 hopefully free, here this means 'homebrew'
SMS_EMBED_SDSC_HEADER(1,0, 2015,7,8, "sverx&tibone\\2015", "2015 Maxim's Birthday Speed Coding Compo",
  "Built using devkitSMS & SMSlib - https://github.com/sverx/devkitSMS\nMusic by tibone");
// you can put these anywhere, I like them at the end of main source.
// note: This makes the ROM >= 32KB even when unnecessary, like here.
