void DrawPlayerShoot(playershoot *ps)
{
	if(ps->playershoottype==PLAYERSHOOT_NORMAL)
	{
		SMS_addSprite(ps->playershootx+4,ps->playershooty,PLAYERSHOOTBASE+2);
		SMS_addSprite(ps->playershootx+4,ps->playershooty+8,PLAYERSHOOTBASE+3);
	}
	else
	{
		SMS_addSprite(ps->playershootx,ps->playershooty,PLAYERSHOOTBASE+(ps->playershoottype<<1));
		SMS_addSprite(ps->playershootx+8,ps->playershooty,PLAYERSHOOTBASE+(ps->playershoottype<<1)+1);
	}
}
		
// Load playershootsprites
void InitPlayershootSprites()
{
	LoadSprite(playershoot_psgcompr, PLAYERSHOOTBASE,playershoot_psgcompr_bank);
}

// Remove playershoot
void RemovePlayershoot(signed char a)
{
	playershoot *psa,*psb;
	
	// Remove list of sprites
	if(a<numplayershoots-1)
	{
		psa=&playershoots[a];
		psb=&playershoots[numplayershoots-1];
		
		psa->playershootx=psb->playershootx;
		psa->playershooty=psb->playershooty;
		psa->playershoottype=psb->playershoottype;
		psa->playershootvelx=psb->playershootvelx;
		psa->playershootvely=psb->playershootvely;
	}
	// Bajamos el numero de player shoots
	numplayershoots--;
}

// Update player shoot
void UpdatePlayershoot(unsigned int a)
{
	// Get player shoot
	playershoot *ps=&playershoots[a];

	// Move
	ps->playershootx+=ps->playershootvelx;
	ps->playershooty-=ps->playershootvely;

	// outside
	if((ps->playershooty<SPEEDPLAYERSHOOT_NORMAL)||(ps->playershootx<SPEEDPLAYERSHOOT_SIDE)||(ps->playershootx>240-SPEEDPLAYERSHOOT_SIDE))
		RemovePlayershoot(a);	
	else 
	// Collision
	if(CheckMapCollision(ps->playershootx+8,ps->playershooty+4))
	{
		InitExplosion(ps->playershootx,ps->playershooty,0);
		RemovePlayershoot(a);
	}
	// Draw 
	else DrawPlayerShoot(ps);
}

// Update all player shoots
void UpdatePlayershoots()
{
	// Do movement
	if(numplayershoots>0)
		for(signed char a=numplayershoots-1;a>=0;a--)
			UpdatePlayershoot(a);
}

// Create a player shoot
void InitPlayershoot(unsigned char x, unsigned char y,unsigned char t)
{
	playershoot *ps;
	
	if(numplayershoots<MAXPLAYERSHOOTS)
	{
		// Get next item
		ps=&playershoots[numplayershoots++];
		
		// Config
		ps->playershootx=x;
		ps->playershooty=y;
		ps->playershoottype=t;
		ps->playershootvelx=(t*SPEEDPLAYERSHOOT_SIDE)-SPEEDPLAYERSHOOT_SIDE;
		ps->playershootvely=(t==PLAYERSHOOT_NORMAL?SPEEDPLAYERSHOOT_NORMAL:SPEEDPLAYERSHOOT_SIDE_VERTICAL);
		
		// Sound
		//PlaySound(playershoot_psg,0);
	}		
}

void InitPlayershoots()
{
	// Playershoot sprites
	InitPlayershootSprites();
	
	// Reset counter
	numplayershoots=0;
}