#ifndef _math_H_INCLUDED
#define _math_H_INCLUDED

#define M_PI 3.14159265358979323846

typedef struct Matrix
{
	float	xu,yu,zu,dummy1;
	float	xv,yv,zv,dummy2;
	float	xw,yw,zw,dummy3;
	float	xx,yy,zz,dummy4;
} Matrix __attribute__((aligned(16)));

typedef struct Vector3d
{
	float x, y, z, w;
} Vector3d __attribute__((aligned(16)));

typedef struct Vector2d
{
	s32 x, y, z, w;
} Vector2d;

extern void math_init();

extern void math_project_vertices(Vector2d* dst, Vector3d* src, int count);
extern void math_transform_vertices(Vector3d* dst, Vector3d* src, Matrix* m, int count);

extern void math_matrix_identity(Matrix *m);
extern void math_matrix_rotatex(Matrix *m, float a);
extern void math_matrix_rotatey(Matrix *m, float a);
extern void math_matrix_rotatez(Matrix *m, float a);
extern void math_matrix_move(Matrix *m, float x, float y, float z);
extern void math_matrix_lookat(Matrix *m, Vector3d* pos, Vector3d* target);
extern void math_matrix_multiply(Matrix *dst, Matrix* a, Matrix* b);

extern void math_vector_calc_normal(Vector3d* dst, Vector3d* a, Vector3d* b, Vector3d* c);
extern void math_vector_normalize(Vector3d* dst, Vector3d* src);
extern void math_vector_mul(Vector3d* dst, Vector3d* a, Vector3d* b);
extern void math_vector_cross(Vector3d* dst, Vector3d* a, Vector3d* b);
extern float math_calc_light(Vector3d* n, Vector3d* pos, Vector3d* lightpos);

/////////////////////// Nedenstende er med tak til craft^fudge a.k.a. drckluft/soopadoopa (dvs. han har skrevet det ;)

#define __my_math_iter 20
#define math_N (32)

extern float math_sinetable[math_N][4];

inline static float sqrt(float a)
{
	float b;
	
	asm(
	"sqrt.s %0,%1\n"
	: "=f" (b)
	: "f" (a));
	
	return b;
}

// Polynomial approximation using sine table (degree 3)
inline static float sin2(float v)
{
	int i=((int)((v)*(1.0/(2*M_PI/math_N))+10000))-10000.0;
	v-=i*(2*M_PI/math_N);
	i&=math_N-1;

	return v*v*v*math_sinetable[i][3]+v*v*math_sinetable[i][2]+v*math_sinetable[i][1]+math_sinetable[i][0];
}

inline static float cos2(float v)
{
	int i=((int)((v)*(1.0/(2*M_PI/math_N))+10000))-10000.0;
	v-=i*(2*M_PI/math_N);
	i+=math_N/4;
	i&=math_N-1;

	return v*v*v*math_sinetable[i][3]+v*v*math_sinetable[i][2]+v*math_sinetable[i][1]+math_sinetable[i][0];
}

// Taylor series
inline static float cos(float v)
{
	float res,w;
	int t;
	float fac;
	int i=(v)/(2*M_PI);
	v-=i*2*M_PI;

	fac=1;
	res=0;
	w=1;
	for(t=0;t<__my_math_iter;)
	{
		res+=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
		
		res-=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
	}
	return res;
}

inline static float sin(float v)
{
	float res,w;
	int t;
	float fac;
	int i=(v)/(2*M_PI);
	v-=i*2*M_PI;

	fac=1;
	res=0;
	w=v;
	for(t=1;t<__my_math_iter;)
	{
		res+=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
		
		res-=fac*w;
		w*=v*v;
		t++;
		fac/=t;
		t++;
		fac/=t;
	}
	return res;
}

#endif

