#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <stdlib.h>
#include <loadfile.h>
#include <fileio.h>
#include "amigamod.h"
#include "misc.h"

extern void gfx_vsync();

static void* mod_ptr;
static int mod_size;

void mod_init(const char* filename)
{
	nprintf("mod_init(%s)\n",filename);
	read_file(filename,&mod_ptr,&mod_size);
	nprintf("mod_init(%s): module size = %d\n", filename, mod_size);
	SifLoadModule("rom0:LIBSD", 0, 0);
	SifLoadModule("host:amigamod.irx", 0, 0);
	amigaModInit(0);
	amigaModLoad(mod_ptr,mod_size);
}

void mod_play()
{
	nprintf("mod_play()\n");
	amigaModPlay(0);
	gfx_vsync();
	gfx_vsync();
	amigaModSetVolume(0x3fff);
}

void mod_getpos(int* order, int* row)
{
	ModInfoStruct info;

	amigaModGetInfo(&info);
	*order = info.curorder;
	*row = info.currow;
}
