#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <fileio.h>
#include <stdlib.h>

#include "gfx.h"
#include "math.h"
#include "vu.h"
#include "misc.h"

gif_env;

extern unsigned int e_particles_vu_begin  __attribute__((section(".vudata")));
extern unsigned int e_particles_vu_end  __attribute__((section(".vudata")));

#define BATCH_SIZE 82
#define NUM_BATCHES 998
#define NUM_PARTICLES  (NUM_BATCHES*BATCH_SIZE)
/*
e_particles_init(): 81836 particles/frame @ 50hz = 4091 KiloSprites/sec
e_particles_init(): 10475008 pixels/frame @ 50hz = 523 MegaPixels/sec
*/

DEFINE_BINARY_DATA(particle);
DEFINE_BINARY_DATA(particle_text);
DEFINE_BINARY_DATA(particle_text2);

static texture particle;
static texture particle_text;
static texture particle_text2;
static Vector3d emitter = {0,0,0,0};
static Vector3d gravity = {0,0,0,0};

static Vector3d* parts_pos;//[NUM_PARTICLES];
static Vector3d* parts_dir;//[NUM_PARTICLES];


static void initpart(int cnt)
{	
	parts_pos[cnt] = emitter;
	parts_dir[cnt].x = f_random()*0.02f-0.01f;
	parts_dir[cnt].y = f_random()*0.02f-0.01f;
	parts_dir[cnt].z = f_random()*0.02f-0.01f;
	parts_dir[cnt].w = -1; // decay speed >:)
	parts_pos[cnt].w = random() % (256-32) + 32;
}

static void updatepositions(Vector3d* pos, Vector3d* dir)
{
	int count = BATCH_SIZE/2;

	__asm__ __volatile__(
		"move		$8, %2\n"
		"lqc2		vf31, 0x00($8)\n"
		"move		$8, %0\n"
		"move		$9, %1\n"
		"move		$10, %3\n"
		"updatepositions.inner:\n"
		"lqc2		vf1, 0x0($8)\n"
		"lqc2		vf16, 0x0($9)\n"
		"lqc2		vf2, 0x10($8)\n"
		"lqc2		vf17, 0x10($9)\n"
		"vadd.xyzw	vf3,vf1,vf16\n"
		"vadd.xyzw	vf18, vf16, vf31\n"
		"vadd.xyzw	vf4,vf2,vf17\n"
		"vadd.xyzw	vf19, vf17, vf31\n"
		"sqc2		vf3, 0x0($8)\n"
		"sqc2		vf18, 0x0($9)\n"
		"sqc2		vf4, 0x10($8)\n"
		"sqc2		vf19, 0x10($9)\n"
		"addiu 	$8, 0x20\n"
		"addiu 	$9, 0x20\n"
		"addiu 	$10, -1\n"
		"bnez 		$10, updatepositions.inner\n"
		:: "r" (pos),"r" (dir),"r"(&gravity),"r" (count));	
}

static void updateparticles(int base)
{	
	int i;
	updatepositions(parts_pos+base,parts_dir+base);
	for(i=base; i<base+BATCH_SIZE; ++i)
	{
		if(parts_pos[i].w <= 0)
			initpart(i);
	}
}

void e_particles_init()
{
	int i;
	texture_load(&particle,binary_particle_start);
	texture_load(&particle_text,binary_particle_text_start);	
	texture_load(&particle_text2,binary_particle_text2_start);	

	nprintf("e_particles_init(): %d particles/frame @ 50hz = %d KiloSprites/sec\n", NUM_PARTICLES,(NUM_PARTICLES*50)/1000);
	nprintf("e_particles_init(): %d pixels/frame @ 50hz = %d MegaPixels/sec\n", NUM_PARTICLES*particle.width*particle.height/2,(NUM_PARTICLES*particle.width*(particle.height/2)*50)/1000000);

	parts_pos=(Vector3d*)malloc(sizeof(Vector3d)*(NUM_BATCHES*(BATCH_SIZE+2)));
	parts_dir=(Vector3d*)malloc(sizeof(Vector3d)*(NUM_BATCHES*(BATCH_SIZE+2)));

	for(i=0;i<(NUM_BATCHES*(BATCH_SIZE+2));++i)
	{
		parts_pos[i].x=parts_pos[i].y=-1000;
		parts_pos[i].z=0;
		parts_pos[i].w=8+(i%220);
		parts_dir[i].x=parts_dir[i].y=parts_dir[i].z=0;
		parts_dir[i].w=-1;
	}

	for(i=0;i<NUM_BATCHES;++i)
	{
		Vector2d *v;
		v = (Vector2d*)&parts_pos[i*(BATCH_SIZE+2)];
		v->x = VIF_CODE(VIF_NOP,0,0); 
		v->y = VIF_CODE(VIF_NOP,0,0); 
		v->z = VIF_CODE(VIF_STCYL,0,0x0404);
		v->w = VIF_CODE(VIF_UNPACK_V4_32,BATCH_SIZE,13|(1<<15));
		v = (Vector2d*)&parts_pos[i*(BATCH_SIZE+2)+BATCH_SIZE+1];
		v->x = VIF_CODE(VIF_MSCAL,0,0); 
		v->y = VIF_CODE(VIF_NOP,0,0); 
		v->z = VIF_CODE(VIF_NOP,0,0);
		v->w = VIF_CODE(VIF_NOP,0,0);
	}
	texture_allocupload(&particle);
	texture_allocupload(&particle_text);	
	texture_allocupload(&particle_text2);	
}

void e_particles_prerun()
{
}

static void drawparts(Matrix* mat, int base)
{
//	GIF_BGCOLOR = 0x00ff00;
	vu_send_vif(&parts_pos[base],BATCH_SIZE+2);
//	GIF_BGCOLOR = 0xffffff;
}

static void drawtext(texture* t, int x, int y)
{
	gif_begin(dma_list);
	gif_tag(0xe,1,0,0,0);

	gPRMODECONT(1);				// refer to prim attributes

	gPRIM(PRIM_SPRITE | PRIM_TEXTUREMAP | PRIM_NOT_PERSPECTIVE | PRIM_ALPHABLEND);
	gALPHA_1(ALPHA_BLEND_ADD);
	gPABE(0);
	gTEST_1(TEST_DEPTHTEST_ALWAYS);
	gTEX0_1(texture_TEX0(t));
	gTEX1_1(0);
	gRGBAQ(0x3f00000080808080);
	gUV(0,0);
	gXYZ2(32000+x,32000+y,0);
	gUV(t->width*16,t->height*16);
	gXYZ2(32000+t->width*2*16+x,32000+t->height*16+y,0);
	gif_send(dma_list);

}

struct Vector3d EmitterPos[]=
{
	/* T */
	{  4, -2, 0, 0 },{  4, 2, 0, 0 },
	{  5.5,  2, 0, 0 },{  3.5, 2, 0, 0 },

	/* T */
	{  1, -2, 0, 0 },{  1, 2, 0, 0 },
	{  2.5,  2, 0, 0 },{  0.5, 2, 0, 0 },

	/* C */
	{ -2.5, 2, 0, 0}, { -1.5, 1.5, 0, 0},
	{ -1.5, 1.5, 0, 0}, { -0.5, 0, 0, 0},
	{ -0.5, 0, 0, 0}, { -1.5, -1.5, 0, 0},
	{ -1.5, -1.5, 0, 0},{ -2.5, -2, 0, 0},
};

#define NUM_EPS ((sizeof(EmitterPos)/sizeof(EmitterPos[0]))/2)

int e_particles_run()
{
	static float e_particles_t = 0;
	float intensity;

	gfx_clearscreen(0);

	gif_begin(dma_list);
	gif_tag(0xe,1,0,0,0);

	gPRMODECONT(1);				// refer to prim attributes

	gPRIM(PRIM_SPRITE | PRIM_TEXTUREMAP | PRIM_NOT_PERSPECTIVE | PRIM_ALPHABLEND);
	gALPHA_1(ALPHA_BLEND_ADD);
	gPABE(0);
	gTEST_1(TEST_DEPTHTEST_ALWAYS);
	gTEX0_1(texture_TEX0(&particle));
	gTEX1_1(/*TEX1_BILINEAR*/0);
	gRGBAQ(0x3f00000080808080);

	gif_send(dma_list);

	/*emitter.x = 2 * cos(e_particles_t*1.9) + 2*sin(e_particles_t*1.4+34234);
	emitter.y = 1.4 * sin(e_particles_t*1.2+12) + 2.6 * sin(1.6*e_particles_t+12145);
	emitter.z = 2.2 * sin(0.5+e_particles_t*1.2) + 1.8 * cos(1.9*e_particles_t*1.4);
	*/
	{
		float emitter_tid = e_particles_t*2;
		float at = emitter_tid-(int)emitter_tid;
		int ep = ((int)emitter_tid) % NUM_EPS;
		emitter.x = EmitterPos[ep*2+0].x + (EmitterPos[ep*2+1].x - EmitterPos[ep*2+0].x) * at;
		emitter.y = EmitterPos[ep*2+0].y + (EmitterPos[ep*2+1].y - EmitterPos[ep*2+0].y) * at;
		emitter.z = EmitterPos[ep*2+0].z + (EmitterPos[ep*2+1].z - EmitterPos[ep*2+0].z) * at;

		emitter.x -= 1.25; // kompenser for at jeg er en klovn ;)
		emitter.y *= 1.25;
	}

	gravity.x = -0.0003*sin(e_particles_t*0.40f+1);
	gravity.y = 0.0005*cos(e_particles_t*0.34f);
	gravity.z = 0.0004*sin(e_particles_t*0.289f+245);
	gravity.w = 0;

	intensity = 21+10*cos(e_particles_t*1.634f+23);

	if(e_particles_t>15)
	{
		intensity *= (18-e_particles_t)/3.0f;
		if(intensity<0)intensity=0;
	}

	{
		int i, p;
		Matrix mat,rtmat;
		//Vector3d pos={-6,-6,-6,0},tgt={0,0,0};
		Vector3d pos={0,0,-8,0},tgt={0,0,0};
		
		math_matrix_lookat(&mat,&pos,&tgt);
		math_matrix_identity(&rtmat);
		math_matrix_rotatey(&rtmat,0.3*e_particles_t);
		math_matrix_rotatex(&rtmat,0.1*e_particles_t+12);
		//math_matrix_multiply(&mat,&rtmat,&mat);
		vu_reset();
		vu_header_begin(0);
		vu_header_add_veci(BATCH_SIZE,BATCH_SIZE/2,0,0);
		vu_header_add_u64_2(BATCH_SIZE|(1<<15UL)|(1UL<<46UL)|((u64)(PRIM_SPRITE | PRIM_TEXTUREMAP | PRIM_NOT_PERSPECTIVE | PRIM_ALPHABLEND)<<47UL)|(5UL<<60UL),(u64)GIF_RGBAQ | ((u64)GIF_UV << 4UL) | ((u64)GIF_XYZF2 << 8UL) | ((u64)GIF_UV << 12UL) | ((u64)GIF_XYZF2 << 16UL));
		vu_header_add(&mat, 4);
		vu_header_add_vecf(386.2828632246680438846623223933, 231.76971793480082633079739343595, 1000.0, 0.0);
		vu_header_add_vecf(2320.0, 2128.0, 0.0, 0.0);
		vu_header_add_vecf(particle.width,particle.height/2,0,0); // particle size
		vu_header_add_veci(0,0,0,0); // uv0
		vu_header_add_veci((particle.width-1)*16,(particle.height-1)*16,0,0); //uv1
		vu_header_add_vecf(intensity,intensity,intensity,0x80); //color
		i=vu_header_end();
		vu_header_begin(512);
		vu_header_add_veci(BATCH_SIZE,BATCH_SIZE/2,0,0);
		vu_header_add_u64_2(BATCH_SIZE|(1<<15UL)|(1UL<<46UL)|((u64)(PRIM_SPRITE | PRIM_TEXTUREMAP | PRIM_NOT_PERSPECTIVE | PRIM_ALPHABLEND)<<47UL)|(5UL<<60UL),(u64)GIF_RGBAQ | ((u64)GIF_UV << 4UL) | ((u64)GIF_XYZF2 << 8UL) | ((u64)GIF_UV << 12UL) | ((u64)GIF_XYZF2 << 16UL));
		vu_header_add(&mat, 4);
		vu_header_add_vecf(386.2828632246680438846623223933, 231.76971793480082633079739343595, 1000.0, 0.0);
		vu_header_add_vecf(2320.0, 2128.0, 0.0, 0.0);
		vu_header_add_vecf(particle.width,particle.height/2,0,0); // particle size
		vu_header_add_veci(0,0,0,0); // uv0
		vu_header_add_veci((particle.width-1)*16,(particle.height-1)*16,0,0); //uv1
		vu_header_add_vecf(intensity,intensity,intensity,0x80); //color
		vu_header_end();
		vu_dbl_buf(0, 512);
		vu_mpg(&e_particles_vu_begin,DWORD_COUNT((ADDRESS_OF(&e_particles_vu_end)-ADDRESS_OF(&e_particles_vu_begin))),0);
		vu_send();

		p=0;
		for(i=0; i<NUM_BATCHES; ++i)
		{
//			GIF_BGCOLOR = 0xff0000;
			updateparticles(p+1);
			drawparts(&mat,p);
			p+=BATCH_SIZE+2;
		}
	}

	if(e_particles_t<6){
		int y = (e_particles_t-4) * 25*16;

		if(y>0)y=0;
		drawtext(&particle_text, 0, y);
	}else if(e_particles_t<9){
		int y = particle_text.height-(e_particles_t-6) * 25*16;

		if(y>0)y=0;
		drawtext(&particle_text, 0, y);
	} else if(e_particles_t<12){
		int y = (e_particles_t-11) * 25*16;
		if(y>0)y=0;
		drawtext(&particle_text2, 0, y);
	}else if(e_particles_t<15){
		int y = particle_text2.height-(e_particles_t-12) * 25*16;

		if(y>0)y=0;
		drawtext(&particle_text2, 0, y);
	}
	e_particles_t += 1.0f / 50.0f;

	return e_particles_t<15;
}
