#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <fileio.h>
#include <stdlib.h>

#include "gfx.h"
#include "math.h"
#include "vu.h"
#include "misc.h"
#include "pad.h"

extern unsigned int e_spheremod_vu_begin  __attribute__((section(".vudata")));
extern unsigned int e_spheremod_vu_end  __attribute__((section(".vudata")));

void e_spheremod_init()
{
}

void e_spheremod_prerun()
{
}

static float e_spheremod_t=0;

int MAX_POINTS = 0;
#define XSEGS 1
#define XSEG (MAX_POINTS * XSEGS)
int YSEG = 0;
#define PACKET_START 7

static void drawSphereSegment(float phi, float dphi, float theta)
{
	static Vector2d package[5];
	Vector3d * v = (Vector3d *)&package[1];
	package[0].x = VIF_CODE(VIF_NOP,0,0); 
	package[0].y = VIF_CODE(VIF_NOP,0,0); 
	package[0].z = VIF_CODE(VIF_STCYL,0,0x0101);
	package[0].w = VIF_CODE(VIF_UNPACK_V4_32,3,PACKET_START|VIF_UNPACK_DBLBUF);
	package[4].x = VIF_CODE(VIF_NOP,0,0); 
	package[4].y = VIF_CODE(VIF_MSCAL,0,0);  
	package[4].z = VIF_CODE(VIF_NOP,0,0); 
	package[4].w = VIF_CODE(VIF_NOP,0,0); 

	v[0].x = phi;
	v[0].y = dphi;
	v[0].z = cos(theta);
	v[0].w = sin(theta);

	v[1].x = 13;
	v[1].y = 13;
	v[1].z = 13;
	v[1].w = 1;

	v[2].x = 6+sin(e_spheremod_t*1.2);
	v[2].y = 8-2*cos(e_spheremod_t*-0.4);
	v[2].z = 7+0.6*sin(2+e_spheremod_t*-0.56);
	v[2].w = e_spheremod_t*0.4;

	vu_send_vif(&package, sizeof(package)/sizeof(package[0]));

	/*while( vif_active() ) ;
	flush_cache(0);
	vu_dump_to_file();
	SleepThread();*/

}


int e_spheremod_run()
{
	int i;
	
	
	/*{
		gif_env;
		texture* tex= &benny[animpos];
		gif_begin(dma_list);
		gif_tag(0xe,1,0,0,0);
		gPRMODECONT(1);				// refer to prim attributes

		gTEX0_1(texture_TEX0(tex));
		gTEX1_1(0);
		gTEST_1(TEST_DEPTHTEST_ALWAYS);
		gPRIM(0x116+0x40);
		gRGBAQ(0x3F80000080808080);
		gUV(0,0);
		gXYZ2(32000,32000,0);
		gUV(tex->width*16,tex->height*16);
		gXYZ2(32000+640*16,32000+256*16,0);

		gALPHA_1(0);
		gif_send(dma_list);
	}
	*/
	gfx_clearscreen(0);
	gfx_set_register(GIF_ALPHA_1, ALPHA_BLEND_ADD);

	{
		Matrix viewmat,projmat, combined;
		math_matrix_identity(&viewmat);
		math_matrix_move(&viewmat,0,0,8);

		{
			Matrix rotmat;
			math_matrix_identity(&rotmat);
			math_matrix_rotatez(&rotmat, e_spheremod_t*0.2);
			math_matrix_rotatex(&rotmat, e_spheremod_t*-1.6);
			math_matrix_multiply(&viewmat,&rotmat,&viewmat);
		}

		math_matrix_project(&projmat, M_PI*0.30f, 0.1, 100.0);
		math_matrix_multiply(&combined,&viewmat,&projmat);

		{
			Matrix scalemat;
			math_matrix_identity(&scalemat);
			scalemat.xu=16.0f*1.5f;
			scalemat.yv=16.0f;
			scalemat.zw=1.0f;
			scalemat.xx=32000.0f/16.0f+320.0f;
			scalemat.yy=32000.0f/16.0f+128.0f;
			scalemat.zz=1.0f;
			math_matrix_multiply(&combined,&combined,&scalemat);
		}


		vu_reset();
		vu_dbl_buf(-1,-1);
		for(i=0;i<2;++i)
		{
			vu_header_begin(i*512);
			vu_header_add_veci(MAX_POINTS,0,0,0);
			vu_header_add_u64_2(MAX_POINTS|(1<<15UL)|(1UL<<46UL)|((u64)(PRIM_LINE_STRIP|PRIM_ANTIALIAS1)<<47UL)|(/*4UL*/2UL<<60UL),(u64)GIF_RGBAQ | ((u64)GIF_XYZF2 << 4UL)/* | ((u64)GIF_XYZF2 << 8UL) | ((u64)GIF_XYZF2 << 12UL)*/);
			vu_header_add(&combined, 4);
			vu_header_add_veci(0xA8/2,0xC9/2,0xEE/2,0x80);
			vu_header_end();		
		}
		vu_dbl_buf(0, 512);
		vu_mpg(&e_spheremod_vu_begin,DWORD_COUNT((ADDRESS_OF(&e_spheremod_vu_end)-ADDRESS_OF(&e_spheremod_vu_begin))),0);
		vu_send();
	}

	{
		float theta=-M_PI/2, phi, dtheta, dphi;
		int y, x;
		
		dtheta = M_PI/YSEG;
		dphi   = 2.0*M_PI/(XSEG-1);
		
		for(y=0; y<YSEG; y++)
		{
			phi = 0;
			for(x=0; x<XSEGS; ++x)
			{
				drawSphereSegment(phi, dphi, theta); 
				phi += dphi * MAX_POINTS;
			}
			theta += dtheta;
		}
	}
	
	e_spheremod_t += 1.0f / 50.0f;

	MAX_POINTS = 2+e_spheremod_t*e_spheremod_t*0.33;
	if(MAX_POINTS>190)MAX_POINTS=190;

	YSEG = MAX_POINTS;
	if(YSEG>190)YSEG=190;

	return (2+e_spheremod_t*e_spheremod_t*0.33)<480;
}
