#include <tamtypes.h>
#include <kernel.h>
#include <sifrpc.h>
#include <string.h>
#include <loadfile.h>

#include "pad.h"

static int pad_port = 0; // 0 -> Connector 1, 1 -> Connector 2
static int pad_slot = 0; // Always zero if not using multitap
static char pad_buf[256] __attribute__((aligned(64)));

static void waitPadReady(int port, int slot)
{
	int state;

	state = padGetState(port, slot);
	while((state != PAD_STATE_STABLE) && (state != PAD_STATE_FINDCTP1)) {
		if(state == PAD_STATE_DISCONN)
			return;
		state=padGetState(port, slot);
	}
}

void pad_init()
{
	nprintf("pad_init()\n");

	if(SifLoadModule("rom0:SIO2MAN", 0, NULL) < 0)
	{
		nprintf("pad_init(): failed to load SIO2MAN\n");
		SleepThread();
	}
	if(SifLoadModule("rom0:PADMAN", 0, NULL) < 0)
	{
		nprintf("pad_init(): failed to load PADMAN\n");
		SleepThread();
	}
	padInit(0);
	if(padPortOpen(pad_port, pad_slot, pad_buf) == 0) 
	{
		nprintf("pad_init(): padOpenPort failed\n");
		SleepThread();
	}
	waitPadReady(pad_port,pad_slot);
	padSetMainMode(pad_port, pad_slot, PAD_MMODE_DUALSHOCK, PAD_MMODE_LOCK);
	waitPadReady(pad_port,pad_slot);
	padInfoPressMode(pad_port, pad_slot);
	waitPadReady(pad_port,pad_slot);
	padEnterPressMode(pad_port, pad_slot);
	waitPadReady(pad_port,pad_slot);
	padInfoAct(pad_port, pad_slot, -1, 0);
	waitPadReady(pad_port,pad_slot);
}

void pad_get_button_state(struct padButtonStatus* button_status)
{
	int ret;
	memset(button_status,0,sizeof(struct padButtonStatus));

	ret=padGetState(pad_port, pad_slot);
	while((ret != PAD_STATE_STABLE) && (ret != PAD_STATE_FINDCTP1)) {
		if(ret==PAD_STATE_DISCONN) {
			//scr_printf("Pad(%d, %d) is disconnected\n", port, slot);
			return;
		}
		ret=padGetState(pad_port, pad_slot);
	}
	padRead(pad_port, pad_slot, button_status); // port, slot, buttons
}

u32 pad_state_from_status(struct padButtonStatus* button_status)
{
	return 0xffff ^ ((button_status->btns[0] << 8) |  button_status->btns[1]);
}
