#include "SM_CommonFXPCH.h"
#include "SM_Engine3DPCH.h"
#include <math.h>
#include "FXFilter.h"
#include "MBSTaticList.h"
#include "SM_Shader.h"
#include "SM_Matrix4X4.h"


bool      g_bFadeIn=false;
bool      g_bFadeOut=false;
float     g_fStartTime;
float     g_fDuration;
float     g_fr,g_fg,g_fb;


int SIZEWIDTH =512;  
int SIZEHEIGHT=512; 


struct RenderTargetDepth
{
  IDirect3DSurface8* m_pZStencilSurface;      
  IDirect3DSurface8* m_pBackBuffer;
  IDirect3DTexture8* m_pAsTexture;
  int                m_iDepthID;
  int                m_iRenderTargetID;
};

MBStaticList<RenderTargetDepth> g_slRTDStack;

void FilterFX::GetCurrent(IDirect3DSurface8** ppDepthStencil, IDirect3DSurface8** ppBackBuffer, 
                          IDirect3DTexture8** ppTexture, int* piDepthID, int* piRenderTarget)
{

  assert(g_slRTDStack.GetNumberElements());

  RenderTargetDepth* pRT;
  g_slRTDStack.Get(g_slRTDStack.Last(), pRT);

  if (ppDepthStencil)
  {
    *ppDepthStencil=pRT->m_pZStencilSurface;
  }

  if (ppBackBuffer)
  {
    *ppBackBuffer=pRT->m_pBackBuffer;
  }

  if (ppTexture)
  {
    *ppTexture=pRT->m_pAsTexture;
  }

  if (piDepthID)
  {
    *piDepthID=pRT->m_iDepthID;
  }

  if (piRenderTarget)
  {
    *piRenderTarget=pRT->m_iRenderTargetID;
  }

}

FilterFX* g_SceneFilter=0;
 
FilterFX::FilterFX(char const* pcName) : SM_DemoEffect(pcName)
{
  assert(!g_SceneFilter);

  m_iFakeBufferID=-1;
  m_iFakeDepthBufferID=-1;
  g_SceneFilter=this;
  m_bInterceptRender=false;
  m_bHorizontalNoise=false;
  m_bTransition=false;
  m_bWobble=false;
  m_bLens=false;  

  #ifdef _DEBUG
  m_uBackGround=0x00FF00;
  #else
  m_uBackGround=0;
  #endif
}

FilterFX::~FilterFX()
{
  Shutdown();
  g_SceneFilter=0;
}

int      FilterFX::Init(bool bRenderTarget)
{
  g_slRTDStack.Init();

  RenderTargetDepth rtd;
  SM_D3d::Device()->GetDepthStencilSurface(&rtd.m_pZStencilSurface);  
  SM_D3d::Device()->GetRenderTarget(&rtd.m_pBackBuffer);
  rtd.m_pAsTexture     =0;
  rtd.m_iDepthID       =-1;
  rtd.m_iRenderTargetID=-1;

  g_slRTDStack.InsertTail(rtd);


  
  if (bRenderTarget)
  {
    m_iFakeBufferID     =ResourceManager::CreateRenderTexture(SIZEWIDTH, SIZEHEIGHT, SM_D3d::GetCurrentMode()->d3dFormat);        
    m_iFakeDepthBufferID=ResourceManager::CreateDepthTexture(SIZEWIDTH, SIZEHEIGHT, SM_D3d::GetCurrentMode()->d3dFormat);


    if (m_iFakeBufferID==-1 || m_iFakeDepthBufferID==-1)
    {
      SM_Main::OutputError("Failed to initializa render to texture infrastructure. If your card supports this consider updating your drivers");
      return -1;
    }

  }
  return (0);
}

int      FilterFX::Shutdown()
{
  if (m_iFakeBufferID!=-1)
  {
    ResourceManager::ReleaseTexture(m_iFakeBufferID);
    m_iFakeBufferID=-1;
  }

  if (m_iFakeDepthBufferID!=-1)
  {
    ResourceManager::ReleaseTexture(m_iFakeDepthBufferID);
    m_iFakeDepthBufferID=-1;
  }

  if (g_slRTDStack.GetNumberElements())
  {
    assert(g_slRTDStack.GetNumberElements()==1);
    RenderTargetDepth* rtd;
    g_slRTDStack.Get(g_slRTDStack.First(), rtd);
    rtd->m_pBackBuffer->Release();
    if (rtd->m_pZStencilSurface) rtd->m_pZStencilSurface->Release();

    g_slRTDStack.Shutdown();
  }

  
  
  return (0);
}

int      FilterFX::Start(float fTime)
{
  return (0);
}

int      FilterFX::Stop()
{
  return (0);
}

int      FilterFX::Run(float fTime)
{
  
  return (0);
}

int      FilterFX::ParseShaderCommand(float fTime)
{
  char* pcShaderName;
  pcShaderName=strtok(0, " \t");

  ShaderManager::Shader* pShader=ShaderManager::GetShader(pcShaderName);
  if (!pShader)
  {
    return -1;
  }

  char* pcVertexShader;
  pcVertexShader=strtok(0, " \t");

  if (strcmp(pcVertexShader, "NOISE")==0)
  {
    pShader->m_pVertexShader=&TheNoiseXYZShader;

    char* pcToken;
    pcToken=strtok(0, " \t");

    char* pcTime=strtok(0, " \t");
        
    if (strcmp(pcToken, "FADEIN")==0)
    {
      TheNoiseXYZShader.m_ExpSlider.Init((float)atof(pcTime), true);
    }
    else
    {
      TheNoiseXYZShader.m_ExpSlider.Init((float)atof(pcTime), false);
    }

    TheNoiseXYZShader.m_ExpSlider.Start(fTime);

    pcToken=strtok(0, " \t");
    TheNoiseXYZShader.m_fAmplitudeX=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    TheNoiseXYZShader.m_fAmplitudeY=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    TheNoiseXYZShader.m_fAmplitudeZ=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    TheNoiseXYZShader.m_fSpaceFrequency=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    TheNoiseXYZShader.m_fTimeFrequency=(float)atof(pcToken);    
  }
  else
  if (strcmp(pcVertexShader, "NOISENORMAL")==0)
  {
    pShader->m_pVertexShader=&TheNormalNoiseShader;
  }
  else if (strcmp(pcVertexShader, "TWIST")==0)
  {
    pShader->m_pVertexShader=&TheTwistShader;
  }
  else
  {
    pShader->m_pVertexShader=0;
  }



  return 0;
}

int      FilterFX::Command           (float fTime, const char* pcCommand)
{
  char* pcToken;

  char* pcAux=new char[strlen(pcCommand)+1];
  strcpy(pcAux, pcCommand);

  pcToken=strtok(pcAux, " \t");
  if (strcmp(pcToken, "BACKGROUND")==0)
  {
    pcToken=strtok(0, " \t");
    float fr=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    float fg=(float)atof(pcToken);
    
    pcToken=strtok(0, " \t");
    float fb=(float)atof(pcToken);

    m_uBackGround=((int(fr*255.0f))<<16)|
                  ((int(fg*255.0f))<< 8)|
                  ((int(fb*255.0f))<< 0);
  }
  else if (strcmp(pcToken, "FADEIN")==0)
  { 
    pcToken=strtok(0, " \t");
    g_fDuration=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    g_fr=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    g_fg=(float)atof(pcToken);
    
    pcToken=strtok(0, " \t");
    g_fb=(float)atof(pcToken);

    g_fStartTime=fTime;

    g_bFadeIn=true;
  }
  else
  if (strcmp(pcToken, "FADEOUT")==0)
  {         
    pcToken=strtok(0, " \t");
    g_fDuration=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    g_fr=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    g_fg=(float)atof(pcToken);
    
    pcToken=strtok(0, " \t");
    g_fb=(float)atof(pcToken);

    g_fStartTime=fTime;

    g_bFadeOut=true;
  }
  else
  if (strcmp(pcToken, "BYPASS")==0)
  { 
    pcToken=strtok(0, " \t");
    if (strcmp(pcToken, "ON")==0)
    {
      m_bInterceptRender=true;
    }
    else
    {
      m_bInterceptRender=false;
    }    
  }
  else
  if (strcmp(pcToken, "NOISE")==0)
  {     
    pcToken=strtok(0, " \t");
    float fDuration=(float)atof(pcToken);

    m_HorizontalNoiseSlider.Init(fDuration);
    m_HorizontalNoiseSlider.Start(fTime);

    pcToken=strtok(0, " \t");
    m_fHorizontalAmplitude=(float)atof(pcToken);

    m_bHorizontalNoise=true;        
  }
  else if (strcmp(pcToken, "LENS")==0)
  { 
    pcToken=strtok(0, " \t");
    if (strcmp(pcToken, "OFF")==0)
    {
      m_bLens=false;        
    }
    else
    {
      if (strcmp(pcToken, "FADEIN")==0)
      {
        m_bFadeIn=true;
      }
      else 
      {
        m_bFadeIn=false;      
      }
   
      pcToken=strtok(0, " \t");
      float fDuration=(float)atof(pcToken);
    
      m_LensSlider.Init(fDuration);
      m_LensSlider.Start(fTime);

      pcToken=strtok(0, " \t");
      m_fLensStrength=(float)atof(pcToken);

      pcToken=strtok(0, " \t");
      m_fLensFrequency=(float)atof(pcToken);

      m_bLens=true;        
    }
  }
  else if (strcmp(pcToken, "BLUR")==0)
  {
    pcToken=strtok(0, " \t");    
    if (strcmp(pcToken, "FADEIN")==0)
    {
      m_bBlurFadeIn=true;
    }
    else 
    {
      m_bBlurFadeIn=false;      
    }

    pcToken=strtok(0, " \t");
    float fDuration=(float)atof(pcToken);

    pcToken=strtok(0, " \t");
    m_fBlurStrength=atof(pcToken);

    m_bBlur=true;
  
    m_BlurSlider.Init(fDuration);
    m_BlurSlider.Start(fTime); 
  }
  else if (strcmp(pcToken, "WOBBLE")==0)
  {
    m_bWobble=true;
  }
  else if (strcmp(pcToken, "TRANSITION")==0)
  {
    m_bTransition=true;
  }
  else if (strcmp(pcToken, "UNDERWATER")==0)
  {
    pcToken=strtok(0, " \t");    
    if (strcmp(pcToken, "FADEIN")==0)
    {
      m_bUnderwaterFadeIn=true;
    }
    else 
    {
      m_bUnderwaterFadeIn=false;      
    }

    pcToken=strtok(0, " \t");
    float fDuration=(float)atof(pcToken);

    m_bUnderwater=true;
  
    m_UnderwaterSlider.Init(fDuration, m_bUnderwaterFadeIn);
    m_UnderwaterSlider.Start(fTime); 

    pcToken=strtok(0, " \t");
    m_fUnderwaterFrecuency=atof(pcToken);

    pcToken=strtok(0, " \t");
    m_fUnderwaterAmplitude=atof(pcToken);    
  }
  else
  if (strcmp(pcToken, "SHADER")==0)
  {
    ParseShaderCommand(fTime);
  }

  delete[] pcAux;

  return (0);
}  

IDirect3DSurface8* g_pZStencilSurface=0;      
IDirect3DSurface8* g_pBackBuffer=0;
int FilterFX::SetRenderDepthTarget(int iRenderTarget, int iDepthBuffer)
{

  RenderTargetDepth rtd;
  SM_D3d::Device()->GetDepthStencilSurface(&rtd.m_pZStencilSurface);  
  SM_D3d::Device()->GetRenderTarget(&rtd.m_pBackBuffer);
  rtd.m_pAsTexture=ResourceManager::GetTextureFromID(iRenderTarget);
  rtd.m_iRenderTargetID=iRenderTarget;
  rtd.m_iDepthID       =iDepthBuffer;
  
  g_slRTDStack.InsertTail(rtd);
  
  if (iRenderTarget==-1)
  {
    SM_Main::OutputConsole("Render/Depth aux buffers weren't initialized");
    return (-1);
  }

  assert(iRenderTarget!=-1);
  
  IDirect3DSurface8* pTextureSurface;      
  ResourceManager::GetTextureFromID(iRenderTarget)->GetSurfaceLevel(0, &pTextureSurface);
  if (FAILED(SM_D3d::Device()->SetRenderTarget(
        pTextureSurface, 
        iDepthBuffer!=-1?ResourceManager::GetSurfaceFromID(iDepthBuffer):0)))
  {
    assert("Render target failed");
    return -1;
  }
  pTextureSurface->Release();

  Coordinates::UpdatePhysicalSize();
  return 0;
}

int FilterFX::RestoreRenderDepthTarget()
{
  RenderTargetDepth rtd;
  g_slRTDStack.Get(g_slRTDStack.Last(), rtd);
  
  SM_D3d::Device()->SetRenderTarget(rtd.m_pBackBuffer, rtd.m_pZStencilSurface);  

  rtd.m_pBackBuffer->Release();
  if (rtd.m_pZStencilSurface) rtd.m_pZStencilSurface->Release();

  g_slRTDStack.Delete(g_slRTDStack.Last());
  
  Coordinates::UpdatePhysicalSize();
  return 0;
}

void FilterFX::RunPreStartFrame  (float fTime)
{
}

void FilterFX::RunPreRender      (float fTime)
{
  if (m_bInterceptRender || m_bHorizontalNoise || m_bLens || m_bWobble || m_bBlur || m_bUnderwater || m_bTransition)
  {
    g_SceneFilter->SetRenderDepthTarget(m_iFakeBufferID, m_iFakeDepthBufferID);


    if (g_SceneFilter)
    {
      SM_D3d::Device()->Clear(0, NULL, D3DCLEAR_TARGET |D3DCLEAR_ZBUFFER, g_SceneFilter->GetBackColor(), 1.0f, 0 );
    }
    else
    {
      #ifdef _DEBUG
      SM_D3d::Device()->Clear(0, NULL, D3DCLEAR_TARGET |D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(0,int(128+127.0f*sinf(Timer::GetTime())),0), 1.0f, 0 );
      #else
      SM_D3d::Device()->Clear(0, NULL, D3DCLEAR_TARGET |D3DCLEAR_ZBUFFER, D3DCOLOR_XRGB(255,255,255), 1.0f, 0 );
      #endif
    }
  }

  Coordinates::UpdatePhysicalSize();
}

#define MAX_RES_Y 1024
void FilterFX::RenderHorizontalNoise(float fAmplitude)
{
  FVF_PosRhwDiffuseTex1 Vertices  [MAX_RES_Y*4];
  unsigned short        pIndices  [MAX_RES_Y*6];

  int i;

  float fWidth =Coordinates::PhysicalWidth();
  float fHeight=Coordinates::PhysicalHeight();
  int   iHeight=int(fHeight);


  FVF_PosRhwDiffuseTex1* pVertices=Vertices;

  float fScaleU=1.0f;
  float fScaleV=1.0f;

  float dv=1.0f/float(iHeight);
  for (i=0 ; i<iHeight ; i++)
  {    
    float fOffset=sinf(i+1.75f*float(i%2?-1:1))*fAmplitude;
    pVertices[0].x=0  -0.5f   ; pVertices[0].y=i  -0.5f; pVertices[0].z=0.0f; pVertices[0].u=0.0f   +fOffset; pVertices[0].v=i*dv; pVertices[0].oow=1.0f; pVertices[0].diffuse=0xFFFFFFFF;
    pVertices[1].x=fWidth-0.5f; pVertices[1].y=i  -0.5f; pVertices[1].z=0.0f; pVertices[1].u=fScaleU+fOffset; pVertices[1].v=i*dv; pVertices[1].oow=1.0f; pVertices[1].diffuse=0xFFFFFFFF;
    pVertices[2].x=fWidth-0.5f; pVertices[2].y=i+1-0.5f; pVertices[2].z=0.0f; pVertices[2].u=fScaleU+fOffset; pVertices[2].v=(i+1)*dv; pVertices[2].oow=1.0f; pVertices[2].diffuse=0xFFFFFFFF;
    pVertices[3].x=0  -0.5f   ; pVertices[3].y=i+1-0.5f; pVertices[3].z=0.0f; pVertices[3].u=0.0f   +fOffset; pVertices[3].v=(i+1)*dv; pVertices[3].oow=1.0f; pVertices[3].diffuse=0xFFFFFFFF;

    pVertices+=4;
  }

  unsigned uOffset=0;
  for (i=0 ; i<iHeight ; i++)
  {
    pIndices[uOffset++]=i*4+0;
    pIndices[uOffset++]=i*4+2;
    pIndices[uOffset++]=i*4+1;
    pIndices[uOffset++]=i*4+0;
    pIndices[uOffset++]=i*4+3;
    pIndices[uOffset++]=i*4+2;
  }
  

  SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP);  
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        

  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TEXTURE );
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2 , D3DTA_DIFFUSE );

  SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      iHeight*4,
      iHeight*2,
      pIndices,
      D3DFMT_INDEX16,
      Vertices, sizeof(FVF_PosRhwDiffuseTex1));
}


#define LENSTILESX  32
#define LENSTILESY  32
void FilterFX::RenderLens(float fAmplitude)
{
  // Material
  D3DMATERIAL8 Material;
  Material.Diffuse.r=Material.Diffuse.g=Material.Diffuse.b=Material.Diffuse.a=1.0f;
  Material.Ambient.r=Material.Ambient.g=Material.Ambient.b=Material.Ambient.a=1.0f;
  Material.Specular.r=Material.Specular.g=Material.Specular.b=Material.Specular.a=1.0f;
  Material.Emissive.r=Material.Emissive.g=Material.Emissive.b=Material.Emissive.a=0.0f;
  Material.Power=0.0f;
  SM_D3d::Device()->SetMaterial(&Material);


  // Render
  float fBias=0.0f;
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));  
  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  SM_D3d::SetRenderState(D3DRS_FOGENABLE, FALSE);  
  SM_D3d::SetRenderState(D3DRS_SPECULARENABLE , FALSE);
  SM_D3d::SetRenderState(D3DRS_LOCALVIEWER , FALSE);
  SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);    
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU); 
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );           
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
  SM_D3d::Device()->SetVertexShader(FVF_POSNORMALDIFFUSETEX1);                              
  SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    

  // Matrix
  Matrix4X4 m;

  float fWidth =Coordinates::PhysicalWidth();
  float fHeight=Coordinates::PhysicalHeight();
  

  float w =4.0f /fWidth;
  float h =-4.0f/fHeight;
  float dw=-2.0f;
  float dh=2.0f;

  float fFar =2.0f;
  float fNear=0.001f;

  float Q =fFar/(fFar-fNear);

  m.m_11=w             ; m.m_12=0.0f; m.m_13=0.0f         ; m.m_14=0.0f;
  m.m_21=0.0f          ; m.m_22=h   ; m.m_23=0.0f         ; m.m_24=0.0f;
  m.m_31=0.0f          ; m.m_32=0.0f; m.m_33=Q            ; m.m_34=1.0f;
  m.m_41=dw            ; m.m_42=dh  ; m.m_43=-Q*fNear     ; m.m_44=1.0f;

  SM_D3d::Device()->SetTransform(D3DTS_VIEW, (D3DMATRIX*)&Matrix4X4::Identity);    
  SM_D3d::Device()->SetTransform(D3DTS_WORLD, (D3DMATRIX*) &Matrix4X4::Identity);      
  SM_D3d::Device()->SetTransform(D3DTS_PROJECTION, (D3DMATRIX*)&m);  
  


  // Primitive
  FVF_PosNormalDiffuseTex1 Vertices  [LENSTILESX*LENSTILESY];
  unsigned short        pIndices  [(LENSTILESX-1)*(LENSTILESY-1)*6];

  
  int   iHeight=int(fHeight);


  FVF_PosNormalDiffuseTex1* pV=Vertices;

  float fScaleU=1.0f;
  float fScaleV=1.0f;

  float dx=fWidth/(LENSTILESX-1);;
  float dy=fHeight/(LENSTILESY-1);
  float du=1.0f/(LENSTILESX-1);
  float dv=1.0f/(LENSTILESY-1);
  int i,j;


  float v=0.0f;
  float y=0.0f;
  
        
  float D=fAmplitude;                  
  for (j=0 ; j<LENSTILESY ; j++)
  {    
    float u=0.0f;
    float x=0.0f;
    for (i=0 ; i<LENSTILESX ; i++)
    {
      pV[0].x=x-0.5f; pV[0].y=y-0.5f; 
      
      
      float rx=u*2.0f-1.0f;
      float ry=v*2.0f-1.0f;
      if (rx*rx+ry*ry<=1.0f)
      {
        pV[0].z=1.0f+(1.0f-(rx*rx+ry*ry))*fAmplitude;
      }
      else
      {
        pV[0].z=1.0;
      }

      pV[0].u=u;
      pV[0].v=v;    
      pV[0].diffuse=0xFFFFFFFF;    
      pV[0].nx=pV[0].ny=pV[0].nz=0.0f;
      pV++;
      u+=du;
      x+=dx;
    }    

    v+=dv;
    y+=dy;
  }

  unsigned uOffset=0;
  for (j=0 ; j<LENSTILESY-1 ; j++)
  {
    for (i=0 ; i<LENSTILESX-1 ; i++)
    {
      pIndices[uOffset++]= i   +(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j+1)*LENSTILESX;
      
    }
  }  
 
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      LENSTILESX*LENSTILESY,
      (LENSTILESX-1)*(LENSTILESY-1)*2,
      pIndices,
      D3DFMT_INDEX16,
      Vertices, sizeof(FVF_PosNormalDiffuseTex1));
}

void FilterFX::RenderWobble(float fAmplitude)
{  
  /*    
  // Material
  D3DMATERIAL8 Material;
  Material.Diffuse.r=Material.Diffuse.g=Material.Diffuse.b=Material.Diffuse.a=1.0f;
  Material.Ambient.r=Material.Ambient.g=Material.Ambient.b=Material.Ambient.a=1.0f;
  Material.Specular.r=Material.Specular.g=Material.Specular.b=Material.Specular.a=1.0f;
  Material.Emissive.r=Material.Emissive.g=Material.Emissive.b=Material.Emissive.a=0.0f;
  Material.Power=0.0f;
  SM_D3d::Device()->SetMaterial(&Material);


  // Render
  float fBias=0.0f;
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));  
  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  SM_D3d::SetRenderState(D3DRS_FOGENABLE, FALSE);  
  SM_D3d::SetRenderState(D3DRS_SPECULARENABLE , FALSE);
  SM_D3d::SetRenderState(D3DRS_LOCALVIEWER , FALSE);
  SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);    
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU); 
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );           
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
  SM_D3d::Device()->SetVertexShader(FVF_POSNORMALDIFFUSETEX1);                              
  SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    

  // Matrix
  Matrix4X4 m;

  float fWidth =Coordinates::PhysicalWidth();
  float fHeight=Coordinates::PhysicalHeight();
  

  float w =4.0f /fWidth;
  float h =-4.0f/fHeight;
  float dw=-2.0f;
  float dh=2.0f;

  float fFar =2.0f;
  float fNear=0.001f;

  float Q =fFar/(fFar-fNear);

  m.m_11=w             ; m.m_12=0.0f; m.m_13=0.0f         ; m.m_14=0.0f;
  m.m_21=0.0f          ; m.m_22=h   ; m.m_23=0.0f         ; m.m_24=0.0f;
  m.m_31=0.0f          ; m.m_32=0.0f; m.m_33=Q            ; m.m_34=1.0f;
  m.m_41=dw            ; m.m_42=dh  ; m.m_43=-Q*fNear     ; m.m_44=1.0f;

  SM_D3d::Device()->SetTransform(D3DTS_VIEW, (D3DMATRIX*)&Matrix4X4::Identity);    
  SM_D3d::Device()->SetTransform(D3DTS_WORLD, (D3DMATRIX*) &Matrix4X4::Identity);      
  SM_D3d::Device()->SetTransform(D3DTS_PROJECTION, (D3DMATRIX*)&m);  
  


  // Primitive
  FVF_PosNormalDiffuseTex1 Vertices  [LENSTILESX*LENSTILESY];
  unsigned short        pIndices  [(LENSTILESX-1)*(LENSTILESY-1)*6];

  
  int   iHeight=int(fHeight);


  FVF_PosNormalDiffuseTex1* pV=Vertices;

  float fScaleU=1.0f;
  float fScaleV=1.0f;

  float dx=fWidth/(LENSTILESX-1);;
  float dy=fHeight/(LENSTILESY-1);
  float du=1.0f/(LENSTILESX-1);
  float dv=1.0f/(LENSTILESY-1);
  int i,j;


  float v=0.0f;
  float y=0.0f;
  
        
  float D=fAmplitude;                  
  for (j=0 ; j<LENSTILESY ; j++)
  {    
    float u=0.0f;
    float x=0.0f;
    for (i=0 ; i<LENSTILESX ; i++)
    {
      pV[0].x=x-0.5f; pV[0].y=y-0.5f; 
      
      pV[0].z=0.5+0.5*sinf(Timer::GetTime()+float(i)/5.0f)*cosf(Timer::GetTime()+float(j)/5.0f); 

      
      pV[0].u=u;
      pV[0].v=v;    
      pV[0].diffuse=0xFFFFFFFF;    
      pV[0].nx=pV[0].ny=pV[0].nz=0.0f;
      pV++;
      u+=du;
      x+=dx;
    }    

    v+=dv;
    y+=dy;
  }

  unsigned uOffset=0;
  for (j=0 ; j<LENSTILESY-1 ; j++)
  {
    for (i=0 ; i<LENSTILESX-1 ; i++)
    {
      pIndices[uOffset++]= i   +(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j+1)*LENSTILESX;
      
    }
  }  
 
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      LENSTILESX*LENSTILESY,
      (LENSTILESX-1)*(LENSTILESY-1)*2,
      pIndices,
      D3DFMT_INDEX16,
      Vertices, sizeof(FVF_PosNormalDiffuseTex1));
  */

  GenerateMips();
  g_SceneFilter->RestoreRenderDepthTarget();
    // Material
  D3DMATERIAL8 Material;
  Material.Diffuse.r=Material.Diffuse.g=Material.Diffuse.b=Material.Diffuse.a=1.0f;
  Material.Ambient.r=Material.Ambient.g=Material.Ambient.b=Material.Ambient.a=1.0f;
  Material.Specular.r=Material.Specular.g=Material.Specular.b=Material.Specular.a=1.0f;
  Material.Emissive.r=Material.Emissive.g=Material.Emissive.b=Material.Emissive.a=0.0f;
  Material.Power=0.0f;
  SM_D3d::Device()->SetMaterial(&Material);


  
  // Render
  float fBias=0.0f;
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));  
  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  SM_D3d::SetRenderState(D3DRS_FOGENABLE, FALSE);  
  SM_D3d::SetRenderState(D3DRS_SPECULARENABLE , FALSE);
  SM_D3d::SetRenderState(D3DRS_LOCALVIEWER , FALSE);
  SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);    
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU); 
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );           
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);
  SM_D3d::Device()->SetVertexShader(FVF_POSNORMALDIFFUSETEX1);                              
  SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    

  // Matrix
  Matrix4X4 m;

  float fWidth =Coordinates::PhysicalWidth();
  float fHeight=Coordinates::PhysicalHeight();
  

  float w =4.0f /fWidth;
  float h =-4.0f/fHeight;
  float dw=-2.0f;
  float dh=2.0f;

  float fFar =2.0f;
  float fNear=0.001f;

  float Q =fFar/(fFar-fNear);

  m.m_11=w             ; m.m_12=0.0f; m.m_13=0.0f         ; m.m_14=0.0f;
  m.m_21=0.0f          ; m.m_22=h   ; m.m_23=0.0f         ; m.m_24=0.0f;
  m.m_31=0.0f          ; m.m_32=0.0f; m.m_33=Q            ; m.m_34=1.0f;
  m.m_41=dw            ; m.m_42=dh  ; m.m_43=-Q*fNear     ; m.m_44=1.0f;

  SM_D3d::Device()->SetTransform(D3DTS_VIEW, (D3DMATRIX*)&Matrix4X4::Identity);    
  SM_D3d::Device()->SetTransform(D3DTS_WORLD, (D3DMATRIX*) &Matrix4X4::Identity);      
  SM_D3d::Device()->SetTransform(D3DTS_PROJECTION, (D3DMATRIX*)&m);  
  


  // Primitive
  FVF_PosNormalDiffuseTex1 Vertices  [LENSTILESX*LENSTILESY];
  unsigned short        pIndices  [(LENSTILESX-1)*(LENSTILESY-1)*6];

  
  int   iHeight=int(fHeight);


  FVF_PosNormalDiffuseTex1* pV=Vertices;

  float fScaleU=1.0f;
  float fScaleV=1.0f;

  float dx=fWidth/(LENSTILESX-1);;
  float dy=fHeight/(LENSTILESY-1);
  float du=1.0f/(LENSTILESX-1);
  float dv=1.0f/(LENSTILESY-1);
  int i,j;


  float v=0.0f;
  float y=0.0f;
  

  float  fModulate=0.5f+0.5f*sinf(Timer::GetTime());
        
  float D=fAmplitude;                  
  for (j=0 ; j<LENSTILESY ; j++)
  {    
    float u=0.0f;
    float x=0.0f;
    for (i=0 ; i<LENSTILESX ; i++)
    {
      pV[0].x=x-0.5f; pV[0].y=y-0.5f; 
      
      pV[0].z=1.0f-fModulate*
          (0.5+0.5*sinf(Timer::GetTime()+float(i)/5.0f)*cosf(Timer::GetTime()+float(j)/5.0f)); 

      
      pV[0].u=u+2.5f*sinf(Timer::GetTime()+j*i)*fModulate;
      pV[0].v=v+2.5f*cosf(Timer::GetTime()+j*i)*fModulate;
      pV[0].diffuse=0xFFFFFFFF;    
      pV[0].nx=pV[0].ny=pV[0].nz=0.0f;
      pV++;
      u+=du;
      x+=dx;
    }    

    v+=dv;
    y+=dy;
  }

  unsigned uOffset=0;
  for (j=0 ; j<LENSTILESY-1 ; j++)
  {
    for (i=0 ; i<LENSTILESX-1 ; i++)
    {
      pIndices[uOffset++]= i   +(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j+1)*LENSTILESX;
      
    }
  }  
 
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      LENSTILESX*LENSTILESY,
      (LENSTILESX-1)*(LENSTILESY-1)*2,
      pIndices,
      D3DFMT_INDEX16,
      Vertices, sizeof(FVF_PosNormalDiffuseTex1));
}


void FilterFX::RenderUnderwater(float fTime, float fAmplitude)
{     
  // Material
  D3DMATERIAL8 Material;
  Material.Diffuse.r=Material.Diffuse.g=Material.Diffuse.b=Material.Diffuse.a=1.0f;
  Material.Ambient.r=Material.Ambient.g=Material.Ambient.b=Material.Ambient.a=1.0f;
  Material.Specular.r=Material.Specular.g=Material.Specular.b=Material.Specular.a=1.0f;
  Material.Emissive.r=Material.Emissive.g=Material.Emissive.b=Material.Emissive.a=0.0f;
  Material.Power=0.0f;
  SM_D3d::Device()->SetMaterial(&Material);


  // Render
  float fBias=0.0f;
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((LPDWORD) (&fBias)));  
  SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  SM_D3d::SetRenderState(D3DRS_FOGENABLE, FALSE);  
  SM_D3d::SetRenderState(D3DRS_SPECULARENABLE , FALSE);
  SM_D3d::SetRenderState(D3DRS_LOCALVIEWER , FALSE);
  SM_D3d::SetRenderState(D3DRS_LIGHTING, FALSE);    
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXCOORDINDEX, D3DTSS_TCI_PASSTHRU); 
  SM_D3d::SetTextureStageState( 0, D3DTSS_TEXTURETRANSFORMFLAGS, D3DTTFF_DISABLE );           
  SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1, D3DTA_TEXTURE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2, D3DTA_DIFFUSE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_WRAP);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
  SM_D3d::Device()->SetVertexShader(FVF_POSNORMALDIFFUSETEX1);                              
  SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    

  // Matrix
  Matrix4X4 m;

  float fWidth =Coordinates::PhysicalWidth();
  float fHeight=Coordinates::PhysicalHeight();
  

  float w =4.0f /fWidth;
  float h =-4.0f/fHeight;
  float dw=-2.0f;
  float dh=2.0f;

  float fFar =2.0f;
  float fNear=0.001f;

  float Q =fFar/(fFar-fNear);

  m.m_11=w             ; m.m_12=0.0f; m.m_13=0.0f         ; m.m_14=0.0f;
  m.m_21=0.0f          ; m.m_22=h   ; m.m_23=0.0f         ; m.m_24=0.0f;
  m.m_31=0.0f          ; m.m_32=0.0f; m.m_33=Q            ; m.m_34=1.0f;
  m.m_41=dw            ; m.m_42=dh  ; m.m_43=-Q*fNear     ; m.m_44=1.0f;

  SM_D3d::Device()->SetTransform(D3DTS_VIEW, (D3DMATRIX*)&Matrix4X4::Identity);    
  SM_D3d::Device()->SetTransform(D3DTS_WORLD, (D3DMATRIX*) &Matrix4X4::Identity);      
  SM_D3d::Device()->SetTransform(D3DTS_PROJECTION, (D3DMATRIX*)&m);  
  


  // Primitive
  FVF_PosNormalDiffuseTex1 Vertices  [LENSTILESX*LENSTILESY];
  unsigned short        pIndices  [(LENSTILESX-1)*(LENSTILESY-1)*6];

  
  int   iHeight=int(fHeight);


  FVF_PosNormalDiffuseTex1* pV=Vertices;

  float fScaleU=1.0f;
  float fScaleV=1.0f;

  float dx=fWidth/(LENSTILESX-1);;
  float dy=fHeight/(LENSTILESY-1);
  float du=1.0f/(LENSTILESX-1);
  float dv=1.0f/(LENSTILESY-1);
  int i,j;


  float v=0.0f;
  float y=0.0f;
  
        
  float D=fAmplitude;                  
  for (j=0 ; j<LENSTILESY ; j++)
  {    
    float u=0.0f;
    float x=0.0f;
    for (i=0 ; i<LENSTILESX ; i++)
    {
      pV[0].x=x-0.5f; pV[0].y=y-0.5f;       
      pV[0].z=1.0f;       

      if (i==0 || i==LENSTILESX-1)
      {
        pV[0].u=u;
      }
      else
      {
        pV[0].u=u+fAmplitude*sinf(fTime+j*i);
      }

      if (j==0 || j==LENSTILESY-1)
      {
        pV[0].v=v;
      }
      else
      {
        pV[0].v=v+fAmplitude*cosf(fTime+j*i);
      }
      
      
      pV[0].diffuse=0xFFFFFFFF;    
      pV[0].nx=pV[0].ny=pV[0].nz=0.0f;
      pV++;
      u+=du;
      x+=dx;
    }    

    v+=dv;
    y+=dy;
  }

  unsigned uOffset=0;
  for (j=0 ; j<LENSTILESY-1 ; j++)
  {
    for (i=0 ; i<LENSTILESX-1 ; i++)
    {
      pIndices[uOffset++]= i   +(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j  )*LENSTILESX;
      pIndices[uOffset++]=(i  )+(j+1)*LENSTILESX;
      pIndices[uOffset++]=(i+1)+(j+1)*LENSTILESX;
      
    }
  }  
 
  SM_D3d::Device()->DrawIndexedPrimitiveUP(
      D3DPT_TRIANGLELIST, 
      0,
      LENSTILESX*LENSTILESY,
      (LENSTILESX-1)*(LENSTILESY-1)*2,
      pIndices,
      D3DFMT_INDEX16,
      Vertices, sizeof(FVF_PosNormalDiffuseTex1));
}



void FilterFX::GenerateMips()
{
  LPDIRECT3DTEXTURE8 pTexture;
  HRESULT            hres;

  pTexture=ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID);
  
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);
  SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
  SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP);
  SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP);  
  SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        

  SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_POINT);    

  SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_MODULATE);
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TEXTURE );
  SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2 , D3DTA_DIFFUSE );

  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
  SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_DIFFUSE );


  FVF_PosRhwDiffuseTex1 pVertices[4];
  unsigned short        pIndices[6]={0,2,1,0,3,2};

  pVertices[0].x=0.0f-0.5f ; pVertices[0].y=0.0f-0.5f; pVertices[0].z=0.0f; pVertices[0].u=0.0f; pVertices[0].v=0.0f; pVertices[0].oow=1.0f; pVertices[0].diffuse=0xFFFFFFFF;
  pVertices[1].x=0.0f-0.5f ; pVertices[1].y=0.0f-0.5f; pVertices[1].z=0.0f; pVertices[1].u=1.0f; pVertices[1].v=0.0f; pVertices[1].oow=1.0f; pVertices[1].diffuse=0x00FFFFFF;
  pVertices[2].x=0.0f-0.5f ; pVertices[2].y=0.0f-0.5f; pVertices[2].z=0.0f; pVertices[2].u=1.0f; pVertices[2].v=1.0f; pVertices[2].oow=1.0f; pVertices[2].diffuse=0xFFFFFFFF;
  pVertices[3].x=0.0f-0.5f ; pVertices[3].y=0.0f-0.5f; pVertices[3].z=0.0f; pVertices[3].u=0.0f; pVertices[3].v=1.0f; pVertices[3].oow=1.0f; pVertices[3].diffuse=0x00FFFFFF;
  
  unsigned i;  
  unsigned uLevels=pTexture->GetLevelCount();
  for (i=1 ; i<uLevels ; i++)
  {
    IDirect3DSurface8* pMip;
    pTexture->GetSurfaceLevel(i, &pMip);
    hres=SM_D3d::Device()->SetRenderTarget(pMip, 0);    
    hres=SM_D3d::Device()->SetTexture(0, pTexture);    
    hres=SM_D3d::SetTextureStageState(0, D3DTSS_MAXMIPLEVEL, i-1);

    D3DSURFACE_DESC dd;
    pMip->GetDesc(&dd);

    pVertices[1].x=dd.Width-0.5f;
    pVertices[2].x=dd.Width-0.5f;
    pVertices[2].y=dd.Height-0.5f;
    pVertices[3].y=dd.Height-0.5f;

    SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1));
    
    pMip->Release();
  }

  SM_D3d::SetTextureStageState(0, D3DTSS_MAXMIPLEVEL, 0);


}

void FilterFX::RunPostRender     (float fTime)
{
  

  if (m_bHorizontalNoise)
  {
    g_SceneFilter->RestoreRenderDepthTarget();

    if (!m_HorizontalNoiseSlider.GetValue(fTime, &fTime))
    {
      m_bHorizontalNoise=false;
    }

    RenderHorizontalNoise((1.0f-fTime)*m_fHorizontalAmplitude);
  }
  else if (m_bWobble)
  {
    

    RenderWobble(fTime);
  }
  else if (m_bTransition)
  {
  }
  else if (m_bUnderwater)
  {
    g_SceneFilter->RestoreRenderDepthTarget();

    

    float fOffset;
    if (!m_UnderwaterSlider.GetValue(fTime, &fOffset) && m_UnderwaterSlider.m_fLength)
    {
      m_bUnderwater=false;
    }

    RenderUnderwater(      
        fTime*m_fUnderwaterFrecuency,
        m_fUnderwaterAmplitude*(m_bFadeIn?(1.0f-fOffset):(fOffset)));    
  }
  else if (m_bLens)
  {
    g_SceneFilter->RestoreRenderDepthTarget();


    float fOffset;
    if (!m_LensSlider.GetValue(fTime, &fOffset) )
    {
      m_bLens=false;
    }

    RenderLens(
      (m_bFadeIn?sinf(fOffset*m_fLensFrequency):cosf(fOffset*m_fLensFrequency))*
        m_fLensStrength*(m_bFadeIn?(1.0f-fOffset):(fOffset)));
  }
  else
  if (m_bInterceptRender || m_bBlur)
  {

    if (m_bBlur)
    {
      GenerateMips();
    }

    g_SceneFilter->RestoreRenderDepthTarget();

    FVF_PosRhwDiffuseTex1 pVertices[4];
    unsigned short        pIndices[6]={0,2,1,0,3,2};


    SM_D3d::Device()->SetTexture(0, ResourceManager::GetTextureFromID(g_SceneFilter->m_iFakeBufferID));    


 
    float fScaleU=1.0f;
    float fScaleV=1.0f;    

    float fWidth =Coordinates::PhysicalWidth();
    float fHeight=Coordinates::PhysicalHeight();

    
    float fScale  =1.0f+0.0f*sinf(fTime);

    pVertices[0].x=0.0f  ; pVertices[0].y=0.0f   ; pVertices[0].z=0.0f; pVertices[0].u=0.0f; pVertices[0].v=0.0f; pVertices[0].oow=1.0f; pVertices[0].diffuse=0xFFFFFFFF;
    pVertices[1].x=fWidth; pVertices[1].y=0.0f   ; pVertices[1].z=0.0f; pVertices[1].u=fScaleU; pVertices[1].v=0.0f; pVertices[1].oow=1.0f; pVertices[1].diffuse=0x00FFFFFF;
    pVertices[2].x=fWidth; pVertices[2].y=fHeight; pVertices[2].z=0.0f; pVertices[2].u=fScaleU; pVertices[2].v=fScaleV; pVertices[2].oow=1.0f; pVertices[2].diffuse=0xFFFFFFFF;
    pVertices[3].x=0.0f  ; pVertices[3].y=fHeight; pVertices[3].z=0.0f; pVertices[3].u=0.0f; pVertices[3].v=fScaleV; pVertices[3].oow=1.0f; pVertices[3].diffuse=0x00FFFFFF;

    SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
    SM_D3d::SetTextureStageState(0, D3DTSS_MAGFILTER, D3DTEXF_LINEAR);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MINFILTER, D3DTEXF_LINEAR);  
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_NONE);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSU, D3DTADDRESS_CLAMP);
    SM_D3d::SetTextureStageState(0, D3DTSS_ADDRESSV, D3DTADDRESS_CLAMP);  
    SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, FALSE);                        


    float fMip=-1.0f;

    if (m_bBlur)
    {
      float fBlur;
      if (!m_BlurSlider.GetValue(fTime, &fBlur))
      {
        m_bBlur=false;
      }

      fMip+=(m_bBlurFadeIn?(1.0f-m_fBlurStrength*fBlur):m_fBlurStrength*fBlur)*(9.0f);

    }
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPFILTER, D3DTEXF_LINEAR);    
    SM_D3d::SetTextureStageState(0, D3DTSS_MIPMAPLODBIAS, *((DWORD*) &fMip));
 
    SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_MODULATE);
    SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TEXTURE );
    SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG2 , D3DTA_DIFFUSE );

    SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
    SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_DIFFUSE );


    SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1));
  }  


  bool bPaint=false;
  unsigned uColor;

  if (g_bFadeIn || g_bFadeOut)
  {
    
    float fFade=min(1.0f, (fTime-g_fStartTime)/g_fDuration);
    if (fFade>=1.0f)
    {
      g_bFadeIn=false;
      g_bFadeOut=false;
    }
    else
    {
      bPaint=true;

      float a=g_bFadeIn?(1.0f-fFade):fFade;

      uColor=(int(255.0f*a   )<<24) |
             (int(255.0f*g_fr)<<16) |
             (int(255.0f*g_fg)<< 8) |
             (int(255.0f*g_fb)<< 0);

    }        
  }

  if (bPaint)
  {
    FVF_PosRhwDiffuseTex1 pVertices[4];
    unsigned short        pIndices[6]={0,1,2,1,2,3};


    pVertices[0].x=0.0f  ; pVertices[0].y=0.0f; pVertices[0].oow=pVertices[0].z=1.0f; pVertices[0].u=pVertices[0].v=0.0f; pVertices[0].diffuse=0xFFFFFFFF;
    pVertices[1].x=Coordinates::PhysicalWidth(); pVertices[1].y=0.0f; pVertices[1].oow=pVertices[1].z=1.0f; pVertices[1].u=pVertices[1].v=0.0f; pVertices[1].diffuse=0xFFFFFFFF;
    pVertices[2].x=0.0f; pVertices[2].y=Coordinates::PhysicalHeight(); pVertices[2].oow=pVertices[2].z=1.0f; pVertices[2].u=pVertices[2].v=0.0f; pVertices[2].diffuse=0xFFFFFFFF;
    pVertices[3].x=Coordinates::PhysicalWidth(); pVertices[3].y=Coordinates::PhysicalHeight(); pVertices[3].oow=pVertices[3].z=1.0f; pVertices[3].u=pVertices[3].v=0.0f; pVertices[3].diffuse=0xFFFFFFFF;

  
    SM_D3d::SetRenderState(D3DRS_ZENABLE, D3DZB_FALSE);  
    SM_D3d::SetRenderState(D3DRS_ALPHABLENDENABLE, TRUE);
    SM_D3d::SetRenderState(D3DRS_FILLMODE, D3DFILL_SOLID);
    SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_ALWAYS);
    SM_D3d::SetRenderState(D3DRS_ZWRITEENABLE, D3DZB_FALSE);
    SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
    SM_D3d::SetTextureStageState(0, D3DTSS_COLOROP   , D3DTOP_SELECTARG1);
    SM_D3d::SetTextureStageState(0, D3DTSS_COLORARG1 , D3DTA_TFACTOR);
    SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAOP   , D3DTOP_SELECTARG1);
    SM_D3d::SetTextureStageState(0, D3DTSS_ALPHAARG1 , D3DTA_TFACTOR);
    SM_D3d::SetRenderState(D3DRS_SRCBLEND, D3DBLEND_SRCALPHA);
    SM_D3d::SetRenderState(D3DRS_DESTBLEND, D3DBLEND_INVSRCALPHA);
    SM_D3d::SetRenderState(D3DRS_TEXTUREFACTOR, uColor);
  

    SM_D3d::SetRenderState(D3DRS_CULLMODE,D3DCULL_NONE );    
    SM_D3d::Device()->SetVertexShader(FVF_POSRHWDIFFUSETEX1);
  
  
    SM_D3d::Device()->DrawIndexedPrimitiveUP(
        D3DPT_TRIANGLELIST, 
        0,
        6,
        2,
        pIndices,
        D3DFMT_INDEX16,
        pVertices, sizeof(FVF_PosRhwDiffuseTex1)); 


    SM_D3d::SetRenderState(D3DRS_ZFUNC, D3DCMP_LESSEQUAL);
    SM_D3d::SetRenderState(D3DRS_ZENABLE, D3DZB_TRUE);
    SM_D3d::SetRenderState(D3DRS_COLORWRITEENABLE, 0xF);          
  }


}

void FilterFX::RunPostEndFrame   (float fTime)
{
}

unsigned  FilterFX::GetBackColor()
{
  return m_uBackGround;
}





DEFINE_EFFECT(FilterFX)
FilterFX Efecto00("FILTER");
