#include "SM_CommonFXPCH.h"
#include "SM_DemoEffect.h"
#include "MSurface.h"
#include "SM_Screen.h"
#include "SM_Main.h"
#include "MSystemFunctions.h"

/*
class StillFX : public SM_DemoEffect
{
public:              
  StillFX(char const* pcName) : SM_DemoEffect(pcName)
  {
  }

  virtual          ~StillFX()
  {
  }

  int      Init()
  {
    return (0);
  }

  int      Shutdown()
  {
    return (0);
  }

  int      Start(float fTime)
  {
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Run(float fTime)
  {
    return (0);
  }

  int      Command           (float fTime, const char* pcCommand)
  {
    return (0);
  }  
};*/

class StillFX : public SM_DemoEffect
{
public:              
  StillFX(char const* pcName) : SM_DemoEffect(pcName)
  {    
    m_fFrameTime=1.0f;
    m_piImages=0;
    m_pfPositions=0;
    m_iImages=0;

    m_bFadeIn=false;
    m_bFadeOut=false;
    m_fStartTime=0.0f;
    m_fDuration=0.0f;    
  }

  virtual          ~StillFX()
  {
  }

  int      Init()
  {
    
    return (0);
  }

  int      Shutdown()
  {
    m_iImages=0;
    if (m_piImages) { delete[] m_piImages; m_piImages=0; }
    if (m_pfPositions) { delete[] m_pfPositions; m_pfPositions=0; }
    
    return (0);
  }

  int      Start(float fTime)
  {
    m_fStartTime=fTime;
    return (0);
  }

  int      Stop()
  {
    return (0);
  }

  int      Run(float fTime)
  {
    if (m_bLoaded)
    {
      float fAnimTime=fTime-m_fStartTime;

      int iFrame;
      if (m_iImages!=0)
      {
        iFrame=(int(fAnimTime/m_fFrameTime))%m_iImages;
      }
      else
      {
        iFrame=0;
      }

    
      if (m_piImages)
      {
        if (m_piImages[iFrame]!=-1)
        {
          bool bPaint=false;
          unsigned uColor;
          float fAlpha;

          if (m_bFadeIn || m_bFadeOut)
          {
            float fFade;

            if (!m_fDuration)
            {
              fFade=1.0f;
            }
            else
            {
              fFade=(fTime-m_fFadeStartTime)/m_fDuration;
            }

            
            if (fFade>=1.0f)
            {
              fFade=1.0f;                            
            }


            bPaint=true;

            fAlpha=m_bFadeIn?(1.0f-fFade):fFade;                                

            uColor=(int(255.0f*fAlpha)<<24) | 0xFFFFFF;
          }

          if (fAlpha==1.0f) uColor=0xFFFFFFFF;

          if (fAlpha)
          {
            ScreenManager::Render(m_piImages[iFrame], m_pfPositions[iFrame*2], m_pfPositions[iFrame*2+1], 1, 1, m_Blend, bPaint?uColor:0xFFFFFFFF);      
          }
        }
      }
    }
    return (1);
  }

  int      Command           (float fTime, const char* pcCommand)
  {
    SM_DemoEffect::Command(fTime, pcCommand);
    char  pcPath[256];
    char* pcCopy =0;
    char* pcToken;
    int   iReturn=-1;
    

    pcCopy=new char[strlen(pcCommand)+1];
    strcpy(pcCopy, pcCommand);

    pcToken=strtok(pcCopy, " \t");

    if (strcmp(pcToken, "LOAD")==0)
    {
      Shutdown();
      pcToken=strtok(0, " \t");
      
      m_iImages=atoi(pcToken);
      m_piImages=new int[m_iImages];
      m_pfPositions=new float[m_iImages*2];

      pcToken=strtok(0, " \t");
      m_fFrameTime=atof(pcToken);

      
            
      int i;
      for (i=0 ; i<m_iImages ; i++)
      {      
        m_pfPositions[i*2  ]=0.0f;
        m_pfPositions[i*2+1]=0.0f;

        pcToken=strtok(0, " \t");

        if (!pcToken)
        { 
          SM_Main::OutputError("Numero de ficheros es menor que el numero de imagenes que has puesto: %s", pcCommand);
        }
      

        strcpy(pcPath, "data/images/");

        char pcAux[256];
        MExtractBasename(pcAux, pcToken);
        strcat(pcPath, pcAux);    

        if (strcmp(pcToken, "_")==0)        
        {
          m_piImages[i]=-1;
        }
        else
        {
          if ( (m_piImages[i]=ScreenManager::LoadImagen(pcPath))==-1)
          {
            SM_Main::OutputError("Error loading %s", pcPath);
            goto EXIT;
          }
        }
      }    

      m_bLoaded= true;

    }
    else if (strcmp(pcToken, "POSITION")==0)
    {
      int iFrame;

      if (m_pfPositions)
      {
        pcToken=strtok(0, " \t");
        iFrame=atoi(pcToken);

        if (iFrame<0 || iFrame>=m_iImages)
        {
          SM_Main::OutputError("Estas pasando un frame fuera de rango: %s", pcCommand);
        }

        pcToken=strtok(0, " \t");
        m_pfPositions[iFrame*2]=atof(pcToken);

        pcToken=strtok(0, " \t");
        m_pfPositions[iFrame*2+1]=atof(pcToken);
      }
    }
    else if (strcmp(pcToken, "POSITIONALL")==0)
    {
      if (m_pfPositions)
      {
        pcToken=strtok(0, " \t");
        float fPosX=atof(pcToken);

        pcToken=strtok(0, " \t");
        float fPosY=atof(pcToken);

        int i;
        for (i=0 ; i<m_iImages ; i++)
        {
          m_pfPositions[i*2]  =fPosX;
          m_pfPositions[i*2+1]=fPosY;
        }
      }
    }
    else if (strcmp(pcToken, "BLEND")==0)
    {
      pcToken=strtok(0, " \t");
      if (strcmp(pcToken,"ADDITIVE")==0)
      {
        m_Blend=ScreenManager::E_ADDITIVE;
      }
      else
      {
        m_Blend=ScreenManager::E_NORMAL;
      }
    }
    if (strcmp(pcToken, "FADEIN")==0)
    { 
      pcToken=strtok(0, " \t");
      m_fDuration=(float)atof(pcToken);
      
      m_fFadeStartTime=fTime;

      m_bFadeOut=true;
      m_bFadeIn=false;
    }
    else
    if (strcmp(pcToken, "FADEOUT")==0)
    {         
      pcToken=strtok(0, " \t");
      m_fDuration=(float)atof(pcToken);

      
      m_fFadeStartTime=fTime;

      m_bFadeIn=true;
      m_bFadeOut=false;
    }
    
    iReturn  = 0;

    
EXIT:
    if (pcCopy) { delete[] pcCopy; pcCopy=0; }
    return iReturn;


    
    return (0);
  }  

protected:  
  bool                  m_bLoaded;
  ScreenManager::eBlend m_Blend;
  int*                  m_piImages;
  float*                m_pfPositions;
  int                   m_iImages;
  float                 m_fFrameTime;
  float                 m_fStartTime;

  bool                  m_bFadeIn;
  bool                  m_bFadeOut;
  float                 m_fFadeStartTime;
  float                 m_fDuration; 
};

DEFINE_EFFECT(StillFX)

StillFX Efecto00("IMAGE_00");
StillFX Efecto01("IMAGE_01");
StillFX Efecto02("IMAGE_02");
StillFX Efecto03("IMAGE_03");
StillFX Efecto04("IMAGE_04");
StillFX Efecto05("IMAGE_05");
StillFX Efecto06("IMAGE_06");
StillFX Efecto07("IMAGE_07");
StillFX Efecto08("IMAGE_08");
StillFX Efecto09("IMAGE_09");
StillFX Efecto10("IMAGE_10");
StillFX Efecto11("IMAGE_11");
StillFX Efecto12("IMAGE_12");
StillFX Efecto13("IMAGE_13");
StillFX Efecto14("IMAGE_14");
StillFX Efecto15("IMAGE_15");
StillFX Efecto16("IMAGE_16");
StillFX Efecto17("IMAGE_17");
StillFX Efecto18("IMAGE_18");
StillFX Efecto19("IMAGE_19");
StillFX Efecto20("IMAGE_20");
StillFX Efecto21("IMAGE_21");
StillFX Efecto22("IMAGE_22");
StillFX Efecto23("IMAGE_23");
StillFX Efecto24("IMAGE_24");
StillFX Efecto25("IMAGE_25");
StillFX Efecto26("IMAGE_26");
StillFX Efecto27("IMAGE_27");
StillFX Efecto28("IMAGE_28");
StillFX Efecto29("IMAGE_29");
StillFX Efecto30("IMAGE_30");
StillFX Efecto31("IMAGE_31");


