#include "SM_SysPch.h"
#include <windows.h>
#include "MVFSResource.h"


int       MVFSFILEResource::fopen     (const char* pcFileName, const char* pcFileAttrib)
{
    HRSRC		rec;
	HGLOBAL		handle;

    rec = FindResource(NULL, (char*) 105, "PACK");

    if (!rec) return -1;

    handle = LoadResource(NULL, rec);
    
	m_pData         = LockResource(handle);
	m_iLength       = SizeofResource(NULL, rec);
	m_iPosition     = 0;

    return 0;
}

int       MVFSFILEResource::fclose    ()
{
    m_pData = 0;
    return 0;
}
unsigned  MVFSFILEResource::fread     (void * pvDest, size_t uItemSize, size_t uItem)
{
    memcpy(pvDest, ((char*) m_pData)+m_iPosition, uItemSize*uItem);
    m_iPosition+=uItemSize*uItem;

    return uItem;
}
unsigned  MVFSFILEResource::fwrite    (void * pvSrc,  size_t uItemSize, size_t uItem)
{
    return 0;
}

int       MVFSFILEResource::ftell     ()
{
    return m_iPosition;
}

int       MVFSFILEResource::fseek     (long lDisplace, int iRelative)
{
  int iNewPosition;

  switch (iRelative)
  {
  case SEEK_SET:
    iNewPosition=lDisplace;
    break;
  case SEEK_CUR:
    iNewPosition=m_iPosition+lDisplace;
    break;
  case SEEK_END:
    iNewPosition=m_iLength+lDisplace;
    break;
  }

  assert(iNewPosition>=0 && iNewPosition<=m_iLength);

  m_iPosition = iNewPosition;

  return (0);
}

int       MVFSFILEResource::fprintf   (const char* pcDString)
{
    return 0;
}

int       MVFSFILEResource::fflush    ()
{
    return 0;
}

char*     MVFSFILEResource::fgets     (char* pcBuffer, int iBufferSize)
{
    return 0;
}

