#include "SM_Engine3DPCH.h"
#include "SM_D3DLight.h"
#include "SM_KeyFrameSequence.h"
#include "SM_KeyFrame.h"
#include "MVFS.h"


int D3DLight::Load(MVFSFILE* f)
{
  int iReturn=(MVFS::fread(&m_Light, sizeof(m_Light), 1, f)==1?0:-1);
  return iReturn;
}

int D3DLight::Save(MVFSFILE* f)
{
  return (MVFS::fwrite(&m_Light, sizeof(m_Light), 1, f)==1?0:-1);
}


void D3DLight::SetPosition(Vector3D*   pPosition)
{ 
  m_Light.Position.x=pPosition->x;
  m_Light.Position.y=pPosition->y;
  m_Light.Position.z=pPosition->z;
}

void  D3DLight::SetRotation(Quaternion* pRotation)
{  
}

void  D3DLight::Update(float fTime)
{  
  if (m_pKeyFrameSequence)
  {
    KeyFrame CurrentKeyFrame;    
    m_pKeyFrameSequence->GetKeyFrame(fTime, m_fKeyFrameSequenceStartTime, &CurrentKeyFrame);
 
    m_Light.Position.x=CurrentKeyFrame.m_Position.x;
    m_Light.Position.y=CurrentKeyFrame.m_Position.y;
    m_Light.Position.z=CurrentKeyFrame.m_Position.z;


    if (m_Light.Type == D3DLIGHT_DIRECTIONAL)
    {
      Quaternion qRot;      
      qRot=CurrentKeyFrame.m_Rotation*Quaternion(0.5f*3.141592f, Vector3D(1.0f, 0.0f, 0.0f));

      float R[3][3];
      qRot.ToRotationMatrix(R);
      m_Light.Direction.x = R[2][0];
      m_Light.Direction.y = R[2][1];
      m_Light.Direction.z = R[2][2];
    }    
  }  
}
  
