#ifndef __SM_RESOURCEMANAGER

#define __SM_RESOURCEMANAGER

#include "SM_D3d.h"

struct MSurface;

namespace ResourceManager 
{
  int Init                                   ();
  int Shutdown                               ();

  void                      NewFrame         ();
  
  // Texture
  int                       CreateDepthTexture(unsigned uWidth, unsigned uHeight, D3DFORMAT Format);
  int                       CreateRenderTexture     (unsigned uWidth, unsigned uHeight, D3DFORMAT Format, unsigned uMips = 1);
  int                       CreateTexture     (unsigned uWidth, unsigned uHeight, D3DFORMAT Format, unsigned uMips = 1);

  int                       CreateCubemapFromSurface(MSurface*  pSurfaces, D3DFORMAT Format);
  int                       CreateBumpmapFromSurface(MSurface*  pSurface , D3DFORMAT Format);
  int                       CreateTextureFromSurface(MSurface*  pSurface , D3DFORMAT Format, bool bRenormalizeRGB = false);

  int                       ReleaseTexture          (int iID);
  IDirect3DTexture8*        GetTextureFromID        (int iID);    
  IDirect3DSurface8*        GetSurfaceFromID        (int iID);
  IDirect3DCubeTexture8*    GetCubeMapFromID        (int iID);

  // Vertex Buffer
  int                       CreateVertexBuffer        (UINT Length, DWORD Usage, DWORD FVF, D3DPOOL Pool);
  int                       ReleaseVertexBuffer       (int iID);
  IDirect3DVertexBuffer8*   GetVertexBufferFromID     (int iID);


  // Index Buffer
  int                       CreateIndexBuffer         (UINT Length, DWORD Usage, D3DFORMAT Format, D3DPOOL Pool);
  int                       ReleaseIndexBuffer        (int iID);
  IDirect3DIndexBuffer8*    GetIndexBufferFromID      (int iID);


  int                       CreateDynamicVertexBuffer (UINT Length, DWORD FVF);
  int                       GiveVBChunk                 (int iID, unsigned uLength, void** ppData);
  int                       DoneVBChunk                 (int iID);

  int                       CreateDynamicIndexBuffer (UINT Length, DWORD FVF);
  int                       GiveIBChunk                 (int iID, unsigned uLength, void** ppData);
  int                       DoneIBChunk                 (int iID);
  
  unsigned					GetVertexStreamSize               ();
  unsigned					GetIndexStreamSize                ();

  extern int                m_iPosNormalDiffuseTex1Stream;
  extern int                m_iIndexStream;

  // RT Management
  int           ResetRenderTargetStack();
  int           SetRenderTarget(int iRenderTarget, int iDepthBuffer);
  int           RestoreRenderTarget();
  void          GetCurrentRenderTarget(IDirect3DSurface8** ppDepthStencil, IDirect3DSurface8** ppBackBuffer, 
                               IDirect3DTexture8** ppTexture, int* piDepthID, int* piRenderTarget);

  int                       GetScratchRenderTexture(unsigned uScratch);
  int                       GetScratchDepthTexture(unsigned uDepth);   

};


#endif
