#include "SM_GuiToolkitPCH.h"
#include "SM_StatusBar.h"


StatusBar::StatusBar()
{
}

StatusBar::~StatusBar()
{
  Shutdown();
}

int StatusBar::Init(Window* pParent)
{
  int iAll = 100;
  return Init(pParent, 1, &iAll);
}

int StatusBar::Init(Window* pParent, int iSegments, int* piPercentage)
{
  RECT rcClient; 
  HLOCAL hloc; 
  LPINT lpParts; 
  int i; 

  if (!pParent)
  {
    return -1;
  }

  // Create the status bar. 
  m_hwnd = CreateWindowEx( 
        0,                       // no extended styles 
        STATUSCLASSNAME,         // name of status bar class 
        (LPCTSTR) NULL,          // no text when first created 
        WS_CHILD | WS_VISIBLE,   // creates a child window 
        0, 0, 0, 0,              // ignores size and position 
        pParent->Hwnd(),         // handle to parent window 
        (HMENU) 0,               // child window identifier 
        SM_Main::HInstance(),    // handle to application instance 
        NULL);                   // no window creation data 

  if (!m_hwnd)
  {
    return -1;
  }
 
  // Get the coordinates of the parent window's client area. 
  GetClientRect(pParent->Hwnd(), &rcClient); 

  // Allocate an array for holding the right edge coordinates. 
  hloc = LocalAlloc(LHND, sizeof(int) * iSegments); 
  lpParts = (int*) LocalLock(hloc); 
 
  // Calculate the right edge coordinate for each part, and 
  // copy the coordinates to the array. 
  int iWidth  = rcClient.right; 
  int iOffset = 0;
  for (i = 0; i < iSegments; i++) 
  { 
    lpParts[i] = iOffset; 
    iOffset += (iWidth * piPercentage[i])/100;; 
  }

  // Tell the status bar to create the window parts. 
  SendMessage(m_hwnd, SB_SETPARTS, (WPARAM) iSegments, 
      (LPARAM) lpParts); 

  // Free the array, and return. 
  LocalUnlock(hloc); 
  LocalFree(hloc); 

  return 0;  
}
void StatusBar::SetText(int iSegment, const char* pcText)
{
  SendMessage(m_hwnd, SB_SETTEXT, (WPARAM) iSegment, (LPARAM) pcText);
}

void StatusBar::Update()
{
  SendMessage(m_hwnd, WM_SIZE, (WPARAM) 0, (LPARAM) 0);
  Window::Update();
}