#ifndef __MAINWINDOW

#define __MAINWINDOW

#include "SM_Window.h"
#include "SM_SimpleLayout.h"
#include "PreviewWindow.h"
#include "TimelineWindow.h"
#include "WorksheetWindow.h"
#include "DemoInterface.h"
#include "ToolWindow.h"
#include "StatusWindow.h"



struct SM_DemoScript::TCommand;



class MainWindowLayout : public ILayout
{
public:
    int               Init        (PreviewWindow* pPreview, TimelineWindow* pTimeline, WorksheetWindow* pWorksheet, ToolWindow* pTool, StatusWindow* pStatus);
    int               Shutdown    ();
    void              Update      ();

protected:
    PreviewWindow*    m_pPreview;
    TimelineWindow*   m_pTimeline;
    WorksheetWindow*  m_pWorksheet;
    ToolWindow*       m_pTool;
    StatusWindow*     m_pStatus;
};

class MainWindow : public Window
{
public:
                        MainWindow          ();

    // From Window
    int                 Init                (Window* pParent = 0);


    // From EventListener
    void                ProcessEvent(Event* pEvent);

    int                 Shutdown            ();
    int                 ProcessMessage      (const UINT message, const WPARAM wParam, const LPARAM lParam);
    

    int                 LoadDemo            ();
    int                 SaveDemo            ();
    int                 LoadConfiguration   (const char* pcScriptName);
    int                 SaveConfiguration   (const char* pcScriptName);
    int                 SaveDemo            (const char* pcScriptName);
    int                 ExportTGAs          ();
    bool                CheckModifySave     ();

    void                Run               ();
    bool                IsPlaying           ();
    
    MainWindowLayout    m_Layout;
    PreviewWindow       m_Preview;
    TimelineWindow      m_Timeline;
    WorksheetWindow     m_Worksheet;
    ToolWindow          m_Tool;
    StatusWindow        m_Status;
    MSurface*           m_pAuxSurface;


    
public:  
    int                              ShutdownCommandList      (MBStaticList<SM_DemoScript::TCommand*>* pList);
    int                              GenerateCommandList      (MBStaticList<SM_DemoScript::TCommand*>* pList, bool bAlsoInactive = false);
    int                              UpdateCommandList        ();

    int                              ImportScript             ();
    int                              PreloadEffects           ();
    int                              ReleaseGUILoadedEffects  ();
    int                              CalculateDemoLength      ();
    void                             SetDemoTick              (int iTick);
	  void                             SetPlayingTick           (int iTick);
    void                             UpdateMusic              (bool bNoMusic, bool bNoMusicOnStop);
    int                              PlayDemo                 ();
    int                              StopDemo                 ();
    void                             SetLength                (int iTicks);
    void                             Update                   ();
    
    DemoControl                      m_DemoPlayer;
    bool                             m_bActive;
    bool                             m_bPlaying;
    bool                             m_bLoaded;
    bool                             m_bDoPlayerUpdate;
    bool                             m_bModified;
    bool                             m_bNoMusic;
    bool                             m_bNoMusicOnStop;
    bool                             m_bBPMGuide;

    float                            m_fStartPlayTime;
    

    MBStaticList<GUILoadedEffect*>   m_slGUILoadedEffects;      

    int                              m_iTicks;
    int                              m_iCurrentTick;
};


#endif
