#ifndef TIMELINE

#define TIMELINE

#include "SM_Window.h"
#include "Structures.h"


DEFINE_EVGUID(EV_TIMELINE_UPDATE , 0x520BE36B, 0x7F1A, 0x4E5A, 0x9E, 0x94, 0x40, 0x67, 0xBF, 0x8F, 0x14, 0x8A);

class TimelineUpdateEvent : public Event
{
public:
  TimelineUpdateEvent(DemoIDEView* pDemoIDEView)
  {
    m_DemoIDEView = *pDemoIDEView;
    m_pGUID = (EVGUID*) &EV_TIMELINE_UPDATE;
  }

  DemoIDEView m_DemoIDEView;
};

DEFINE_EVGUID(EV_TIMESET, 0x731AA572, 0xD272, 0x4485, 0xA2, 0x71, 0x73, 0x70, 0x52, 0x8A, 0x2F, 0xBB);

class TimesetEvent : public Event
{
public:
  TimesetEvent(DemoIDEView* pDemoIDEView)
  {
    m_DemoIDEView = *pDemoIDEView;
    m_pGUID = (EVGUID*) &EV_TIMESET;    
  }

  DemoIDEView m_DemoIDEView;
};

DEFINE_EVGUID(EV_LIMITUPDATE, 0x4C9570E8, 0xB4E6, 0x4214, 0x96, 0x36, 0x26, 0x95, 0xAF, 0x6B, 0xDB, 0xC1);

class LimitUpdateEvent : public Event
{
public:
  LimitUpdateEvent(int iStartLimit, int iEndLimit)
  {
    m_pGUID = (EVGUID*) &EV_LIMITUPDATE;    
    m_iStartLimit = iStartLimit;
    m_iEndLimit   = iEndLimit;
  }

  int m_iStartLimit;
  int m_iEndLimit;
};



class TimelineWindow : public Window
{
public:
                        TimelineWindow  ();
  virtual int           Init            (Window* pParent = 0);  
  virtual int           Shutdown        ();
  virtual int           ProcessMessage  (const UINT message, const WPARAM wParam, const LPARAM lParam);
 
  void                  SetLength       (int iTicks);
  void                  SetScale        (int iScale);
  void                  SetStart        (float fStart);
  void                  SetBPMGuide     (bool bGuide);

  DemoIDEView*          GetDemoIDEView  ()
  {
    return &m_DemoIDEView;
  }

  void                  Update          ();
  
protected:  
  void                  PaintLimits     (HDC hdc);
  void                  PaintPointer    (HDC hdc, int iTick, HBRUSH hBrush, HPEN hPenHalf, HRGN* pRGN = 0);
  void                  PaintBPMGuide   (HDC hdc);
  void                  SetOffset       (int iOffset);
  void                  Paint           ();
  void                  UpdateScrollBar (int iStartTick);
  
  DemoIDEView           m_DemoIDEView;
  int                   m_iPageSize; 
  int                   m_iStartLimit;
  int                   m_iEndLimit;

  struct    BPMDlgProcData
  {
    TimelineWindow* m_pTimelineWindow;
    int             m_iBPM;
  };

  static  BOOL CALLBACK BPMDlgProc( HWND _hdlg, UINT _uMsg, WPARAM _wparam, LPARAM _lparam);

  // GDI
  HFONT   font;
  HBRUSH  hBrushWhite;
  HBRUSH  hBrushGreen;    
  HPEN    hPenHalfGreen;
  HBRUSH  hBrushRed;    
  HPEN    hPenHalfRed;  
  HBRUSH  hBrushPurple;    
  HPEN    hPenHalfPurple;  

  HRGN    hStartLimit;
  HRGN    hEndLimit;
  HRGN    hBPM;

};


#endif