#include "DemoIDEPch.h"
#include <windows.h>
#include <commctrl.h>
#include "SM_Window.h"
#include "SM_SimpleLayout.h"
#include "SM_Main.h"
#include "SM_d3d.h"
#include "resource.h"
#include "MWinReg.h"

#include "MainWindow.h"
#include "PreviewWindow.h"
#include "TimelineWindow.h"


#define ENUMERA(Efecto) void EnumeraLinka##Efecto##(); EnumeraLinka##Efecto##();



void EnumerateFx()
{ 

  ENUMERA(FilterFX);
  ENUMERA(StillFX);
  ENUMERA(ScrollFX);
  ENUMERA(Escena3DFX);
  ENUMERA(PelosFX);
  ENUMERA(TunelFX);
  ENUMERA(PirulasFX);
  ENUMERA(GreetingsFX);
  ENUMERA(EnredaderaFX);
  ENUMERA(Font3DFx);  
  ENUMERA(Text3DFx);    
  ENUMERA(FlareFX);
  ENUMERA(MusicFX);
  ENUMERA(VoxelFX);
  ENUMERA(SoundSyncerFX);
  ENUMERA(FXDistortBall);
  ENUMERA(FXTunnel1);
  ENUMERA(FXTunnel2);
  ENUMERA(FXSpikeTube);
  ENUMERA(FXExplode);
  ENUMERA(TraumaTributeFX);
  ENUMERA(PulpoFX);
  ENUMERA(PlasmaFX);
  ENUMERA(MDMABordeFX);
  ENUMERA(AviVideoFX);
}


HWND DoCreateStatusBar(HWND hwndParent, int nStatusID, 
    HINSTANCE hinst, int nParts) 
{ 
    HWND hwndStatus; 
    RECT rcClient; 
    HLOCAL hloc; 
    LPINT lpParts; 
    int i, nWidth; 

    // Ensure that the common control DLL is loaded. 
    InitCommonControls(); 
    
    // Create the status bar. 
    hwndStatus = CreateWindowEx( 
        0,                       // no extended styles 
        STATUSCLASSNAME,         // name of status bar class 
        (LPCTSTR) NULL,          // no text when first created 
        //CCS_TOP  |         // includes a sizing grip 
        // includes a sizing grip 
        WS_CHILD | WS_VISIBLE,                // creates a child window 
        0, 0, 0, 0,              // ignores size and position 
        hwndParent,              // handle to parent window 
        (HMENU) nStatusID,       // child window identifier 
        hinst,                   // handle to application instance 
        NULL);                   // no window creation data 
 
    // Get the coordinates of the parent window's client area. 
    GetClientRect(hwndParent, &rcClient); 
 
    // Allocate an array for holding the right edge coordinates. 
    hloc = LocalAlloc(LHND, sizeof(int) * nParts); 
    lpParts = (int*) LocalLock(hloc); 
 
    // Calculate the right edge coordinate for each part, and 
    // copy the coordinates to the array. 
    nWidth = rcClient.right / nParts; 
    int iOffset = 0;
    for (i = 0; i < nParts; i++) { 
        lpParts[i] = iOffset; 
        iOffset += nWidth; 
    } 
 
    // Tell the status bar to create the window parts. 
    SendMessage(hwndStatus, SB_SETPARTS, (WPARAM) nParts, 
        (LPARAM) lpParts); 
 
 
    // Free the array, and return. 
    LocalUnlock(hloc); 
    LocalFree(hloc); 
    return hwndStatus; 
} 
 


MainWindow        g_MainWindow;
DemoControl       g_Demo;
HWND              g_splash;


BOOL CALLBACK SplashProc( HWND _hdlg, UINT _uMsg, WPARAM _wparam, LPARAM _lparam)
{
  switch (_uMsg)
  {
    case WM_INITDIALOG :
    {
      RECT r;
      GetClientRect(_hdlg, &r);

      SetWindowPos(_hdlg,HWND_TOPMOST,
          (GetSystemMetrics(SM_CXSCREEN)-r.right)/2,
          (GetSystemMetrics(SM_CYSCREEN)-r.bottom)/2,r.right,r.bottom, 0);
      g_splash = _hdlg;
      return TRUE;
    }
  }

  return FALSE;
}


int SmAppPreInit()
{
  if (!MWinreg::Init("software/threepixels/studio/"))
  {
    SM_Main::OutputError("Error: Registry hive HKEY_LOCAL_MACHINE/software/threepixels/studio/ not initialized!");
    return (-1);
  }


  int iSplash = 0;
  MWinreg::ReadInt("", "Nosplash", &iSplash);

  if (!iSplash)
  {
    CreateDialogParam(SM_Main::HInstance(), 
                      MAKEINTRESOURCE(IDD_SPLASH),
                      NULL,
                      SplashProc,
                      0);
  }
  
  return 0;
}

int SmWantMainWindow()
{
  return 0;
}

int SmIgnoreClears()
{
  return 0;
}


void DestroySplash()
{
  if (g_splash) 
  {
    CloseWindow(g_splash);
    DestroyWindow(g_splash);
  }
}

int SmAppInit()
{  
  if (SM_D3d::Init()!=0)
  {
    DestroySplash();
    SM_Main::OutputError("Error initializing d3d ");
    return (-1);
  }

  if (SM_DemoEffect::InitResources()!=0)
  {
    DestroySplash();
    SM_Main::OutputError("Error initializing effect resources");
    return (-1);
  }

  if (g_MainWindow.Init() == -1)
  {
    DestroySplash();
    return -1;
  }
  
  DestroySplash();

  return 0;
}

int SmAppRun()
{
  MSG  msg;
  BOOL bRet;

  if (g_MainWindow.IsPlaying())
  {
    if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
    {
      TranslateMessage(&msg);
		  DispatchMessage(&msg);      
    }

    g_MainWindow.Run();
    return 1;
  }
  else
  {
    if (bRet = GetMessage(&msg, NULL, 0, 0 ) != 0)
    {
      if (bRet == -1)
      {
        return 0;
      }
      else
      {
        TranslateMessage(&msg);
			  DispatchMessage(&msg);      
      }

      g_MainWindow.Run();
      return 1;
    }
  }

  
  return 0;
}

int SmAppEnd()
{  
  if (SM_DemoEffect::ShutdownResources() != 0)
  {
    SM_Main::OutputError("Error shuttting down effect resources");
  }

  if (SM_D3d::Shutdown()!=0)
  {
    SM_Main::OutputError("Error shuttting down d3d ");
  }
  
  return 0;
}
