#include <stdlib.h>
#include <stdio.h>
#include <minmax.h>
#include <string.h>
#include <assert.h>
#include "MVFS.h"
#include "MSurface.h"
#include "MSystemFunctions.h"

#define COLOREXTENSION "@RGB"
#define ALPHAEXTENSION "@ALPHA"

int MExtractAlpha(MSurface* pTarget, MSurface* pSource)
{
  *pTarget=*pSource;

  // Propagate alpha

  unsigned i,j;
  unsigned uWidth =pTarget->GetPSurfaceDescriptor()->m_uiWidth;
  unsigned uHeight=pTarget->GetPSurfaceDescriptor()->m_uiHeight;

  for (j=0 ; j<uHeight ; j++)
  {
    unsigned* pScan=(unsigned*) pTarget->GetSurfacePointer(0, j);

    for (i=0 ; i<uWidth ; i++)
    {
      unsigned uAlpha=pScan[i]&0xFF000000;
      
      pScan[i]=(uAlpha>>24) | (uAlpha>>16) | (uAlpha>>8);
    }
  }

  return 0;
}

int __cdecl  main(int argc, char* argv[])
{
  printf("--------------------------------------\n");
  printf("TGA 2 JPG conversor. ThreePixels 2001 \n");
  printf("--------------------------------------\n");

  MVFS::Init("");

  if (argc!=4)
  {
    printf("Converts all the tga in SourceDir to JPGs in DestDir\n", argv[0]);
    printf("Usage: %s SourceDir DestDir Quality(0-100)\n", argv[0]);
    return 0;
  }

  int iQuality=atoi(argv[3]);
  iQuality=min(100, max(0, iQuality));
  
  printf("\n");
  printf("Source dir: %s\n", argv[1]);
  printf("Dest   dir: %s\n", argv[2]);
  printf("Quality   : %i\n", iQuality);



  if (!MVFS::findfilestart(argv[1], "*.TGA"))
  {
    printf("Didn't find any files to convert!\n");
    return 0;
  }

  char pcPath[256];
  char pcColorOut[256];
  char pcAlphaOut[256];
  char pcBaseName[256];
  while (MVFS::findfileget(pcPath))
  {
    

    printf("Processing %s.....\n", pcPath);

    MSurface s;
    if (s.Load(pcPath)!=0)
    {
      printf("ERROR loading TGA\n");  
    }

    MExtractBasename(pcBaseName, pcPath);

    if (s.GetPSurfaceDescriptor()->m_pfPixelFormat.m_uAMask)
    {
      MSurface sAlpha;      
      MExtractAlpha(&sAlpha, &s);

      strcpy(pcAlphaOut, argv[2]);
      strcat(pcAlphaOut, "/");
      strcat(pcAlphaOut, pcBaseName);
      strcat(pcAlphaOut, ALPHAEXTENSION);
      strcat(pcAlphaOut, ".JPG");

      if (sAlpha.SaveJPG(pcAlphaOut, iQuality)!=0)
      {
        printf("ERROR saving JPG\n");  
      }      

      printf("\tOutputted %s\n", pcAlphaOut);

      strcpy(pcColorOut, argv[2]);
      strcat(pcColorOut, "/");
      strcat(pcColorOut, pcBaseName);
      strcat(pcColorOut, COLOREXTENSION);
      strcat(pcColorOut, ".JPG");
      
      if (s.SaveJPG(pcColorOut, iQuality)!=0)
      {
        printf("ERROR saving JPG\n");  
      }

      printf("\tOutputted %s\n", pcColorOut);      
    }
    else
    {
      strcpy(pcColorOut, argv[2]);
      strcat(pcColorOut, "/");
      strcat(pcColorOut, pcBaseName);
      strcat(pcColorOut, ".JPG");
      
      if (s.SaveJPG(pcColorOut, iQuality)!=0)
      {
        printf("ERROR saving JPG\n");  
      }

      printf("\tOutputted %s\n", pcColorOut);
    }

  }
  
  MVFS::findfileend();


  MVFS::Shutdown();
  
  return (0);
}