comment +
 888888888888
        ,88'     8I          256 byte intro "Check out"
      ,88"       8I          Code:    bitl/7dump (2023)
     ,88'        8I          mailto: aleks_gs@yahoo.com
  aaa888aa       8I
   ,8P     ,gggg,8I  gg      gg   ,ggg,,ggg,,ggg,   gg,gggg,
  ,88     dP"  "Y8I  I8      8I  ,8" "8P" "8P" "8,  I8P"  "Yb
  88'    i8'    ,8I  I8,    ,8I  I8   8I   8I   8I  I8'    ,8i
  88    ,d8,   ,d8b,,d8b,  ,d8b,,dP   8I   8I   Yb,,I8 _  ,d8'
  88    P"Y8888P"`Y88P'"Y88P"`Y88P'   8I   8I   `Y8PI8 YY88888P
                                                    I8
   GrEeTiNgS  & ReSpEct:                            I8
   HellMood, sensenstahl, TomCatAbaddon,   iONic    I8
   wbc\\bz7, p01, pestis, Asato, rrrola, Optimus    I8
   superogue,  Kuemmel,  Digimind,  Manwe,   LBi    I8
                                                    I8
   For compilation  use   Turbo  Assembler 2.02     I8
   tasm /m2 checkout.asm  tlink /t checkout.obj     I8

comment end! +

mode60 = 0  ; enable tweaked 60hz VGA mode
SPEED  = 5

t       =0
v4      =4
v32     =6
v128    =8
ycos    =10
ysin    =14
xstart  =18
ystart  =22
q       =26
r       =28

.model tiny
.data
_t      DD 0A000h ;0
_v4     DW 4      ;4
_v32    DW 32     ;6
_v128   DW 128    ;8

IF mode60
vga60 DW 0b06h, 3e07h, 0c310h, 8c11h, 8f12h, 9015h, 0b16h
ENDIF

.code
.386
org 0100h

start:

mov ax,13h
;int 10h

add dh, al                 ; cs + 1300h
mov fs, dx                 ; segment for framebuffer

mov bl, 64                 ; setup palette and vga mode 13
@pal:
int 10h
mov cl, bl ;blue
mov ch, bl ;green
shr ch, 1
mov dh, ch ;red
shr dh, 1
mov ax, 1010h
dec bx
jnz @pal


IF mode60
mov dx, 3d4h               ; Set tweaked 60hz VGA mode 320x200
push dx
mov al, 11h
out dx, al
inc dx
in al, dx
and al, 7fh
out dx, al
mov dx, 3C2h
mov al, 0e3h
out dx, al
pop dx
lea si, vga60
mov cx, 7
rep outsw
ENDIF

;**********************************************************************
; MAIN LOOP
;**********************************************************************
lea bx, _t
mov es, word ptr [bx]      ; ES = 0A000h

@mainloop:
add word ptr [bx+q], SPEED

;r:=q and 127;
mov ax, [bx+q]
and ax, 127
mov [bx+r], ax


push cx
@layers:                   ; layers loop
fninit
fild word ptr [bx+v128]
fild word ptr [bx+v4]

;scale:=r/128+n;
fild word ptr [bx+r]       ;    r    |    v4   |  128    |
fdiv st(0), st(2)          ;    r    |    v4   |  128    |
fiadd word ptr [esp]       ;  scale  |    v4   |  128    |

;col:=scale*16
fld st(0)                  ;  scale  |  scale  |    v4   | 128
fmul st(0), st(2)
fmul st(0), st(2)
fistp word ptr [bx+t]
mov ax, word ptr [bx+t]

;zoom:=v4-scale
fsub st(1), st(0)          ;  scale  |   zoom  |  128    |

fimul word ptr [bx+v32]    ; scale*32|   zoom  |  128    |
fild word ptr [bx+q]       ;    q    |  scale  |  zoom   |  128
fdiv st(0), st(3)          ;  q/128  |  scale  |  zoom   |  128
fsincos                    ;   cos   |   sin   | scale*32|  zoom   | 128

;xcentr:=cos(q/tau)*scale*32-160;
fmul st(0), st(2)          ;cos*scale|   sin   | scale*32|  zoom   | 128
fsub st(0), st(4)          ;  xcentr |   sin   | scale*32|  zoom   | 128
fisub word ptr [bx+v32]

;ycentr:=sin(q/tau)*scale*32-100;
fxch st(2)                 ; scale*32|   sin   |  xcentr |  zoom    | 128
fmul st(0), st(1)          ;sin*scale|   sin   |  xcentr |  zoom    | 128
fsub st(0), st(4)          ; ycentr  |   sin   |  xcentr |  zoom    | 128
;fiadd word ptr [bx+v32]

;angle:=sin(q/128)*0.3
fxch st(1)                 ;   sin   |  ycentr | xcentr  |  zoom    | 128
fldlg2                     ;   0.3   |   sin   | ycentr  |  xcentr  | zoom | 128
fmulp st(1), st(0)         ;  angle  |  ycentr | xcentr  |  zoom    | 128

;Tcos := round(cos(angle)*256*scale);
;Tsin := round(sin(angle)*256*scale);
fsincos                    ;  cos(a) | sin(a)  | ycentr  |  xcentr  |  zoom    |  128
fld st(5)                  ;  128
fadd st(0), st(0)          ;  256
fmul st(2), st(0)          ;  256    | cos(a)  | sin*256 |  ycentr  |  xcentr  |  zoom | 128
fmulp st(1), st(0)         ; cos*256 | sin*256 |  ycentr |  xcentr  |  zoom    |  128
fmul st(0), st(4)          ;  tcos   | sin*256 |  ycentr |  xcentr  |  zoom    |  128
fist word ptr [bx+t]       ;  tcos   | sin*256 |  ycentr |  xcentr  |  zoom    |  128
mov si, [bx+t]

;ycos:=tcos*ycentr;
fld st(0)                  ;  tcos   |  tcos   | sin*256 |  ycentr  |  xcentr  |  zoom  | 128
fmul st(0), st(3)          ;  ycos   |  tcos   | sin*256 |  ycentr  |  xcentr  |  zoom  | 128
fistp dword ptr [bx+ycos]  ;  tcos   | sin*256 |  ycentr |  xcentr  |   zoom   |  128

;xstart:=tcos*xcentr+256*32;
fmul st(0), st(3)          ;  xstart | sin*256 |  ycentr |  xcentr  |  zoom    |  128
fistp dword ptr [bx+xstart]; sin*256 |  ycentr |  xcentr |  zoom    |  128

fmul st(0), st(3)          ;  tsin   |  ycentr |  xcentr |  zoom    |  128
fist word ptr [bx+t]
mov bp, [bx+t]

;ysin:=tsin*ycentr;
fmul st(1), st(0)          ;  tsin   |  ysin   |  xcentr |  zoom    |  128

;ystart:=tsin*xcentr-256*32;
fmulp st(2), st(0)         ;  ysin   |  ystart |   zoom  |  128
fistp dword ptr [bx+ysin]
fistp dword ptr [bx+t]

mov dx, 32*256
add word ptr [bx+xstart], dx
sub word ptr [bx+t], dx

xor di, di
mov cl, 200
@draw: ;for y:=0 to 199 do begin
  push cx
  mov cx, word ptr [bx+xstart]
  mov dx, word ptr [bx+t]

  add dx, word ptr [bx+ycos]  ;ytemp:=ystart+ycos;
  sub cx, word ptr [bx+ysin]  ;xtemp:=xstart-ysin;
  add word ptr [bx+ysin], bp  ;ysin:=ysin+tsin;
  add word ptr [bx+ycos], si  ;ycos:=ycos+tcos;

  push bx
  mov bx, 320
  @drawline:     ;for x:=0 to 319 do begin
      mov ah, ch ;xx:= xtemp shr 8;  ;yy:= ytemp shr 8;
      xor ah, dh
      and ah, 64
      jnz @skipdraw  ;if (xx xor yy) and 64 = 0 then
         mov fs:[di], al ;mem[vaddr:word(n)]:=col;
      @skipdraw:
      add cx, si ;xtemp:=xtemp+Tcos;
      add dx, bp ;ytemp:=ytemp+Tsin;
      inc di ;inc(n);
  dec bx
  jnz @drawline
  pop bx
  pop cx
loop @draw

pop ax
inc ax
push ax
cmp al, 3
jbe @layers
pop ax

     mov  dx, 3DAh           ; Wait for vertical retrace
@w1:
;     in   al, dx
;     test al, 8
;     jnz  @w1
@w2:
     in   al, dx
     test al, 8
     jz   @w2

                              ; move buffer to screen
     xor si, si
     xor di, di
     xchg ax, cx
     mov ch, 125
@l:
     db 64h                   ; prefix for "movsw ES:[di], FS:[si]"
     movsw
     mov fs:[si-2], ax        ; clear old data
loop @l

in al, 60h                    ; wait for ESC
dec ax
jnz @mainloop                 ; none received, start over


;**********************************************************************
; EXIT
;**********************************************************************
;     mov ax, 3                ; back to text
;     int 10h                  ; mode
;     int 20h                  ; exit
ret
end start
