PROC rotoscop
pusha
mov dword ptr [si+_colorfill], 68686868h

; flash palette
xor bp, bp
test dx, 4
jz @skip_flash
  mov bp, 6
@skip_flash:

call palgen

cmp dx, 1340
jb @skip_excentric
mov byte ptr [si+_excentric], 50
@skip_excentric:


mov es, word ptr [si+_vaddr]
finit
fild word ptr [si+_q]
fidiv word ptr [si+_v8]       ; q=q/8

;xx:=cos(q/8)*excentric-160;
;yy:=sin(q/8)*excentric-100;
fld st(0)                     ;   q    |    q
fidiv word ptr [si+_v8]       ;  q/8  |    q
fsincos                       ;  cos() |  sin()  |    q
fimul word ptr [si+_excentric]; cos*ex |  sin()  |    q
fisub word ptr [si+_v160]     ;   xx   |  sin()  |    q
fxch st(1)                    ;  sin() |   xx    |    q
fimul word ptr [si+_excentric]; sin*ex |   xx    |    q
fisub word ptr [si+_v100]     ;   yy   |   xx    |    q
fxch st(2)                    ;   q    |   xx    |    yy

;scale:=cos(q/45)*0.4+1;
fld st(0)                     ;   q    |    q
fidiv word ptr [si+_v20]      ;  q/45  |    q
fcos                          ; cos(q) |    q
fmul dword ptr [si+_v04]      ; cos*0.4|    q
fld1                          ;   1    | cos*0.4 |    q
faddp st(1), st(0)            ; scale  |    q    |

;lag:= (pi/4) * sin(q/60);
fld st(1)                     ;   q    |  scale  |    q
fidiv word ptr [si+_v60]      ;  q/60  |  scale  |    q
fsin                          ; sin(q) |  scale  |    q
fldpi                         ;   pi   |  sin(q) |  scale  |   q
fidiv word ptr [si+_v4]       ;  pi/4  |  sin(q) |  scale  |   q
fmulp st(1), st(0)            ;  lag   |  scale  |    q    |

;angle:=q/8
fxch st(2)                    ;   q    |  scale  |   lag
fidiv word ptr [si+_v8]       ; angle  |  scale  |   lag

mov byte ptr [si+_n], 4
@layers:
;angle:=angle+lag;
fadd st(0), st(2)             ; angle+ |  scale  |   lag   |   xx   |   yy

;Tcos := round(cos(angle)*256/scale);
;Tsin := round(sin(angle)*256/scale);
fld st(0)                     ;  anlge | angle  |  scale  |   lag   |  xx   |   yy
fsincos                       ;  cos(a)| sin(a) |  angle  |  scale  |  lag  |   xx  |   yy
fild word ptr [si+_v256]      ;  256   | cos(a) | sin(a)  |  angle  | scale |  lag  |   xx  |  yy

push si
mov si, offset pos+_Yi

fmul st(2), st(0)             ;  256   | cos(a) | sin*256 |  angle  | scale |  lag  |   xx  |  yy
fmulp st(1), st(0)            ; cos*256| sin*256|  angle  |  scale  | lag   |   xx  |   yy
fdiv st(0), st(3)             ;  tcos  | sin*256|  angle  |  scale  | lag   |   xx  |   yy
fist word ptr [si]            ;  tcos  | sin*256|  angle  |  scale  | lag   |   xx  |   yy
mov bx, [si]                  ; BX=tcos

;xstart := tcos*xx
fmul st(0), st(5)             ; xstart | sin*256|  angle  |  scale  |  lag   |  xx  |   yy
fistp dword ptr [si]          ; sin*256|  angle |  scale  |   lag   |  xx    |  yy
mov ax, word ptr [si]         ; AX = xstart

fdiv st(0), st(2)             ;  tsin  | angle  |  scale  |   lag   |  xx  |  yy
fist word ptr [si]            ;  tsin  | angle  |  scale  |   lag   |  xx  |  yy  |
mov dx, word ptr [si]         ; DX=tsin

;ysin   := tsin*yy
fmul st(0), st(5)             ;  ysin  | angle  |  scale  |   lag   |  xx  |  yy  |
fistp dword ptr [si]
mov bp, word ptr [si]

add ah, 24     ;xstart+24*256 -  for centrized lines
push ax        ;push xstart

xor di, di
mov ah, 200
@dlayer:
  pop cx ;xtemp:=xstart-ysin;
  push cx
  sub cx, bp
  mov si, 320
      @dline:
          mov al, ch ;xx:= xtemp shr 8;
          and al, 16
          shr al, 2
          add es:[di], al
          add cx, bx ;xtemp:=xtemp+Tcos;
          inc di
          dec si
      jnz @dline
  add bp, dx ;ysin:=ysin+Tsin;
  dec ah
jnz @dlayer
pop ax

pop si
dec byte ptr [si+_n]
jnz @layers

popa
ret
ENDP rotoscop


