
// 
//
//  Six-2-Four - a 4Kb intro packer.
//
//  Copyright (c) Kim Holviala a.k.a Kimmy/PULP Productions 1997
//
// 


#include <stdio.h>
#include <stdlib.h>

#define byte unsigned char
#define word unsigned short
#define dword unsigned long

#define OK 0
#define ERROR 1

#define MAXSIZE 20000

#define TRUE 0
#define FALSE 1


byte buffer[MAXSIZE], lzbuffer[MAXSIZE];
word lenght, lzlenght, hufflimit1, hufflimit2, lenlimit, decodelenght;
int maxhuffman, dummy;
char bitpos;

struct {
    word eoff;
    word ll;
    word hl1;
    word hl2;
    word hf2;
} decoder;

char *rotorchar = "/\\";

char *info = "Six-2-Four v1.0 - Exepacker for 4Kb-intros.\n"
             "Copyright (c) Kim Holviala a.k.a Kimmy/PULP Productions 1997.\n";

char *help = "    Usage: 624 [-s] infile [outfile]\n\n"
             "    Where: -s      - use super duper compression\n"
             "           infile  - COM-file shorter than 20000 bytes\n"
             "           outfile - optional filename for the compressed file\n\n"
             "This program is EMAILWARE. You're free to use this even with commercial\n"
             "programs, AFTER you email me to <kimmy@iki.fi> and tell me the name of\n"
             "your favorite dark beer!";



// 
//
//  Write one bit to the lzbuffer
//
// 

void writebit(word bit) {

    byte mask = 1;


    mask <<= bitpos;

    if (bit == 0) lzbuffer[lzlenght] &= 255-mask;
    else lzbuffer[lzlenght] |= mask;

    if (++bitpos > 7) {

        bitpos = 0;
        lzlenght++;
    }
}



// 
//
//  Write n bits to the lzbuffer
//
// 

void writedata(word b, word mask) {

    do {
        writebit(b & mask);
        mask >>= 1;

    } while (mask > 0);
}



// 
//
//  Write one "huffman"-coded number to the lzbuffer
//
// 

void writehuffman(word number) {

    word mask;


    number--;

    if (number < (hufflimit1 * 2)) {

        writebit(0);
        mask = hufflimit1;
    }
    else {
        number -= (hufflimit1 * 2);

        writebit(1);
        mask = hufflimit2;
    }


    do {
        writebit(number & mask);
        mask >>= 1;

    } while (mask > 0);
}



// 
//
//  Return log2 (if that's what it is?)
//
// 

word log2(word l) {

    switch (l) {
        case 1: return 0;
        case 2: return 1;
        case 4: return 2;
        case 8: return 3;
        case 16: return 4;
        case 32: return 5;
        case 64: return 6;
        case 128: return 7;
        case 256: return 8;
        case 512: return 9;
        case 1024: return 10;
        case 2048: return 11;
        case 4096: return 12;
    }

    return 0;
}



// 
//
//  Compress the file
//
// 

void squeeze(void) {

    int count1, count2;
    word bestlen, bestpos, len, *wptr;
    byte b, prefix;


    lzlenght = decodelenght;
    bitpos = 0;

    lzbuffer[decoder.eoff] = lenght & 0xff;
    lzbuffer[decoder.eoff + 1] = (lenght >> 8) + 0x01;
    lzbuffer[decoder.ll] = lenlimit - 1;

    lzbuffer[decoder.hl1] = log2(hufflimit1) + 1;
    lzbuffer[decoder.hl2] = log2(hufflimit2) + 1;
    lzbuffer[decoder.hf2] = (hufflimit1 * 2) + 1;

    for (count1 = 0; count1 < lenght; count1++) {

        bestlen = 0;
        b = buffer[count1];

        for (count2 = (count1 - 1); count2 > (count1 - maxhuffman); count2--) {

            if (count2 < 0) break;

            if (buffer[count2] == b) {

                for (len = 1; len < maxhuffman; len ++) {

                    if ((count1 + len) > lenght) break;
                    if (buffer[count1 + len] != buffer[count2 + len]) break;
                }

                if (len > bestlen) {

                    bestlen = len;
                    bestpos = count1 - count2;
                }
            }

        }


//printf("len: %i  pos: %i  char: %c\n", bestlen, bestpos, b);

        if (bestlen == 1 && bestpos < 17) {

            writebit(1);
            writebit(0);
            writedata(bestpos - 1, 8);

            continue;
        }

        if (bestlen > 1) {

            if (bestlen < lenlimit) {

                for (count2 = 0; count2 < bestlen; count2++) writebit(1);
                writebit(0);
            }
            else {
                for (count2 = 0; count2 < lenlimit; count2++) writebit(1);
                writehuffman(bestlen - 1);
            }

            count1 += bestlen - 1;
            writehuffman(bestpos);

            continue;
        }

        writebit(0);
        writedata(b, 128);
    }

    lzlenght++;
}



// 
//
//  Find the best compression values
//
// 

void compress(void) {

    word besthl1, besthl2, bestll, bestlzlen;
    byte rotor = 0;


    lenlimit = 9;
    bestlzlen = 60000;

    for (hufflimit1 = 4; hufflimit1 <= 64; hufflimit1 *= 2)
    for (hufflimit2 = hufflimit1 * 4; hufflimit2 <= 2048; hufflimit2 *= 2) {

        printf("\rCompressing ... (%c) ", rotorchar[rotor]);
        if (++rotor > 3) rotor = 0;

        maxhuffman = (hufflimit2 + hufflimit1) * 2;

        squeeze();

        if (lzlenght < bestlzlen) {

            besthl1 = hufflimit1;
            besthl2 = hufflimit2;
            bestlzlen = lzlenght;
        }
    }

    hufflimit1 = besthl1;
    hufflimit2 = besthl2;
    maxhuffman = (hufflimit2 + hufflimit1) * 2;
    bestlzlen = 60000;

    for (lenlimit = 5; lenlimit <= 15; lenlimit++) {

        printf("\rCompressing ... (%c) ", rotorchar[rotor]);
        if (++rotor > 3) rotor = 0;

        squeeze();

        if (lzlenght < bestlzlen) {

            bestll = lenlimit;
            bestlzlen = lzlenght;
        }
    }

    lenlimit = bestll;

    squeeze();

//printf("\n(%i, %i, %i)\n", hufflimit1, hufflimit2, lenlimit);
}



// 
//
//  Main
//
// 

int main(int argc, char *argv[]) {

    FILE *fp;
    char *destfile, *srcfile, slow, ch = ' ', lastch;
    long ratio;


    puts(info);

    if (argc == 1 || argc > 4) {

        puts(help);
        return ERROR;
    }

    if (argv[1][0] == '-') {

        slow = TRUE;

        srcfile = argv[2];

        if (argc == 4) destfile = argv[3];
        else destfile = argv[2];
    }
    else {
        slow = FALSE;

        srcfile = argv[1];

        if (argc == 3) destfile = argv[2];
        else destfile = argv[1];
    }

    printf("Loading overlay ... ");

    if ((fp = fopen(argv[0], "rb")) == NULL) {

        printf("What the h...???\n");
        return ERROR;
    }

    do {
        lastch = ch;
        if (fread(&ch, 1, 1, fp) == 0) break;

    } while (lastch != '@' || ch != '@');

    fread(&decoder, 1, 10, fp);
    decodelenght = (word) fread(lzbuffer, 1, 1000, fp);

    fclose(fp);

    if (decodelenght == 0) {

        printf("It seems to be missing!\n");
        return ERROR;
    }

    printf("Done!\nLoading '%s' ... ", srcfile);

    if ((fp = fopen(srcfile, "rb")) == NULL) {

        printf("File not found!\n");
        return ERROR;
    }

    lenght = (word) fread(buffer, 1, MAXSIZE, fp);

    if (lenght == 0) {

        printf("Error reading from file!\n");
        fclose(fp);

        return ERROR;
    }

    if (fread(&dummy, 1, 1, fp) != 0) {

        printf("File too big (must be < 20000 bytes)!\n");
        fclose(fp);

        return ERROR;
    }

    fclose(fp);

    printf("Done!\n", argv[1]);

    if (slow == TRUE) compress();
    else {
        hufflimit1 = 16;
        hufflimit2 = 128;
        lenlimit = 9;
        maxhuffman = (hufflimit2 + hufflimit1) * 2;

        squeeze();
    }

    printf("\rCompressing ... Done!\nSaving to '%s' ... ", destfile);

    if ((fp = fopen(destfile, "wb")) == NULL) {

        printf("Cannot create file!\n");
        return ERROR;
    }

    fwrite(lzbuffer, 1, lzlenght, fp);
    fclose(fp);

    ratio = ((long) lenght - (long) lzlenght) * 100 / ((long) lenght);
    printf("Done!\n\nInput/Output ratio: %i/%i bytes (saved %i%)\n",
           lenght, lzlenght, ratio);

    return OK;
}
