comment +
--------------------------------------------------------------- _-_.--------
 MIDI-player  for  "Forever Reality"  4k-intro  (2023)       _-',^. `-_.
 coded by bitl/7dump       (email: aleks_gs@yahoo.com)   ._-' ,'   `.   `-_
                                                        !`-_._________`-':::
 Greetz to:   HellMood,  sensenstahl, rrrola, Optimus,  !   /\        /\::::
 TomCatAbaddon,  p01,  pestis,  Asato,  iONic,  Manwe,  ;  /  \      /..\:::
 superogue,  Kuemmel, Digimind,  wbc\\bz7, LBi, & YOU!  ! /    \    /....\::
                                                        !/      \  /......\:
 For compilation use:            Requirements:          ;--.___. \/_.__.--;;
 Turbo  Assembler 2.02        Windows XP, DosBox         '-_    `:!;;;;;;;'
 tasm /m2 realplay.asm     (theoretically:  DOS with        `-_, :!;;;''
 tlink /t realplay.obj    support MPU-401 soundcard ;)          `-!'
----------------------------------------------------------------------------
comment end! +

uncr_offs = 4096/16              ; offset in code segment for uncrunch-data
contr_size = 156                 ; unrunched data size of control block
note_size = 180                  ; uncrunched data size of notes block
stat_offs = contr_size+note_size ; offset for status-array

.model tiny
.data
 music_position DW 60
 tick           DB 0

.code
.486
org 0100h

start:
pop gs


;----------------------------Player init ---------------------------------
push ds
pop ax
add ax, uncr_offs
mov es, ax                ; ES - uncrunched data offset (DS+uncr_offset)

mov di, stat_offs         ; offset to status of channels array}
mov si, offset @instr     ; offset to instruments setup}

mov al, 3Fh               ; set UART mode
mov dx, 331h              ; MIDI Control Port
out dx, al                ;
dec dx                    ; DX to data port 330h

xor bx, bx
cld                       ; init status of channels array
@init_player:
   mov al, 0c0h           ; set instruments to channels
   add al, bl
   out dx, al
   lodsb                  ; AL=number instrument
   out dx, al
   mov al, 90h
   add al, bl
   stosw                  ; OnOff=90h+chan, Note=0
   movsb                  ; Volume
   xor ax, ax
   stosw                  ; Enable=0, Pause=0, Possition=0
   stosw                  ; Position=0
   inc di
   inc bx
   cmp bl, 16
jb @init_player


xor di,di                 ; Uncruch music data (4 bit value to byte)
mov si, offset @notes
mov cx, (note_size+contr_size)/2
@decrunch:
   xor ax, ax
   lodsb
   shl ax, 4
   shr al, 4
   stosw
loop @decrunch


                          ; Set interrupt vector for player routine (1Ch)
mov bl, 70h
push dword ptr gs:[bx]    ; save old 1C vector
push cs
push offset @player
pop dword ptr gs:[bx]     ; put new vector


                          ; Quick timer
mov al, 34h
out 43h, al
mov al, 4096 and 0ffh
out 40h, al
mov al, 4096 shr 8
out 40h, al



;**************************************************************************
; MAIN LOOP
;**************************************************************************
@mainloop:



in al, 60h                ; wait for ESC
dec al
jnz @mainloop             ; none received, start over


;**************************************************************************
; EXIT
;**************************************************************************
@exit:


mov al, 34h               ; normal timer
out 43h, al
xor al, al
out 40h, al
out 40h, al


pop dword ptr gs:[70h]    ; restor old vector to 1C interrupt

mov cx, 15                ; Stop all sound
mov   dx, 330h            ; MIDI Data Port
@sound_off:
mov   al, 0b0h
add   al, cl              ; control to 0xB.. channel
out   dx, al
mov   al, 123             ; all note OFF
out   dx, al
out   dx, al
loop @sound_off

int 20h                   ; exit to DOS


;**************************************************************************
; MAIN PLAYER ROUTINE
;**************************************************************************

@player:
cli
pusha
push ds
push es

mov ax, cs
mov ds, ax
mov es, ax

     inc byte ptr tick

     cmp byte ptr tick, 16
     jbe @exit_player
       mov byte ptr tick, 0

       mov si, note_size
       mov di, stat_offs

       lea bp, music_position

       inc word ptr es:[bp]      ; increment music position
       push word ptr es:[bp]

       add ax, uncr_offs         ; DS to uncrunched data (DS=DS+256*16)
       mov ds, ax

       ; -- Channels control block --
       xor cx, cx
       @l_contr:
          pop dx
          push dx
          shr dx, 3

          lodsb
          cmp al, ch
          jae @skip_add_pattern
          add cl, 10h
          @skip_add_pattern:

          mov ch, al  ;{save current pos}
          add al, cl  ;{add num pattern}

          xor bx, bx
          cmp dl, al     ;{if m=a then}
          jne @next_contr
                mov ax, ds:[si]
                cmp ah, 0Fh
                jb @channel_contr
                sub word ptr es:[bp], 128 ;{pos:=pos-128}
                mov word ptr ds:[si], bx
                jmp @next_contr

                @channel_contr:
                mov bl, al  ;{channel number}
                shl bl, 3
                cmp byte ptr ds:[di+bx], 8Fh
                jbe @next_contr
                mov ds:[di+bx+3], ah  ;{mem[stat:(b and 15)*8+3]:=b; {enable=b}

       @next_contr:
       inc si
       inc si
       cmp si, contr_size+note_size
       jb @l_contr


  mov si, di
  xor di, di
  mov bl, 48

  @loop_channel:

       mov dx, ds:[di] ;{DL=beat, DH=length}
       inc dh      ;{DH=length+1}
       inc dx
       shl dl, 2   ;{DL=beat}

     @renew:
       pop ax
       push ax
       and ax, 63
       inc ax
       div dl
       test ah, ah
       jnz @skip_beat
       inc byte ptr ds:[si+4]
       @skip_beat:

       mov al, byte ptr ds:[si+5]  ;{al=possition}

       xor cx, cx
       cmp dh, al ;{if length=Possition then}
       jne @skip_renew
          mov word ptr ds:[si+4], cx ; pause[ch]:=0; possition[ch]:=0
          jmp @renew ;{goto renew}
       @skip_renew:

       xadd bl,al       ;{accum+possition];}
       mov cl, ds:[bx]  ;{CL=note}
       xchg al,bl

       add bl, dh       ;{accum=accum+length}

       inc di
       inc di
       imul ax, word ptr ds:[di], 6  ;{octave}

       mov dx, ds:[si+3]  ;{DL=enable, DH=pause}
       test dh, dh
       jz @skip_playchannel ;{if (pause>0) then begin}
           test dl, dl         ;{downshift}
           jz @skip_playnote   ;{if (Enable<>0)}
               add al, cl         ;{Octave+Note}
               sub al, dl         ;{-downshift}
               mov ds:[si+1], al  ;{Note+Octave-downshift;}
               jcxz @skip_playnote  ;{if (note<>0) then}

                   mov dx, 330h  ;{then for n:=0 to 2 do port[$330]:=mem[stat:chl+n];}
                   outsb
                   outsb
                   outsb
                   sub si, 3
                   xor al, al    ;{fix for Windows XP (NTVDM)}
                   out dx, al
                   out dx, al

            @skip_playnote:
               btc word ptr ds:[si], 4
               jc @skip_playchannel
               inc byte ptr ds:[si+5]

        @skip_playchannel:

     add si, 8
     inc di

     cmp di, 15*3
     jbe @loop_channel
     pop ax

@exit_player:
     pop es
     pop ds
     popa
     sti
     iret

;**************************************************************************
; MUSIC DATA
;**************************************************************************

@instr:
;channels setup (num instrument, volume)
db 117, 127, 38, 127, 38, 127, 34, 110, 81, 96, 81, 96, 81, 96, 87
db 127, 87, 127, 0, 127, 80, 96, 38, 70, 80, 70, 47, 127, 55, 127, 81, 70

@notes:
;notes
db 123, 121, 111, 49, 21, 32, 199, 235, 177, 239, 235, 81
db 47, 53, 116, 231, 252, 84, 247, 188, 56, 31, 119, 191
db 223, 176, 10, 86, 34, 46, 47, 239, 226, 34, 47, 207, 51
db 63, 63, 240, 250, 59, 240, 250, 107, 218, 0, 0, 0, 0, 0
db 0, 80, 209, 250, 63, 0, 0, 42, 57, 2, 142, 0, 48, 239, 128
db 173, 255, 3, 0, 146, 35, 224, 8, 0, 243, 206, 123, 69, 35
db 240, 255, 0, 48, 240, 250, 59, 240, 250, 107

;control
db 151, 113, 24, 183, 113, 23, 213, 129, 20, 88, 129, 22, 248
db 129, 13, 231, 129, 19, 40, 241, 7, 143, 0, 82, 36, 136, 255
db 40, 129, 14, 70, 96, 5, 102, 96, 2, 230, 126, 15, 23, 86, 16
db 231, 129, 201, 233, 144, 224, 240, 31, 29, 231, 129, 13, 200
db 134, 106, 233, 112, 25, 23, 112, 18, 208, 113, 12, 168, 128
db 3, 232, 129, 2, 152, 192, 14, 220, 192, 11


end start
