#include "fusa_logging.h"

using namespace fusa;

namespace fusa
{
  cLogger logger;
}

std::string fusa::getExtentionCaps(const std::string &str)
{
  int dotSearch = str.size()-1;
  while(str[dotSearch]!='.')
    {
      dotSearch--;
      if(dotSearch<0)
	return "";
    }
  dotSearch++;
  std::string ans = str.substr(dotSearch,str.size()-dotSearch );
  std::transform(ans.begin(), ans.end(), ans.begin(),
		 (int(*)(int)) std::toupper);
  return ans;
    
}

std::string fusa::getUpperCasedString(const std::string &str)
{
  std::string ans = str;
  std::transform(ans.begin(), ans.end(), ans.begin(),
		 (int(*)(int)) std::toupper);
  return ans;
 
}