#include "OGLWindow.h"
#define CHECK_FOR_MULTISAMPLE 0

bool	arbMultisampleSupported	= false;
int		arbMultisampleFormat	= 0;

int m_winWidth = 0;
int m_winHeight = 0;

HDC m_windowHDC;
HWND m_windowHWND;
HGLRC m_windowRC;
HINSTANCE m_windowInstance;	

float dTime = 0;
int timeOffset = 0;

bool(*m_ptr_render_func)() = 0;

bool keys[256];
bool keys_lastFrame[256];

short mouseX;
short mouseY;
int mouseButton = 0;

#define MULTI_SAMPLES 8

bool mouseDownLastFrame = false;


///////////////

int oglGetWinWidth()
{
	return m_winWidth;
}

int oglGetWinHeight()
{
	return m_winHeight;
}

bool oglKeyDown(char key)
{
	return keys[key];
}

bool oglKeyDownLastFrame(char key)
{
	return keys_lastFrame;
}

short oglGetMouseX()
{
	return mouseX;
}

short oglGetMouseY()
{
	return mouseY;
}

int oglGetMouseButton()
{
	return mouseButton;
}

bool oglMouseDownLastFrame()
{
	return mouseDownLastFrame;
}


float oglDeltaTime()
{
		return dTime;
}

void oglSwapBuffer()
{
#ifdef WIN32
	SwapBuffers(m_windowHDC);
#endif
}

void oglSetRenderFunc(bool(*ptr_func)())
{
	m_ptr_render_func = ptr_func;
}

void resizeGLScene(int width, int height)
{	
	/*if (mptr_resizeCallback)
	{
		mptr_resizeCallback();
		return;
	}//*/

	m_winWidth = width;
	m_winHeight = height;
	
	if (height==0)										
	{
		height=1;									
	}

	glViewport(0,0,width,height);					

	glMatrixMode(GL_PROJECTION);				
	glLoadIdentity();							

	gluPerspective(45.0f,(GLfloat)width/(GLfloat)height,1.0f,1000.0f);

	glMatrixMode(GL_MODELVIEW);				
	glLoadIdentity();	

	SwapBuffers(m_windowHDC);
	glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT);
}

void initGLScene()
{
/*	if (mptr_createCallback)
	{
		mptr_createCallback();
		return;
	}//*/

	//glShadeModel(GL_SMOOTH);						
	//glClearColor(0.4f, 0.4f, 0.4f, 1.0f);			
	glClearDepth(1.0f);							
	glEnable(GL_DEPTH_TEST);
	//glEnable(GL_CULL_FACE);
	//glDepthFunc(GL_LEQUAL);								
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);	//*/
	GLeeInit();
}

void oglResetViewport()
{
	resizeGLScene(m_winWidth, m_winHeight);
}
	
/////NON EXPORTED MULTIPLATFORM START

bool drawLoop()
{
	glClear(GL_DEPTH_BUFFER_BIT | GL_COLOR_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);
	if (m_ptr_render_func)
	{
		if (!m_ptr_render_func())
		{
			return false;
		}
	}
	oglSwapBuffer();
	glFlush();
	return true;
}

//////////////////////////////////////////////////////////////////////////////
// WINDOWS PART
//////////////////////////////////////////////////////////////////////////////

#ifdef WIN32

bool WGLisExtensionSupported(const char *extension)
{

	const size_t extlen = strlen(extension);
	const char *supported = NULL;

	// Try To Use wglGetExtensionStringARB On Current DC, If Possible
	PROC wglGetExtString = wglGetProcAddress("wglGetExtensionsStringARB");

	if (wglGetExtString)
		supported = ((char*(__stdcall*)(HDC))wglGetExtString)(wglGetCurrentDC());

	// If That Failed, Try Standard Opengl Extensions String
	if (supported == NULL)
		supported = (char*)glGetString(GL_EXTENSIONS);

	// If That Failed Too, Must Be No Extensions Supported
	if (supported == NULL)
		return false;

	// Begin Examination At Start Of String, Increment By 1 On False Match
	for (const char* p = supported; ; p++)
	{
		// Advance p Up To The Next Possible Match
		p = strstr(p, extension);

		if (p == NULL)
			return false;						// No Match

		// Make Sure That Match Is At The Start Of The String Or That
		// The Previous Char Is A Space, Or Else We Could Accidentally
		// Match "wglFunkywglExtension" With "wglExtension"

		// Also, Make Sure That The Following Character Is Space Or NULL
		// Or Else "wglExtensionTwo" Might Match "wglExtension"
		if ((p==supported || p[-1]==' ') && (p[extlen]=='\0' || p[extlen]==' '))
			return true;						// Match
	}
}

bool InitMultisample(HINSTANCE hInstance,HWND hWnd,PIXELFORMATDESCRIPTOR pfd)
{  
	// See If The String Exists In WGL!
	if (!WGLisExtensionSupported("WGL_ARB_multisample"))
	{
		arbMultisampleSupported=false;
		return false;
	}

	// Get Our Pixel Format
	PFNWGLCHOOSEPIXELFORMATARBPROC wglChoosePixelFormatARB =
		(PFNWGLCHOOSEPIXELFORMATARBPROC)wglGetProcAddress("wglChoosePixelFormatARB");

	if (!wglChoosePixelFormatARB)
	{
		// We Didn't Find Support For Multisampling, Set Our Flag And Exit Out.
		arbMultisampleSupported=false;
		return false;
	}

	// Get Our Current Device Context. We Need This In Order To Ask The OpenGL Window What Attributes We Have
	HDC hDC = GetDC(hWnd);

	int pixelFormat;
	bool valid;
	UINT numFormats;
	float fAttributes[] = {0,0};

	// These Attributes Are The Bits We Want To Test For In Our Sample
	// Everything Is Pretty Standard, The Only One We Want To 
	// Really Focus On Is The SAMPLE BUFFERS ARB And WGL SAMPLES
	// These Two Are Going To Do The Main Testing For Whether Or Not
	// We Support Multisampling On This Hardware
	int iAttributes[] = { WGL_DRAW_TO_WINDOW_ARB,GL_TRUE,
		WGL_SUPPORT_OPENGL_ARB,GL_TRUE,
		WGL_ACCELERATION_ARB,WGL_FULL_ACCELERATION_ARB,
		WGL_COLOR_BITS_ARB,24,
		WGL_ALPHA_BITS_ARB,8,
		WGL_DEPTH_BITS_ARB,16,
		WGL_STENCIL_BITS_ARB,0,
		WGL_DOUBLE_BUFFER_ARB,GL_TRUE,
		WGL_SAMPLE_BUFFERS_ARB,GL_TRUE,
		WGL_SAMPLES_ARB, MULTI_SAMPLES ,						// Check For 4x Multisampling
		0,0};

	// First We Check To See If We Can Get A Pixel Format For 4 Samples
	valid = wglChoosePixelFormatARB(hDC,iAttributes,fAttributes,1,&pixelFormat,&numFormats);
 
	// if We Returned True, And Our Format Count Is Greater Than 1
	if (valid && numFormats >= 1)
	{
		arbMultisampleSupported	= true;
		arbMultisampleFormat	= pixelFormat;	
		return arbMultisampleSupported;
	}

	// Our Pixel Format With 4 Samples Failed, Test For 2 Samples
	iAttributes[19] = 2;
	valid = wglChoosePixelFormatARB(hDC,iAttributes,fAttributes,1,&pixelFormat,&numFormats);
	if (valid && numFormats >= 1)
	{
		arbMultisampleSupported	= true;
		arbMultisampleFormat	= pixelFormat;	 
		return arbMultisampleSupported;
	}
	  
	// Return The Valid Format
	return  arbMultisampleSupported;
}

void oglStart()
{
	MSG	msg;
	bool done = false;
	bool firstFrame = true;
	while (!done)
	{
		if (PeekMessage(&msg,NULL,0,0,PM_REMOVE))
		{
			if (msg.message==WM_QUIT)
			{
				done = true;
			}
			else			
			{
				TranslateMessage(&msg);
				DispatchMessage(&msg);	
			}
		}
		else
		{
			//if (!firstFrame)
			//dTime = timeGetTime() - timeOffset;
			//timeOffset = timeGetTime();
			if (!drawLoop())
			{
				done = true;
			}

			firstFrame = false;

			for (int i= 0; i < 256; i++)
			{
				keys_lastFrame[i] = keys[i];
			}
			
			if (mouseButton != 0)
				mouseDownLastFrame = true;
			else
				mouseDownLastFrame = false;
			
		}
	}
}

GLvoid KillGLWindow(GLvoid)
{
	wglMakeCurrent(m_windowHDC, NULL);
	wglDeleteContext(m_windowRC);
/*	if (m_windowHWND!= 0)												// Does The Window Have A Handle?
	{	
		if (m_windowHDC != 0)											// Does The Window Have A Device Context?
		{
			wglMakeCurrent (m_windowHDC, 0);							// Set The Current Active Rendering Context To Zero
			if (m_windowRC != 0)										// Does The Window Have A Rendering Context?
			{
				wglDeleteContext (m_windowRC);							// Release The Rendering Context
				m_windowRC = 0;										// Zero The Rendering Context

			}
			ReleaseDC (m_windowHWND, m_windowHDC);						// Release The Device Context
			m_windowHDC = 0;											// Zero The Device Context
		}
		DestroyWindow (m_windowHWND);									// Destroy The Window
		m_windowHWND = 0;												// Zero The Window Handle
	}
//*/
}

LRESULT CALLBACK WndProc(	HWND	hWnd, UINT	uMsg, WPARAM	wParam,	LPARAM	lParam)	
{
	switch (uMsg)									
	{
		case WM_ACTIVATE:							
		{
			if (!HIWORD(wParam))				
			{

			}
			else
			{

			}
			return 0;								
		}

		case WM_SYSCOMMAND:							
		{
			switch (wParam)							
			{
				case SC_SCREENSAVE:					
				case SC_MONITORPOWER:				
				return 0;							
			}
			break;									
		}

		case WM_CLOSE:								
		{
			 // deselect rendering context and delete it
			wglMakeCurrent(m_windowHDC, NULL);
			wglDeleteContext(m_windowRC);

			PostQuitMessage(0);						
			return 0;							
		}

		case WM_KEYDOWN:							
		{
			//globals::m_keys[wParam] = true;
			keys[wParam] = true;
			if (wParam == VK_ESCAPE)
				PostQuitMessage(0);
			return 0;							
		}

		case WM_KEYUP:								
		{
		//	globals::m_keys[wParam] = false;
			keys[wParam] = false;
			return 0;							
		}

		case WM_SIZE:							
		{
			//TODO; Resize callback code here!
			//THIS IS A HACK!
			int h = HIWORD(lParam);		
			int w = LOWORD(lParam);
			resizeGLScene(w,h);
			return 0;							
		}
		case WM_MOUSEMOVE:
		{
			int x=(short)LOWORD(lParam);
			int y=(short)HIWORD(lParam);
			mouseX = x;
			mouseY = y;
			return 0;
		}
		case WM_LBUTTONDOWN:
		{
			int x=(short)LOWORD(lParam);
			int y=(short)HIWORD(lParam);
			mouseX = x;
			mouseY = y;
			mouseButton = 1;
			return 0;
		}
		case WM_LBUTTONUP:
		{
			mouseButton = 0;
			return 0;
		}
		case WM_MBUTTONDOWN:
		{
			int x=(short)LOWORD(lParam);
			int y=(short)HIWORD(lParam);
			mouseX = x;
			mouseY = y;
			mouseButton = 3;
			return 0;
		}
		case WM_MBUTTONUP:
		{
			mouseButton = 0;
			return 0;
		}
		case WM_RBUTTONDOWN:
		{
			int x=(short)LOWORD(lParam);
			int y=(short)HIWORD(lParam);
			mouseX = x;
			mouseY = y;
			mouseButton = 2;
			return 0;
		}
		case WM_RBUTTONUP:
		{
			mouseButton = 0;
			return 0;	
		}
	}
	// Pass All Unhandled Messages To DefWindowProc
	return DefWindowProc(hWnd,uMsg,wParam,lParam);
}

bool createWindowOGL()
{

	GLuint	PixelFormat;
	int bits = 32;

	static	PIXELFORMATDESCRIPTOR pfd=				// pfd Tells Windows How We Want Things To Be
	{
		sizeof(PIXELFORMATDESCRIPTOR),				// Size Of This Pixel Format Descriptor
		1,											// Version Number
		PFD_DRAW_TO_WINDOW |						// Format Must Support Window
		PFD_SUPPORT_OPENGL |						// Format Must Support OpenGL
		PFD_DOUBLEBUFFER,							// Must Support Double Buffering
		PFD_TYPE_RGBA,								// Request An RGBA Format
		bits,										// Select Our Color Depth
		0, 0, 0, 0, 0, 0,							// Color Bits Ignored
		1,											// No Alpha Buffer
		0,											// Shift Bit Ignored
		0,											// No Accumulation Buffer
		0, 0, 0, 0,									// Accumulation Bits Ignored
		16,											// 16Bit Z-Buffer (Depth Buffer)  
		0,											// No Stencil Buffer
		0,											// No Auxiliary Buffer
		PFD_MAIN_PLANE,								// Main Drawing Layer
		0,											// Reserved
		0, 0, 0										// Layer Masks Ignored
	};
	
	if (!(m_windowHDC=GetDC(m_windowHWND)))							// Did We Get A Device Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Device Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	//////////////////////////

	if(!arbMultisampleSupported)
	{

		PixelFormat = ChoosePixelFormat (m_windowHDC, &pfd);				// Find A Compatible Pixel Format
		if (PixelFormat == 0)												// Did We Find A Compatible Format?
		{
			// Failed
			ReleaseDC (m_windowHWND, m_windowHDC);							// Release Our Device Context
			m_windowHDC = 0;												// Zero The Device Context
			DestroyWindow (m_windowHWND);									// Destroy The Window
			m_windowHWND = 0;												// Zero The Window Handle
			return FALSE;													// Return False
		}

	}
	else
	{
		PixelFormat = arbMultisampleFormat;
	}

	/////////////////////////////////

	if (!(PixelFormat=ChoosePixelFormat(m_windowHDC,&pfd)))	// Did Windows Find A Matching Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Find A Suitable PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!SetPixelFormat(m_windowHDC,PixelFormat,&pfd))		// Are We Able To Set The Pixel Format?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Set The PixelFormat.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if (!(m_windowRC=wglCreateContext(m_windowHDC)))				// Are We Able To Get A Rendering Context?
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Create A GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	if(!wglMakeCurrent(m_windowHDC,m_windowRC))					// Try To Activate The Rendering Context
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Can't Activate The GL Rendering Context.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	///
	if(!arbMultisampleSupported && CHECK_FOR_MULTISAMPLE)
	{
	
		if(InitMultisample(m_windowInstance,m_windowHWND,pfd))
		{			
			KillGLWindow();
			return createWindowOGL();//oglCreateWindow(m_winWidth, m_winHeight, "New Win");
		}//*/
	}

	ShowWindow(m_windowHWND,SW_SHOW);						// Show The Window
	SetForegroundWindow(m_windowHWND);						// Slightly Higher Priority
	SetFocus(m_windowHWND);									// Sets Keyboard Focus To The Window
	resizeGLScene(m_winWidth, m_winHeight);					// Set Up Our Perspective GL Screen

	initGLScene();
	
	return true;
}

bool createWindowWindows(int width, int height, char* title, bool fullscreen)
{
	WNDCLASS	wc;						// Windows Class Structure
	DWORD		dwExStyle;				// Window Extended Style
	DWORD		dwStyle;				// Window Style
	RECT		WindowRect;				// Grabs Rectangle Upper Left / Lower Right Values
	WindowRect.left=(long)0;			// Set Left Value To 0
	WindowRect.right=(long)width;		// Set Right Value To Requested Width
	WindowRect.top=(long)0;				// Set Top Value To 0
	WindowRect.bottom=(long)height;		// Set Bottom Value To Requested Height

	
	m_winWidth = width;
	m_winHeight = height;

	m_windowInstance	= GetModuleHandle(NULL);				// Grab An Instance For Our Window
	wc.style			= CS_HREDRAW | CS_VREDRAW | CS_OWNDC;	// Redraw On Size, And Own DC For Window.
	wc.lpfnWndProc		= (WNDPROC) WndProc;					// WndProc Handles Messages
	wc.cbClsExtra		= 0;									// No Extra Window Data
	wc.cbWndExtra		= 0;									// No Extra Window Data
	wc.hInstance		= m_windowInstance;							// Set The Instance
	wc.hIcon			= LoadIcon(NULL, IDI_WINLOGO);			// Load The Default Icon
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);			// Load The Arrow Pointer
	wc.hbrBackground	= NULL;									// No Background Required For GL
	wc.lpszMenuName		= NULL;									// We Don't Want A Menu
	wc.lpszClassName	= "OpenGL";								// Set The Class Name

	if (!RegisterClass(&wc))									// Attempt To Register The Window Class
	{
		MessageBox(NULL,"Failed To Register The Window Class.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;											// Return FALSE
	}
	
	if (fullscreen)												// Attempt Fullscreen Mode?
	{
		DEVMODE dmScreenSettings;								// Device Mode
		memset(&dmScreenSettings,0,sizeof(dmScreenSettings));	// Makes Sure Memory's Cleared
		dmScreenSettings.dmSize=sizeof(dmScreenSettings);		// Size Of The Devmode Structure
		dmScreenSettings.dmPelsWidth	= width;				// Selected Screen Width
		dmScreenSettings.dmPelsHeight	= height;				// Selected Screen Height
		dmScreenSettings.dmBitsPerPel	= 32;					// Selected Bits Per Pixel
		dmScreenSettings.dmFields=DM_BITSPERPEL|DM_PELSWIDTH|DM_PELSHEIGHT;

		// Try To Set Selected Mode And Get Results.  NOTE: CDS_FULLSCREEN Gets Rid Of Start Bar.
		if (ChangeDisplaySettings(&dmScreenSettings,CDS_FULLSCREEN)!=DISP_CHANGE_SUCCESSFUL)
		{
			// If The Mode Fails, Offer Two Options.  Quit Or Use Windowed Mode.
			if (MessageBox(NULL,"The Requested Fullscreen Mode Is Not Supported By\nYour Video Card. Use Windowed Mode Instead?","NeHe GL",MB_YESNO|MB_ICONEXCLAMATION)==IDYES)
			{
				fullscreen=FALSE;		// Windowed Mode Selected.  Fullscreen = FALSE
			}
			else
			{
				// Pop Up A Message Box Letting User Know The Program Is Closing.
				MessageBox(NULL,"Program Will Now Close.","ERROR",MB_OK|MB_ICONSTOP);
				return FALSE;									// Return FALSE
			}
		}
	}

	if (fullscreen)												// Are We Still In Fullscreen Mode?
	{
		dwExStyle=WS_EX_APPWINDOW;								// Window Extended Style
		dwStyle=WS_POPUP;										// Windows Style
		ShowCursor(FALSE);										// Hide Mouse Pointer
	}
	else
	{
		dwExStyle=WS_EX_APPWINDOW | WS_EX_WINDOWEDGE;			// Window Extended Style
		dwStyle=WS_OVERLAPPEDWINDOW;							// Windows Style
	}

	AdjustWindowRectEx(&WindowRect, dwStyle, FALSE, dwExStyle);		// Adjust Window To True Requested Size

	// Create The Window
	if (!(m_windowHWND=CreateWindowEx(	dwExStyle,							// Extended Style For The Window
								"OpenGL",							// Class Name
								title,								// Window Title
								dwStyle |							// Defined Window Style
								WS_CLIPSIBLINGS |					// Required Window Style
								WS_CLIPCHILDREN,					// Required Window Style
								CW_USEDEFAULT, 0,								// Window Position
								WindowRect.right-WindowRect.left,	// Calculate Window Width
								WindowRect.bottom-WindowRect.top,	// Calculate Window Height
								NULL,								// No Parent Window
								NULL,								// No Menu
								m_windowInstance,							// Instance
								NULL)))								// Dont Pass Anything To WM_CREATE
	{
		KillGLWindow();								// Reset The Display
		MessageBox(NULL,"Window Creation Error.","ERROR",MB_OK|MB_ICONEXCLAMATION);
		return FALSE;								// Return FALSE
	}

	///////////////////////////////////////
	return createWindowOGL();
}

#endif
///////////////////////////////////////////////////////////////////
//END WINDOWS PART
///////////////////////////////////////////////////////////////////

bool oglCreateWindow(int width, int height, char* title, bool fullscreen)
{
#ifdef WIN32
	return createWindowWindows(width, height, title, fullscreen);
#endif

	return false;
}