/*******************************************************

Original Author...Tor Jonas Onsrud
Purpose...........matrix3 math

Description:
This is a matrix3 math class for fusausion.
It is templetized to support different types.

			
********************************************************/


#ifndef H_xxFUSA_MATRIX3xx_H
#define H_xxFUSA_MATRIX3xx_H

#include "fusa_vectormath.h"
#include <iostream>



template <class te>
struct sData3
{
	te _00;
	te _10;
	te _20;
	te _01;
	te _11;
	te _21;
	te _02;
	te _12;
	te _22;
		
};
namespace fusa
{
	template <class ta>
	/*
	@class cMatrix3
	@brief cMatrix3 is a mathematical 3*3 matrix structure. the datatype is templetized
	*/
	class cMatrix3
	{
	public:
		 
		cMatrix3()
		{
			m_identityMatrix._00=1;	m_identityMatrix._01=0;	m_identityMatrix._02=0;	
			m_identityMatrix._10=0;	m_identityMatrix._11=1;	m_identityMatrix._12=0;	
			m_identityMatrix._20=0;	m_identityMatrix._21=0;	m_identityMatrix._22=1;	
			
			m_matrixData=m_identityMatrix;
		}
		cMatrix3( ta _00,ta _01, ta _02, 
				  ta _10,ta _11, ta _12, 
				  ta _20,ta _21, ta _22)
		{
			m_matrixData._00=_00;m_matrixData._01=_01;m_matrixData._02=_02;
			m_matrixData._10=_10;m_matrixData._11=_11;m_matrixData._12=_12;
			m_matrixData._20=_20;m_matrixData._21=_21;m_matrixData._22=_22;
			
			m_identityMatrix._00=1;	m_identityMatrix._01=0;	m_identityMatrix._02=0;	
			m_identityMatrix._10=0;	m_identityMatrix._11=1;	m_identityMatrix._12=0;
			m_identityMatrix._20=0;	m_identityMatrix._21=0;	m_identityMatrix._22=1;	

			

			
		}
		~cMatrix3(){;}
		///Sets the m_matrixData to the current matrix
		void setMatrix3f( ta _00,ta _01, ta _02, 
						  ta _10,ta _11, ta _12, 
						  ta _20,ta _21, ta _22)
						  
		{
			m_matrixData._00=_00;m_matrixData._01=_01;m_matrixData._02=_02;
			m_matrixData._10=_10;m_matrixData._11=_11;m_matrixData._12=_12;
			m_matrixData._20=_20;m_matrixData._21=_21;m_matrixData._22=_22;
			
		}
		///Operator overloaded, multiplying two matrix and leave the result in the first matrix.
		void operator *=(const cMatrix3 &matrix)
		{
			m_matrixDataI._00=(m_matrixData._00 * matrix.m_matrixData._00) + (m_matrixData._01 * matrix.m_matrixData._10) + (m_matrixData._02 * matrix.m_matrixData._20);
			m_matrixDataI._01=(m_matrixData._00 * matrix.m_matrixData._01) + (m_matrixData._01 * matrix.m_matrixData._11) + (m_matrixData._02 * matrix.m_matrixData._21);
			m_matrixDataI._02=(m_matrixData._00 * matrix.m_matrixData._02) + (m_matrixData._01 * matrix.m_matrixData._12) + (m_matrixData._02 * matrix.m_matrixData._22);
			
			m_matrixDataI._10=(m_matrixData._10 * matrix.m_matrixData._00) + (m_matrixData._11 * matrix.m_matrixData._10) + (m_matrixData._12 * matrix.m_matrixData._20);
			m_matrixDataI._11=(m_matrixData._10 * matrix.m_matrixData._01) + (m_matrixData._11 * matrix.m_matrixData._11) + (m_matrixData._12 * matrix.m_matrixData._21);
			m_matrixDataI._12=(m_matrixData._10 * matrix.m_matrixData._02) + (m_matrixData._11 * matrix.m_matrixData._12) + (m_matrixData._12 * matrix.m_matrixData._22);

			m_matrixDataI._20=(m_matrixData._20 * matrix.m_matrixData._00) + (m_matrixData._21 * matrix.m_matrixData._10) + (m_matrixData._22 * matrix.m_matrixData._20);
			m_matrixDataI._21=(m_matrixData._20 * matrix.m_matrixData._01) + (m_matrixData._21 * matrix.m_matrixData._11) + (m_matrixData._22 * matrix.m_matrixData._21);
			m_matrixDataI._22=(m_matrixData._20 * matrix.m_matrixData._02) + (m_matrixData._21 * matrix.m_matrixData._12) + (m_matrixData._22 * matrix.m_matrixData._22);
						
			m_matrixData = m_matrixDataI;
			
		}
		///Operator overloaded, multiplying two matrix and returns the new one.
		cMatrix3 operator *(const cMatrix3 &matrix)
		{
			m_matrixDataI._00=(m_matrixData._00 * matrix.m_matrixData._00) + (m_matrixData._01 * matrix.m_matrixData._10) + (m_matrixData._02 * matrix.m_matrixData._20);
			m_matrixDataI._01=(m_matrixData._00 * matrix.m_matrixData._01) + (m_matrixData._01 * matrix.m_matrixData._11) + (m_matrixData._02 * matrix.m_matrixData._21);
			m_matrixDataI._02=(m_matrixData._00 * matrix.m_matrixData._02) + (m_matrixData._01 * matrix.m_matrixData._12) + (m_matrixData._02 * matrix.m_matrixData._22);
			
			m_matrixDataI._10=(m_matrixData._10 * matrix.m_matrixData._00) + (m_matrixData._11 * matrix.m_matrixData._10) + (m_matrixData._12 * matrix.m_matrixData._20);
			m_matrixDataI._11=(m_matrixData._10 * matrix.m_matrixData._01) + (m_matrixData._11 * matrix.m_matrixData._11) + (m_matrixData._12 * matrix.m_matrixData._21);
			m_matrixDataI._12=(m_matrixData._10 * matrix.m_matrixData._02) + (m_matrixData._11 * matrix.m_matrixData._12) + (m_matrixData._12 * matrix.m_matrixData._22);

			m_matrixDataI._20=(m_matrixData._20 * matrix.m_matrixData._00) + (m_matrixData._21 * matrix.m_matrixData._10) + (m_matrixData._22 * matrix.m_matrixData._20);
			m_matrixDataI._21=(m_matrixData._20 * matrix.m_matrixData._01) + (m_matrixData._21 * matrix.m_matrixData._11) + (m_matrixData._22 * matrix.m_matrixData._21);
			m_matrixDataI._22=(m_matrixData._20 * matrix.m_matrixData._02) + (m_matrixData._21 * matrix.m_matrixData._12) + (m_matrixData._22 * matrix.m_matrixData._22);
				
			
			return cMatrix3(    m_matrixDataI._00,m_matrixDataI._01,m_matrixDataI._02,
								m_matrixDataI._10,m_matrixDataI._11,m_matrixDataI._12,
								m_matrixDataI._20,m_matrixDataI._21,m_matrixDataI._22);
			
		}
		///Generates the translation matrix based on the inparameters.
		void toTranslateMatrix(const cVec2<ta> &m_position)
		{
			m_matrixData=m_identityMatrix;
			
			m_matrixData._02=m_position.x;
			m_matrixData._12=m_position.y;
			
		}
		///Generates the scale matrix based on the inparameter.
		void toScaleMatrix(const cVec2f &m_scale)
		{
			m_matrixData=m_identityMatrix;
			
			m_matrixData._00=m_scale.x;
			m_matrixData._11=m_scale.y;
			
		}
		///Generates the rotation matrix based on the inparameter. The rotation is in radians
		void toRotateMatrix(ta rads)
		{
			ta m_Cosine=(float)cos(rads),m_Sine=(float)sin(rads);
			m_matrixData=m_identityMatrix;

			m_matrixData._00= +m_Cosine;
			m_matrixData._01= -m_Sine;
			m_matrixData._10= +m_Sine;
			m_matrixData._11= +m_Cosine;
		}
		///Getting the row, starting at 0.
		cVec3f getRow(int row)
		{
			if (row==0)
			{
				return cVec3f(m_matrixData._00,m_matrixData._01,m_matrixData._02);
			}
			if (row==1)
			{
				return cVec3f(m_matrixData._10,m_matrixData._11,m_matrixData._12);
			}
			if (row==2)
			{
				return cVec3f(m_matrixData._20,m_matrixData._21,m_matrixData._22);
			}
			
		}
		///Getting the collumn, starting at 0.
		cVec3f getCollumn(int col)
		{
			if (col==0)
			{	
				return cVec3f(m_matrixData._00,m_matrixData._10,m_matrixData._20);
			}
			if (col==1)
			{
				return cVec3f(m_matrixData._01,m_matrixData._11,m_matrixData._21);
			}
			if (col==2)
			{
				return cVec3f(m_matrixData._02,m_matrixData._12,m_matrixData._22);
			}
			
		}
		///Inversing the matrix through "rekkereduksjon".
		void invers()
		{
			
			m_matrixDataI=m_identityMatrix;

			m_V1=m_matrixData._00;
			m_matrixData._00=m_matrixData._00 / m_V1;	m_matrixData._01=m_matrixData._01 / m_V1;m_matrixData._02=m_matrixData._02 / m_V1;/**/m_matrixDataI._00=m_matrixDataI._00 / m_V1;m_matrixDataI._01=m_matrixDataI._01 / m_V1;m_matrixDataI._02=m_matrixDataI._02 / m_V1;		
			m_V2=m_matrixData._10;
			m_matrixData._10=m_matrixData._10 - (m_V2 * m_matrixData._00);	m_matrixData._11=m_matrixData._11 - (m_V2 * m_matrixData._01);	m_matrixData._12=m_matrixData._12 - (m_V2 * m_matrixData._02);/**/m_matrixDataI._10=m_matrixDataI._10 - (m_V2 * m_matrixDataI._00);	m_matrixDataI._11=m_matrixDataI._11 - (m_V2 * m_matrixDataI._01);	m_matrixDataI._12=m_matrixDataI._12 - (m_V2 * m_matrixDataI._02);				
			m_V3=m_matrixData._20;
			m_matrixData._20=m_matrixData._20 - (m_V3 * m_matrixData._00);	m_matrixData._21=m_matrixData._21 - (m_V3 * m_matrixData._01);	m_matrixData._22=m_matrixData._22 - (m_V3 * m_matrixData._02);/**/m_matrixDataI._20=m_matrixDataI._20 - (m_V3 * m_matrixDataI._00);	m_matrixDataI._21=m_matrixDataI._21 - (m_V3 * m_matrixDataI._01);	m_matrixDataI._22=m_matrixDataI._22 - (m_V3 * m_matrixDataI._02);	

			m_V1=m_matrixData._11;
			m_matrixData._10=m_matrixData._10 / m_V1;	m_matrixData._11=m_matrixData._11 / m_V1;m_matrixData._12=m_matrixData._12 / m_V1;/**/m_matrixDataI._10=m_matrixDataI._10 / m_V1;m_matrixDataI._11=m_matrixDataI._11 / m_V1;m_matrixDataI._12=m_matrixDataI._12 / m_V1;	
			m_V2=m_matrixData._01;
			m_matrixData._00=m_matrixData._00 - (m_V2 * m_matrixData._10); m_matrixData._01=m_matrixData._01 - (m_V2 * m_matrixData._11);	m_matrixData._02=m_matrixData._02 - (m_V2 * m_matrixData._12);/**/m_matrixDataI._00=m_matrixDataI._00 - (m_V2 * m_matrixDataI._10); m_matrixDataI._01=m_matrixDataI._01 - (m_V2 * m_matrixDataI._11);	m_matrixDataI._02=m_matrixDataI._02 - (m_V2 * m_matrixDataI._12);			
			m_V3=m_matrixData._21;
			m_matrixData._20=m_matrixData._20 - (m_V3 * m_matrixData._10); m_matrixData._21=m_matrixData._21 - (m_V3 * m_matrixData._11);	m_matrixData._22=m_matrixData._22 - (m_V3 * m_matrixData._12);/**/m_matrixDataI._20=m_matrixDataI._20 - (m_V3 * m_matrixDataI._10); m_matrixDataI._21=m_matrixDataI._21 - (m_V3 * m_matrixDataI._11);	m_matrixDataI._22=m_matrixDataI._22 - (m_V3 * m_matrixDataI._12);	


			m_V1=m_matrixData._22;
			m_matrixData._20=m_matrixData._20 / m_V1; m_matrixData._21=m_matrixData._21 / m_V1;m_matrixData._22=m_matrixData._22 / m_V1;/**/m_matrixDataI._20=m_matrixDataI._20 / m_V1;m_matrixDataI._21=m_matrixDataI._21 / m_V1;m_matrixDataI._22=m_matrixDataI._22 / m_V1;
			m_V2=m_matrixData._02;
			m_matrixData._00=m_matrixData._00 - (m_V2 * m_matrixData._20); m_matrixData._01=m_matrixData._01 - (m_V2 * m_matrixData._21);	m_matrixData._02=m_matrixData._02 - (m_V2 * m_matrixData._22);/**/ m_matrixDataI._00=m_matrixDataI._00 - (m_V2 * m_matrixDataI._20); m_matrixDataI._01=m_matrixDataI._01 - (m_V2 * m_matrixDataI._21);	m_matrixDataI._02=m_matrixDataI._02 - (m_V2 * m_matrixDataI._22);	 
			m_V3=m_matrixData._12;
			m_matrixData._10=m_matrixData._10 - (m_V3 * m_matrixData._20); m_matrixData._11=m_matrixData._11 - (m_V3 * m_matrixData._21);   m_matrixData._12=m_matrixData._12 - (m_V3 * m_matrixData._22);/**/ m_matrixDataI._10=m_matrixDataI._10 - (m_V3 * m_matrixDataI._20); m_matrixDataI._11=m_matrixDataI._11 - (m_V3 * m_matrixDataI._21);	m_matrixDataI._12=m_matrixDataI._12 - (m_V3 * m_matrixDataI._22);		
			
			m_matrixData=m_matrixDataI;
				
		}
		///Transposing the matrix.
		void transpose()
		{
			m_matrixDataI._00=m_matrixData._00;
			m_matrixDataI._10=m_matrixData._01;
			m_matrixDataI._20=m_matrixData._02;
			
			m_matrixDataI._01=m_matrixData._10;
			m_matrixDataI._11=m_matrixData._11;
			m_matrixDataI._21=m_matrixData._12;
			
			m_matrixDataI._02=m_matrixData._20;
			m_matrixDataI._12=m_matrixData._21;
			m_matrixDataI._22=m_matrixData._22;
						
			m_matrixData=m_matrixDataI;
		}
		///Generates the identity matrix.
		void toIdentityMatrix()
		{	
			m_matrixData=m_identityMatrix;
		}

		///Holding the actually matrix data.
		sData3<ta> m_matrixData;
	private:
		///Holding the identity matrix at all time.
		sData3<ta> m_identityMatrix;
		///Helping structure, used un the function inverse etc.
		sData3<ta> m_matrixDataI;
		///Helping structures, used in the function inverse etc.
		ta m_V1,m_V2,m_V3,m_V4;
	};

}
#endif
